/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.utils.ErrorCollectionException;

public class EnvEntryComplianceChecker
extends BaseComplianceChecker {
    private static final String[] ENTRY_TYPES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.String", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        WebAppBean webAppBean = deploymentInfo.getWebAppBean();
        if (webAppBean == null) {
            return;
        }
        EnvEntryBean[] envEntryBeanArray = webAppBean.getEnvEntries();
        if (envEntryBeanArray == null) {
            return;
        }
        for (int i = 0; i < envEntryBeanArray.length; ++i) {
            this.checkEnvEntry(envEntryBeanArray[i]);
        }
        this.checkForExceptions();
    }

    private void checkEnvEntry(EnvEntryBean envEntryBean) {
        if (envEntryBean == null) {
            return;
        }
        String string = envEntryBean.getEnvEntryType();
        String string2 = envEntryBean.getEnvEntryValue();
        if (string == null || !EnvEntryComplianceChecker.isEntryTypeValid(string)) {
            this.addDescriptorError(this.fmt.INVALID_ENV_ENTRY_TYPE(string));
            return;
        }
        this.validateEntryValue(string, string2);
    }

    private void validateEntryValue(String string, String string2) {
        if (string.equals("java.lang.Character")) {
            if (string2 == null || string2.length() > 2) {
                this.update(this.fmt.warning() + this.fmt.INVALID_ENV_ENTRY_VALUE(string, string2));
            }
        } else {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                constructor.newInstance(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
                this.addDescriptorError(this.fmt.INVALID_ENV_ENTRY_VALUE(string, string2));
            }
            catch (InvocationTargetException invocationTargetException) {
                this.addDescriptorError(this.fmt.INVALID_ENV_ENTRY_VALUE(string, string2));
            }
        }
    }

    private static boolean isEntryTypeValid(String string) {
        for (int i = 0; i < ENTRY_TYPES.length; ++i) {
            if (!ENTRY_TYPES[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

