/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.util.HashSet;
import java.util.Set;
import weblogic.j2ee.descriptor.ErrorPageBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.utils.ErrorCollectionException;

public class ErrorPageComplianceChecker
extends BaseComplianceChecker {
    private Set errorCodeSet;
    private Set exceptionTypeSet;

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        ErrorPageBean[] errorPageBeanArray = deploymentInfo.getWebAppBean().getErrorPages();
        if (errorPageBeanArray == null) {
            return;
        }
        for (int i = 0; i < errorPageBeanArray.length; ++i) {
            this.checkErrorPage(errorPageBeanArray[i], deploymentInfo);
        }
        this.checkForExceptions();
    }

    private void checkErrorPage(ErrorPageBean errorPageBean, DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        Object object;
        int n = errorPageBean.getErrorCode();
        String string = errorPageBean.getExceptionType();
        String string2 = null;
        boolean bl = false;
        if (n < 1 && string != null && string.length() > 0) {
            this.addDescriptorError(this.fmt.MULTIPLE_DEFINES_ERROR_PAGE("" + n, string));
            this.checkForExceptions();
        }
        if (!this.addErrorCode("" + n)) {
            this.addDescriptorError(this.fmt.DUPLICATE_ERROR_DEF("<error-code>", string2));
        }
        if (string != null && n < 1) {
            bl = true;
            object = deploymentInfo.getClassLoader();
            if (object != null) {
                this.isClassAssignable((ClassLoader)object, "<exception-type>", string, "java.lang.Throwable");
            }
            if (!this.addExceptionType(string)) {
                this.addDescriptorError(this.fmt.DUPLICATE_ERROR_DEF("<exception-type>", string));
            }
        }
        if ((object = errorPageBean.getLocation()) == null || ((String)object).length() == 0) {
            if (bl) {
                this.addDescriptorError(this.fmt.NO_ERROR_PAGE_LOCATION_TYPE(string));
            } else {
                this.addDescriptorError(this.fmt.NO_ERROR_PAGE_LOCATION_CODE("" + n));
            }
        }
        this.checkForExceptions();
    }

    private boolean addErrorCode(String string) {
        if (this.errorCodeSet == null) {
            this.errorCodeSet = new HashSet();
        }
        return this.errorCodeSet.add(string);
    }

    private boolean addExceptionType(String string) {
        if (this.exceptionTypeSet == null) {
            this.exceptionTypeSet = new HashSet();
        }
        return this.exceptionTypeSet.add(string);
    }
}

