/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.util.HashSet;
import weblogic.j2ee.descriptor.FilterBean;
import weblogic.j2ee.descriptor.FilterMappingBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.servlet.internal.dd.compliance.DescriptorErrorInfo;
import weblogic.utils.ErrorCollectionException;

public class FilterComplianceChecker
extends BaseComplianceChecker {
    private static final String SUPER_CLASS = "javax.servlet.Filter";
    private static final boolean debug = false;

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        FilterBean[] filterBeanArray = deploymentInfo.getWebAppBean().getFilters();
        FilterMappingBean[] filterMappingBeanArray = deploymentInfo.getWebAppBean().getFilterMappings();
        if (filterBeanArray == null && filterMappingBeanArray == null) {
            return;
        }
        if (filterBeanArray != null) {
            HashSet<String> hashSet = filterBeanArray.length > 1 ? new HashSet<String>() : null;
            for (int i = 0; i < filterBeanArray.length; ++i) {
                this.checkFilter(filterBeanArray[i], deploymentInfo.getClassLoader());
                if (hashSet == null || hashSet.add(filterBeanArray[i].getFilterName())) continue;
                this.update(this.fmt.warning() + this.fmt.DUPLICATE_FILTER_DEF(filterBeanArray[i].getFilterName()));
            }
        }
        this.checkForExceptions();
        if (filterMappingBeanArray == null && filterBeanArray != null) {
            for (int i = 0; i < filterBeanArray.length; ++i) {
                this.update(this.fmt.warning() + this.fmt.NO_MAPPING_FOR_FILTER(filterBeanArray[i].getFilterName()));
            }
        }
        if (filterMappingBeanArray != null) {
            for (int i = 0; i < filterMappingBeanArray.length; ++i) {
                this.checkFilterMapping(filterBeanArray, filterMappingBeanArray[i], deploymentInfo);
            }
        }
    }

    private void checkFilter(FilterBean filterBean, ClassLoader classLoader) throws ErrorCollectionException {
        String string = filterBean.getFilterName();
        if (string == null || string.length() == 0) {
            this.addDescriptorError(this.fmt.NO_FILTER_NAME());
        }
        this.checkForExceptions();
        String string2 = filterBean.getFilterClass();
        if (string2 == null || string2.length() == 0) {
            this.addDescriptorError(this.fmt.NO_FILTER_CLASS(string));
        }
        this.checkForExceptions();
        if (string2 != null && classLoader != null && !this.isClassAssignable(classLoader, "filter-class", string2, SUPER_CLASS)) {
            this.checkForExceptions();
        }
    }

    private void checkFilterMapping(FilterBean[] filterBeanArray, FilterMappingBean filterMappingBean, DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        String[] stringArray;
        String string = filterMappingBean.getFilterName();
        if (string != null) {
            this.update(this.fmt.CHECKING_FILTER_MAPPING(string));
        }
        boolean bl = false;
        for (int i = 0; i < filterBeanArray.length; ++i) {
            if (!string.equals(filterBeanArray[i].getFilterName())) continue;
            bl = true;
            break;
        }
        String[] stringArray2 = filterMappingBean.getUrlPatterns();
        String string2 = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            string2 = stringArray2[0];
        }
        if (!bl) {
            this.addDescriptorError(this.fmt.NO_FILTER_DEF_FOR_MAPPING(string2), new DescriptorErrorInfo(new String[]{"<filter-mapping>", "<url-pattern>"}, (Object)string2, new Object[]{"<filter-name>"}));
            this.checkForExceptions();
        }
        if ((stringArray = filterMappingBean.getServletNames()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.validateServletName(stringArray[i], deploymentInfo)) continue;
                this.addDescriptorError(this.fmt.NO_SERVLET_DEF_FOR_FILTER(stringArray[i], string), new DescriptorErrorInfo(new String[]{"<filter-mapping>", "<filter-name>"}, (Object)string, new Object[]{"<servlet-name>"}));
            }
        } else if (stringArray2 != null && stringArray2.length > 0) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.validateURLPattern(string, stringArray2[i]);
            }
        }
        this.checkForExceptions();
    }

    private void validateURLPattern(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            this.addDescriptorError(this.fmt.NO_URL_PATTERN_FOR_FILTER(string), new DescriptorErrorInfo("<filter-name>", (Object)string, "<url-pattern>"));
        }
    }

    public boolean validateServletName(String string, DeploymentInfo deploymentInfo) {
        ServletBean[] servletBeanArray = deploymentInfo.getWebAppBean().getServlets();
        if (servletBeanArray == null || string == null) {
            return false;
        }
        for (int i = 0; i < servletBeanArray.length; ++i) {
            if (!string.equals(servletBeanArray[i].getServletName())) continue;
            return true;
        }
        return false;
    }
}

