/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.util.HashSet;
import java.util.Set;
import weblogic.j2ee.descriptor.SecurityConstraintBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.UserDataConstraintBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebResourceCollectionBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.utils.ErrorCollectionException;

public class SecurityConstraintComplianceChecker
extends BaseComplianceChecker {
    private Set resourceNames;

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        WebAppBean webAppBean = deploymentInfo.getWebAppBean();
        SecurityConstraintBean[] securityConstraintBeanArray = webAppBean.getSecurityConstraints();
        for (int i = 0; i < securityConstraintBeanArray.length; ++i) {
            this.checkSecurityConstraint(securityConstraintBeanArray[i], deploymentInfo);
        }
    }

    private void checkSecurityConstraint(SecurityConstraintBean securityConstraintBean, DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        String string;
        UserDataConstraintBean userDataConstraintBean;
        WebResourceCollectionBean[] webResourceCollectionBeanArray;
        String[] stringArray = securityConstraintBean.getDisplayNames();
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if ((webResourceCollectionBeanArray = securityConstraintBean.getWebResourceCollections()) != null) {
            for (int i = 0; i < webResourceCollectionBeanArray.length; ++i) {
                this.checkResourceCollection(webResourceCollectionBeanArray[i]);
            }
        }
        if ((userDataConstraintBean = securityConstraintBean.getUserDataConstraint()) != null && !SecurityConstraintComplianceChecker.isTransportGuaranteeValid(string = userDataConstraintBean.getTransportGuarantee())) {
            this.addDescriptorError(this.fmt.INVALID_TRANSPORT_GUARANTEE(string));
        }
        if ((string = securityConstraintBean.getAuthConstraint()) != null) {
            String[] stringArray2;
            SecurityRoleBean[] securityRoleBeanArray = deploymentInfo.getWebAppBean().getSecurityRoles();
            String[] stringArray3 = null;
            if (securityRoleBeanArray != null) {
                stringArray3 = new String[securityRoleBeanArray.length];
                for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                    stringArray3[i] = securityRoleBeanArray[i].getRoleName();
                }
            }
            if ((stringArray2 = string.getRoleNames()) != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3 = stringArray2[i];
                    if (string3 != null && "*".equals(string3)) {
                        this.update("info : Since '*' is specified, all roles will be given access to the resource " + (string2 != null ? ": " + string2 : ""));
                        continue;
                    }
                    boolean bl = false;
                    for (int j = 0; j < stringArray3.length; ++j) {
                        if (!stringArray3[j].equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.addDescriptorError(this.fmt.NO_SECURITY_ROLE_FOR_AUTH(string3));
                }
            }
        }
        this.checkForExceptions();
    }

    private void checkResourceCollection(WebResourceCollectionBean webResourceCollectionBean) throws ErrorCollectionException {
        String string = webResourceCollectionBean.getWebResourceName();
        String[] stringArray = webResourceCollectionBean.getUrlPatterns();
        if (!this.addResourceName(string)) {
            this.addDescriptorError(this.fmt.DUPLICATE_RESOURCE_NAME(string));
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.validateURLPattern(string, stringArray[i]);
            }
        }
        this.checkForExceptions();
    }

    private boolean addResourceName(String string) {
        if (this.resourceNames == null) {
            this.resourceNames = new HashSet();
        }
        return this.resourceNames.add(string);
    }

    private static boolean isTransportGuaranteeValid(String string) {
        return "NONE".equals(string) || "INTEGRAL".equals(string) || "CONFIDENTIAL".equals(string);
    }

    private void validateURLPattern(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            this.addDescriptorError(this.fmt.ILLEGAL_URL_PATTERN(string));
        }
    }
}

