/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.util.HashSet;
import weblogic.j2ee.descriptor.RunAsBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.servlet.internal.dd.compliance.DescriptorErrorInfo;
import weblogic.utils.ErrorCollectionException;

public class ServletComplianceChecker
extends BaseComplianceChecker {
    private static final boolean debug = false;
    private static final String SUPER_CLASS = "javax.servlet.Servlet";

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        int n;
        HashSet<String> hashSet = null;
        ServletMappingBean[] servletMappingBeanArray = deploymentInfo.getWebAppBean().getServletMappings();
        ServletBean[] servletBeanArray = deploymentInfo.getWebAppBean().getServlets();
        if (servletBeanArray == null && servletMappingBeanArray == null) {
            return;
        }
        if (servletBeanArray != null) {
            if (servletBeanArray.length > 1) {
                hashSet = new HashSet<String>(servletBeanArray.length);
            }
            for (n = 0; n < servletBeanArray.length; ++n) {
                this.checkServlet(deploymentInfo, servletBeanArray[n], deploymentInfo.getClassLoader());
                if (hashSet == null || hashSet.add(servletBeanArray[n].getServletName())) continue;
                this.addDescriptorError(this.fmt.DUPLICATE_SERVLET_DEF(servletBeanArray[n].getServletName()));
            }
            this.checkForExceptions();
        }
        if (servletMappingBeanArray != null) {
            for (n = 0; n < servletMappingBeanArray.length; ++n) {
                this.checkServletMapping(servletBeanArray, servletMappingBeanArray[n]);
            }
            this.checkForExceptions();
        }
    }

    private void checkServlet(DeploymentInfo deploymentInfo, ServletBean servletBean, ClassLoader classLoader) throws ErrorCollectionException {
        RunAsBean runAsBean;
        Object object;
        if (servletBean == null) {
            return;
        }
        String string = servletBean.getServletName();
        if (string == null || string.length() == 0) {
            this.addDescriptorError(this.fmt.NO_SERVLET_NAME());
        }
        this.checkForExceptions();
        this.update(this.fmt.CHECKING_SERVLET(servletBean.getServletName()));
        String string2 = servletBean.getServletClass();
        String string3 = servletBean.getJspFile();
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            this.addDescriptorError(this.fmt.MULTIPLE_DEFINES_SERVLET_DEF(servletBean.getServletName()), new DescriptorErrorInfo(new String[]{"<servlet>"}, (Object)servletBean.getServletName(), new Object[]{"<jsp-file>", "<servlet-class>"}));
        }
        if (!(string2 != null && string2.length() != 0 || string3 != null && string3.length() != 0)) {
            this.addDescriptorError(this.fmt.NO_SERVLET_DEF(servletBean.getServletName()), new DescriptorErrorInfo("<servlet-name>", (Object)servletBean.getServletName(), "<servlet-class>"));
        }
        if (string2 != null && classLoader != null && !deploymentInfo.isWebServiceModule()) {
            boolean bl = false;
            try {
                object = classLoader.loadClass(string2);
                bl = this.hasWebServiceAnnotations((Class)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl && !this.isClassAssignable(classLoader, "servlet-class", string2, SUPER_CLASS)) {
                this.checkForExceptions();
            }
        }
        if ((runAsBean = servletBean.getRunAs()) != null) {
            object = runAsBean.getRoleName();
            SecurityRoleBean[] securityRoleBeanArray = deploymentInfo.getWebAppBean().getSecurityRoles();
            boolean bl = false;
            if (securityRoleBeanArray != null) {
                for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                    String string4 = securityRoleBeanArray[i].getRoleName();
                    if (!string4.equals(object)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                this.addDescriptorError(this.fmt.NO_SECURITY_ROLE_FOR_RUNAS(servletBean.getServletName(), (String)object), new DescriptorErrorInfo("<servlet>", (Object)servletBean.getServletName(), "<run-as>"));
            }
        }
    }

    private boolean hasWebServiceAnnotations(Class clazz) throws ClassNotFoundException {
        return clazz.isAnnotationPresent(Class.forName("javax.jws.WebService")) || clazz.isAnnotationPresent(Class.forName("javax.xml.ws.WebServiceProvider"));
    }

    private void checkServletMapping(ServletBean[] servletBeanArray, ServletMappingBean servletMappingBean) throws ErrorCollectionException {
        String string = servletMappingBean.getServletName();
        if (string != null) {
            this.update(this.fmt.CHECKING_SERVLET_MAPPING(string));
        }
        boolean bl = false;
        if (servletBeanArray != null) {
            for (int i = 0; i < servletBeanArray.length; ++i) {
                if (!servletBeanArray[i].getServletName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        String[] stringArray = servletMappingBean.getUrlPatterns();
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if (!bl) {
            this.addDescriptorError(this.fmt.NO_SERVLET_DEF_FOR_MAPPING(string2), new DescriptorErrorInfo(new String[]{"<servlet-mapping>", "<url-pattern>"}, (Object)string2, new Object[]{"<servlet-name>"}));
            this.checkForExceptions();
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.validateURLPattern(string, stringArray[i]);
            }
        }
    }

    private void validateURLPattern(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            this.addDescriptorError(this.fmt.NO_URL_PATTERN(string), new DescriptorErrorInfo("<servlet-name>", (Object)string, "<url-pattern>"));
            return;
        }
        if (string2.equalsIgnoreCase("*.jsp")) {
            this.update(this.fmt.warning() + this.fmt.STAR_JSP_URL_PATTERN(string));
        }
    }
}

