/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import weblogic.j2ee.descriptor.JspConfigBean;
import weblogic.j2ee.descriptor.ListenerBean;
import weblogic.j2ee.descriptor.LoginConfigBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.SessionConfigBean;
import weblogic.j2ee.descriptor.TagLibBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.ResourceDescriptionBean;
import weblogic.j2ee.descriptor.wl.ResourceEnvDescriptionBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StringUtils;

public class WebAppDescriptorComplianceChecker
extends BaseComplianceChecker {
    private static final String PARENT_CLASS = "java.util.EventListener";
    private static final String[] LISTENER_CLASSES = new String[]{"javax.servlet.ServletContextListener", "javax.servlet.ServletContextAttributeListener", "javax.servlet.ServletRequestListener", "javax.servlet.ServletRequestAttributeListener", "javax.servlet.http.HttpSessionListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionBindingListener"};
    private static final String SHAREABLE = "Shareable";
    private static final String UNSHAREABLE = "Unshareable";
    private static final String AUTH_APPLICATION = "Application";
    private static final String AUTH_CONTAINER = "Container";
    private static final String AM_BASIC = "BASIC";
    private static final String AM_DIGEST = "DIGEST";
    private static final String AM_FORM = "FORM";
    private static final String AM_CLIENT_CERT = "CLIENT-CERT";

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        int n;
        ListenerBean[] listenerBeanArray;
        JspConfigBean[] jspConfigBeanArray;
        WebAppBean webAppBean = deploymentInfo.getWebAppBean();
        SessionConfigBean[] sessionConfigBeanArray = webAppBean.getSessionConfigs();
        if (sessionConfigBeanArray != null && sessionConfigBeanArray.length > 0) {
            this.validateSessionConfig(sessionConfigBeanArray[0]);
        }
        if ((jspConfigBeanArray = webAppBean.getJspConfigs()) != null && jspConfigBeanArray.length > 0 && (listenerBeanArray = jspConfigBeanArray[0].getTagLibs()) != null) {
            for (n = 0; n < listenerBeanArray.length; ++n) {
                this.validateTagLib((TagLibBean)listenerBeanArray[n]);
            }
        }
        if ((listenerBeanArray = webAppBean.getListeners()) != null) {
            for (n = 0; n < listenerBeanArray.length; ++n) {
                this.validateListeners(listenerBeanArray[n], deploymentInfo);
            }
        }
        ResourceEnvRefBean[] resourceEnvRefBeanArray = webAppBean.getResourceEnvRefs();
        this.validateResourceEnvRefs(resourceEnvRefBeanArray, deploymentInfo);
        LoginConfigBean[] loginConfigBeanArray = webAppBean.getLoginConfigs();
        if (loginConfigBeanArray != null && loginConfigBeanArray.length > 0) {
            this.validateLoginDescriptor(loginConfigBeanArray[0]);
        }
        this.checkForExceptions();
    }

    private void validateSessionConfig(SessionConfigBean sessionConfigBean) {
        if (sessionConfigBean == null) {
            return;
        }
    }

    private void validateListeners(ListenerBean listenerBean, DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        if (listenerBean == null) {
            return;
        }
        String string = listenerBean.getListenerClass();
        ClassLoader classLoader = deploymentInfo.getClassLoader();
        if (string != null && classLoader != null) {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                clazz = classLoader.loadClass(string);
                clazz2 = classLoader.loadClass(PARENT_CLASS);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.addDescriptorError(this.fmt.CLASS_NOT_FOUND("listener", string));
                return;
            }
            boolean bl = clazz2.isAssignableFrom(clazz);
            if (!bl) {
                this.addDescriptorError(this.fmt.INVALID_LISTENER_CLASS(string));
                return;
            }
            boolean bl2 = false;
            for (int i = 0; i < LISTENER_CLASSES.length; ++i) {
                try {
                    Class<?> clazz3 = classLoader.loadClass(LISTENER_CLASSES[i]);
                    bl2 = clazz3.isAssignableFrom(clazz);
                    if (!bl2) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.addDescriptorError(this.fmt.CLASS_NOT_FOUND("listener", LISTENER_CLASSES[i]));
                    this.checkForExceptions();
                }
            }
            if (!bl2) {
                this.addDescriptorError(this.fmt.INVALID_LISTENER_CLASS(string));
                this.checkForExceptions();
            }
        }
    }

    private void validateTagLib(TagLibBean tagLibBean) {
        String string = tagLibBean.getTagLibLocation();
        String string2 = tagLibBean.getTagLibUri();
        if (string2 == null || string2.length() == 0) {
            this.addDescriptorError(this.fmt.NO_TAGLIB_URI());
        }
        if (string == null || string.length() == 0) {
            this.addDescriptorError(this.fmt.NO_TAGLIB_LOCATION());
        }
    }

    private void validateResourceReferences(ResourceRefBean[] resourceRefBeanArray, DeploymentInfo deploymentInfo) {
        if (resourceRefBeanArray == null) {
            return;
        }
        ResourceDescriptionBean[] resourceDescriptionBeanArray = null;
        if (deploymentInfo.getWeblogicWebAppBean() != null) {
            resourceDescriptionBeanArray = deploymentInfo.getWeblogicWebAppBean().getResourceDescriptions();
        }
        for (int i = 0; i < resourceRefBeanArray.length; ++i) {
            String string = null;
            String string2 = resourceRefBeanArray[i].getResRefName();
            String string3 = resourceRefBeanArray[i].getResSharingScope();
            String string4 = resourceRefBeanArray[i].getResAuth();
            boolean bl = false;
            if (string2 != null && resourceDescriptionBeanArray != null) {
                for (int j = 0; j < resourceDescriptionBeanArray.length; ++j) {
                    String string5 = resourceDescriptionBeanArray[j].getResRefName();
                    if (!string2.equals(string5)) continue;
                    bl = true;
                    string = resourceDescriptionBeanArray[j].getJNDIName();
                    break;
                }
                if (!bl) {
                    this.addDescriptorError(this.fmt.NO_RES_DESC_FOR_RESOURCE_REF(string2));
                } else if (string == null || string.equals("")) {
                    this.addDescriptorError(this.fmt.NO_JNDI_NAME_FOR_RESOURCE_DESCRIPTOR(string2));
                }
            }
            if (string3 != null && !SHAREABLE.equalsIgnoreCase(string3) && !UNSHAREABLE.equalsIgnoreCase(string3)) {
                this.addDescriptorError(this.fmt.INVALID_SHARING_SCOPE(string3, string2));
            }
            if (AUTH_APPLICATION.equalsIgnoreCase(string4) || AUTH_CONTAINER.equalsIgnoreCase(string4)) continue;
            this.addDescriptorError(this.fmt.INVALID_RES_AUTH(string2, string4));
        }
    }

    private void validateResourceEnvRefs(ResourceEnvRefBean[] resourceEnvRefBeanArray, DeploymentInfo deploymentInfo) {
        if (resourceEnvRefBeanArray == null) {
            return;
        }
        ResourceEnvDescriptionBean[] resourceEnvDescriptionBeanArray = null;
        if (deploymentInfo.getWeblogicWebAppBean() != null) {
            resourceEnvDescriptionBeanArray = deploymentInfo.getWeblogicWebAppBean().getResourceEnvDescriptions();
        }
        if (resourceEnvDescriptionBeanArray != null) {
            for (int i = 0; i < resourceEnvRefBeanArray.length; ++i) {
                String string = resourceEnvRefBeanArray[i].getResourceEnvRefName();
                boolean bl = false;
                if (resourceEnvDescriptionBeanArray != null && string != null) {
                    for (int j = 0; j < resourceEnvDescriptionBeanArray.length; ++j) {
                        if (!string.equals(resourceEnvDescriptionBeanArray[j].getResourceEnvRefName())) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addDescriptorError(this.fmt.NO_RES_DESC_FOR_ENV_REF(string));
            }
        }
    }

    private void validateLoginDescriptor(LoginConfigBean loginConfigBean) {
        if (loginConfigBean == null) {
            return;
        }
        String string = loginConfigBean.getAuthMethod();
        if (string == null) {
            return;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)", ");
        if (stringArray.length == 0) {
            this.addDescriptorError(this.fmt.INVALID_AUTH_METHOD(string));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(stringArray[i].equals(AM_BASIC) || stringArray[i].equals(AM_FORM) || stringArray[i].equals(AM_CLIENT_CERT) || stringArray[i].equals(AM_DIGEST))) {
                this.addDescriptorError(this.fmt.INVALID_AUTH_METHOD(stringArray[i]));
            }
            if ((stringArray[i].equals(AM_BASIC) || stringArray[i].equals(AM_FORM)) && i != stringArray.length - 1) {
                this.addDescriptorError(this.fmt.INVALID_AUTH_METHOD(string));
            }
            if (stringArray[i].equals(AM_FORM)) {
                if (loginConfigBean.getFormLoginConfig() == null || loginConfigBean.getFormLoginConfig().getFormLoginPage() == null || loginConfigBean.getFormLoginConfig().getFormLoginPage().length() < 1) {
                    this.addDescriptorError(this.fmt.LOGIN_PAGE_MISSING());
                }
                if (loginConfigBean.getFormLoginConfig() == null || loginConfigBean.getFormLoginConfig().getFormErrorPage() == null || loginConfigBean.getFormLoginConfig().getFormErrorPage().length() < 1) {
                    this.addDescriptorError(this.fmt.ERROR_PAGE_MISSING());
                }
            }
            if (!stringArray[i].equals(AM_DIGEST)) continue;
            this.update(this.fmt.warning() + this.fmt.DIGEST_NOT_IMPLEMENTED());
        }
    }
}

