/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.compliance;

import java.io.File;
import java.nio.charset.Charset;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.CharsetMappingBean;
import weblogic.j2ee.descriptor.wl.CharsetParamsBean;
import weblogic.j2ee.descriptor.wl.InputCharsetBean;
import weblogic.j2ee.descriptor.wl.SessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.VirtualDirectoryMappingBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.dd.compliance.BaseComplianceChecker;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.utils.ErrorCollectionException;

public class WebLogicWebAppComplianceChecker
extends BaseComplianceChecker {
    private static final String CHARSET_MAPPING = "charset-mapping";
    private static final String INPUT_CHARSET = "input-charset";
    private static final String URL_MATCH_MAP = "url-match-map";
    private static final String URL_MATCH_MAP_SUPERCLASS = "weblogic.servlet.utils.URLMapping";

    public void check(DeploymentInfo deploymentInfo) throws ErrorCollectionException {
        WeblogicWebAppBean weblogicWebAppBean = deploymentInfo.getWeblogicWebAppBean();
        if (weblogicWebAppBean == null) {
            return;
        }
        CharsetParamsBean charsetParamsBean = (CharsetParamsBean)DescriptorUtils.getOrCreateFirstChild(weblogicWebAppBean, weblogicWebAppBean.getCharsetParams(), "CharsetParams");
        if (charsetParamsBean != null) {
            this.validateCharsetMapping(charsetParamsBean.getCharsetMappings());
            this.validateInputCharset(charsetParamsBean.getInputCharsets());
        }
        VirtualDirectoryMappingBean[] virtualDirectoryMappingBeanArray = weblogicWebAppBean.getVirtualDirectoryMappings();
        this.validateVirtualDirectoryMappings(virtualDirectoryMappingBeanArray);
        this.validateURLMatchMap(weblogicWebAppBean.getUrlMatchMaps().length > 0 ? weblogicWebAppBean.getUrlMatchMaps()[0] : null, deploymentInfo);
        this.validateSessionDescriptor((SessionDescriptorBean)DescriptorUtils.getOrCreateFirstChild(weblogicWebAppBean, weblogicWebAppBean.getSessionDescriptors(), "SessionDescriptor"));
        this.checkForExceptions();
    }

    private void validateCharsetMapping(CharsetMappingBean[] charsetMappingBeanArray) {
        if (charsetMappingBeanArray == null) {
            return;
        }
        for (int i = 0; i < charsetMappingBeanArray.length; ++i) {
            CharsetMappingBean charsetMappingBean = charsetMappingBeanArray[i];
            String string = charsetMappingBean.getJavaCharsetName();
            if (Charset.isSupported(string)) continue;
            this.update(this.fmt.warning() + this.fmt.UNSUPPORTED_ENCODING(CHARSET_MAPPING, string));
        }
    }

    private void validateInputCharset(InputCharsetBean[] inputCharsetBeanArray) {
        if (inputCharsetBeanArray == null) {
            return;
        }
        for (int i = 0; i < inputCharsetBeanArray.length; ++i) {
            String string = inputCharsetBeanArray[i].getJavaCharsetName();
            if (Charset.isSupported(string)) continue;
            this.update(this.fmt.warning() + this.fmt.UNSUPPORTED_ENCODING(INPUT_CHARSET, string));
        }
    }

    private void validateVirtualDirectoryMappings(VirtualDirectoryMappingBean[] virtualDirectoryMappingBeanArray) {
        if (virtualDirectoryMappingBeanArray == null) {
            return;
        }
        for (int i = 0; i < virtualDirectoryMappingBeanArray.length; ++i) {
            String string = virtualDirectoryMappingBeanArray[i].getLocalPath();
            if (string != null) {
                File file = new File(string);
                if (file.exists()) continue;
                this.update(this.fmt.warning() + this.fmt.INVALID_LOCAL_PATH(string));
                continue;
            }
            this.update(this.fmt.warning() + this.fmt.INVALID_LOCAL_PATH(string));
        }
    }

    private void validateURLMatchMap(String string, DeploymentInfo deploymentInfo) {
        ClassLoader classLoader = deploymentInfo.getClassLoader();
        if (string != null) {
            this.isClassAssignable(classLoader, URL_MATCH_MAP, string, URL_MATCH_MAP_SUPERCLASS);
        }
    }

    private void validateSessionDescriptor(SessionDescriptorBean sessionDescriptorBean) {
        if (sessionDescriptorBean == null) {
            return;
        }
        String string = sessionDescriptorBean.getCookieDomain();
        if (string != null && string != null && !string.startsWith(".")) {
            this.update(this.fmt.warning() + this.fmt.INVALID_COOKIE_DOMAIN(string));
        }
    }
}

