/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.glassfish;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.dd.glassfish.BaseGlassfishTagParser;
import weblogic.servlet.internal.dd.glassfish.ClassLoaderTagParser;
import weblogic.servlet.internal.dd.glassfish.ContextRootTagParser;
import weblogic.servlet.internal.dd.glassfish.DefaultTagParser;
import weblogic.servlet.internal.dd.glassfish.EjbRefTagParser;
import weblogic.servlet.internal.dd.glassfish.JspConfigTagParser;
import weblogic.servlet.internal.dd.glassfish.ResourceEnvRefTagParser;
import weblogic.servlet.internal.dd.glassfish.ResourceRefTagParser;
import weblogic.servlet.internal.dd.glassfish.SecurityRoleMappingTagParser;
import weblogic.servlet.internal.dd.glassfish.SessionConfigTagParser;
import weblogic.utils.jars.VirtualJarFile;

public class GlassFishWebAppParser {
    private static final String GLASSFISH_DD = "WEB-INF/glassfish-web.xml";
    private static final String SUNWEB_DD = "WEB-INF/sun-web.xml";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"GlassFishWebAppParser");
    private InputStream descriptorInputStream;
    private Map<String, BaseGlassfishTagParser> parserMap = new HashMap<String, BaseGlassfishTagParser>();

    private GlassFishWebAppParser(InputStream inputStream) {
        this.descriptorInputStream = inputStream;
        this.parserMap.put("context-root", new ContextRootTagParser());
        this.parserMap.put("security-role-mapping", new SecurityRoleMappingTagParser());
        this.parserMap.put("session-config", new SessionConfigTagParser());
        this.parserMap.put("ejb-ref", new EjbRefTagParser());
        this.parserMap.put("resource-ref", new ResourceRefTagParser());
        this.parserMap.put("resource-env-ref", new ResourceEnvRefTagParser());
        this.parserMap.put("class-loader", new ClassLoaderTagParser());
        this.parserMap.put("jsp-config", new JspConfigTagParser());
        this.parserMap.put("default-tag-parser", new DefaultTagParser());
    }

    public static GlassFishWebAppParser getParser(VirtualJarFile virtualJarFile) {
        InputStream inputStream = null;
        if (virtualJarFile != null) {
            ZipEntry zipEntry = virtualJarFile.getEntry(GLASSFISH_DD);
            if (zipEntry == null) {
                zipEntry = virtualJarFile.getEntry(SUNWEB_DD);
            }
            if (zipEntry != null) {
                try {
                    inputStream = virtualJarFile.getInputStream(zipEntry);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return new GlassFishWebAppParser(inputStream);
    }

    public static GlassFishWebAppParser getParser(String string, boolean bl) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        return new GlassFishWebAppParser(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeblogicWebAppBean getWeblogicWebAppBean() throws IOException, XMLStreamException {
        WeblogicWebAppBean weblogicWebAppBean;
        block3: {
            if (this.descriptorInputStream == null) {
                return null;
            }
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(this.descriptorInputStream);
            try {
                weblogicWebAppBean = this.parseDescriptor(xMLStreamReader);
                Object var5_4 = null;
                if (xMLStreamReader == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var5_5 = null;
                    if (xMLStreamReader == null) break block4;
                    xMLStreamReader.close();
                }
                throw throwable;
            }
            xMLStreamReader.close();
        }
        return weblogicWebAppBean;
    }

    private WeblogicWebAppBean parseDescriptor(XMLStreamReader xMLStreamReader) throws IOException, XMLStreamException {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Start Parse Glassfish Descriptor...");
        }
        WeblogicWebAppBean weblogicWebAppBean = this.createWeblogicWebAppBean();
        do {
            int n;
            if ((n = xMLStreamReader.next()) != 1) continue;
            this.getTagParser(xMLStreamReader.getLocalName()).parse(xMLStreamReader, weblogicWebAppBean);
        } while (xMLStreamReader.hasNext());
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Parse Glassfish Descriptor completed!");
        }
        return weblogicWebAppBean;
    }

    private BaseGlassfishTagParser getTagParser(String string) {
        BaseGlassfishTagParser baseGlassfishTagParser = this.parserMap.get(string);
        if (baseGlassfishTagParser == null) {
            baseGlassfishTagParser = this.parserMap.get("default-tag-parser");
        }
        return baseGlassfishTagParser;
    }

    private WeblogicWebAppBean createWeblogicWebAppBean() {
        WeblogicWebAppBean weblogicWebAppBean = (WeblogicWebAppBean)new DescriptorManager().createDescriptorRoot(WeblogicWebAppBean.class).getRootBean();
        return weblogicWebAppBean;
    }
}

