/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.dd.glassfish;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.j2ee.descriptor.wl.SessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.dd.glassfish.BaseGlassfishTagParser;

public class SessionConfigTagParser
extends BaseGlassfishTagParser {
    void parse(XMLStreamReader xMLStreamReader, WeblogicWebAppBean weblogicWebAppBean) throws XMLStreamException {
        int n;
        SessionDescriptorBean sessionDescriptorBean = weblogicWebAppBean.createSessionDescriptor();
        do {
            if ((n = xMLStreamReader.next()) != 1) continue;
            String string = xMLStreamReader.getLocalName();
            if ("session-manager".equals(string)) {
                this.parseSessionManager(xMLStreamReader, sessionDescriptorBean);
                continue;
            }
            if (!"session-properties".equals(string)) continue;
            this.parseSessionProperties(xMLStreamReader, sessionDescriptorBean);
        } while (xMLStreamReader.hasNext() && !this.isEndTag(n, xMLStreamReader, "session-config"));
    }

    void parseSessionManager(XMLStreamReader xMLStreamReader, SessionDescriptorBean sessionDescriptorBean) throws XMLStreamException {
        int n;
        do {
            if ((n = xMLStreamReader.next()) != 1) continue;
            String string = xMLStreamReader.getLocalName();
            if ("manager-properties".equals(string)) {
                this.parseManagerProperties(xMLStreamReader, sessionDescriptorBean);
                continue;
            }
            if (!"store-properties".equals(string)) continue;
            this.parseStoreProperties(xMLStreamReader, sessionDescriptorBean);
        } while (xMLStreamReader.hasNext() && !this.isEndTag(n, xMLStreamReader, "session-manager"));
    }

    private void parseSessionProperties(XMLStreamReader xMLStreamReader, SessionDescriptorBean sessionDescriptorBean) throws XMLStreamException {
        int n;
        do {
            BaseGlassfishTagParser.Property property;
            String string;
            if ((n = xMLStreamReader.next()) != 1 || !"property".equals(string = xMLStreamReader.getLocalName()) || !"timeoutSeconds".equals((property = this.getProperty(xMLStreamReader)).getName())) continue;
            sessionDescriptorBean.setTimeoutSecs(Integer.parseInt(property.getValue()));
            HTTPLogger.logGlassfishDescriptorParsed((String)"timeoutSeconds");
        } while (xMLStreamReader.hasNext() && !this.isEndTag(n, xMLStreamReader, "session-properties"));
    }

    private void parseStoreProperties(XMLStreamReader xMLStreamReader, SessionDescriptorBean sessionDescriptorBean) throws XMLStreamException {
        int n;
        do {
            BaseGlassfishTagParser.Property property;
            String string;
            if ((n = xMLStreamReader.next()) != 1 || !"property".equals(string = xMLStreamReader.getLocalName()) || !"directory".equals((property = this.getProperty(xMLStreamReader)).getName())) continue;
            sessionDescriptorBean.setPersistentStoreDir(property.getValue());
            HTTPLogger.logGlassfishDescriptorParsed((String)"directory");
        } while (xMLStreamReader.hasNext() && !this.isEndTag(n, xMLStreamReader, "store-properties"));
    }

    private void parseManagerProperties(XMLStreamReader xMLStreamReader, SessionDescriptorBean sessionDescriptorBean) throws XMLStreamException {
        int n;
        do {
            String string;
            if ((n = xMLStreamReader.next()) != 1 || !"property".equals(string = xMLStreamReader.getLocalName())) continue;
            BaseGlassfishTagParser.Property property = this.getProperty(xMLStreamReader);
            if ("reapIntervalSeconds".equals(property.getName())) {
                sessionDescriptorBean.setInvalidationIntervalSecs(Integer.parseInt(property.getValue()));
                HTTPLogger.logGlassfishDescriptorParsed((String)"reapIntervalSeconds");
                continue;
            }
            if (!"maxSessions".equals(property.getName())) continue;
            sessionDescriptorBean.setMaxInMemorySessions(Integer.parseInt(property.getValue()));
            HTTPLogger.logGlassfishDescriptorParsed((String)"maxSessions");
        } while (xMLStreamReader.hasNext() && !this.isEndTag(n, xMLStreamReader, "manager-properties"));
    }
}

