/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.sql.DataSource;
import weblogic.cluster.replication.AsyncFlush;
import weblogic.cluster.replication.AsyncQueueManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.servlet.internal.session.AsyncJDBCSessionData;
import weblogic.servlet.internal.session.JDBCSessionData;
import weblogic.utils.collections.Stack;

public class AsyncJDBCPersistenceManager
implements AsyncFlush {
    private AsyncQueueManager queue;
    private String updateQuery;
    private String insertQuery;
    private String deleteQuery;
    private Properties jdbcProps;
    private DataSource dataSource;
    private Stack pendingUpdates;
    private static final int QUERY_TIMEOUT = 30;
    protected static final DebugLogger DEBUG_SESSIONS = DebugLogger.getDebugLogger((String)"DebugHttpSessions");

    public AsyncJDBCPersistenceManager(DataSource dataSource, String string, String string2, String string3, int n, int n2, int n3) {
        this.dataSource = dataSource;
        this.updateQuery = string;
        this.insertQuery = string2;
        this.deleteQuery = string3;
        this.queue = new AsyncQueueManager(this, false, n, n2, n3);
        this.pendingUpdates = new Stack();
    }

    public Connection getConnection() throws SQLException {
        return JDBCSessionData.getConnection(this.dataSource, null);
    }

    public void update(AsyncJDBCSessionData asyncJDBCSessionData) {
        this.queue.addToUpdates(asyncJDBCSessionData);
    }

    public void blockingFlush() {
        this.queue.flushOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void flushQueue(BlockingQueue blockingQueue) {
        HashSet hashSet = new HashSet();
        blockingQueue.drainTo(hashSet);
        if (this.pendingUpdates.size() > 0) {
            hashSet.addAll(this.pendingUpdates);
            this.pendingUpdates.clear();
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (SQLException sQLException) {
            if (DEBUG_SESSIONS.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("Database unavailable", (Throwable)sQLException);
            }
            this.pendingUpdates.addAll(hashSet);
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            this.createSessionsInDB(connection, preparedStatement, hashSet);
            this.updateSessionsInDB(connection, preparedStatement, hashSet);
            this.removeSessionsInDB(connection, preparedStatement, hashSet);
            if (DEBUG_SESSIONS.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("Persisted " + hashSet.size() + " sessions to the database");
            }
            Object var6_6 = null;
            this.closeStatement(preparedStatement);
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeStatement(preparedStatement);
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
            return;
        }
        catch (SQLException sQLException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionsInDB(Connection connection, PreparedStatement preparedStatement, Set set) {
        boolean bl = false;
        try {
            block6: {
                try {
                    preparedStatement = connection.prepareStatement(this.insertQuery);
                    for (AsyncJDBCSessionData asyncJDBCSessionData : set) {
                        if (asyncJDBCSessionData.getState() != 1) continue;
                        bl = true;
                        asyncJDBCSessionData.addStatements(preparedStatement);
                        preparedStatement.addBatch();
                    }
                    if (!bl) break block6;
                    preparedStatement.executeBatch();
                }
                catch (SQLException sQLException) {
                    if (DEBUG_SESSIONS.isDebugEnabled()) {
                        DEBUG_SESSIONS.debug("Failed while making bulk  insert. We will automatically attempt to fix this ", (Throwable)sQLException);
                    }
                    Object var8_9 = null;
                    this.closeStatement(preparedStatement);
                }
            }
            Object var8_8 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionsInDB(Connection connection, PreparedStatement preparedStatement, Set set) {
        boolean bl = false;
        try {
            block6: {
                try {
                    preparedStatement = connection.prepareStatement(this.updateQuery);
                    for (AsyncJDBCSessionData asyncJDBCSessionData : set) {
                        if (asyncJDBCSessionData.getState() != 2) continue;
                        bl = true;
                        asyncJDBCSessionData.addStatements(preparedStatement);
                        preparedStatement.addBatch();
                    }
                    if (!bl) break block6;
                    preparedStatement.executeBatch();
                }
                catch (SQLException sQLException) {
                    if (DEBUG_SESSIONS.isDebugEnabled()) {
                        DEBUG_SESSIONS.debug("Failed while making bulk  update. We will automatically attempt to fix this ", (Throwable)sQLException);
                    }
                    Object var8_9 = null;
                    this.closeStatement(preparedStatement);
                }
            }
            Object var8_8 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionsInDB(Connection connection, PreparedStatement preparedStatement, Set set) {
        boolean bl = false;
        try {
            block6: {
                try {
                    preparedStatement = connection.prepareStatement(this.deleteQuery);
                    AsyncJDBCPersistenceManager.setQueryTimeout(preparedStatement, 30);
                    for (AsyncJDBCSessionData asyncJDBCSessionData : set) {
                        if (asyncJDBCSessionData.getState() != 3) continue;
                        bl = true;
                        asyncJDBCSessionData.addStatements(preparedStatement);
                        preparedStatement.addBatch();
                    }
                    if (!bl) break block6;
                    preparedStatement.executeBatch();
                }
                catch (SQLException sQLException) {
                    if (DEBUG_SESSIONS.isDebugEnabled()) {
                        DEBUG_SESSIONS.debug("Failed to invalidate some  sessions. The server will perform auto recovery", (Throwable)sQLException);
                    }
                    Object var8_9 = null;
                    this.closeStatement(preparedStatement);
                }
            }
            Object var8_8 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private static void setQueryTimeout(PreparedStatement preparedStatement, int n) {
        try {
            preparedStatement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

