/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.util.Collections;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.AsyncJDBCPersistenceManager;
import weblogic.servlet.internal.session.AsyncJDBCSessionData;
import weblogic.servlet.internal.session.JDBCSessionContext;
import weblogic.servlet.internal.session.JDBCSessionData;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;

public class AsyncJDBCSessionContext
extends JDBCSessionContext {
    private AsyncJDBCPersistenceManager persistenceManager;

    public AsyncJDBCSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
        this.persistenceManager = new AsyncJDBCPersistenceManager(this.dataSource, this.updateQuery, this.insertQuery, this.deleteQuery, this.configMgr.getPersistentSessionFlushInterval(), this.configMgr.getPersistentSessionFlushThreshold(), this.configMgr.getPersistentAsyncQueueTimeout());
    }

    public String getPersistentStoreType() {
        return "async-jdbc";
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        JDBCSessionData jDBCSessionData = AsyncJDBCSessionData.newSession(string, this, this.dataSource, this.properties);
        if (jDBCSessionData == null) {
            return null;
        }
        jDBCSessionData.incrementActiveRequestCount();
        if (this.cache != Collections.EMPTY_MAP) {
            this.cache.put(jDBCSessionData.id, jDBCSessionData);
        }
        this.incrementOpenSessionsCount();
        SessionData.checkSpecial(servletRequestImpl, jDBCSessionData);
        jDBCSessionData.setMonitoringId();
        return jDBCSessionData;
    }

    public JDBCSessionData getSessionDataFromDB(String string, Properties properties) {
        return AsyncJDBCSessionData.getFromDB(string, this, this.dataSource, properties);
    }

    protected JDBCSessionData createNewData(String string, SessionContext sessionContext, DataSource dataSource, Properties properties, boolean bl) {
        return new AsyncJDBCSessionData(string, sessionContext, dataSource, properties, bl);
    }

    public AsyncJDBCPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void destroy(boolean bl) {
        this.persistenceManager.blockingFlush();
        super.destroy(bl);
    }
}

