/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import weblogic.servlet.internal.session.AsyncJDBCSessionContext;
import weblogic.servlet.internal.session.JDBCSessionData;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.utils.StackTraceUtils;

public class AsyncJDBCSessionData
extends JDBCSessionData {
    private static final long serialVersionUID = 7506555655775346941L;
    public static final int SHOULD_BATCH = 0;
    public static final int CREATE = 1;
    public static final int UPDATE = 2;
    public static final int REMOVE = 3;
    private AsyncJDBCSessionContext jdbcCtx;
    private boolean blockingFlushCall = false;
    private boolean shouldBatch = false;
    private boolean shouldCreate = false;
    private int state;

    public AsyncJDBCSessionData(String string, SessionContext sessionContext, DataSource dataSource, Properties properties, boolean bl) {
        super(string, sessionContext, dataSource, properties, bl);
        this.jdbcCtx = (AsyncJDBCSessionContext)sessionContext;
        this.state = 0;
        this.shouldBatch = true;
    }

    static JDBCSessionData newSession(String string, SessionContext sessionContext, DataSource dataSource, Properties properties) {
        AsyncJDBCSessionData asyncJDBCSessionData = new AsyncJDBCSessionData(string, sessionContext, dataSource, properties, true);
        asyncJDBCSessionData.shouldCreate = true;
        sessionContext.getServletContext().getEventsManager().notifySessionLifetimeEvent(asyncJDBCSessionData, true);
        return asyncJDBCSessionData;
    }

    void syncSession() {
        super.syncSession();
        if (this.blockingFlushCall) {
            this.jdbcCtx.getPersistenceManager().blockingFlush();
            this.blockingFlushCall = false;
        }
    }

    public int getState() {
        return this.state;
    }

    protected synchronized void dbCreate() {
        this.state = 1;
        this.jdbcCtx.getPersistenceManager().update(this);
        this.shouldBatch = false;
    }

    protected synchronized void dbUpdate() {
        if (this.shouldBatch) {
            if (this.shouldCreate) {
                this.shouldCreate = false;
                this.state = 1;
            } else {
                this.state = 2;
            }
            this.jdbcCtx.getPersistenceManager().update(this);
            this.shouldBatch = false;
        }
    }

    protected synchronized void dbRemove() {
        this.state = 3;
        if (this.shouldBatch) {
            this.shouldBatch = false;
            this.jdbcCtx.getPersistenceManager().update(this);
        }
    }

    private void commit() {
        this.state = 0;
        this.shouldBatch = true;
    }

    public synchronized void addStatements(PreparedStatement preparedStatement) throws SQLException {
        if (this.state == 0) {
            throw new AssertionError((Object)("This should never happen, and state is " + this.state));
        }
        if (this.state == 1) {
            this.addCreateStatement(preparedStatement);
        } else if (this.state == 2) {
            try {
                this.addFirstUpdateStatement(preparedStatement);
            }
            catch (IOException iOException) {
                throw new SQLException("Could not serialize attributes to update session " + this.id + ":\n" + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
            this.addTimeSensitiveUpdateStatement(preparedStatement);
        } else if (this.state == 3) {
            this.addRemoveStatement(preparedStatement);
        }
        this.dbLAT = this.accessTime;
        this.commit();
    }

    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        if (string.equals("weblogic.authuser")) {
            this.blockingFlushCall = true;
        }
    }
}

