/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import javax.servlet.http.HttpSession;
import weblogic.cluster.replication.AsyncReplicationManager;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.AsyncReplicatedSessionData;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionConfigManager;

public class AsyncReplicatedSessionContext
extends ReplicatedSessionContext {
    private static final ReplicationServices repserv = AsyncReplicationManager.services();

    public AsyncReplicatedSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
    }

    public String getPersistentStoreType() {
        return "async-replication";
    }

    protected ReplicationServices getReplicationServices() {
        return repserv;
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        this.checkSessionCount();
        AsyncReplicatedSessionData asyncReplicatedSessionData = new AsyncReplicatedSessionData(string, this);
        asyncReplicatedSessionData.setMonitoringId();
        return asyncReplicatedSessionData;
    }

    public void destroy(boolean bl) {
        ((AsyncReplicationManager)repserv).blockingFlush();
        super.destroy(bl);
    }
}

