/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.Serializable;
import weblogic.cluster.replication.AsyncReplicatable;
import weblogic.cluster.replication.AsyncReplicationManager;
import weblogic.servlet.internal.session.AsyncReplicatedSessionChange;
import weblogic.servlet.internal.session.ReplicatedSessionChange;
import weblogic.servlet.internal.session.ReplicatedSessionData;
import weblogic.servlet.internal.session.SessionContext;

public class AsyncReplicatedSessionData
extends ReplicatedSessionData
implements AsyncReplicatable {
    private static final long serialVersionUID = -7620574765802976000L;
    private transient ReplicatedSessionChange asyncChange;
    private boolean blockingFlushCall = false;

    public AsyncReplicatedSessionData() {
    }

    public AsyncReplicatedSessionData(String string, SessionContext sessionContext) {
        super(string, sessionContext, true);
    }

    protected AsyncReplicatedSessionData(String string, SessionContext sessionContext, boolean bl) {
        super(string, sessionContext, bl);
    }

    protected void initializeChange() {
        this.asyncChange = new AsyncReplicatedSessionChange();
    }

    protected ReplicatedSessionChange getSessionChange() {
        return this.asyncChange;
    }

    void syncSession() {
        super.syncSession();
        if (this.blockingFlushCall) {
            ((AsyncReplicationManager)this.getReplicationServices()).blockingFlush();
            this.blockingFlushCall = false;
        }
    }

    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        if (string.equals("weblogic.authuser")) {
            this.blockingFlushCall = true;
        }
    }

    protected Serializable getUpdateObject() {
        return this;
    }

    public void setQueued() {
        ((AsyncReplicatedSessionChange)this.asyncChange).setQueued();
    }

    public boolean isQueued() {
        return ((AsyncReplicatedSessionChange)this.asyncChange).isQueued();
    }

    public Serializable getBatchedChanges() {
        return this.asyncChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        ReplicatedSessionChange replicatedSessionChange = this.asyncChange;
        synchronized (replicatedSessionChange) {
            ((AsyncReplicatedSessionChange)this.asyncChange).commit();
        }
    }
}

