/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import weblogic.logging.Loggable;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.CookieSessionData;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;

public final class CookieSessionContext
extends SessionContext {
    private final String cookieName;

    public CookieSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
        this.cookieName = this.configMgr.getCookiePersistentStoreCookieName();
    }

    protected void initializeInvalidator() {
    }

    public String getPersistentStoreType() {
        return "cookie";
    }

    String getWLCookieName() {
        return this.cookieName;
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        if (servletResponseImpl == null) {
            return null;
        }
        servletResponseImpl.removeCookie(this.cookieName, "/");
        CookieSessionData cookieSessionData = new CookieSessionData(string, this, servletRequestImpl, servletResponseImpl);
        SessionData.checkSpecial(servletRequestImpl, cookieSessionData);
        this.incrementOpenSessionsCount();
        return cookieSessionData;
    }

    public SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        if (servletRequestImpl == null || servletResponseImpl == null) {
            return null;
        }
        string = RSID.getID(string);
        Cookie cookie = this.getCookie(servletRequestImpl);
        if (cookie == null || cookie.getValue() == null || cookie.getValue().length() < 4 || cookie.getValue().indexOf("|") == -1) {
            return null;
        }
        try {
            CookieSessionData cookieSessionData = new CookieSessionData(string, this, servletRequestImpl, servletResponseImpl, cookie);
            if (servletRequestImpl != null && servletResponseImpl != null && !cookieSessionData.isValidForceCheck()) {
                return null;
            }
            return cookieSessionData;
        }
        catch (Exception exception) {
            cookie.setValue("");
            return null;
        }
    }

    public String[] getIdsInternal() {
        return new String[0];
    }

    void unregisterExpiredSessions(ArrayList arrayList) {
    }

    boolean invalidateSession(SessionData sessionData, boolean bl, boolean bl2) {
        sessionData.remove(bl2);
        this.decrementOpenSessionsCount();
        SessionData.invalidateProcessedSession(sessionData);
        return true;
    }

    public void destroy(boolean bl) {
    }

    public void sync(HttpSession httpSession) {
    }

    public Cookie getCookie(ServletRequestImpl servletRequestImpl) {
        Cookie[] cookieArray = servletRequestImpl.getCookies();
        if (cookieArray == null) {
            return null;
        }
        for (int i = cookieArray.length - 1; i > -1; --i) {
            if (!this.cookieName.equals(cookieArray[i].getName())) continue;
            if (this.isDebugEnabled()) {
                Loggable loggable = HTTPSessionLogger.logFoundWLCookieLoggable((String)this.cookieName, (String)cookieArray[i].getValue());
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            return cookieArray[i];
        }
        return null;
    }

    public int getNonPersistedSessionCount() {
        return 0;
    }

    public int getCurrOpenSessionsCount() {
        return 0;
    }
}

