/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import weblogic.servlet.internal.AttributeWrapper;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.session.CookieSessionContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;

public final class CookieSessionData
extends SessionData {
    private static final long serialVersionUID = 1423350728235186420L;
    private ServletResponseImpl response = null;
    private Cookie wlcookie = null;
    private static final String EQL = "/";
    static final String DELIMITER = "|";

    public CookieSessionData(String string, SessionContext sessionContext, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, Cookie cookie) {
        super(string, sessionContext, false);
        this.wlcookie = cookie;
        this.response = servletResponseImpl;
        this.initSessionPropsFromCookie(this.wlcookie.getValue());
        if (!sessionContext.getConfigMgr().isSessionSharingEnabled()) {
            this.wlcookie.setPath(this.response.processProxyPathHeaders(this.getContextPath()));
        }
        this.response.addCookie(this.wlcookie);
        this.setNew(false);
    }

    public CookieSessionData(String string, SessionContext sessionContext, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        super(string, sessionContext, true);
        this.response = servletResponseImpl;
        this.wlcookie = new Cookie(((CookieSessionContext)sessionContext).getWLCookieName(), this.getCookieValue());
        if (!sessionContext.getConfigMgr().isSessionSharingEnabled()) {
            this.wlcookie.setPath(this.response.processProxyPathHeaders(this.getContextPath()));
        }
        this.response.addCookie(this.wlcookie);
        this.getWebAppServletContext().getEventsManager().notifySessionLifetimeEvent(this, true);
    }

    protected void initRuntime() {
    }

    public synchronized void setAttribute(String string, Object object, boolean bl) throws IllegalStateException, IllegalArgumentException {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Cookie based sessions support attributes of type \"String\" only; could not set attribute: " + string);
        }
        super.setAttribute(string, object, bl);
        this.wlcookie.setValue(this.getCookieValue());
    }

    protected void removeAttribute(String string, boolean bl) throws IllegalStateException {
        super.removeAttribute(string, bl);
        this.wlcookie.setValue(this.getCookieValue());
    }

    public synchronized void setInternalAttribute(String string, Object object) throws IllegalStateException, IllegalArgumentException {
        if (object instanceof String) {
            super.setInternalAttribute(string, object);
            this.wlcookie.setValue(this.getCookieValue());
        }
    }

    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        this.wlcookie.setValue(this.getCookieValue());
    }

    public void setLastAccessedTime(long l) {
        super.setLastAccessedTime(l);
        if (this.wlcookie != null) {
            this.wlcookie.setValue(this.getCookieValue());
        }
    }

    public void setMaxInactiveInterval(int n) {
        super.setMaxInactiveInterval(n);
        this.wlcookie.setValue(this.getCookieValue());
    }

    public void invalidate(boolean bl) throws IllegalStateException {
        if (!this.isValid) {
            throw new IllegalStateException("Session already invalidated");
        }
        this.getContext().invalidateSession(this, false, bl);
        this.wlcookie.setValue("");
        this.wlcookie.setMaxAge(0);
        this.setValid(false);
    }

    private String getCookieValue() {
        String string = "" + this.creationTime + DELIMITER + this.accessTime + DELIMITER + this.maxInactiveInterval;
        if (this.attributes != null) {
            for (String string2 : this.attributes.keySet()) {
                if ("weblogic.authuser".equals(string2)) continue;
                String string3 = this.getAttribute(string2).toString();
                if (string3 == null) {
                    string3 = "";
                }
                string = string + DELIMITER + string2 + EQL + string3;
            }
        }
        return string;
    }

    private void initSessionPropsFromCookie(String string) {
        try {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            String string2 = stringTokenizer.nextToken();
            this.creationTime = new Long(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            string2 = stringTokenizer.nextToken();
            this.accessTime = new Long(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            string2 = stringTokenizer.nextToken();
            this.maxInactiveInterval = new Integer(string2);
            this.attributes = new ConcurrentHashMap();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf(EQL);
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                this.attributes.put(string4, new AttributeWrapper(string5));
            }
        }
        catch (Exception exception) {
            HTTPSessionLogger.logMalformedWLCookie((String)string, (Exception)exception);
            return;
        }
    }

    protected void logTransientAttributeError(String string) {
    }
}

