/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.util.ArrayList;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;

public abstract class ExtendableSessionContext
extends SessionContext {
    public ExtendableSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
    }

    protected void postCreateSession(ServletRequestImpl servletRequestImpl, SessionData sessionData) {
        SessionData.checkSpecial(servletRequestImpl, sessionData);
        sessionData.setMonitoringId();
    }

    public void incrementSessionCount(SessionData sessionData) {
        sessionData.incrementActiveRequestCount();
        this.incrementOpenSessionsCount();
    }

    public void decrementSessionCount(SessionData sessionData) {
        sessionData.decrementActiveRequestCount();
        this.decrementOpenSessionsCount();
    }

    protected void syncSession(SessionData sessionData) {
    }

    public boolean invalidateSessionFromContext(SessionData sessionData, boolean bl) {
        this.servletContext.getServer().getSessionLogin().unregister(sessionData.id, sessionData.getContextPath());
        sessionData.unregisterRuntimeMBean();
        SessionData.invalidateProcessedSession(sessionData);
        return true;
    }

    boolean invalidateSession(SessionData sessionData, boolean bl, boolean bl2) {
        return false;
    }

    protected void initializeInvalidator() {
    }

    void unregisterExpiredSessions(ArrayList arrayList) {
    }
}

