/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import weblogic.cache.utils.BubblingCache;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HTTPDebugLogger;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.FileSessionData;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;

public final class FileSessionContext
extends SessionContext {
    private static final String ROOT = "webapps" + File.separator;
    private File sessionDir = null;
    private int sessionDirLen = 0;
    private static final Object dirTreeLock = new Object();
    private BubblingCache cachedSessions = null;
    private int fileSessionsCacheSize = 256;
    protected static final String[][] RESERVED = new String[][]{new String[0], new String[0], new String[0], {"PRN"}, {"LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"}, new String[0], new String[0]};
    protected static final boolean WRITE_VERSIONS = !Boolean.getBoolean("weblogic.servlet.session.PersistentBackCompatibility");
    private static final int PATH_LIM = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
        Object object;
        String string;
        try {
            string = webAppServletContext.getTempPath();
            String string2 = this.configMgr.getPersistentStoreDir();
            string2 = string2.replace('/', File.separatorChar);
            if (!FileSessionContext.isAbsolute(string2)) {
                object = new File(DomainDir.getDataDirForServer((String)webAppServletContext.getServer().getServerName()), ROOT + string);
                if (!((File)object).exists() && !((File)object).mkdirs()) {
                    HTTPLogger.logUnableToMakeDirectory((String)webAppServletContext.getLogContext(), (String)((File)object).getAbsolutePath());
                }
                this.sessionDir = new File((File)object, string2);
            } else {
                object = webAppServletContext.getName();
                if (object != null && ((String)object).length() > 0) {
                    string2 = string2 + File.separatorChar + (String)object;
                }
                this.sessionDir = new File(string2);
            }
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
        if (this.configMgr.isCleanupSessionFilesEnabled()) {
            this.deleteSessionTree();
        }
        if (this.isDebugEnabled()) {
            string = HTTPSessionLogger.logPersistenceLoggable((String)this.sessionDir.getAbsolutePath());
            DEBUG_SESSIONS.debug(string.getMessage());
        }
        boolean bl = false;
        for (int i = 0; i < 10; ++i) {
            object = dirTreeLock;
            synchronized (object) {
                if (this.sessionDir.mkdirs() || this.sessionDir.isDirectory()) {
                    bl = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!bl) {
            throw new RuntimeException("Cannot make directory: " + this.sessionDir.getAbsolutePath());
        }
        String string3 = this.sessionDir.getAbsolutePath();
        this.sessionDirLen = string3.endsWith(File.separator) ? string3.length() : string3.length() + 1;
        this.fileSessionsCacheSize = this.configMgr.getCacheSize();
        if (this.fileSessionsCacheSize > 0) {
            this.cachedSessions = new BubblingCache(this.fileSessionsCacheSize);
        }
    }

    static boolean containsReservedKeywords(String string) {
        String string2;
        int n;
        int n2;
        String[] stringArray = FileSessionContext.getStorageDirs(string.toUpperCase());
        if (4 <= RESERVED.length) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                String string3 = stringArray[i];
                for (n2 = 0; n2 < RESERVED[4].length; ++n2) {
                    if (!RESERVED[4][n2].equals(string3)) continue;
                    return true;
                }
            }
        }
        if ((n = (string2 = stringArray[stringArray.length - 1]).length()) <= RESERVED.length) {
            for (n2 = 0; n2 < RESERVED[n].length; ++n2) {
                if (!RESERVED[n][n2].equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    protected void invalidateOrphanedSessions() {
        int n;
        Set set = this.getServletContext().getServer().getSessionLogin().getAllIds();
        if (set.isEmpty()) {
            return;
        }
        String[] stringArray = this.getIdsInternal();
        for (n = 0; n < stringArray.length; ++n) {
            set.remove(stringArray[n]);
        }
        if (n == 0) {
            return;
        }
        String string2 = null;
        for (String string2 : set) {
            this.getServletContext().getServer().getSessionLogin().unregister(string2, this.getServletContext().getContextPath());
        }
    }

    private static boolean isAbsolute(String string) {
        String string2 = System.getProperty("os.name");
        if (string2 != null && (string2 = string2.toLowerCase(Locale.ENGLISH)).indexOf("windows") >= 0 && string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return true;
        }
        return string.length() > 0 && string.charAt(0) == File.separatorChar;
    }

    public String getPersistentStoreType() {
        return "file";
    }

    private void deleteSessionTree() {
        Object object;
        if (this.isDebugEnabled()) {
            object = HTTPSessionLogger.logDeleteDirectoryLoggable((String)this.sessionDir.getAbsolutePath());
            DEBUG_SESSIONS.debug(object.getMessage());
        }
        object = new FileEnumerator(this, true, false);
        ((FileEnumerator)object).recurse(this.sessionDir);
        File[] fileArray = ((FileEnumerator)object).getSessionFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].delete()) continue;
            HTTPSessionLogger.logUnableToDelete((String)fileArray[i].getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeStorageDir(String string) {
        boolean bl = false;
        File file = this.getSessionPath(RSID.getID(string));
        if ((file = new File(file.getParent())).isDirectory()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            Object object = dirTreeLock;
            synchronized (object) {
                if (file.mkdirs() || file.isDirectory()) {
                    bl = true;
                    break;
                }
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new RuntimeException("Cannot make directory: " + file.getAbsolutePath());
        }
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        FileSessionData fileSessionData = new FileSessionData(string, this, true);
        SessionData.checkSpecial(servletRequestImpl, fileSessionData);
        fileSessionData.incrementActiveRequestCount();
        this.addSession(fileSessionData.id, fileSessionData);
        this.makeStorageDir(fileSessionData.id);
        this.incrementOpenSessionsCount();
        fileSessionData.setMonitoringId();
        return fileSessionData;
    }

    private String path2session(File file) {
        String string = file.getAbsolutePath().substring(this.sessionDirLen);
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String session2path(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = FileSessionContext.getStorageDirs(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(File.separatorChar);
            }
            stringBuilder.append(stringArray[stringArray.length - 1]);
        }
        return stringBuilder.toString();
    }

    static String[] getStorageDirs(String string) {
        int n = string.length();
        int n2 = n / 4;
        if (n % 4 > 0) {
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n - 4) {
            stringArray[n4] = string.substring(n3, n3 + 4);
            n3 += 4;
            ++n4;
        }
        stringArray[n2 - 1] = string.substring(n3);
        return stringArray;
    }

    public File getSessionPath(String string) {
        return new File(this.sessionDir, this.session2path(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sync(HttpSession var1_1) {
        var2_2 = (FileSessionData)var1_1;
        if (!var2_2.isValid()) {
            return;
        }
        var2_2.syncSession();
        var3_3 = var2_2;
        synchronized (var3_3) {
            block25: {
                var2_2.decrementActiveRequestCount();
                if (var2_2.sessionInUse() || !var2_2.isValid()) {
                    return;
                }
                var2_2.notifyAboutToPassivate(new HttpSessionEvent((HttpSession)var2_2));
                var4_4 = var2_2.id;
                if (this.cachedSessions != null) {
                    this.cachedSessions.put(var2_2.id, var1_1);
                }
                var5_5 = null;
                var6_6 = null;
                try {
                    block24: {
                        var6_6 = this.getSessionPath(var4_4);
                        var7_7 = FileSessionContext.dirTreeLock;
                        synchronized (var7_7) {
                            this.makeStorageDir(var4_4);
                            var5_5 = new DataOutputStream(new FileOutputStream(var6_6));
                            var8_10 = new WLObjectOutputStream(var5_5);
                            var8_10.setReplacer(RemoteObjectReplacer.getReplacer());
                            var8_10.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
                            if (FileSessionContext.WRITE_VERSIONS) {
                                this.writeVersionInfo((WebAppServletContext)var2_2.getServletContext(), var8_10);
                            }
                            var8_10.writeObject(var2_2);
                            var8_10.flush();
                            var5_5.writeLong(var2_2.getLAT());
                            var8_10.close();
                            var5_5.close();
                        }
                        if (var2_2.transientAttributes != null) {
                            this.transientData.put(var4_4, var2_2.transientAttributes);
                        }
                        var5_5 = null;
                        if (!this.isDebugEnabled()) break block24;
                        var7_7 = HTTPSessionLogger.logPickledSessionLoggable((String)var4_4, (String)var6_6.getAbsolutePath());
                        FileSessionContext.DEBUG_SESSIONS.debug(var7_7.getMessage());
                    }
                    var11_12 = null;
                    ** if (var5_5 == null) goto lbl-1000
                }
                catch (Throwable var10_18) {
                    var11_14 = null;
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (Exception var12_17) {
                            // empty catch block
                        }
                    }
                    throw var10_18;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var5_5.close();
                    }
                    catch (Exception var12_15) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                    catch (ThreadDeath var7_8) {
                        throw var7_8;
                    }
                    catch (Throwable var7_9) {
                        HTTPSessionLogger.logErrorSavingSessionData((Throwable)var7_9);
                        if (var6_6 != null) {
                            var6_6.delete();
                        }
                        var11_13 = null;
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (Exception var12_16) {}
                        }
                    }
                }
            }
            this.removeSession(var4_4);
        }
    }

    public void destroy(boolean bl, boolean bl2) {
        super.destroy(bl2);
        if (this.configMgr.isCleanupSessionFilesEnabled()) {
            this.deleteSessionTree();
        }
    }

    private void writeVersionInfo(WebAppServletContext webAppServletContext, ObjectOutputStream objectOutputStream) throws IOException {
        if (webAppServletContext.getVersionId() == null) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(new AppVersionInfo(webAppServletContext.getVersionId()));
        }
    }

    private File getParent(File file) {
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        File file2 = new File(string);
        if ((string = file2.getAbsolutePath()).length() <= this.sessionDirLen) {
            return null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delTree(File file) {
        Object object = dirTreeLock;
        synchronized (object) {
            if (file == null || !file.exists()) {
                return;
            }
            do {
                String[] stringArray;
                if ((stringArray = file.list()) != null && stringArray.length > 0) {
                    return;
                }
                if (file.delete()) continue;
                return;
            } while ((file = this.getParent(file)) != null);
        }
    }

    boolean invalidateSession(SessionData sessionData, boolean bl, boolean bl2) {
        block15: {
            if (sessionData == null) {
                return false;
            }
            String string = sessionData.id;
            File file = this.getSessionPath(string);
            this.removeSession(string);
            if (this.cachedSessions != null) {
                this.cachedSessions.remove(sessionData.id);
            }
            this.transientData.remove(string);
            sessionData.remove(bl2);
            sessionData.setValid(false);
            this.decrementOpenSessionsCount();
            try {
                int n;
                boolean bl3 = false;
                int n2 = n = bl ? 1 : 3;
                while (n > 0) {
                    if (!file.exists()) {
                        if (this.isDebugEnabled()) {
                            Loggable loggable = HTTPSessionLogger.logNotInvalidatedLoggable((String)file.getAbsolutePath());
                            DEBUG_SESSIONS.debug(loggable.getMessage());
                        }
                        return false;
                    }
                    if (file.delete()) {
                        bl3 = true;
                        break;
                    }
                    if (n > 1) {
                        if (this.isDebugEnabled()) {
                            DEBUG_SESSIONS.debug("Retry deleting session persistent file : " + file.getAbsolutePath());
                        }
                        try {
                            Thread.sleep(50 + (int)(Math.random() * 50.0));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    --n;
                }
                if (!bl3) {
                    HTTPSessionLogger.logUnableToDelete((String)file.getAbsolutePath());
                } else if (this.isDebugEnabled()) {
                    Loggable loggable = HTTPSessionLogger.logDeletedFileLoggable((String)file.getAbsolutePath());
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                }
                this.delTree(this.getParent(file));
                SessionData.invalidateProcessedSession(sessionData);
            }
            catch (Throwable throwable) {
                HTTPSessionLogger.logTestFailure((String)string, (Throwable)throwable);
                if (file == null) break block15;
                file.delete();
                this.delTree(this.getParent(file));
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private FileSessionData loadSession(FileInputStream var1_1, File var2_2, String var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void logLoadingErrorForDebug(Exception exception) {
        this.logLoadingErrorForDebug(null, exception);
    }

    private final void logLoadingErrorForDebug(String string, Exception exception) {
        if (HTTPDebugLogger.isEnabled()) {
            HTTPDebugLogger.debug(string != null ? string : "Failed to load session from file. It could be interfered by other server which is pointing to the same persistent file system.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIdsInternal() {
        FileEnumerator fileEnumerator = new FileEnumerator(this, false, false);
        Object object = dirTreeLock;
        synchronized (object) {
            fileEnumerator.recurse(this.sessionDir);
        }
        return fileEnumerator.getSessionIds();
    }

    void unregisterExpiredSessions(ArrayList arrayList) {
    }

    public int getCurrOpenSessionsCount() {
        FileEnumerator fileEnumerator = new FileEnumerator(this, false, true);
        fileEnumerator.recurse(this.sessionDir);
        return fileEnumerator.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCacheStale(SessionData var1_1) {
        var2_2 = this.getSessionPath(var1_1.id);
        if (!var2_2.exists()) {
            if (this.isDebugEnabled() == false) return true;
            var3_3 = HTTPSessionLogger.logNotInvalidatedLoggable((String)var2_2.getAbsolutePath());
            FileSessionContext.DEBUG_SESSIONS.debug(var3_3.getMessage());
            return true;
        }
        var3_4 = null;
        var4_5 = FileSessionContext.dirTreeLock;
        synchronized (var4_5) {
            try {
                block16: {
                    try {
                        var3_4 = new RandomAccessFile(var2_2, "r");
                        var3_4.seek(var2_2.length() - 8L);
                        var5_6 = var3_4.readLong();
                        var3_4.seek(0L);
                        var3_4.close();
                        var3_4 = null;
                        if (var5_6 > var1_1.getLAT()) break block16;
                        var7_8 = false;
                        var9_9 = null;
                        if (var3_4 != null) {
                            try {
                                var3_4.close();
                            }
                            catch (Exception var10_13) {
                                // empty catch block
                            }
                        }
                        var3_4 = null;
                        return var7_8;
                    }
                    catch (Throwable var5_7) {
                        if (this.isDebugEnabled()) {
                            var6_17 = HTTPSessionLogger.logTestFailureLoggable((String)var1_1.id, (Throwable)var5_7);
                            FileSessionContext.DEBUG_SESSIONS.debug(var6_17.getMessage());
                        }
                        var2_2.delete();
                        this.delTree(this.getParent(var2_2));
                        var9_11 = null;
                        if (var3_4 == null) return true;
                        ** try [egrp 4[TRYBLOCK] [5 : 185->192)] { 
lbl42:
                        // 1 sources

                        var3_4.close();
                        return true;
lbl44:
                        // 1 sources

                        catch (Exception var10_15) {
                            // empty catch block
                        }
                        return true;
                    }
                }
                var9_10 = null;
                if (var3_4 == null) return true;
                ** try [egrp 4[TRYBLOCK] [5 : 185->192)] { 
lbl51:
                // 1 sources

                var3_4.close();
                return true;
lbl53:
                // 1 sources

                catch (Exception var10_14) {
                    // empty catch block
                }
                return true;
            }
            catch (Throwable var8_18) {
                block18: {
                    var9_12 = null;
                    if (var3_4 != null) {
                        ** try [egrp 4[TRYBLOCK] [5 : 185->192)] { 
lbl61:
                        // 1 sources

                        var3_4.close();
                        break block18;
lbl63:
                        // 1 sources

                        catch (Exception var10_16) {
                            // empty catch block
                        }
                    }
                }
                var3_4 = null;
                throw var8_18;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        FileSessionData fileSessionData = (FileSessionData)this.getOpenSession(string = RSID.getID(string));
        if (fileSessionData == null && this.cachedSessions != null && (fileSessionData = (FileSessionData)this.cachedSessions.get(string)) != null) {
            if (!fileSessionData.sessionInUse() && this.isCacheStale(fileSessionData)) {
                this.cachedSessions.remove(fileSessionData.id);
                fileSessionData = null;
            } else {
                this.addSession(fileSessionData.id, fileSessionData);
            }
        }
        if (fileSessionData != null) {
            if (servletRequestImpl != null && servletResponseImpl != null) {
                FileSessionData fileSessionData2 = fileSessionData;
                synchronized (fileSessionData2) {
                    if (!fileSessionData.isValidForceCheck()) {
                        if (this.cachedSessions != null) {
                            this.cachedSessions.remove(fileSessionData.id);
                        }
                        this.removeSession(fileSessionData.id);
                        return null;
                    }
                    fileSessionData.incrementActiveRequestCount();
                }
            }
            return fileSessionData;
        }
        File file = this.getSessionPath(string);
        if (this.isDebugEnabled()) {
            Loggable loggable = HTTPSessionLogger.logSessionPathLoggable((String)string, (String)file.getAbsolutePath(), (boolean)file.exists());
            DEBUG_SESSIONS.debug(loggable.getMessage());
        }
        if ((fileSessionData = this.loadSession(null, file, string, servletRequestImpl != null && servletResponseImpl != null)) != null && servletRequestImpl != null && servletResponseImpl != null) {
            fileSessionData.reinitRuntimeMBean();
            fileSessionData.updateVersionIfNeeded(this);
            fileSessionData.getContext().addSession(string, fileSessionData);
            fileSessionData.incrementActiveRequestCount();
            fileSessionData.notifyActivated(new HttpSessionEvent((HttpSession)fileSessionData));
        }
        return fileSessionData;
    }

    public int getNonPersistedSessionCount() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String lookupAppVersionIdForSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        String string2;
        FileInputStream fileInputStream;
        block20: {
            Serializable serializable;
            if (string == null) {
                return null;
            }
            string = RSID.getID(string);
            if (this.cachedSessions != null && !this.cachedSessions.isEmpty() && (serializable = (SessionData)this.cachedSessions.get(string)) != null && ((SessionData)serializable).getServletContext() != null) {
                return ((WebAppServletContext)((SessionData)serializable).getServletContext()).getVersionId();
            }
            serializable = this.getSessionPath(string);
            if (serializable == null || !((File)serializable).exists() || ((File)serializable).isDirectory()) {
                return null;
            }
            fileInputStream = null;
            string2 = null;
            fileInputStream = new FileInputStream((File)serializable);
            WLObjectInputStream wLObjectInputStream = new WLObjectInputStream(fileInputStream);
            wLObjectInputStream.setReplacer(RemoteObjectReplacer.getReplacer());
            Object object = wLObjectInputStream.readObject();
            if (object != null && object instanceof AppVersionInfo) {
                string2 = ((AppVersionInfo)object).getVersionInfo();
            }
            if (!HTTPDebugLogger.isEnabled()) break block20;
            StringBuilder stringBuilder = new StringBuilder("got version id \"");
            stringBuilder.append(string2).append("\" for session id \"").append(string).append("\" from file \"").append(serializable).append("\"");
            HTTPDebugLogger.debug(stringBuilder.toString());
        }
        Object var11_15 = null;
        if (fileInputStream == null) return string2;
        try {
            fileInputStream.close();
            return string2;
        }
        catch (Throwable throwable) {}
        return string2;
        {
            catch (FileNotFoundException fileNotFoundException) {
                this.logLoadingErrorForDebug(fileNotFoundException);
                Object var11_16 = null;
                if (fileInputStream == null) return string2;
                try {
                    fileInputStream.close();
                    return string2;
                }
                catch (Throwable throwable) {}
                return string2;
            }
            catch (EOFException eOFException) {
                this.logLoadingErrorForDebug(eOFException);
                Object var11_17 = null;
                if (fileInputStream == null) return string2;
                try {
                    fileInputStream.close();
                    return string2;
                }
                catch (Throwable throwable) {}
                return string2;
            }
            catch (IOException iOException) {
                this.logLoadingErrorForDebug(iOException);
                Object var11_18 = null;
                if (fileInputStream == null) return string2;
                try {
                    fileInputStream.close();
                    return string2;
                }
                catch (Throwable throwable) {}
                return string2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logLoadingErrorForDebug(classNotFoundException);
                Object var11_19 = null;
                if (fileInputStream == null) return string2;
                try {
                    fileInputStream.close();
                    return string2;
                }
                catch (Throwable throwable) {}
                return string2;
            }
            catch (Exception exception) {
                this.logLoadingErrorForDebug(exception);
                Object var11_20 = null;
                if (fileInputStream == null) return string2;
                try {
                    fileInputStream.close();
                    return string2;
                }
                catch (Throwable throwable) {}
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var11_21 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private class FileEnumerator {
        private final ArrayList list;
        private final ArrayList sessionIds;
        private FileSessionContext ctxt;
        private boolean listFiles = false;
        private boolean justCount = false;
        private int count = 0;

        FileEnumerator(FileSessionContext fileSessionContext2, boolean bl, boolean bl2) {
            this.ctxt = fileSessionContext2;
            this.list = new ArrayList();
            this.listFiles = bl;
            this.justCount = bl2;
            this.sessionIds = new ArrayList();
        }

        public void recurse(File file) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    this.recurse(file2);
                    if (this.justCount || !this.listFiles) continue;
                    this.list.add(file2);
                    continue;
                }
                if (this.justCount) {
                    ++this.count;
                    continue;
                }
                if (this.listFiles) {
                    this.list.add(file2);
                    continue;
                }
                String string = this.ctxt.path2session(file2);
                this.list.add(string);
                this.sessionIds.add(string);
            }
        }

        public int getCount() {
            return this.count;
        }

        public File[] getSessionFiles() {
            File[] fileArray = new File[this.list.size()];
            return this.list.toArray(fileArray);
        }

        public String[] getSessionIds() {
            String[] stringArray = new String[this.sessionIds.size()];
            return this.sessionIds.toArray(stringArray);
        }
    }

    private static final class AppVersionInfo
    implements Serializable {
        private final String versionId;

        AppVersionInfo(String string) {
            this.versionId = string;
        }

        public String getVersionInfo() {
            return this.versionId;
        }
    }
}

