/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.ServletRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.session.SessionContext;

public class GracefulShutdownHelper {
    private static int maxPendingSessionTimeout;
    private static final long PENDING_SESSION_INTERVAL = 30000L;
    private static final String PRODUCTION_TO_ADMIN_LOCK_PREFIX = "weblogic.webapp.ProductionToAdminLock";

    public static void waitForPendingSessions() {
        Map map = GracefulShutdownHelper.getActiveSessions();
        if (map.size() > 0) {
            String[] stringArray = GracefulShutdownHelper.getPendingSessionsMessage(map);
            int n = GracefulShutdownHelper.getPendingSessionTimeout(maxPendingSessionTimeout);
            HTTPLogger.logSessionListDuringSuspend((String)stringArray[0], (String)stringArray[1]);
            HTTPLogger.logInitialSessionsDuringSuspend((int)n);
            GracefulShutdownHelper.startSessionChecker(30000L);
        }
        HTTPLogger.logPrepareToSuspendComplete();
    }

    private static Map getActiveSessions() {
        HashMap hashMap = new HashMap();
        for (HttpServer httpServer : WebService.getHttpServers()) {
            WebAppServletContext[] webAppServletContextArray = httpServer.getServletContextManager().getAllContexts();
            if (webAppServletContextArray == null) continue;
            for (int i = 0; i < webAppServletContextArray.length; ++i) {
                WebAppServletContext webAppServletContext = webAppServletContextArray[i];
                maxPendingSessionTimeout = GracefulShutdownHelper.updateActiveSessionTable(webAppServletContext, hashMap, maxPendingSessionTimeout, false);
            }
        }
        return hashMap;
    }

    private static int getPendingSessionTimeout(int n) {
        int n2 = n;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getGracefulShutdownTimeout() > 0) {
            n2 = Math.min(ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getGracefulShutdownTimeout(), n);
        }
        return n2;
    }

    private static int updateActiveSessionTable(WebAppServletContext webAppServletContext, Map map, int n, boolean bl) {
        if (webAppServletContext.isInternalApp()) {
            return n;
        }
        SessionContext sessionContext = webAppServletContext.getSessionContext();
        int n2 = bl ? sessionContext.getCurrOpenSessionsCount() : sessionContext.getNonPersistedSessionCount();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (GracefulShutdownHelper.hasWSEEServlets(webAppServletContext) && webAppServletContext.getVersionId() != null && bl) {
            String string = webAppServletContext.getApplicationName();
            ApplicationRuntimeMBean applicationRuntimeMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServerRuntime().lookupApplicationRuntime(string);
            if (applicationRuntimeMBean != null) {
                ComponentRuntimeMBean[] componentRuntimeMBeanArray;
                for (ComponentRuntimeMBean componentRuntimeMBean : componentRuntimeMBeanArray = applicationRuntimeMBean.getComponentRuntimes()) {
                    WseeV2RuntimeMBean[] wseeV2RuntimeMBeanArray = null;
                    if (componentRuntimeMBean instanceof WebAppComponentRuntimeMBean) {
                        wseeV2RuntimeMBeanArray = ((WebAppComponentRuntimeMBean)componentRuntimeMBean).getWseeV2Runtimes();
                    } else if (componentRuntimeMBean instanceof EJBComponentRuntimeMBean) {
                        wseeV2RuntimeMBeanArray = ((EJBComponentRuntimeMBean)componentRuntimeMBean).getWseeV2Runtimes();
                    }
                    if (wseeV2RuntimeMBeanArray == null) continue;
                    for (int i = 0; i < wseeV2RuntimeMBeanArray.length; ++i) {
                        n2 = (int)((long)n2 + wseeV2RuntimeMBeanArray[i].getConversationInstanceCount());
                    }
                }
            }
        }
        if (n2 > 0) {
            map.put(webAppServletContext.getContextPath(), new Long(n2));
            return Math.max(n, sessionContext.getConfigMgr().getSessionTimeoutSecs());
        }
        return n;
    }

    private static String[] getPendingSessionsMessage(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer2.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
            stringBuffer2.append(", ");
        }
        return new String[]{stringBuffer.toString(), stringBuffer2.toString()};
    }

    private static void startSessionChecker(long l) {
        if (l <= 0L) {
            return;
        }
        SessionChecker sessionChecker = new SessionChecker(l);
        sessionChecker.start();
    }

    public static void waitForPendingSessions(String string, WebAppModule webAppModule, boolean bl) {
        if (bl) {
            return;
        }
        HashMap hashMap = new HashMap();
        int n = GracefulShutdownHelper.getActiveSessions(webAppModule, hashMap);
        String string2 = ApplicationVersionUtils.getDisplayName(string);
        if (hashMap.size() > 0) {
            String[] stringArray = GracefulShutdownHelper.getPendingSessionsMessage(hashMap);
            int n2 = GracefulShutdownHelper.getPendingSessionTimeout(n);
            HTTPLogger.logSessionListDuringGracefulProductionToAdmin((String)string2, (String)webAppModule.getName(), (String)stringArray[0], (String)stringArray[1]);
            HTTPLogger.logInitialSessionsDuringGracefulProductionToAdmin((String)string2, (String)webAppModule.getName(), (int)n2);
            GracefulShutdownHelper.startSessionChecker(30000L, string, webAppModule);
        } else {
            HTTPLogger.logGracefulProductionToAdminComplete((String)string2, (String)webAppModule.getName());
        }
    }

    private static int getActiveSessions(WebAppModule webAppModule, Map map) {
        int n = 0;
        Iterator iterator = webAppModule.getAllContexts();
        while (iterator.hasNext()) {
            WebAppServletContext webAppServletContext = (WebAppServletContext)iterator.next();
            if (webAppServletContext == null) continue;
            n = GracefulShutdownHelper.updateActiveSessionTable(webAppServletContext, map, n, true);
        }
        return n;
    }

    private static void startSessionChecker(long l, String string, WebAppModule webAppModule) {
        if (l <= 0L) {
            return;
        }
        SessionChecker sessionChecker = new SessionChecker(l, string, webAppModule);
        sessionChecker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyGracefulProductionToAdmin(String string, WebAppModule webAppModule) {
        Object object;
        Object object2 = object = GracefulShutdownHelper.getProductionToAdminLock(string, webAppModule);
        synchronized (object2) {
            object.notify();
        }
    }

    private static boolean hasWSEEServlets(WebAppServletContext webAppServletContext) {
        ServletRuntimeMBean[] servletRuntimeMBeanArray = webAppServletContext.getServletRuntimeMBeans();
        for (int i = 0; i < servletRuntimeMBeanArray.length; ++i) {
            ServletRuntimeMBean servletRuntimeMBean = servletRuntimeMBeanArray[i];
            if (!servletRuntimeMBean.getServletClassName().equals("weblogic.wsee.server.servlet.WebappWSServlet") && !servletRuntimeMBean.getServletClassName().equals("weblogic.wsee.server.servlet.EjbWSServlet")) continue;
            return true;
        }
        return false;
    }

    private static Object getProductionToAdminLock(String string, WebAppModule webAppModule) {
        if (webAppModule == null) {
            return PRODUCTION_TO_ADMIN_LOCK_PREFIX;
        }
        return ("weblogic.webapp.ProductionToAdminLock." + string + "." + webAppModule.getName()).intern();
    }

    private static final class SessionChecker {
        private final long period;
        private long duration;
        private long nextLogInterval;
        private String appId;
        private WebAppModule webAppModule;

        SessionChecker(long l) {
            this.period = l;
        }

        SessionChecker(long l, String string, WebAppModule webAppModule) {
            this.period = l;
            this.appId = string;
            this.webAppModule = webAppModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void start() {
            Map map;
            while (!((map = this.getActiveSessions()).size() <= 0 || this.webAppModule != null && this.webAppModule.isSuspended())) {
                Object object;
                if (this.shouldLog()) {
                    object = GracefulShutdownHelper.getPendingSessionsMessage(map);
                    this.logSessionsDuringSuspend(this.duration, object[0]);
                }
                this.duration += this.period / 1000L;
                Object object2 = object = GracefulShutdownHelper.getProductionToAdminLock(this.appId, this.webAppModule);
                synchronized (object2) {
                    try {
                        object.wait(this.period);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            this.logPrepareToSuspendComplete();
        }

        private Map getActiveSessions() {
            if (this.webAppModule == null) {
                return GracefulShutdownHelper.getActiveSessions();
            }
            HashMap hashMap = new HashMap();
            GracefulShutdownHelper.getActiveSessions(this.webAppModule, hashMap);
            return hashMap;
        }

        private boolean shouldLog() {
            if (this.nextLogInterval <= 0L || this.duration >= this.nextLogInterval) {
                this.nextLogInterval = this.duration * 2L;
                return true;
            }
            return false;
        }

        private void logSessionsDuringSuspend(long l, String string) {
            int n = (int)(l / 60L);
            if (this.webAppModule == null) {
                HTTPLogger.logSessionsDuringSuspend((int)n, (String)string);
            } else {
                HTTPLogger.logSessionsDuringGracefulProductionToAdmin((String)ApplicationVersionUtils.getDisplayName(this.appId), (String)this.webAppModule.getName(), (int)n, (String)string);
            }
        }

        private void logPrepareToSuspendComplete() {
            if (this.webAppModule == null) {
                HTTPLogger.logPrepareToSuspendComplete();
            } else if (this.webAppModule.isSuspended()) {
                HTTPLogger.logGracefulProductionToAdminInterrupted((String)ApplicationVersionUtils.getDisplayName(this.appId), (String)this.webAppModule.getName());
            } else {
                HTTPLogger.logGracefulProductionToAdminComplete((String)ApplicationVersionUtils.getDisplayName(this.appId), (String)this.webAppModule.getName());
            }
        }
    }
}

