/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.sql.DataSource;
import weblogic.cache.utils.BubblingCache;
import weblogic.common.ResourceException;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.ConnectionPoolManager;
import weblogic.servlet.internal.NakedTimerListenerBase;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.JDBCSessionData;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;

public class JDBCSessionContext
extends SessionContext {
    protected final String selectQuery;
    protected final String selectLATQuery;
    protected final String selectIDSQuery;
    protected final String updateQuery;
    protected final String deleteQuery;
    protected final String insertQuery;
    protected final String countQuery;
    protected final String selectCtxPathQuery;
    protected final String tableName;
    protected final String wlMaxInactiveInternal;
    protected final Properties properties;
    protected final Map cache;
    protected final DataSource dataSource;
    protected static final String dataSourceKey = "dataSourceProp";
    private LastAccessTimeTrigger latTrigger;
    private static boolean tryImplicitConversionFromCharToSmallInt = Boolean.getBoolean("weblogic.servlet.sessions.jdbc.tryImplicitConversionFromCharToSmallInt");

    public JDBCSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
        this.wlMaxInactiveInternal = this.configMgr.getMaxInactiveIntervalColumnName();
        this.tableName = this.configMgr.getPersistentStoreTable();
        this.insertQuery = this.createInsertQuery();
        this.selectIDSQuery = this.createSelectIDSQuery();
        this.updateQuery = this.createUpdateQuery();
        this.selectQuery = this.createSelectQuery();
        this.selectLATQuery = this.createSelectLATQuery();
        this.deleteQuery = this.createDeleteQuery();
        this.countQuery = this.createCountQuery();
        this.selectCtxPathQuery = this.createSelectCtxPathQuery();
        this.cache = this.configMgr.getCacheSize() <= 0 ? Collections.EMPTY_MAP : new JDBCSessionCache(this.configMgr.getCacheSize());
        this.properties = new Properties();
        String string = this.configMgr.getPersistentDataSourceJNDIName();
        if (string != null) {
            this.dataSource = this.lookupDataSource(string);
        } else {
            this.properties.put("connectionPoolID", this.configMgr.getPersistentStorePool());
            this.initializeConnectionPool();
            this.dataSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSource lookupDataSource(String string) {
        DataSource dataSource;
        InitialContext initialContext = null;
        try {
            try {
                initialContext = new InitialContext();
                dataSource = (DataSource)initialContext.lookup(string);
                Object var6_5 = null;
                if (initialContext == null) return dataSource;
            }
            catch (NamingException namingException) {
                HTTPSessionLogger.logUnexpectedError((String)this.getServletContext().getLogContext(), (Throwable)namingException);
                DataSource dataSource2 = null;
                Object var6_6 = null;
                if (initialContext == null) return dataSource2;
                try {
                    initialContext.close();
                    return dataSource2;
                }
                catch (NamingException namingException3) {
                    // empty catch block
                }
                return dataSource2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (initialContext == null) throw throwable;
            try {}
            catch (NamingException namingException2) {
                throw throwable;
            }
            initialContext.close();
            throw throwable;
        }
        try {}
        catch (NamingException namingException) {
            // empty catch block
            return dataSource;
        }
        initialContext.close();
        return dataSource;
    }

    public void startTimers() {
        super.startTimers();
        this.latTrigger = new LastAccessTimeTrigger(this.getServletContext(), this.dataSource, this.properties, 10, this.isDebugEnabled());
    }

    private void initializeConnectionPool() {
        try {
            ConnectionPool connectionPool = ConnectionPoolManager.getPool((String)this.configMgr.getPersistentStorePool());
            if (connectionPool != null) {
                connectionPool.setResourceReserveTimeoutSeconds(this.configMgr.getJDBCConnectionTimeoutSecs());
                HTTPSessionLogger.logConnectionPoolReserveTimeoutSecondsOverride();
            }
        }
        catch (ResourceException resourceException) {
            HTTPSessionLogger.logUnexpectedError((String)this.getServletContext().getLogContext(), (Throwable)((Object)resourceException));
        }
    }

    String getSelectQuery() {
        return this.selectQuery;
    }

    String getSelectLATQuery() {
        return this.selectLATQuery;
    }

    String getUpdateQuery() {
        return this.updateQuery;
    }

    String getDeleteQuery() {
        return this.deleteQuery;
    }

    String getInsertQuery() {
        return this.insertQuery;
    }

    String getCountQuery() {
        return this.countQuery;
    }

    String getSelectCtxPathQuery() {
        return this.selectCtxPathQuery;
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        JDBCSessionData jDBCSessionData = JDBCSessionData.newSession(string, this, this.dataSource, this.properties);
        if (jDBCSessionData == null) {
            return null;
        }
        jDBCSessionData.incrementActiveRequestCount();
        if (this.cache != Collections.EMPTY_MAP) {
            this.cache.put(jDBCSessionData.id, jDBCSessionData);
        }
        this.incrementOpenSessionsCount();
        SessionData.checkSpecial(servletRequestImpl, jDBCSessionData);
        jDBCSessionData.setMonitoringId();
        return jDBCSessionData;
    }

    public String getPersistentStoreType() {
        return "jdbc";
    }

    protected void invalidateOrphanedSessions() {
        int n;
        Set set = this.getServletContext().getServer().getSessionLogin().getAllIds();
        if (set.isEmpty()) {
            return;
        }
        String[] stringArray = this.getIdsInternal();
        for (n = 0; n < stringArray.length; ++n) {
            set.remove(stringArray[n]);
        }
        if (n == 0) {
            return;
        }
        String string2 = null;
        for (String string2 : set) {
            this.getServletContext().getServer().getSessionLogin().unregister(string2, this.getServletContext().getContextPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        string = RSID.getID(string);
        String string2 = string.intern();
        synchronized (string2) {
            JDBCSessionData jDBCSessionData;
            JDBCSessionData jDBCSessionData2 = (JDBCSessionData)this.cache.get(string);
            if (jDBCSessionData2 != null) {
                jDBCSessionData = jDBCSessionData2;
                synchronized (jDBCSessionData) {
                    if (!jDBCSessionData2.sessionInUse() && jDBCSessionData2.isCacheStale()) {
                        this.cache.remove(string);
                        jDBCSessionData2 = null;
                    }
                }
            }
            if (jDBCSessionData2 != null) {
                jDBCSessionData = jDBCSessionData2;
                synchronized (jDBCSessionData) {
                    if (servletRequestImpl != null && servletResponseImpl != null) {
                        if (!jDBCSessionData2.isValidForceCheck()) {
                            this.cache.remove(string);
                            return null;
                        }
                        jDBCSessionData2.incrementActiveRequestCount();
                    }
                    return jDBCSessionData2;
                }
            }
            jDBCSessionData2 = this.getSessionDataFromDB(string, this.properties);
            if (jDBCSessionData2 == null) {
                return null;
            }
            jDBCSessionData = jDBCSessionData2;
            synchronized (jDBCSessionData) {
                jDBCSessionData2.transientAttributes = (Hashtable)this.transientData.get(jDBCSessionData2.id);
                if (servletRequestImpl != null && servletResponseImpl != null) {
                    if (!jDBCSessionData2.isValidForceCheck()) {
                        return null;
                    }
                    jDBCSessionData2.incrementActiveRequestCount();
                    jDBCSessionData2.updateVersionIfNeeded(this);
                    ((JDBCSessionContext)jDBCSessionData2.getContext()).cacheSession(jDBCSessionData2);
                    jDBCSessionData2.notifyActivated(new HttpSessionEvent((HttpSession)jDBCSessionData2));
                    jDBCSessionData2.reinitRuntimeMBean();
                }
                return jDBCSessionData2;
            }
        }
    }

    public JDBCSessionData getSessionDataFromDB(String string, Properties properties) {
        return JDBCSessionData.getFromDB(string, this, this.dataSource, properties);
    }

    protected JDBCSessionData createNewData(String string, SessionContext sessionContext, DataSource dataSource, Properties properties, boolean bl) {
        return new JDBCSessionData(string, sessionContext, dataSource, properties, bl);
    }

    public String[] getIdsInternal() {
        return JDBCSessionData.getSessionIds(this.dataSource, this.properties, this.getServletContext(), this.selectIDSQuery);
    }

    public String lookupAppVersionIdForSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        SessionData sessionData = (SessionData)this.cache.get(string = RSID.getID(string));
        if (sessionData != null) {
            return sessionData.getVersionId();
        }
        String string2 = this.getServletContext().getName();
        for (String string3 : stringArray = JDBCSessionData.getWlCtxPaths(this.dataSource, this.properties, this.getServletContext(), this.getSelectCtxPathQuery(), string)) {
            int n;
            if (!string3.startsWith(string2) || (n = string3.indexOf(35)) == -1) continue;
            return string3.substring(n + 1);
        }
        return null;
    }

    void unregisterExpiredSessions(ArrayList arrayList) {
    }

    public int getCurrOpenSessionsCount() {
        return JDBCSessionData.getTotalSessionsCount(this.dataSource, this.properties, this.getServletContext(), this.countQuery);
    }

    boolean invalidateSession(SessionData sessionData, boolean bl, boolean bl2) {
        if (sessionData == null) {
            return false;
        }
        this.cache.remove(sessionData.id);
        try {
            this.transientData.remove(sessionData.id);
            sessionData.remove(bl2);
            this.decrementOpenSessionsCount();
            SessionData.invalidateProcessedSession(sessionData);
            return true;
        }
        catch (Exception exception) {
            HTTPSessionLogger.logUnableToRemoveSession((String)sessionData.id, (Exception)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(HttpSession httpSession) {
        JDBCSessionData jDBCSessionData;
        JDBCSessionData jDBCSessionData2 = jDBCSessionData = (JDBCSessionData)httpSession;
        synchronized (jDBCSessionData2) {
            jDBCSessionData.decrementActiveRequestCount();
            if (jDBCSessionData.sessionInUse()) {
                return;
            }
            jDBCSessionData.notifyAboutToPassivate(new HttpSessionEvent((HttpSession)jDBCSessionData));
            jDBCSessionData.syncSession();
            if (this.cache != Collections.EMPTY_MAP) {
                this.cache.put(jDBCSessionData.id, httpSession);
            }
            if (jDBCSessionData.transientAttributes != null) {
                this.transientData.put(jDBCSessionData.id, jDBCSessionData.transientAttributes);
            }
        }
    }

    public void destroy(boolean bl) {
        super.destroy(bl);
        if (this.latTrigger != null) {
            this.latTrigger.stop();
        }
    }

    public int getNonPersistedSessionCount() {
        return 0;
    }

    void updateLAT(JDBCSessionData jDBCSessionData, String string, String string2) {
        this.latTrigger.addLATUpdateQuery(new UpdateQueryObject(jDBCSessionData, string, string2, this.tableName));
    }

    private String createInsertQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("insert into ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" (wl_id, wl_context_path, wl_is_new, wl_create_time, ");
        stringBuilder.append("wl_session_values, wl_is_valid, wl_access_time, ");
        stringBuilder.append(this.wlMaxInactiveInternal);
        stringBuilder.append(" ) values (?, ?, ?, ?, ?, ?, ?, ?)");
        return stringBuilder.toString();
    }

    protected String createSelectIDSQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select wl_id from ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" where ( wl_context_path = ? or wl_context_path = ? )");
        return stringBuilder.toString();
    }

    private String createUpdateQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" set wl_session_values = ?, ");
        stringBuilder.append("wl_is_new = ?, wl_is_valid = ?, wl_access_time = ?, ");
        stringBuilder.append(this.wlMaxInactiveInternal);
        stringBuilder.append(" = ?");
        stringBuilder.append(" where wl_id = ? ");
        stringBuilder.append(" and ( wl_context_path = ? or wl_context_path = ? )");
        stringBuilder.append(" and ( wl_access_time = ? or wl_access_time = ? )");
        return stringBuilder.toString();
    }

    protected String createSelectQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select wl_is_new, ");
        stringBuilder.append(" wl_create_time,");
        stringBuilder.append("wl_session_values, wl_is_valid, wl_access_time, ");
        stringBuilder.append(this.wlMaxInactiveInternal);
        stringBuilder.append(" from ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" where wl_id = ?");
        stringBuilder.append(" and ( wl_context_path = ? or wl_context_path = ? )");
        return stringBuilder.toString();
    }

    protected String createSelectLATQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select wl_access_time from ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" where wl_id = ?");
        stringBuilder.append(" and ( wl_context_path = ? or wl_context_path = ? )");
        return stringBuilder.toString();
    }

    private String createDeleteQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("delete from ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" where wl_id = ?");
        stringBuilder.append("and ( wl_context_path = ? or wl_context_path = ? )");
        return stringBuilder.toString();
    }

    protected String createCountQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select count(*) from ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" where ( wl_context_path = ? or wl_context_path = ? )");
        return stringBuilder.toString();
    }

    protected String createSelectCtxPathQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select wl_context_path from ").append(this.tableName);
        stringBuilder.append(" where wl_id = ? ");
        return stringBuilder.toString();
    }

    private void cacheSession(JDBCSessionData jDBCSessionData) {
        if (this.cache != Collections.EMPTY_MAP) {
            this.cache.put(jDBCSessionData.id, jDBCSessionData);
        }
    }

    protected class JDBCSessionCache
    extends BubblingCache {
        private static final long serialVersionUID = 6276338313903142442L;
        private final Map overflows;

        public JDBCSessionCache(int n) {
            super(n);
            this.overflows = new WeakHashMap();
        }

        public synchronized Object get(Object object) {
            WeakReference weakReference;
            Object object2 = super.get(object);
            if (object2 == null && (weakReference = (WeakReference)this.overflows.get(object)) != null && (object2 = weakReference.get()) == null) {
                this.overflows.remove(object);
            }
            return object2;
        }

        public synchronized Object put(Object object, Object object2) {
            JDBCSessionData jDBCSessionData = (JDBCSessionData)super.put(object, object2);
            if (jDBCSessionData != null && jDBCSessionData != object2) {
                this.overflows.put(jDBCSessionData.id, new WeakReference<JDBCSessionData>(jDBCSessionData));
            }
            return jDBCSessionData;
        }

        public synchronized Object remove(Object object) {
            this.overflows.remove(object);
            return super.remove(object);
        }
    }

    private static class UpdateQueryObject {
        private final JDBCSessionData session;
        private final String contextName;
        private final String ctxNamePlusVid;
        private final String tableName;
        private final int hashCode;

        public UpdateQueryObject(JDBCSessionData jDBCSessionData, String string, String string2, String string3) {
            this.session = jDBCSessionData;
            this.contextName = string;
            this.ctxNamePlusVid = string2;
            this.hashCode = jDBCSessionData.getInternalId().hashCode() ^ string.hashCode();
            this.tableName = string3;
        }

        public JDBCSessionData getSession() {
            return this.session;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof UpdateQueryObject) {
                UpdateQueryObject updateQueryObject = (UpdateQueryObject)object;
                return this.session.getInternalId().equals(updateQueryObject.session.getInternalId()) && this.contextName.equals(updateQueryObject.contextName);
            }
            return false;
        }

        public String getQuery(long l) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("update ");
            stringBuilder.append(this.tableName);
            stringBuilder.append(" set  wl_is_valid =");
            if (!tryImplicitConversionFromCharToSmallInt) {
                stringBuilder.append(this.session.isValid() ? "'1'" : "'0'");
            } else {
                stringBuilder.append(this.session.isValid() ? "1" : "0");
            }
            stringBuilder.append(", wl_access_time =");
            stringBuilder.append(l);
            stringBuilder.append(" where wl_id = '");
            stringBuilder.append(this.session.getInternalId());
            stringBuilder.append("' and ( wl_context_path ='");
            stringBuilder.append(this.contextName);
            stringBuilder.append("' or wl_context_path = '");
            stringBuilder.append(this.ctxNamePlusVid);
            stringBuilder.append("' ) and wl_access_time < ");
            stringBuilder.append(l);
            return stringBuilder.toString();
        }
    }

    private static class LastAccessTimeTrigger
    extends NakedTimerListenerBase {
        private Timer timer;
        private final Properties jdbcProps;
        private final HashSet set;
        private final int triggerInterval;
        private final boolean debug;
        private final DataSource dataSource;

        private LastAccessTimeTrigger(WebAppServletContext webAppServletContext, DataSource dataSource, Properties properties, int n, boolean bl) {
            super("JDBCLastAccessTimeTrigger", webAppServletContext);
            this.jdbcProps = properties;
            this.dataSource = dataSource;
            this.set = new HashSet();
            this.triggerInterval = n * 1000;
            this.debug = bl;
            this.start();
        }

        private void start() {
            this.timer = this.timerManager.schedule((TimerListener)this, 0L, (long)this.triggerInterval);
        }

        private void stop() {
            this.timer.cancel();
            this.timerManager.stop();
        }

        public Connection getConnection() throws SQLException {
            if (this.dataSource != null) {
                return this.dataSource.getConnection();
            }
            return JDBCSessionData.getConnection(this.dataSource, this.jdbcProps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void timerExpired(Timer var1_1) {
            block33: {
                block29: {
                    block32: {
                        block28: {
                            var2_2 = null;
                            var3_3 = null;
                            var4_4 = new HashSet<E>();
                            if (this.debug) {
                                SessionContext.DEBUG_SESSIONS.debug("LAT trigger started at " + new Date() + " size " + this.set.size());
                            }
                            try {
                                try {
                                    var5_5 = this.set;
                                    synchronized (var5_5) {
                                        if (this.set.size() == 0) {
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 27] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
                                            var13_7 = null;
                                            break block28;
                                        }
                                        var4_4.addAll(this.set);
                                        this.set.clear();
                                    }
                                    var2_2 = this.getConnection();
                                    var3_3 = var2_2.createStatement();
                                    for (UpdateQueryObject var6_15 : var4_4) {
                                        var8_17 = var7_16 = var6_15.getSession();
                                        synchronized (var8_17) {
                                            if (!var7_16.isCacheStale()) {
                                                var9_18 = var7_16.getLAT();
                                                var3_3.addBatch(var6_15.getQuery(var9_18));
                                                var6_15.getSession().setTriggerLAT(var9_18);
                                            }
                                        }
                                    }
                                    var3_3.executeBatch();
                                    var4_4.clear();
                                    break block29;
                                }
                                catch (SQLException var5_6) {
                                    var5_6.printStackTrace();
                                    var13_9 = null;
                                    try {
                                        if (var2_2 != null) {
                                            var2_2.close();
                                        }
                                    }
                                    catch (SQLException var14_13) {
                                        // empty catch block
                                    }
                                    try {
                                        if (var3_3 == null) return;
                                        var3_3.close();
                                        return;
                                    }
                                    catch (SQLException var14_13) {
                                        return;
                                    }
                                }
                            }
                            catch (Throwable var12_19) {
                                block31: {
                                    var13_10 = null;
                                    ** try [egrp 5[TRYBLOCK] [11 : 272->285)] { 
lbl53:
                                    // 1 sources

                                    if (var2_2 != null) {
                                        var2_2.close();
                                    }
                                    break block31;
lbl56:
                                    // 1 sources

                                    catch (SQLException var14_14) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [12 : 287->300)] { 
lbl60:
                                // 1 sources

                                if (var3_3 == null) throw var12_19;
                                var3_3.close();
                                throw var12_19;
lbl63:
                                // 1 sources

                                catch (SQLException var14_14) {
                                    // empty catch block
                                }
                                throw var12_19;
                            }
                        }
                        ** try [egrp 5[TRYBLOCK] [11 : 272->285)] { 
lbl68:
                        // 1 sources

                        if (var2_2 != null) {
                            var2_2.close();
                        }
                        break block32;
lbl71:
                        // 1 sources

                        catch (SQLException var14_11) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [12 : 287->300)] { 
lbl75:
                    // 1 sources

                    if (var3_3 == null) return;
                    var3_3.close();
                    return;
lbl78:
                    // 1 sources

                    catch (SQLException var14_11) {
                        // empty catch block
                    }
                    return;
                }
                var13_8 = null;
                ** try [egrp 5[TRYBLOCK] [11 : 272->285)] { 
lbl84:
                // 1 sources

                if (var2_2 != null) {
                    var2_2.close();
                }
                break block33;
lbl87:
                // 1 sources

                catch (SQLException var14_12) {
                    // empty catch block
                }
            }
            try {}
            catch (SQLException var14_12) {}
            if (var3_3 == null) return;
            var3_3.close();
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addLATUpdateQuery(UpdateQueryObject updateQueryObject) {
            HashSet hashSet = this.set;
            synchronized (hashSet) {
                this.set.add(updateQueryObject);
            }
        }
    }
}

