/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import weblogic.common.internal.WLObjectInputStream;
import weblogic.common.internal.WLObjectOutputStream;
import weblogic.j2ee.ApplicationManager;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.JDBCSessionContext;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.internal.session.SessionNotFoundException;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

class JDBCSessionData
extends SessionData
implements HttpSession {
    private static final long serialVersionUID = 7715646887169061115L;
    private static final boolean PERSIST_APPVERSION = !Boolean.getBoolean("weblogic.servlet.session.PersistentBackCompatibility");
    private static final Driver driver = new weblogic.jdbc.pool.Driver();
    private final String logContext;
    private final String contextName;
    private final String fullCtxName;
    private final Properties jdbcProps;
    protected final JDBCSessionContext jdbcCtx;
    private final DataSource dataSource;
    protected transient long dbLAT;
    private transient long triggerLAT;
    private transient boolean isCacheStale = false;

    public JDBCSessionData(String string, SessionContext sessionContext, DataSource dataSource, Properties properties, boolean bl) {
        super(string, sessionContext, bl);
        this.dataSource = dataSource;
        this.jdbcProps = properties;
        this.logContext = sessionContext.getServletContext().getLogContext();
        this.jdbcCtx = (JDBCSessionContext)sessionContext;
        this.contextName = this.getContextName();
        this.fullCtxName = sessionContext.getServletContext().getFullCtxName();
    }

    static JDBCSessionData newSession(String string, SessionContext sessionContext, DataSource dataSource, Properties properties) {
        JDBCSessionData jDBCSessionData = null;
        try {
            jDBCSessionData = new JDBCSessionData(string, sessionContext, dataSource, properties, true);
            jDBCSessionData.dbCreate();
            sessionContext.getServletContext().getEventsManager().notifySessionLifetimeEvent(jDBCSessionData, true);
        }
        catch (SQLException sQLException) {
            HTTPSessionLogger.logUnexpectedError((String)sessionContext.getServletContext().getLogContext(), (Throwable)sQLException);
            return null;
        }
        return jDBCSessionData;
    }

    static JDBCSessionData getFromDB(String string, SessionContext sessionContext, DataSource dataSource, Properties properties) {
        JDBCSessionData jDBCSessionData = null;
        try {
            jDBCSessionData = JDBCSessionData.dbRefresh(string, sessionContext, dataSource, properties);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            return null;
        }
        catch (SQLException sQLException) {
            HTTPSessionLogger.logUnexpectedError((String)sessionContext.getServletContext().getLogContext(), (Throwable)sQLException);
            return null;
        }
        return jDBCSessionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getSessionIds(DataSource dataSource, Properties properties, WebAppServletContext webAppServletContext, String string) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try {
                connection = JDBCSessionData.getConnection(dataSource, properties);
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, webAppServletContext.getName());
                preparedStatement.setString(2, webAppServletContext.getFullCtxName());
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                Object var11_8 = null;
            }
            catch (SQLException sQLException) {
                HTTPSessionLogger.logUnexpectedError((String)webAppServletContext.getLogContext(), (Throwable)sQLException);
                String[] stringArray = new String[]{};
                Object var11_9 = null;
                JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
            throw throwable;
        }
        JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getWlCtxPaths(DataSource dataSource, Properties properties, WebAppServletContext webAppServletContext, String string, String string2) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try {
                connection = JDBCSessionData.getConnection(dataSource, properties);
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                Object var12_9 = null;
            }
            catch (SQLException sQLException) {
                HTTPSessionLogger.logUnexpectedError((String)webAppServletContext.getLogContext(), (Throwable)sQLException);
                String[] stringArray = new String[]{};
                Object var12_10 = null;
                JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
            throw throwable;
        }
        JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    static Connection getConnection(DataSource dataSource, Properties properties) throws SQLException {
        Connection connection = null;
        try {
            connection = dataSource != null ? dataSource.getConnection() : driver.connect("jdbc:weblogic:pool", properties);
            connection.setAutoCommit(true);
            return connection;
        }
        catch (SQLException sQLException) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    protected void dbCreate() throws SQLException {
        Object object;
        if (this.isDebugEnabled()) {
            object = HTTPSessionLogger.logPerformOperationLoggable((String)"dbCreate()", (String)this.id, (String)this.getContextPath());
            DEBUG_SESSIONS.debug(object.getMessage());
        }
        object = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                if (object == null) {
                    object = JDBCSessionData.getConnection(this.dataSource, this.jdbcProps);
                }
                preparedStatement = object.prepareStatement(this.jdbcCtx.getInsertQuery());
                this.addCreateStatement(preparedStatement);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new SQLException("Failed to insert record for session " + this.id + " in the database");
                }
                this.dbLAT = this.accessTime;
            }
            catch (SQLException sQLException) {
                this.setValid(false);
                throw sQLException;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.setModified(false);
            JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
            throw throwable;
        }
        this.setModified(false);
        JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
    }

    protected void addCreateStatement(PreparedStatement preparedStatement) throws SQLException {
        int n = 0;
        preparedStatement.setString(++n, this.id);
        preparedStatement.setString(++n, PERSIST_APPVERSION ? this.fullCtxName : this.contextName);
        preparedStatement.setString(++n, this.isNew() ? "1" : "0");
        preparedStatement.setLong(++n, this.creationTime);
        try {
            this.initVersionAttrsIfNeeded();
            byte[] byArray = this.serializeAttributes();
            preparedStatement.setBinaryStream(++n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        }
        catch (IOException iOException) {
            this.setValid(false);
            throw new SQLException("Could not serialize attributes to create session " + this.id + ":\n" + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
        }
        preparedStatement.setString(++n, this.isValid() ? "1" : "0");
        preparedStatement.setLong(++n, this.accessTime);
        preparedStatement.setInt(++n, this.maxInactiveInterval);
    }

    protected void addFirstUpdateStatement(PreparedStatement preparedStatement) throws SQLException, IOException {
        byte[] byArray = this.serializeAttributes();
        preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        preparedStatement.setString(2, this.isNew() ? "1" : "0");
        preparedStatement.setString(3, this.isValid() ? "1" : "0");
        preparedStatement.setLong(4, this.accessTime);
        preparedStatement.setInt(5, this.maxInactiveInterval);
    }

    protected void addTimeSensitiveUpdateStatement(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(6, this.id);
        preparedStatement.setString(7, this.contextName);
        preparedStatement.setString(8, this.fullCtxName);
        preparedStatement.setLong(9, this.dbLAT);
        preparedStatement.setLong(10, this.triggerLAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dbUpdate() throws SQLException {
        Object object;
        if (this.isDebugEnabled()) {
            object = HTTPSessionLogger.logPerformOperationLoggable((String)("dbUpdate() lat=" + this.accessTime + " "), (String)this.id, (String)this.getContextPath());
            DEBUG_SESSIONS.debug(object.getMessage());
        }
        object = null;
        PreparedStatement preparedStatement = null;
        try {
            block15: {
                try {
                    boolean bl = false;
                    if (this.isModified()) {
                        object = JDBCSessionData.getConnection(this.dataSource, this.jdbcProps);
                        preparedStatement = object.prepareStatement(this.jdbcCtx.getUpdateQuery());
                        try {
                            this.addFirstUpdateStatement(preparedStatement);
                            int n = 0;
                            JDBCSessionData jDBCSessionData = this;
                            synchronized (jDBCSessionData) {
                                this.addTimeSensitiveUpdateStatement(preparedStatement);
                                n = preparedStatement.executeUpdate();
                                if (n > 0) {
                                    this.dbLAT = this.accessTime;
                                    this.triggerLAT = 0L;
                                }
                            }
                            if (n != 0) break block15;
                            if (this.isValid()) {
                                try {
                                    this.dbCreate();
                                    break block15;
                                }
                                catch (SQLException sQLException) {
                                    HTTPSessionLogger.logJDBCSessionConcurrentModification((String)(this.id + " ctx:" + this.contextName + " dblat:" + this.dbLAT + " triggerLAT:" + this.triggerLAT), (Exception)sQLException);
                                    throw sQLException;
                                }
                            }
                            throw new SQLException("Failed to update database record for session " + this.id + " for contextName = " + this.contextName);
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Could not serialize attributes to update session " + this.id + ":\n" + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                        }
                    }
                    this.jdbcCtx.updateLAT(this, this.contextName, this.fullCtxName);
                }
                catch (SQLException sQLException) {
                    this.setValid(false);
                    throw sQLException;
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.setModified(false);
            JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
            throw throwable;
        }
        this.setModified(false);
        JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
    }

    protected static String getJDBCContextName(SessionContext sessionContext) {
        if (sessionContext.getConfigMgr().isSessionSharingEnabled()) {
            return sessionContext.getServletContext().getApplicationId();
        }
        return sessionContext.getServletContext().getName();
    }

    protected static JDBCSessionData dbRefresh(String string, SessionContext sessionContext, DataSource dataSource, Properties properties) throws SQLException, SessionNotFoundException {
        SessionData sessionData;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block18: {
            SessionData sessionData2;
            block19: {
                connection = null;
                preparedStatement = null;
                resultSet = null;
                sessionData = null;
                JDBCSessionContext jDBCSessionContext = (JDBCSessionContext)sessionContext;
                String string2 = sessionContext.getServletContext().getName();
                if (DEBUG_SESSIONS.isDebugEnabled()) {
                    DEBUG_SESSIONS.debug("Looking in database for " + string + " with contextPath: " + string2);
                }
                connection = JDBCSessionData.getConnection(dataSource, properties);
                preparedStatement = connection.prepareStatement(jDBCSessionContext.getSelectQuery());
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, sessionContext.getServletContext().getFullCtxName());
                resultSet = preparedStatement.executeQuery();
                String string3 = null;
                if (!resultSet.next()) break block18;
                string3 = resultSet.getString(1);
                if (resultSet.wasNull()) {
                    throw new SQLException("Failed to read session " + string + " from db");
                }
                sessionData = jDBCSessionContext.createNewData(string, sessionContext, dataSource, properties, false);
                ((JDBCSessionData)sessionData).isNew = string3.equals("1");
                ((JDBCSessionData)sessionData).creationTime = resultSet.getLong(2);
                InputStream inputStream = resultSet.getBinaryStream(3);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                byte[] byArray = null;
                try {
                    while ((n = inputStream.read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (Exception exception) {
                    throw new SQLException("JDBCSessionData dbRefresh() fails getting session data: " + exception.getMessage());
                }
                sessionData.setValid(resultSet.getString(4).equals("1"));
                ((JDBCSessionData)sessionData).accessTime = resultSet.getLong(5);
                ((JDBCSessionData)sessionData).maxInactiveInterval = resultSet.getInt(6);
                ((JDBCSessionData)sessionData).dbLAT = ((JDBCSessionData)sessionData).accessTime;
                try {
                    super.deSerializeAttributes(byArray, (JDBCSessionData)sessionData);
                    if (sessionContext.isDebugEnabled()) {
                        sessionData2 = HTTPSessionLogger.logPerformOperationLoggable((String)("dbRefresh() gets version=" + sessionData.getInternalAttribute("weblogic.versionId")), (String)string, (String)string2);
                        DEBUG_SESSIONS.debug(sessionData2.getMessage());
                    }
                }
                catch (IOException iOException) {
                    boolean bl = sessionData.isValid();
                    sessionData.remove();
                    long l = System.currentTimeMillis() - sessionData.getLAT();
                    if (bl && (((JDBCSessionData)sessionData).maxInactiveInterval < 0 || l <= (long)(((JDBCSessionData)sessionData).maxInactiveInterval * 1000))) {
                        throw new SQLException("Could not deserialize attributes after reading session " + string + ":\n" + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
                    }
                    JDBCSessionData jDBCSessionData = null;
                    Object var21_22 = null;
                    if (sessionData != null) {
                        sessionData.setModified(false);
                    }
                    JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
                    return jDBCSessionData;
                }
                sessionData2 = sessionData;
                Object var21_23 = null;
                if (sessionData == null) break block19;
                sessionData.setModified(false);
            }
            JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
            return sessionData2;
        }
        try {
            try {
                throw new SessionNotFoundException();
            }
            catch (SQLException sQLException) {
                if (sessionData != null) {
                    sessionData.setValid(false);
                }
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            if (sessionData != null) {
                sessionData.setModified(false);
            }
            JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
            throw throwable;
        }
    }

    boolean isCacheStale() {
        if (!this.isCacheStale) {
            this.isCacheStale = this.checkCacheStale();
        }
        return this.isCacheStale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkCacheStale() {
        Object object;
        if (this.isDebugEnabled()) {
            object = HTTPSessionLogger.logPerformOperationLoggable((String)"isCacheStale()", (String)this.id, (String)this.getContextPath());
            DEBUG_SESSIONS.debug(object.getMessage());
        }
        object = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long l = this.dbLAT;
        if (this.triggerLAT > this.dbLAT) {
            l = this.triggerLAT;
        }
        try {
            try {
                object = JDBCSessionData.getConnection(this.dataSource, this.jdbcProps);
                preparedStatement = object.prepareStatement(this.jdbcCtx.getSelectLATQuery());
                preparedStatement.setString(1, this.id);
                preparedStatement.setString(2, this.contextName);
                preparedStatement.setString(3, this.fullCtxName);
                JDBCSessionData jDBCSessionData = this;
                synchronized (jDBCSessionData) {
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        this.dbLAT = resultSet.getLong(1);
                    }
                }
                Object var9_9 = null;
            }
            catch (SQLException sQLException) {
                HTTPSessionLogger.logUnexpectedError((String)this.logContext, (Throwable)sQLException);
                boolean bl = true;
                Object var9_10 = null;
                JDBCSessionData.closeDBResources(resultSet, preparedStatement, (Connection)object);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            JDBCSessionData.closeDBResources(resultSet, preparedStatement, (Connection)object);
            throw throwable;
        }
        JDBCSessionData.closeDBResources(resultSet, preparedStatement, (Connection)object);
        return l < this.dbLAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dbRemove() {
        Object object;
        if (this.isDebugEnabled()) {
            object = HTTPSessionLogger.logPerformOperationLoggable((String)"dbRemove()", (String)this.id, (String)this.getContextPath());
            DEBUG_SESSIONS.debug(object.getMessage());
        }
        object = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                object = JDBCSessionData.getConnection(this.dataSource, this.jdbcProps);
                preparedStatement = object.prepareStatement(this.jdbcCtx.getDeleteQuery());
                this.addRemoveStatement(preparedStatement);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                HTTPSessionLogger.logUnexpectedError((String)this.logContext, (Throwable)sQLException);
                Object var5_4 = null;
                JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
            throw throwable;
        }
        JDBCSessionData.closeDBResources(null, preparedStatement, (Connection)object);
    }

    protected void addRemoveStatement(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.id);
        preparedStatement.setString(2, this.contextName);
        preparedStatement.setString(3, this.fullCtxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int getTotalSessionsCount(DataSource dataSource, Properties properties, WebAppServletContext webAppServletContext, String string) {
        int n;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = JDBCSessionData.getConnection(dataSource, properties);
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, webAppServletContext.getName());
            preparedStatement.setString(2, webAppServletContext.getFullCtxName());
            resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            n = n2;
            Object var10_10 = null;
        }
        catch (SQLException sQLException) {
            try {
                HTTPSessionLogger.logUnexpectedError((String)webAppServletContext.getLogContext(), (Throwable)sQLException);
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
                throw throwable;
            }
            JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
            return 0;
        }
        JDBCSessionData.closeDBResources(resultSet, preparedStatement, connection);
        return n;
    }

    private byte[] serializeAttributes() throws IOException {
        byte[] byArray = null;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        WLObjectOutputStream wLObjectOutputStream = new WLObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
        wLObjectOutputStream.setReplacer(RemoteObjectReplacer.getReplacer());
        wLObjectOutputStream.setServerChannel(ServerChannelManager.findDefaultLocalServerChannel());
        wLObjectOutputStream.writeObject(JDBCSessionData.convertToHashtable(this.attributes));
        wLObjectOutputStream.writeObject(JDBCSessionData.convertToHashtable(this.internalAttributes));
        wLObjectOutputStream.flush();
        byArray = unsyncByteArrayOutputStream.toRawBytes();
        return byArray;
    }

    private void deSerializeAttributes(byte[] byArray, JDBCSessionData jDBCSessionData) throws IOException {
        block10: {
            if (byArray == null || byArray.length < 2) {
                return;
            }
            try {
                UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
                if (byArray[0] == -84 && byArray[1] == -19) {
                    SessionMigrationObjectInputStream sessionMigrationObjectInputStream = new SessionMigrationObjectInputStream(unsyncByteArrayInputStream);
                    jDBCSessionData.attributes = JDBCSessionData.convertToConcurrentHashMap(sessionMigrationObjectInputStream.readObject());
                    try {
                        jDBCSessionData.internalAttributes = JDBCSessionData.convertToConcurrentHashMap(sessionMigrationObjectInputStream.readObject());
                    }
                    catch (StreamCorruptedException streamCorruptedException) {
                        this.internalAttributes = null;
                        if (this.isDebugEnabled()) {
                            DEBUG_SESSIONS.debug("Ignoring the StreamCorruptedException " + streamCorruptedException.getMessage());
                        }
                        break block10;
                    }
                }
                WLObjectInputStream wLObjectInputStream = new WLObjectInputStream((InputStream)unsyncByteArrayInputStream);
                wLObjectInputStream.setReplacer(RemoteObjectReplacer.getReplacer());
                jDBCSessionData.attributes = JDBCSessionData.convertToConcurrentHashMap(wLObjectInputStream.readObject());
                try {
                    jDBCSessionData.internalAttributes = JDBCSessionData.convertToConcurrentHashMap(wLObjectInputStream.readObject());
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    this.internalAttributes = null;
                    if (this.isDebugEnabled()) {
                        DEBUG_SESSIONS.debug("Ignoring the StreamCorruptedException " + streamCorruptedException.getMessage());
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Exception deserializing attributes:" + StackTraceUtils.throwable2StackTrace((Throwable)classNotFoundException));
            }
        }
    }

    void setTriggerLAT(long l) {
        this.triggerLAT = l;
    }

    void remove(boolean bl) {
        super.remove(bl);
        this.dbRemove();
        this.setValid(false);
    }

    void syncSession() {
        if (!this.isValid()) {
            return;
        }
        super.syncSession();
        try {
            this.dbUpdate();
        }
        catch (SQLException sQLException) {
            HTTPSessionLogger.logUnexpectedError((String)this.logContext, (Throwable)sQLException);
        }
    }

    public synchronized void setAttribute(String string, Object object, boolean bl) throws IllegalStateException, IllegalArgumentException {
        super.setAttribute(string, object, bl);
        this.setModified(true);
    }

    protected void removeAttribute(String string, boolean bl) throws IllegalStateException {
        super.removeAttribute(string, bl);
        this.setModified(true);
    }

    public synchronized void setInternalAttribute(String string, Object object) throws IllegalStateException, IllegalArgumentException {
        super.setInternalAttribute(string, object);
        this.setModified(true);
    }

    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        this.setModified(true);
    }

    protected void logTransientAttributeError(String string) {
        HTTPSessionLogger.logTransientJDBCAttributeError((String)this.logContext, (String)string, (String)this.getId());
    }

    private static void closeDBResources(ResultSet resultSet, PreparedStatement preparedStatement, Connection connection) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class SessionMigrationObjectInputStream
    extends ObjectInputStream {
        public SessionMigrationObjectInputStream() throws IOException, SecurityException {
        }

        public SessionMigrationObjectInputStream(UnsyncByteArrayInputStream unsyncByteArrayInputStream) throws IOException, StreamCorruptedException {
            super((InputStream)unsyncByteArrayInputStream);
        }

        public Class resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException {
            return ApplicationManager.loadClass(objectStreamClass.getName(), null);
        }
    }
}

