/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.MemorySessionData;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;

public final class MemorySessionContext
extends SessionContext {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MemorySessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        this.checkSessionCount();
        MemorySessionData memorySessionData = new MemorySessionData(string, this, true);
        SessionData.checkSpecial(servletRequestImpl, memorySessionData);
        memorySessionData.incrementActiveRequestCount();
        this.addSession(memorySessionData.id, memorySessionData);
        this.incrementOpenSessionsCount();
        memorySessionData.setMonitoringId();
        return memorySessionData;
    }

    public String getPersistentStoreType() {
        return "memory";
    }

    protected void invalidateSecondarySessions() {
    }

    void unregisterExpiredSessions(ArrayList arrayList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        MemorySessionData memorySessionData = (MemorySessionData)this.getOpenSession(string = RSID.getID(string));
        if (memorySessionData == null) {
            return null;
        }
        MemorySessionData memorySessionData2 = memorySessionData;
        synchronized (memorySessionData2) {
            if (servletRequestImpl != null && servletResponseImpl != null) {
                if (!memorySessionData.isValidForceCheck()) {
                    return null;
                }
                memorySessionData.incrementActiveRequestCount();
            }
        }
        return memorySessionData;
    }

    public int getCurrOpenSessionsCount() {
        return this.getOpenSessions().size();
    }

    boolean invalidateSession(SessionData sessionData, boolean bl, boolean bl2) {
        this.removeSession(sessionData.id);
        sessionData.remove(bl2);
        this.decrementOpenSessionsCount();
        SessionData.invalidateProcessedSession(sessionData);
        return true;
    }

    public void destroy(boolean bl) {
        super.destroy(bl);
        if (this.configMgr.isSaveSessionsOnRedeployEnabled()) {
            return;
        }
        String[] stringArray = this.getIdsInternal();
        SessionCleanupAction sessionCleanupAction = new SessionCleanupAction(stringArray);
        Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)sessionCleanupAction);
        if (throwable != null) {
            HTTPSessionLogger.logUnexpectedErrorCleaningUpSessions((String)this.getServletContext().getLogContext(), (Throwable)throwable);
        }
    }

    public void sync(HttpSession httpSession) {
        MemorySessionData memorySessionData = (MemorySessionData)httpSession;
        memorySessionData.decrementActiveRequestCount();
        memorySessionData.syncSession();
    }

    public int getNonPersistedSessionCount() {
        return this.getOpenSessions().size();
    }

    class SessionCleanupAction
    implements PrivilegedAction {
        private final String[] ids;

        SessionCleanupAction(String[] stringArray) {
            this.ids = stringArray;
        }

        public Object run() {
            try {
                for (int i = 0; i < this.ids.length && this.ids[i] != null; ++i) {
                    SessionData sessionData = MemorySessionContext.this.getSessionInternal(this.ids[i], null, null);
                    MemorySessionContext.this.invalidateSession(sessionData, false);
                }
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }
}

