/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.application.AppClassLoaderManager;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.internal.session.ReplicatedSessionData;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.io.ChunkInputStreamAccess;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedObjectOutputStream;
import weblogic.utils.io.StringInput;
import weblogic.utils.io.StringOutput;

public class ReplicatedSessionChange
implements Externalizable {
    private static final long serialVersionUID = -2864760712171499570L;
    protected final HashMap attributeChanges = new HashMap();
    protected final HashMap internalChanges = new HashMap();
    protected int maxInactiveInterval;
    protected long lastAccessedTime;
    protected long timeOnPrimaryAtUpdate;
    protected boolean modified = false;
    protected String annotation;
    protected static final DebugLogger DEBUG_SESSIONS = DebugLogger.getDebugLogger((String)"DebugHttpSessions");
    private transient boolean useLazyDeserialization = false;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ClusterMBean clusterMbean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getCluster();

    synchronized void init(int n, long l) {
        this.maxInactiveInterval = n;
        this.lastAccessedTime = l;
        this.modified = true;
        String string = ReplicatedSessionData.getAnnotation();
        this.annotation = string == null ? "" : string;
    }

    void clear() {
        this.attributeChanges.clear();
        this.internalChanges.clear();
        this.modified = false;
    }

    boolean getModified() {
        return this.modified;
    }

    void setTimeOnPrimaryAtUpdate(long l) {
        this.timeOnPrimaryAtUpdate = l;
    }

    long getTimeOnPrimaryAtUpdate() {
        return this.timeOnPrimaryAtUpdate;
    }

    long getLastAccessTime() {
        return this.lastAccessedTime;
    }

    int getMaxInActiveInterval() {
        return this.maxInactiveInterval;
    }

    HashMap getAttributeChanges() {
        return this.attributeChanges;
    }

    HashMap getInternalAttributeChanges() {
        return this.internalChanges;
    }

    public void addAttributeChange(String string, Object object) {
        this.getAttributeChanges().put(string, object);
    }

    public void addInternalAttributeChange(String string, Object object) {
        this.getInternalAttributeChanges().put(string, object);
    }

    public String toString() {
        return "[Changes:" + this.attributeChanges.size() + " internalChanges:" + this.internalChanges.size() + " maxInactiveInterval: " + this.maxInactiveInterval + " lastAccessedTime: " + this.lastAccessedTime + "]";
    }

    private void writeString(ObjectOutput objectOutput, String string) throws IOException {
        if (objectOutput instanceof StringOutput) {
            StringOutput stringOutput = (StringOutput)objectOutput;
            stringOutput.writeUTF8(string);
        } else {
            objectOutput.writeUTF(string);
        }
    }

    private String readString(ObjectInput objectInput) throws IOException {
        if (objectInput instanceof StringInput) {
            StringInput stringInput = (StringInput)objectInput;
            return stringInput.readUTF8();
        }
        return objectInput.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeString(objectOutput, this.annotation);
        int n = this.attributeChanges.size();
        objectOutput.writeInt(n);
        if (n > 0) {
            Object object;
            Iterator iterator = this.attributeChanges.keySet().iterator();
            if (clusterMbean.isSessionLazyDeserializationEnabled() && objectOutput instanceof PeerInfoable && (object = ((PeerInfoable)objectOutput).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_1033) > 0) {
                this.useLazyDeserialization = true;
            }
            if (!this.useLazyDeserialization) {
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    this.writeString(objectOutput, (String)object);
                    objectOutput.writeObject(this.attributeChanges.get(object));
                }
            } else {
                object = new ChunkedObjectOutputStream();
                object.setReplacer(RemoteObjectReplacer.getReplacer());
                while (iterator.hasNext()) {
                    Object var7_6;
                    try {
                        String string = (String)iterator.next();
                        this.writeString(objectOutput, string);
                        object.writeObject(this.attributeChanges.get(string));
                        ((ChunkOutput)objectOutput).writeChunks(object.getChunks());
                        var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        object.reset();
                        throw throwable;
                    }
                    object.reset();
                    {
                    }
                }
            }
        }
        n = this.internalChanges.size();
        objectOutput.writeInt(n);
        if (n > 0) {
            for (Object object : this.internalChanges.keySet()) {
                this.writeString(objectOutput, (String)object);
                objectOutput.writeObject(this.internalChanges.get(object));
            }
        }
        objectOutput.writeInt(this.maxInactiveInterval);
        objectOutput.writeLong(this.lastAccessedTime);
        objectOutput.writeLong(this.timeOnPrimaryAtUpdate);
        objectOutput.writeBoolean(this.modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PeerInfo peerInfo;
        GenericClassLoader genericClassLoader = null;
        String string = this.readString(objectInput);
        genericClassLoader = AppClassLoaderManager.getAppClassLoaderManager().findLoader(new Annotation(string));
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        if (genericClassLoader != null) {
            thread2.setContextClassLoader((ClassLoader)genericClassLoader);
        }
        if (clusterMbean.isSessionLazyDeserializationEnabled() && objectInput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)objectInput).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_1033) > 0) {
            this.useLazyDeserialization = true;
        }
        try {
            String string2;
            int n;
            this.clear();
            int n2 = objectInput.readInt();
            for (n = 0; n < n2; ++n) {
                string2 = this.readString(objectInput);
                if (!this.useLazyDeserialization) {
                    this.attributeChanges.put(string2, objectInput.readObject());
                    continue;
                }
                int n3 = ((ChunkInputStreamAccess)objectInput).readChunkLength();
                byte[] byArray = new byte[n3];
                ((ChunkInputStreamAccess)objectInput).readByteArray(byArray, 0, n3);
                if (byArray.length == 1 && byArray[0] == 112) {
                    this.attributeChanges.put(string2, null);
                    continue;
                }
                this.attributeChanges.put(string2, byArray);
            }
            n2 = objectInput.readInt();
            for (n = 0; n < n2; ++n) {
                string2 = this.readString(objectInput);
                this.internalChanges.put(string2, objectInput.readObject());
            }
            this.maxInactiveInterval = objectInput.readInt();
            this.lastAccessedTime = objectInput.readLong();
            this.timeOnPrimaryAtUpdate = objectInput.readLong();
            this.modified = objectInput.readBoolean();
            Object var12_12 = null;
            if (genericClassLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (genericClassLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
    }

    public boolean isUseLazyDeserialization() {
        return this.useLazyDeserialization;
    }
}

