/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.Externalizable;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import weblogic.cluster.replication.NotFoundException;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.ReplicationManager;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.logging.Loggable;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.URLManager;
import weblogic.rmi.spi.HostID;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.MembershipControllerImpl;
import weblogic.servlet.internal.NakedTimerListenerBase;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.ReplicatedSessionData;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.Debug;

public class ReplicatedSessionContext
extends SessionContext {
    private static final boolean DEBUG = false;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ReplicationServices repserv = ReplicationManager.services();
    private final HttpServer httpServer = this.getServletContext().getServer();
    private LATUpdateTrigger latTrigger;

    public ReplicatedSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
    }

    public void startTimers() {
        super.startTimers();
        this.latTrigger = new LATUpdateTrigger();
    }

    public String getPersistentStoreType() {
        return "replicated";
    }

    ROID getSecondarySession(String string) {
        return this.httpServer.getReplicator().getSecondary(string);
    }

    void removeSecondarySession(String string) {
        this.httpServer.getReplicator().removeSecondary(string, this.getServletContext().getContextPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(HttpSession httpSession) {
        ReplicatedSessionData replicatedSessionData;
        ReplicatedSessionData replicatedSessionData2 = replicatedSessionData = (ReplicatedSessionData)httpSession;
        synchronized (replicatedSessionData2) {
            replicatedSessionData.decrementActiveRequestCount();
            if (DEBUG_SESSIONS.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("synchronized on " + replicatedSessionData.getROID() + " and session is inUse: " + replicatedSessionData.sessionInUse() + " and active request count is: " + replicatedSessionData.getActiveRequestCount());
            }
            if (replicatedSessionData.sessionInUse()) {
                return;
            }
            if (DEBUG_SESSIONS.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("Going ahead with replication for " + replicatedSessionData.getROID());
            }
            if (replicatedSessionData.isValid()) {
                replicatedSessionData.syncSession();
            }
        }
        if (replicatedSessionData.getActiveRequestCount() < 0) {
            throw new AssertionError((Object)("Reference Count value set below 0, value is" + replicatedSessionData.getActiveRequestCount()));
        }
    }

    public ROID getROID(String string) {
        ROID rOID = (ROID)this.getOpenSession(string);
        if (rOID == null) {
            rOID = this.getSecondarySession(string);
        }
        return rOID;
    }

    public void updateSecondaryLAT(ROID rOID, long l) {
        ReplicatedSessionData replicatedSessionData = this.getSecondarySession(rOID);
        if (replicatedSessionData != null && replicatedSessionData.getLAT() < l) {
            if (DEBUG_SESSIONS.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("updating LAT for " + rOID + " lat=" + l + " prev=" + replicatedSessionData.getLAT());
            }
            replicatedSessionData.setLastAccessedTime(l);
        }
    }

    void killSecondary(ReplicatedSessionData replicatedSessionData) {
        replicatedSessionData.unregisterSecondary();
        this.removeSecondarySession(replicatedSessionData.id);
    }

    boolean hasSecondarySessionExpired(ReplicatedSessionData replicatedSessionData, long l) {
        long l2 = Long.MAX_VALUE;
        int n = replicatedSessionData.getMaxInactiveInterval() * 2;
        l2 = l - (long)n * 1000L;
        return n >= 0 && replicatedSessionData.getLAT() < l2;
    }

    public void destroy(boolean bl) {
        if (this.latTrigger != null) {
            this.latTrigger.stop();
        }
        super.destroy(bl);
        if (bl) {
            return;
        }
        if (this.configMgr.isSaveSessionsOnRedeployEnabled()) {
            return;
        }
        String[] stringArray = this.getIdsInternal();
        if (stringArray != null && stringArray.length > 0) {
            SessionCleanupAction sessionCleanupAction = new SessionCleanupAction(stringArray);
            Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)sessionCleanupAction);
            if (throwable != null) {
                HTTPSessionLogger.logUnexpectedErrorCleaningUpSessions((String)this.getServletContext().getLogContext(), (Throwable)throwable);
            }
        }
    }

    void unregisterExpiredSessions(ArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return;
        }
        ROID[] rOIDArray = new ROID[arrayList.size()];
        for (int i = 0; i < rOIDArray.length; ++i) {
            rOIDArray[i] = ((ReplicatedSessionData)arrayList.get(i)).getROID();
        }
        this.getReplicationServices().unregister(rOIDArray, (Object)this.getServletContext().getContextPath());
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        this.checkSessionCount();
        ReplicatedSessionData replicatedSessionData = new ReplicatedSessionData(string, this);
        replicatedSessionData.setMonitoringId();
        return replicatedSessionData;
    }

    private ReplicatedSessionData lookupRO(String string, String string2, ServerIdentity serverIdentity, ROID rOID) {
        ROID rOID2 = null;
        try {
            if (serverIdentity == null) {
                return null;
            }
            ReplicatedSessionData replicatedSessionData = (ReplicatedSessionData)this.getReplicationServices().registerLocally((HostID)serverIdentity, rOID, this.getServletContext().getContextPath());
            rOID2 = (ROID)this.getOpenSession(string2);
            if (replicatedSessionData != null) {
                if (this.isDebugEnabled()) {
                    Loggable loggable = HTTPSessionLogger.logRetrievedROIDFromSecondaryLoggable((String)rOID2.toString(), (String)serverIdentity.toString(), (String)"", (String)string2);
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                }
                if (DEBUG_SESSIONS.isDebugEnabled()) {
                    DEBUG_SESSIONS.debug("looked up the roid = " + rOID2 + " from host " + serverIdentity.toString());
                }
            }
            return replicatedSessionData;
        }
        catch (RemoteException remoteException) {
            HTTPSessionLogger.logErrorGettingSession((String)string, (Exception)remoteException);
            return null;
        }
    }

    private SessionData getPrimarySessionForTrigger(String string) throws NotFoundException {
        if (string == null) {
            return null;
        }
        ROID rOID = (ROID)this.getOpenSession(string);
        if (rOID == null) {
            return null;
        }
        return (ReplicatedSessionData)this.getReplicationServices().invalidationLookup(rOID, this.getServletContext().getContextPath());
    }

    public boolean isPrimaryOrSecondary(String string) {
        RSID rSID = new RSID(string, MembershipControllerImpl.getInstance().getClusterMembers());
        if (rSID.id == null) {
            return true;
        }
        ServerIdentity serverIdentity = this.getCurrentClusterMember();
        if (rSID.getPrimary() == null && rSID.getSecondary() == null) {
            return true;
        }
        return serverIdentity.equals(rSID.getPrimary()) || serverIdentity.equals(rSID.getSecondary());
    }

    public SessionData getSessionInternalForAuthentication(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        return this.getSessionInternal(string, servletRequestImpl, servletResponseImpl, true);
    }

    public SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        return this.getSessionInternal(string, servletRequestImpl, servletResponseImpl, false);
    }

    private SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, boolean bl) {
        try {
            if (servletRequestImpl == null) {
                return this.getPrimarySessionForTrigger(RSID.getID(string));
            }
            return this.lookupSession(string, servletRequestImpl, servletResponseImpl, bl);
        }
        catch (NotFoundException notFoundException) {
        }
        catch (RuntimeException runtimeException) {
            HTTPSessionLogger.logErrorGettingSession((String)string, (Exception)runtimeException);
        }
        return null;
    }

    public boolean hasSession(String string) {
        if (this.getSessionInternal(string, null, null) != null) {
            return true;
        }
        return this.lookupSession(string, null, null, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionData lookupSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, boolean bl) {
        try {
            ReplicatedSessionData replicatedSessionData;
            Externalizable externalizable;
            boolean bl2;
            RSID rSID = new RSID(string, MembershipControllerImpl.getInstance().getClusterMembers());
            if (rSID.id == null) {
                return null;
            }
            ServerIdentity serverIdentity = this.getCurrentClusterMember();
            String string2 = null;
            String string3 = null;
            if (rSID.getPrimary() != null && !serverIdentity.equals(rSID.getPrimary())) {
                string2 = URLManager.findURL(rSID.getPrimary(), this.httpServer.getReplicationChannel());
            }
            if (rSID.getSecondary() != null && !serverIdentity.equals(rSID.getSecondary())) {
                string3 = URLManager.findURL(rSID.getSecondary(), this.httpServer.getReplicationChannel());
            }
            boolean bl3 = false;
            String string4 = null;
            Externalizable externalizable2 = (ROID)this.getOpenSession(rSID.id);
            if (externalizable2 == null && serverIdentity.equals(rSID.getSecondary())) {
                externalizable2 = this.getSecondarySession(rSID.id);
            }
            boolean bl4 = bl2 = !serverIdentity.equals(rSID.getSecondary()) && !serverIdentity.equals(rSID.getPrimary());
            if (string2 != null && this.getPersistentStoreType() != "async-replication-across-cluster" && !bl) {
                HTTPSessionLogger.logSessionAccessFromNonPrimary((String)rSID.id, (String)serverIdentity.toString(), (String)(rSID.getPrimary() != null ? rSID.getPrimary().toString() : "NONE"), (String)(servletRequestImpl != null ? servletRequestImpl.getRequestURL().toString() : "NONE"));
            }
            if (bl2) {
                externalizable = null;
                replicatedSessionData = null;
                RemoteException remoteException = null;
                if (string2 != null) {
                    try {
                        externalizable = this.httpServer.getReplicator().lookupROID(rSID.id, string2, this.getConfigMgr().getCookieName(), this.getConfigMgr().getCookiePath(), bl2);
                    }
                    catch (RemoteException remoteException2) {
                        remoteException = remoteException2;
                    }
                    if (externalizable != null) {
                        externalizable2 = externalizable;
                        string4 = "primary-server: " + string2;
                        replicatedSessionData = this.lookupRO(string, rSID.id, rSID.getPrimary(), (ROID)externalizable2);
                        if (replicatedSessionData != null) {
                            bl3 = true;
                        }
                    }
                }
                if (externalizable == null && string3 != null) {
                    try {
                        externalizable = this.httpServer.getReplicator().lookupROID(rSID.id, string3, this.getConfigMgr().getCookieName(), this.getConfigMgr().getCookiePath(), bl2);
                    }
                    catch (RemoteException remoteException3) {
                        remoteException = remoteException3;
                    }
                    if (externalizable != null) {
                        externalizable2 = externalizable;
                        string4 = "secondary-server: " + string3;
                        replicatedSessionData = this.lookupRO(string, rSID.id, rSID.getSecondary(), (ROID)externalizable2);
                        if (replicatedSessionData != null) {
                            bl3 = true;
                        }
                    }
                }
                if (externalizable2 == null && remoteException != null) {
                    HTTPSessionLogger.logErrorGettingSession((String)string, (Exception)remoteException);
                }
            }
            if (externalizable2 == null) {
                return null;
            }
            if (string4 == null) {
                string4 = "current-server";
            }
            if ((externalizable = (ReplicatedSessionData)this.getReplicationServices().lookup((ROID)externalizable2, this.getServletContext().getContextPath())) == null) {
                return null;
            }
            if (!((ReplicatedSessionData)externalizable).id.equals(rSID.id)) {
                Debug.say((String)("Incoming sessionid: " + string + "\nrsid: " + rSID + "\nrsid.id: " + rSID.id + "\nroid: " + externalizable2 + "\nprimary: " + rSID.getPrimary() + "\nsecondary: " + rSID.getSecondary() + "\ncurrentServer: " + serverIdentity.hashCode() + "\ncurrent context path: " + this.getServletContext().getContextPath() + "\norigin: " + string4 + "\nsession.id: " + ((ReplicatedSessionData)externalizable).id + "\nsession.ROID: " + ((ReplicatedSessionData)externalizable).getROID() + "\nsession.ContextPath: " + ((SessionData)externalizable).getContextPath()));
                throw new AssertionError((Object)"Lookup returned replicated session object with a different sessionid");
            }
            replicatedSessionData = externalizable;
            synchronized (replicatedSessionData) {
                if (!((SessionData)externalizable).isValid()) {
                    return null;
                }
                ((SessionData)externalizable).setSessionContext(this);
                ((SessionData)externalizable).updateVersionIfNeeded(this);
                if (bl3) {
                    ((SessionData)externalizable).setLastAccessedTime(System.currentTimeMillis());
                    ((SessionData)externalizable).notifyActivated(new HttpSessionEvent((HttpSession)externalizable));
                }
                if (!((SessionData)externalizable).isValidForceCheck()) {
                    return null;
                }
                if (servletRequestImpl != null) {
                    ((SessionData)externalizable).incrementActiveRequestCount();
                }
                ((ReplicatedSessionData)externalizable).reinitializeSecondary();
            }
            return externalizable;
        }
        catch (NotFoundException notFoundException) {
        }
        catch (RuntimeException runtimeException) {
            HTTPSessionLogger.logErrorGettingSession((String)string, (Exception)runtimeException);
        }
        return null;
    }

    public Object getOpenSession(String string) {
        return this.httpServer.getReplicator().getPrimary(string);
    }

    public void removeSession(String string, ROID rOID) {
        super.removeSession(string);
        this.httpServer.getReplicator().removePrimary(string, this.getServletContext().getContextPath());
    }

    public int getCurrOpenSessionsCount() {
        return this.getOpenSessions().size();
    }

    boolean invalidateSession(SessionData sessionData, boolean bl, boolean bl2) {
        String string = sessionData.id;
        ReplicatedSessionData replicatedSessionData = (ReplicatedSessionData)sessionData;
        replicatedSessionData.remove(bl, bl2);
        this.removeSession(string, replicatedSessionData.getROID());
        this.decrementOpenSessionsCount();
        SessionData.invalidateProcessedSession(sessionData);
        return true;
    }

    private ReplicatedSessionData getSecondarySession(ROID rOID) {
        try {
            return (ReplicatedSessionData)this.getReplicationServices().invalidationLookup(rOID, this.getServletContext().getContextPath());
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    protected void invalidateOrphanedSessions() {
        long l = System.currentTimeMillis();
        ROID[] rOIDArray = this.httpServer.getReplicator().getSecondaryIds();
        int n = rOIDArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ROID rOID = rOIDArray[i];
            try {
                ReplicatedSessionData replicatedSessionData = this.getSecondarySession(rOID);
                if (replicatedSessionData == null || replicatedSessionData.sessionInUse() || !this.hasSecondarySessionExpired(replicatedSessionData, l)) continue;
                this.killSecondary(replicatedSessionData);
                if (this.isDebugEnabled()) {
                    Loggable loggable = HTTPSessionLogger.logTimerInvalidatedSessionLoggable((String)("secondary:" + rOID), (String)this.getServletContext().getContextPath());
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                }
                ++n2;
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                HTTPSessionLogger.logUnexpectedTimeoutError((Throwable)throwable);
            }
        }
        if (DEBUG_SESSIONS.isDebugEnabled() && n > 0) {
            DEBUG_SESSIONS.debug("Total secondary sessions invalidated = " + n2 + " out of total secondary sessions = " + n + " in " + this.getServletContext().getContextPath());
        }
    }

    public int getNonPersistedSessionCount() {
        Hashtable hashtable = this.getOpenSessions();
        if (hashtable.size() < 1) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ReplicatedSessionData replicatedSessionData = (ReplicatedSessionData)enumeration.nextElement();
            ROID rOID = replicatedSessionData.getROID();
            try {
                if (this.getReplicationServices().getSecondaryInfo(rOID) != null) continue;
                ++n;
            }
            catch (NotFoundException notFoundException) {}
        }
        return n;
    }

    protected ReplicationServices getReplicationServices() {
        return repserv;
    }

    public String lookupAppVersionIdForSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        HttpSession httpSession = servletRequestImpl.getSession(false);
        if (httpSession == null || !(httpSession instanceof ReplicatedSessionData)) {
            return null;
        }
        return ((ReplicatedSessionData)httpSession).getVersionId();
    }

    LATUpdateTrigger getTimer() {
        return this.latTrigger;
    }

    private class SessionCleanupAction
    implements PrivilegedAction {
        private final String[] ids;

        SessionCleanupAction(String[] stringArray) {
            this.ids = stringArray;
        }

        public Object run() {
            try {
                for (int i = 0; i < this.ids.length; ++i) {
                    SessionData sessionData = null;
                    if (this.ids[i] == null) break;
                    try {
                        sessionData = ReplicatedSessionContext.this.getPrimarySessionForTrigger(this.ids[i]);
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                    if (sessionData == null) continue;
                    ReplicatedSessionContext.this.invalidateSession(sessionData, false);
                }
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    class LATUpdateTrigger
    extends NakedTimerListenerBase {
        private static final int DEFAULT_INTERVAL = 120;
        private static final int MAX_INTERVAL = 900;
        private static final int MIN_INTERVAL = 60;
        private final Hashtable allBatchJobs;
        private Timer timer;
        private boolean stopRequested;
        private int triggerInterval;
        private int latestBatchJobInterval;

        private LATUpdateTrigger() {
            super("LATUpdateTrigger", ReplicatedSessionContext.this.getServletContext());
            this.allBatchJobs = new Hashtable();
            this.stopRequested = false;
            this.triggerInterval = 120;
            this.latestBatchJobInterval = 120;
            this.latestBatchJobInterval = 120;
            this.computeBatchInterval(-1);
            this.start();
        }

        private void start() {
            this.stopRequested = false;
            this.triggerInterval = this.latestBatchJobInterval;
            this.timer = this.timerManager.schedule((TimerListener)this, 0L, (long)(this.triggerInterval * 1000));
        }

        private void stop() {
            this.stopRequested = true;
            this.timer.cancel();
            this.timerManager.stop();
        }

        private void bounce() {
            this.timer.cancel();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerLAT(ROID rOID, long l, int n) {
            ServerIdentity serverIdentity = this.getSecondary(rOID);
            if (serverIdentity == null) {
                return;
            }
            Hashtable<ROID, Long> hashtable = (Hashtable<ROID, Long>)this.allBatchJobs.get(serverIdentity);
            if (hashtable == null) {
                Hashtable hashtable2 = this.allBatchJobs;
                synchronized (hashtable2) {
                    hashtable = (Hashtable)this.allBatchJobs.get(serverIdentity);
                    if (hashtable == null) {
                        hashtable = new Hashtable<ROID, Long>();
                        this.allBatchJobs.put(serverIdentity, hashtable);
                    }
                }
            }
            hashtable.put(rOID, new Long(n));
            this.computeBatchInterval(n);
        }

        private ServerIdentity getSecondary(ROID rOID) {
            try {
                return (ServerIdentity)ReplicatedSessionContext.this.getReplicationServices().getSecondaryInfo(rOID);
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
        }

        void unregisterLAT(ROID rOID) {
            ServerIdentity serverIdentity = this.getSecondary(rOID);
            if (serverIdentity == null) {
                return;
            }
            Hashtable hashtable = (Hashtable)this.allBatchJobs.get(serverIdentity);
            if (hashtable == null) {
                return;
            }
            hashtable.remove(rOID);
        }

        private void computeBatchInterval(int n) {
            int n2;
            if (n > 0 && n / 3 < this.latestBatchJobInterval) {
                this.latestBatchJobInterval = n / 3;
            }
            if ((n2 = ReplicatedSessionContext.this.configMgr.getInvalidationIntervalSecs()) / 2 < this.latestBatchJobInterval) {
                this.latestBatchJobInterval = n2 / 2;
            }
            if (this.latestBatchJobInterval < 60) {
                this.latestBatchJobInterval = 60;
            } else if (this.latestBatchJobInterval > 900) {
                this.latestBatchJobInterval = 900;
            }
        }

        public void timerExpired(Timer timer) {
            if (!ReplicatedSessionContext.this.getServletContext().isStarted()) {
                return;
            }
            final int n = this.allBatchJobs.size();
            if (n < 1) {
                this.latestBatchJobInterval = 120;
                return;
            }
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        LATUpdateTrigger.this.runTrigger(n);
                    }
                    catch (Throwable throwable) {
                        HTTPSessionLogger.logLATUpdateError((String)ReplicatedSessionContext.this.getServletContext().getContextPath(), (Throwable)throwable);
                    }
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTrigger(int n) {
            try {
                if (SessionContext.DEBUG_SESSIONS.isDebugEnabled()) {
                    SessionContext.DEBUG_SESSIONS.debug("LATUpdateTrigger: total jobs: " + n + " current interval=" + this.latestBatchJobInterval);
                }
                Hashtable hashtable = null;
                Object object = this.allBatchJobs;
                synchronized (object) {
                    hashtable = (Hashtable)this.allBatchJobs.clone();
                    this.allBatchJobs.clear();
                }
                n = hashtable.size();
                if (n < 1) {
                    Object var6_5 = null;
                    if (!this.stopRequested && this.triggerInterval != this.latestBatchJobInterval) {
                        this.bounce();
                    }
                    return;
                }
                object = hashtable.values().iterator();
                while (object.hasNext()) {
                    this.sendBatchJob((Hashtable)object.next());
                }
                Object var6_6 = null;
                if (!this.stopRequested && this.triggerInterval != this.latestBatchJobInterval) {
                    this.bounce();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!this.stopRequested && this.triggerInterval != this.latestBatchJobInterval) {
                    this.bounce();
                }
                throw throwable;
            }
        }

        private void sendBatchJob(Hashtable hashtable) {
            int n = hashtable.size();
            if (n < 1) {
                return;
            }
            ROID[] rOIDArray = new ROID[n];
            long[] lArray = new long[n];
            String string = null;
            Enumeration enumeration = hashtable.keys();
            for (int i = 0; enumeration.hasMoreElements() && i < n; ++i) {
                ROID rOID = (ROID)enumeration.nextElement();
                if (string == null) {
                    try {
                        ServerIdentity serverIdentity = (ServerIdentity)ReplicatedSessionContext.this.getReplicationServices().getSecondaryInfo(rOID);
                        if (serverIdentity != null) {
                            string = URLManager.findURL(serverIdentity, ReplicatedSessionContext.this.httpServer.getReplicationChannel());
                        }
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                rOIDArray[i] = rOID;
                lArray[i] = (Long)hashtable.get(rOID);
            }
            if (SessionContext.DEBUG_SESSIONS.isDebugEnabled()) {
                SessionContext.DEBUG_SESSIONS.debug("LATUpdateTrigger: sending a batch of size = " + n + " to secondary url : " + string);
            }
            if (string != null) {
                ReplicatedSessionContext.this.httpServer.getReplicator().updateROIDLastAccessTimes(string, rOIDArray, lArray, ReplicatedSessionContext.this.getServletContext().getContextPath());
            }
            hashtable.clear();
        }
    }
}

