/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationAccess;
import weblogic.cluster.replication.ApplicationUnavailableException;
import weblogic.cluster.replication.NotFoundException;
import weblogic.cluster.replication.ROID;
import weblogic.cluster.replication.Replicatable;
import weblogic.cluster.replication.ReplicationServices;
import weblogic.logging.Loggable;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.utils.io.RemoteObjectReplacer;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.AttributeWrapper;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServerHelper;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.session.EJBAttributeWrapper;
import weblogic.servlet.internal.session.EJBHomeAttributeWrapper;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.ReplicatedSessionChange;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionData;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.NestedError;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedObjectInputStream;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public class ReplicatedSessionData
extends SessionData
implements Replicatable {
    private static final long serialVersionUID = -1080155161838278576L;
    protected ROID roid;
    protected String contextName;
    private String webserverName;
    private HttpServer srvr;
    private transient ReplicatedSessionChange change;
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");
    private String secondaryJVMID = null;

    public ReplicatedSessionData() {
        this.initializeChange();
    }

    public ReplicatedSessionData(String string, SessionContext sessionContext) {
        this(string, sessionContext, true);
    }

    protected ReplicatedSessionData(String string, SessionContext sessionContext, boolean bl) {
        super(string, sessionContext, bl);
        this.initializeChange();
        this.srvr = this.getWebAppServletContext().getServer();
        this.contextName = this.getContextPath();
        this.webserverName = this.srvr == WebService.defaultHttpServer() ? "USE_DEFAULT_WEB_SERVER" : this.srvr.getName();
        this.roid = this.registerOrAdd(this.srvr, this.id, this.contextName);
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("registerOrAdd returns " + this.roid));
        }
        if (!this.isValid) {
            HTTPSessionLogger.logSessionGotInvalidatedBeforeCreationCouldComplete((String)this.getWebAppServletContext().getLogContext(), (String)this.id);
        } else if (DEBUG_SESSIONS.isDebugEnabled()) {
            DEBUG_SESSIONS.debug("sessionId:" + string + " associated with roid:" + this.roid);
        }
        this.reinitializeSecondary();
        this.getWebAppServletContext().getEventsManager().notifySessionLifetimeEvent(this, true);
        this.incrementActiveRequestCount();
        ((SessionContext)this.getSessionContext()).addSession(this.id, this);
        this.srvr.getReplicator().putPrimary(this.id, this.getROID(), this.contextName);
        ((SessionContext)this.getSessionContext()).incrementOpenSessionsCount();
    }

    protected void initializeChange() {
        this.change = new ReplicatedSessionChange();
    }

    protected ReplicatedSessionChange getSessionChange() {
        return this.change;
    }

    protected ROID registerOrAdd(HttpServer httpServer, String string, String string2) {
        ROID rOID = httpServer.getReplicator().getPrimary(string);
        if (rOID != null) {
            this.getReplicationServices().add(rOID, this);
            return rOID;
        }
        rOID = httpServer.getReplicator().getSecondary(string);
        if (rOID != null) {
            httpServer.getReplicator().putPrimary(string, rOID, string2);
            this.getReplicationServices().add(rOID, this);
            return rOID;
        }
        return this.getReplicationServices().register(this).getROID();
    }

    ROID getROID() {
        return this.roid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        GenericClassLoader genericClassLoader = null;
        String string = (String)objectInput.readObject();
        genericClassLoader = AppClassLoaderManager.getAppClassLoaderManager().findLoader(new Annotation(string));
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        if (genericClassLoader != null) {
            thread2.setContextClassLoader((ClassLoader)genericClassLoader);
        }
        try {
            this.attributes = ReplicatedSessionData.convertToConcurrentHashMap(objectInput.readObject());
            this.setNew(false);
            this.isValid = objectInput.readBoolean();
            this.creationTime = objectInput.readLong();
            this.maxInactiveInterval = objectInput.readInt();
            this.id = (String)objectInput.readObject();
            this.roid = (ROID)objectInput.readObject();
            this.contextName = (String)objectInput.readObject();
            this.webserverName = (String)objectInput.readObject();
            this.internalAttributes = ReplicatedSessionData.convertToConcurrentHashMap(objectInput.readObject());
            this.accessTime = objectInput.readLong();
            long l = objectInput.readLong();
            long l2 = System.currentTimeMillis() - l;
            this.accessTime += l2;
            this.setupVersionIdFromAttrs();
            Object var11_8 = null;
            if (genericClassLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (genericClassLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("ReplicatedSessionData.readExternal: versionId=" + this.versionId + ", contextName=" + this.contextName + ", id=" + this.id + ", workCtxs=" + this.getWorkContexts()));
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getWebAppAnnotation());
        this.initVersionAttrsIfNeeded();
        objectOutput.writeObject(ReplicatedSessionData.convertToHashtable(this.attributes));
        objectOutput.writeBoolean(this.isValid);
        objectOutput.writeLong(this.creationTime);
        objectOutput.writeInt(this.maxInactiveInterval);
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.roid);
        objectOutput.writeObject(this.contextName);
        objectOutput.writeObject(this.webserverName);
        objectOutput.writeObject(ReplicatedSessionData.convertToHashtable(this.internalAttributes));
        objectOutput.writeLong(this.accessTime);
        objectOutput.writeLong(System.currentTimeMillis());
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("ReplicatedSessionData.writeExternal: versionId=" + this.versionId + ", contextName=" + this.contextName + ", id=" + this.id + ", workCtxs=" + this.getWorkContexts()));
        }
    }

    private String getWebAppAnnotation() throws IOException {
        ClassLoader classLoader;
        WebAppServletContext webAppServletContext = ReplicatedSessionData.getServletContext(this.webserverName, this.contextName, this.versionId);
        if (webAppServletContext != null && (classLoader = webAppServletContext.getServletClassLoader()) != null && classLoader instanceof GenericClassLoader) {
            return ((GenericClassLoader)classLoader).getAnnotation().getAnnotationString();
        }
        return ReplicatedSessionData.getAnnotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void becomePrimary(ROID rOID) {
        SessionContext sessionContext;
        if (rOID != null) {
            this.roid = rOID;
        }
        if ((sessionContext = this.getContext(this.webserverName, this.contextName)) == null) {
            HTTPSessionLogger.logContextNotFound((String)this.contextName, (String)"becomePrimary");
            throw new RuntimeException("WebApp with contextPath: " + this.contextName + " not found in the secondary server");
        }
        if (!(sessionContext instanceof ReplicatedSessionContext)) {
            HTTPSessionLogger.logPersistentStoreTypeNotReplicated((String)this.contextName, (String)"becomePrimary");
            throw new RuntimeException("WebApp with contextPath: " + this.contextName + " is not replicatable in the secondary server");
        }
        ReplicatedSessionContext replicatedSessionContext = (ReplicatedSessionContext)sessionContext;
        this.setSessionContext(replicatedSessionContext);
        this.setLastAccessedTime(System.currentTimeMillis());
        this.reinitRuntimeMBean();
        this.getWebAppServletContext().getServer().getSessionLogin().register(this.id, this.getContextPath());
        if (!this.isNew()) {
            this.setForceToConvertAttributes(true);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getWebAppServletContext().getServletClassLoader());
            this.notifyActivated(new HttpSessionEvent((HttpSession)this));
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        if (!this.isNew()) {
            replicatedSessionContext.incrementOpenSessionsCount();
        }
        this.getHttpServer().getReplicator().putPrimary(this.id, rOID, this.contextName);
        replicatedSessionContext.addSession(this.id, this);
        if (this.isDebugEnabled()) {
            Loggable loggable = HTTPSessionLogger.logBecomePrimaryLoggable((String)this.id);
            DEBUG_SESSIONS.debug(loggable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyActivated() {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        String string = ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
        if (string == null) {
            this.getWebAppServletContext().pushEnvironment(thread2);
        }
        try {
            this.notifyActivated(new HttpSessionEvent((HttpSession)this));
            Object var5_4 = null;
            if (string != null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (string != null) throw throwable;
            this.getWebAppServletContext();
            WebAppServletContext.popEnvironment(thread2, classLoader);
            throw throwable;
        }
        this.getWebAppServletContext();
        WebAppServletContext.popEnvironment(thread2, classLoader);
    }

    public Object becomeSecondary(ROID rOID) {
        this.roid = rOID;
        SessionContext sessionContext = this.getContext(this.webserverName, this.contextName);
        if (sessionContext == null) {
            HTTPSessionLogger.logContextNotFound((String)this.contextName, (String)"becomeSecondary");
            throw new ApplicationUnavailableException("WebApp with contextPath: " + this.contextName + " not found in the secondary server");
        }
        if (!(sessionContext instanceof ReplicatedSessionContext)) {
            HTTPSessionLogger.logPersistentStoreTypeNotReplicated((String)this.contextName, (String)"becomeSecondary");
            throw new ApplicationUnavailableException("WebApp with contextPath: " + this.contextName + " is not replicatable in the secondary server");
        }
        ReplicatedSessionContext replicatedSessionContext = (ReplicatedSessionContext)sessionContext;
        this.setSessionContext(replicatedSessionContext);
        if (replicatedSessionContext.getOpenSession(this.id) != null) {
            replicatedSessionContext.decrementOpenSessionsCount();
        }
        this.getHttpServer().getReplicator().putSecondary(this.id, rOID, this.contextName);
        this.getHttpServer().getSessionLogin().unregister(this.id, this.getContextPath());
        this.unregisterRuntimeMBean();
        if (this.isDebugEnabled()) {
            Loggable loggable = HTTPSessionLogger.logBecomeSecondaryLoggable((String)this.id);
            DEBUG_SESSIONS.debug(loggable.getMessage());
        }
        return LocalServerIdentity.getIdentity();
    }

    public void becomeUnregistered(ROID rOID) {
        ReplicatedSessionContext replicatedSessionContext;
        SessionContext sessionContext = this.getContext(this.webserverName, this.contextName);
        if (sessionContext != null) {
            replicatedSessionContext = (ReplicatedSessionContext)sessionContext;
            if (replicatedSessionContext.getOpenSession(this.id) != null) {
                replicatedSessionContext.decrementOpenSessionsCount();
            }
            this.getHttpServer().getReplicator().removeSecondary(this.id, this.contextName);
            this.getHttpServer().getSessionLogin().unregister(this.id, this.getContextPath());
        }
        if (this.isDebugEnabled()) {
            replicatedSessionContext = HTTPSessionLogger.logUnregisterLoggable((String)this.id);
            DEBUG_SESSIONS.debug(replicatedSessionContext.getMessage());
        }
    }

    public void update(ROID rOID, Serializable serializable) {
        if (this.isDebugEnabled()) {
            Debug.assertion((boolean)(serializable instanceof ReplicatedSessionChange));
        }
        if (serializable == null) {
            return;
        }
        ReplicatedSessionChange replicatedSessionChange = null;
        try {
            replicatedSessionChange = (ReplicatedSessionChange)serializable;
        }
        catch (ClassCastException classCastException) {
            if (this.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("Failed to update the secondary: ", (Throwable)classCastException);
            }
            return;
        }
        this.applySessionChange(replicatedSessionChange);
        if (this.isDebugEnabled()) {
            DEBUG_SESSIONS.debug("Received Change = " + replicatedSessionChange.toString() + ", workCtxs=" + this.getWorkContexts());
        }
    }

    protected void applySessionChange(ReplicatedSessionChange replicatedSessionChange) {
        Object v;
        this.maxInactiveInterval = replicatedSessionChange.getMaxInActiveInterval();
        this.accessTime = replicatedSessionChange.getLastAccessTime();
        long l = System.currentTimeMillis() - replicatedSessionChange.getTimeOnPrimaryAtUpdate();
        this.accessTime += l;
        if (!replicatedSessionChange.getAttributeChanges().isEmpty()) {
            for (Object k : replicatedSessionChange.getAttributeChanges().keySet()) {
                v = replicatedSessionChange.getAttributeChanges().get(k);
                this.justPutValue((String)k, v, replicatedSessionChange.isUseLazyDeserialization());
            }
        }
        if (!replicatedSessionChange.getInternalAttributeChanges().isEmpty()) {
            for (Object k : replicatedSessionChange.getInternalAttributeChanges().keySet()) {
                v = replicatedSessionChange.getInternalAttributeChanges().get(k);
                if (v != null) {
                    super.setInternalAttribute((String)k, v);
                    if (!k.equals("weblogic.workContexts")) continue;
                    this.updateWorkContextsIfNeeded();
                    continue;
                }
                super.removeInternalAttribute((String)k);
            }
        }
    }

    private Object checkEJBAttribute(Object object) {
        if (object != null && object instanceof AttributeWrapper) {
            AttributeWrapper attributeWrapper = (AttributeWrapper)object;
            if (object instanceof EJBAttributeWrapper) {
                try {
                    Handle handle = (Handle)attributeWrapper.getObject();
                    if (handle != null) {
                        object = handle.getEJBObject();
                    }
                }
                catch (Exception exception) {
                    HTTPSessionLogger.logErrorReconstructingEJBObject((String)object.toString(), (Exception)exception);
                }
            } else if (object != null && object instanceof EJBHomeAttributeWrapper) {
                try {
                    HomeHandle homeHandle = (HomeHandle)attributeWrapper.getObject();
                    object = homeHandle != null ? homeHandle.getEJBHome() : null;
                }
                catch (Exception exception) {
                    HTTPSessionLogger.logErrorReconstructingEJBHome((String)object.toString(), (Exception)exception);
                }
            }
        }
        return object;
    }

    private void justPutValue(String string, Object object, boolean bl) {
        if (object != null) {
            if (bl) {
                this.attributes.put(string, object);
            } else {
                Object object2 = this.checkEJBAttribute(object);
                SessionData.AttributeInfo attributeInfo = this.validateAttributeValue(string, object2);
                AttributeWrapper attributeWrapper = new AttributeWrapper(object2);
                if (attributeInfo != null) {
                    attributeWrapper.setCheckSum(attributeInfo.checksum);
                    attributeWrapper.setPreviousChecksum(attributeInfo.oldChecksum);
                }
                this.attributes.put(string, attributeWrapper);
            }
        } else {
            this.attributes.remove(string);
        }
    }

    private HttpServer getHttpServer() {
        if (this.srvr != null) {
            return this.srvr;
        }
        this.srvr = this.webserverName.equals("USE_DEFAULT_WEB_SERVER") ? WebService.defaultHttpServer() : WebService.getHttpServer(this.webserverName);
        return this.srvr;
    }

    private String getSecondaryJVMID() {
        String string = this.secondaryJVMID;
        if (string != null) {
            return string;
        }
        try {
            ServerIdentity serverIdentity = (ServerIdentity)this.getReplicationServices().getSecondaryInfo(this.roid);
            string = serverIdentity != null ? (ServerHelper.useExtendedSessionFormat() ? ServerHelper.createServerEntry(ServerHelper.getNetworkChannelName(), serverIdentity, "!") : Integer.toString(serverIdentity.hashCode())) : "NONE";
        }
        catch (NotFoundException notFoundException) {
            if (this.isDebugEnabled()) {
                Loggable loggable = HTTPSessionLogger.logSecondaryIDNotFoundLoggable((String)this.getWebAppServletContext().getLogContext(), (String)this.id, (Throwable)notFoundException);
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            string = "NONE";
        }
        catch (RuntimeException runtimeException) {
            if (this.isDebugEnabled()) {
                Loggable loggable = HTTPSessionLogger.logFailedToFindSecondaryInfoLoggable((String)this.getWebAppServletContext().getLogContext(), (String)this.id, (Throwable)runtimeException);
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            string = "NONE";
        }
        this.secondaryJVMID = string;
        return string;
    }

    void reinitializeSecondary() {
        this.secondaryJVMID = null;
    }

    public String getIdWithServerInfo() {
        SessionContext sessionContext = this.getContext();
        if (sessionContext == null) {
            return this.id;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        stringBuilder.append("!");
        if (ServerHelper.useExtendedSessionFormat()) {
            stringBuilder.append(ServerHelper.createServerEntry(ServerHelper.getNetworkChannelName(), LocalServerIdentity.getIdentity(), "!"));
        } else {
            stringBuilder.append(this.getWebAppServletContext().getServer().getServerHash());
        }
        stringBuilder.append("!");
        stringBuilder.append(this.getSecondaryJVMID());
        return stringBuilder.toString();
    }

    void remove(boolean bl, boolean bl2) {
        ((ReplicatedSessionContext)this.getContext()).getTimer().unregisterLAT(this.roid);
        if (!bl) {
            this.getReplicationServices().unregister(this.roid, (Object)this.contextName);
        }
        super.remove(bl2);
    }

    void unregisterSecondary() {
        this.getReplicationServices().removeOrphanedSecondary(this.roid, this.contextName);
    }

    public void setMaxInactiveInterval(int n) {
        super.setMaxInactiveInterval(n);
        this.getSessionChange().init(this.maxInactiveInterval, this.accessTime);
    }

    private void setForceToConvertAttributes(boolean bl) {
        if (this.attributes != null) {
            for (Object v : this.attributes.values()) {
                if (!(v instanceof AttributeWrapper)) continue;
                AttributeWrapper attributeWrapper = (AttributeWrapper)v;
                attributeWrapper.setForceToConvert(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInternalAttribute(String string, Object object) throws IllegalStateException, IllegalArgumentException {
        if (object == null) {
            this.removeInternalAttribute(string);
            return;
        }
        super.setInternalAttribute(string, object);
        if (object instanceof Serializable || object instanceof Remote) {
            this.getSessionChange().init(this.maxInactiveInterval, this.accessTime);
            ReplicatedSessionChange replicatedSessionChange = this.getSessionChange();
            synchronized (replicatedSessionChange) {
                this.getSessionChange().getInternalAttributeChanges().put(string, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        this.getSessionChange().init(this.maxInactiveInterval, this.accessTime);
        ReplicatedSessionChange replicatedSessionChange = this.getSessionChange();
        synchronized (replicatedSessionChange) {
            this.getSessionChange().addInternalAttributeChange(string, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object, boolean bl) throws IllegalStateException {
        if (object == null) {
            this.removeAttribute(string, bl);
            return;
        }
        super.setAttribute(string, object, bl);
        object = this.replaceObject(object, string);
        if (object instanceof Serializable || object instanceof Remote) {
            AttributeWrapper attributeWrapper;
            Object object2;
            if (this.isDebugEnabled() && (object2 = this.attributes.get(string)) != null && object2 instanceof AttributeWrapper && (attributeWrapper = (AttributeWrapper)object2).getPreviousChecksum() == attributeWrapper.getCheckSum()) {
                String string2 = "Attribute value for '" + string + "' is being replicated although it has not changed. previous value checksum: " + attributeWrapper.getPreviousChecksum() + ", new value checksum: " + attributeWrapper.getCheckSum();
                DEBUG_SESSIONS.debug(string2);
            }
            this.getSessionChange().init(this.maxInactiveInterval, this.accessTime);
            object2 = this.getSessionChange();
            synchronized (object2) {
                this.getSessionChange().addAttributeChange(string, object);
            }
        } else if (this.isDebugEnabled()) {
            DEBUG_SESSIONS.debug("Session attribute with name:" + string + " class:" + object.getClass().getName() + " is not serializable ane will " + " not be replicated or persisted");
        }
    }

    private Object replaceObject(Object object, String string) {
        Object object2 = object;
        if (object instanceof EJBObject) {
            try {
                Handle handle = ((EJBObject)object).getHandle();
                object2 = new EJBAttributeWrapper(handle);
            }
            catch (RemoteException remoteException) {
                HTTPSessionLogger.logErrorFindingHandle((String)string, (Exception)remoteException);
            }
        } else if (object instanceof EJBHome) {
            try {
                HomeHandle homeHandle = ((EJBHome)object).getHomeHandle();
                object2 = new EJBHomeAttributeWrapper(homeHandle);
            }
            catch (RemoteException remoteException) {
                HTTPSessionLogger.logErrorFindingHomeHandle((String)string, (Exception)remoteException);
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAttribute(String string, boolean bl) throws IllegalStateException {
        Object object = this.getAttribute(string);
        super.removeAttribute(string, bl);
        this.getSessionChange().init(this.maxInactiveInterval, this.accessTime);
        ReplicatedSessionChange replicatedSessionChange = this.getSessionChange();
        synchronized (replicatedSessionChange) {
            this.getSessionChange().addAttributeChange(string, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncSession() {
        super.syncSession();
        if (DEBUG_SESSIONS.isDebugEnabled()) {
            DEBUG_SESSIONS.debug("The change associated with this SessionData(" + this.getROID() + " or " + this + ") is: " + this.getSessionChange().hashCode());
        }
        if (!this.isValid) {
            return;
        }
        if (this.isDebugEnabled()) {
            DEBUG_SESSIONS.debug("SessionData.syncSession() the change is modified: " + this.getSessionChange().getModified() + " and the active request count is: " + this.getActiveRequestCount() + " for " + this.getROID() + " and this is: " + this);
        }
        if (this.getSessionChange().getModified()) {
            ReplicatedSessionChange replicatedSessionChange;
            if (this.isDebugEnabled()) {
                DEBUG_SESSIONS.debug("Replicating session : " + this.getROID() + " and " + this);
            }
            ((ReplicatedSessionContext)this.getContext()).getTimer().unregisterLAT(this.roid);
            try {
                this.notifyAboutToPassivate(new HttpSessionEvent((HttpSession)this));
                this.getSessionChange().setTimeOnPrimaryAtUpdate(System.currentTimeMillis());
                replicatedSessionChange = this.getSessionChange();
                synchronized (replicatedSessionChange) {
                    this.getReplicationServices().updateSecondary(this.roid, this.getUpdateObject(), this.contextName);
                }
            }
            catch (RemoteRuntimeException remoteRuntimeException) {
                if (this.isDebugEnabled()) {
                    Loggable loggable = HTTPSessionLogger.logFailedToUpdateSecondaryLoggable((String)this.id, (Exception)((Object)remoteRuntimeException));
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                }
            }
            catch (NotFoundException notFoundException) {
                if (this.isDebugEnabled()) {
                    Loggable loggable = HTTPSessionLogger.logSecondaryNotFoundLoggable((String)this.id, (Exception)notFoundException);
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                }
                throw new NestedError("Could not find secondary on remote server", (Throwable)notFoundException);
            }
            replicatedSessionChange = this.getSessionChange();
            synchronized (replicatedSessionChange) {
                this.getSessionChange().clear();
            }
        }
        ((ReplicatedSessionContext)this.getContext()).getTimer().registerLAT(this.roid, this.accessTime, this.maxInactiveInterval);
    }

    protected Serializable getUpdateObject() {
        return this.change;
    }

    protected void logTransientAttributeError(String string) {
        HTTPSessionLogger.logTransientReplicatedAttributeError((String)this.getWebAppServletContext().getLogContext(), (String)string, (String)this.getId());
    }

    public Object getKey() {
        return this.contextName;
    }

    protected ReplicationServices getReplicationServices() {
        ReplicatedSessionContext replicatedSessionContext = (ReplicatedSessionContext)this.getSessionContext();
        return replicatedSessionContext.getReplicationServices();
    }

    protected void initVersionAttrsIfNeeded() {
        if (this.versionId != null && this.getInternalAttribute("weblogic.versionId") == null) {
            this.setInternalAttribute("weblogic.versionId", this.versionId);
        }
    }

    private byte[] getWorkContexts() {
        return (byte[])this.getInternalAttribute("weblogic.workContexts");
    }

    private void updateWorkContextsIfNeeded() {
        SessionContext sessionContext;
        byte[] byArray = this.getWorkContexts();
        if (byArray != null && (sessionContext = this.getContext(this.webserverName, this.contextName)) != null) {
            sessionContext.getServletContext().getServer().getWorkContextManager().updateWorkContexts(this.id, byArray);
        }
    }

    static String getAnnotation() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ReplicatedSessionData.getAnnotation(classLoader);
    }

    private static String getAnnotation(ClassLoader classLoader) {
        return classLoader instanceof GenericClassLoader ? ((GenericClassLoader)classLoader).getAnnotation().getAnnotationString() : null;
    }

    public Object getAttribute(String string) throws IllegalStateException {
        Object v;
        this.check(string);
        Object object = this.getSecurityModuleAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.attributes != null && (v = this.attributes.get(string)) != null && v instanceof byte[]) {
            return this.deserializeAttribute(string, (byte[])v);
        }
        return this.getAttributeInternal(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object deserializeAttribute(String string, byte[] byArray) {
        Object object;
        Chunk chunk;
        block9: {
            chunk = null;
            ChunkedObjectInputStream chunkedObjectInputStream = null;
            try {
                try {
                    chunk = Chunk.getChunk();
                    Chunk.chunkFully((Chunk)chunk, (InputStream)new UnsyncByteArrayInputStream(byArray));
                    chunkedObjectInputStream = new ChunkedObjectInputStream(chunk, 0);
                    chunkedObjectInputStream.setReplacer(RemoteObjectReplacer.getReplacer());
                    Object object2 = chunkedObjectInputStream.readObject();
                    object2 = this.checkEJBAttribute(object2);
                    SessionData.AttributeInfo attributeInfo = this.validateAttributeValue(string, object2);
                    AttributeWrapper attributeWrapper = new AttributeWrapper(object2);
                    if (attributeInfo != null) {
                        attributeWrapper.setCheckSum(attributeInfo.checksum);
                        attributeWrapper.setPreviousChecksum(attributeInfo.oldChecksum);
                    }
                    this.attributes.put(string, attributeWrapper);
                    object = object2;
                    Object var10_10 = null;
                    if (chunkedObjectInputStream == null) break block9;
                }
                catch (Exception exception) {
                    if (this.isDebugEnabled()) {
                        DEBUG_SESSIONS.debug("Unable to deserialize attribute value for key: " + string, (Throwable)exception);
                    }
                    Object var10_11 = null;
                    if (chunkedObjectInputStream != null) {
                        chunkedObjectInputStream.close();
                        return null;
                    }
                    if (chunk == null) return null;
                    Chunk.releaseChunks((Chunk)chunk);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (chunkedObjectInputStream != null) {
                    chunkedObjectInputStream.close();
                    throw throwable;
                }
                if (chunk == null) throw throwable;
                Chunk.releaseChunks((Chunk)chunk);
                throw throwable;
            }
            chunkedObjectInputStream.close();
            return object;
        }
        if (chunk == null) return object;
        Chunk.releaseChunks((Chunk)chunk);
        return object;
    }
}

