/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.PrintStream;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServletSessionRuntimeMBean;
import weblogic.servlet.internal.session.ServletSessionRuntimeManager;
import weblogic.servlet.internal.session.SessionData;

public final class ServletSessionRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ServletSessionRuntimeMBean {
    private static final long serialVersionUID = -1298228652729291451L;
    private SessionData session;
    public static final String TYPE = "ServletSessionRuntime";

    public ServletSessionRuntimeMBeanImpl(SessionData sessionData) throws ManagementException {
        super(ServletSessionRuntimeManager.getSessionKey(sessionData), (RuntimeMBean)sessionData.getWebAppServletContext().getRuntimeMBean());
        this.session = sessionData;
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public long getTimeLastAccessed() {
        return this.session.getLAT();
    }

    public long getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public String getMainAttribute() {
        return this.session.getMainAttributeValue();
    }

    public static void dumpSession(PrintStream printStream, ServletSessionRuntimeMBean servletSessionRuntimeMBean) {
        ServletSessionRuntimeMBeanImpl.println(printStream, "    SESSION NAME: " + servletSessionRuntimeMBean.getName());
        ServletSessionRuntimeMBeanImpl.println(printStream, "        TimeLastAccessed: " + servletSessionRuntimeMBean.getTimeLastAccessed());
        ServletSessionRuntimeMBeanImpl.println(printStream, "        MainAttribute: " + servletSessionRuntimeMBean.getMainAttribute());
    }

    private static void println(PrintStream printStream, String string) {
        printStream.println(string + "<br>");
    }
}

