/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ServletSessionRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.ServletSessionRuntimeMBeanImpl;
import weblogic.servlet.internal.session.SessionConstants;
import weblogic.servlet.internal.session.SessionData;

final class ServletSessionRuntimeManager
implements SessionConstants {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Map runtimesBySessionKey = Collections.synchronizedMap(new HashMap(128));

    static final ServletSessionRuntimeManager getInstance() {
        return SINGLETON.instance;
    }

    private ServletSessionRuntimeManager() {
    }

    static String getSessionKey(SessionData sessionData) {
        return sessionData.id + "!" + sessionData.creationTime;
    }

    private ServletSessionRuntimeMBean find(SessionData sessionData) {
        return (ServletSessionRuntimeMBean)this.runtimesBySessionKey.get(ServletSessionRuntimeManager.getSessionKey(sessionData));
    }

    ServletSessionRuntimeMBean findOrCreate(SessionData sessionData) {
        ServletSessionRuntimeMBean servletSessionRuntimeMBean = this.find(sessionData);
        if (servletSessionRuntimeMBean != null) {
            return servletSessionRuntimeMBean;
        }
        return this.create(sessionData);
    }

    private synchronized ServletSessionRuntimeMBean create(SessionData sessionData) {
        ServletSessionRuntimeMBean servletSessionRuntimeMBean = this.find(sessionData);
        if (servletSessionRuntimeMBean != null) {
            return servletSessionRuntimeMBean;
        }
        servletSessionRuntimeMBean = (ServletSessionRuntimeMBean)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new CreateAction(sessionData));
        if (servletSessionRuntimeMBean != null) {
            this.runtimesBySessionKey.put(ServletSessionRuntimeManager.getSessionKey(sessionData), servletSessionRuntimeMBean);
        }
        return servletSessionRuntimeMBean;
    }

    void destroy(SessionData sessionData) {
        SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new DestroyAction(sessionData));
    }

    private class DestroyAction
    implements PrivilegedAction {
        SessionData session;

        DestroyAction(SessionData sessionData) {
            this.session = sessionData;
        }

        public Object run() {
            String string = ServletSessionRuntimeManager.getSessionKey(this.session);
            try {
                ServletSessionRuntimeMBeanImpl servletSessionRuntimeMBeanImpl = (ServletSessionRuntimeMBeanImpl)ServletSessionRuntimeManager.this.runtimesBySessionKey.remove(string);
                if (servletSessionRuntimeMBeanImpl == null) {
                    return null;
                }
                servletSessionRuntimeMBeanImpl.unregister();
            }
            catch (ManagementException managementException) {
                String string2 = string + " was not properly unregistered.";
                HTTPSessionLogger.logErrorUnregisteringServletSessionRuntime((String)string2, null);
            }
            return null;
        }
    }

    private class CreateAction
    implements PrivilegedAction {
        SessionData session;

        CreateAction(SessionData sessionData) {
            this.session = sessionData;
        }

        public Object run() {
            try {
                return new ServletSessionRuntimeMBeanImpl(this.session);
            }
            catch (ManagementException managementException) {
                HTTPSessionLogger.logErrorCreatingServletSessionRuntimeMBean((Throwable)managementException);
                return null;
            }
        }
    }

    private static class SINGLETON {
        static ServletSessionRuntimeManager instance = new ServletSessionRuntimeManager();

        private SINGLETON() {
        }
    }
}

