/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.util.ArrayList;
import java.util.HashMap;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.SessionConfigBean;
import weblogic.j2ee.descriptor.wl.ContainerDescriptorBean;
import weblogic.j2ee.descriptor.wl.SessionDescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebComponentBeanUpdateListener;
import weblogic.servlet.internal.session.SessionConstants;

public final class SessionConfigManager
implements SessionConstants {
    private final WebAppModule module;
    private final WebAppServletContext servletContext;
    private String persistentStoreType = "memory";
    private String sessionPersistentStoreDir = "session_db";
    private String sessionPersistentStoreTable = "wl_servlet_sessions";
    private String maxInactiveIntervalColumnName = "wl_max_inactive_interval";
    private String cookieName = "JSESSIONID";
    private String cookiePath = "/";
    private String cookiePersistentStoreCookieName = "WLCOOKIE";
    private int jdbcConnectionTimeoutSecs = 120;
    private int idLength = 52;
    private String sessionPersistentStorePool;
    private String sessionPersistentDataSourceJNDIName;
    private int sessionPersistentFlushInterval;
    private int sessionPersistentFlushThreshold;
    private int sessionPersistentQueueTimeout;
    private String cookieDomain;
    private String cookieComment;
    private boolean sessionTrackingEnabled = true;
    private boolean sessionCookiesEnabled = true;
    private boolean urlRewritingEnabled = true;
    private boolean cacheSessionCookieEnabled = true;
    private boolean sessionSharingEnabled;
    private boolean invalidateOnRelogin = false;
    private boolean encodeSessionIdInQueryParamsEnabled;
    private boolean cookieSecure;
    private boolean cookieHttpOnly = true;
    private boolean cleanupSessionFilesEnabled;
    private boolean saveSessionsOnRedeploy;
    private boolean debugEnabled = false;
    private int cookieMaxAgeSecs = -1;
    private int sessionTimeoutSecs = 3600;
    private boolean isTimeoutSecsSet = false;
    private int maxInMemorySessions = -1;
    private int cacheSize = 1024;
    private String monitoringAttributeName = null;
    private int invalidationIntervalSecs = 60;
    private final BeanUpdateListener sessionBeanListener;
    private String wlsAuthCookieName = "_WL_AUTHCOOKIE_JSESSIONID";
    public static final HashMap SESSION_ELEMENTS_MAP = new HashMap();

    SessionConfigManager(SessionDescriptorBean sessionDescriptorBean, WebAppServletContext webAppServletContext) {
        this.servletContext = webAppServletContext;
        this.module = webAppServletContext.getWebAppModule();
        this.initWithSessionConfigBean();
        this.initWithSessionDescriptorBean(sessionDescriptorBean);
        this.sessionBeanListener = this.createBeanUpdateListener();
    }

    public String getPersistentStoreDir() {
        return this.sessionPersistentStoreDir;
    }

    public void setPersistentStoreDir(String string) {
        this.sessionPersistentStoreDir = string;
    }

    public int getJDBCConnectionTimeoutSecs() {
        return this.jdbcConnectionTimeoutSecs;
    }

    public void setJDBCConnectionTimeoutSecs(int n) {
        this.jdbcConnectionTimeoutSecs = n;
    }

    public String getPersistentStorePool() {
        return this.sessionPersistentStorePool;
    }

    public void setPersistentStorePool(String string) {
        this.sessionPersistentStorePool = string;
    }

    public String getPersistentDataSourceJNDIName() {
        return this.sessionPersistentDataSourceJNDIName;
    }

    public void setPersistentDataSourceJNDIName(String string) {
        this.sessionPersistentDataSourceJNDIName = string;
    }

    public int getPersistentSessionFlushInterval() {
        return this.sessionPersistentFlushInterval;
    }

    public void setPersistentSessionFlushInterval(int n) {
        this.sessionPersistentFlushInterval = n;
    }

    public int getPersistentAsyncQueueTimeout() {
        return this.sessionPersistentQueueTimeout;
    }

    public void setPersistentAsyncQueueTimeout(int n) {
        this.sessionPersistentQueueTimeout = n;
    }

    public int getPersistentSessionFlushThreshold() {
        return this.sessionPersistentFlushThreshold;
    }

    public void setPersistentSessionFlushThreshold(int n) {
        this.sessionPersistentFlushThreshold = n;
    }

    public String getPersistentStoreTable() {
        return this.sessionPersistentStoreTable;
    }

    public void setPersistentStoreTable(String string) {
        this.sessionPersistentStoreTable = string;
    }

    public String getMaxInactiveIntervalColumnName() {
        return this.maxInactiveIntervalColumnName;
    }

    public void setMaxInactiveIntervalColumnName(String string) {
        this.maxInactiveIntervalColumnName = string;
    }

    public boolean isCleanupSessionFilesEnabled() {
        return this.cleanupSessionFilesEnabled;
    }

    public void setCleanupSessionFilesEnabled(boolean bl) {
        this.cleanupSessionFilesEnabled = bl;
    }

    public boolean isSaveSessionsOnRedeployEnabled() {
        return this.saveSessionsOnRedeploy;
    }

    public void setSaveSessionsOnRedeployEnabled(boolean bl) {
        this.saveSessionsOnRedeploy = bl;
    }

    boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void setCookieSecure(boolean bl) {
        this.cookieSecure = bl;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void setCookieHttpOnly(boolean bl) {
        this.cookieHttpOnly = bl;
    }

    public String getCookieComment() {
        return this.cookieComment;
    }

    public void setCookieComment(String string) {
        this.cookieComment = string;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String string) {
        if (string == null) {
            string = "JSESSIONID";
        }
        this.cookieName = string;
    }

    public String getWLSAuthCookieName() {
        return this.wlsAuthCookieName;
    }

    public String getCookiePersistentStoreCookieName() {
        return this.cookiePersistentStoreCookieName;
    }

    public void setCookiePersistentStoreCookieName(String string) {
        if (string == null) {
            string = "WLCOOKIE";
        }
        this.cookiePersistentStoreCookieName = string;
    }

    public int getCookieMaxAgeSecs() {
        return this.cookieMaxAgeSecs;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String string) {
        this.cookieDomain = string;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String string) {
        if (string == null) {
            string = "/";
        }
        this.cookiePath = string;
    }

    public int getSessionTimeoutSecs() {
        return this.sessionTimeoutSecs;
    }

    public int getMaxInMemorySessions() {
        return this.maxInMemorySessions;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getIDLength() {
        return this.idLength;
    }

    public void setIDLength(int n) {
        this.idLength = n;
    }

    String getMonitoringAttributeName() {
        return this.monitoringAttributeName;
    }

    public boolean isMonitoringEnabled() {
        if (this.module != null && this.module.getWlWebAppBean() != null) {
            WeblogicWebAppBean weblogicWebAppBean = this.module.getWlWebAppBean();
            ContainerDescriptorBean containerDescriptorBean = (ContainerDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getContainerDescriptors(), "ContainerDescriptor");
            return containerDescriptorBean.isSessionMonitoringEnabled();
        }
        return false;
    }

    public boolean isUrlRewritingEnabled() {
        return this.urlRewritingEnabled;
    }

    public void setUrlRewritingEnabled(boolean bl) {
        this.urlRewritingEnabled = bl;
    }

    public boolean isEncodeSessionIdInQueryParamsEnabled() {
        return this.encodeSessionIdInQueryParamsEnabled;
    }

    public boolean isCacheSessionCookieEnabled() {
        return this.cacheSessionCookieEnabled;
    }

    public boolean isSessionTrackingEnabled() {
        return this.sessionTrackingEnabled;
    }

    public boolean isSessionCookiesEnabled() {
        return this.sessionCookiesEnabled;
    }

    public boolean isSessionSharingEnabled() {
        return this.sessionSharingEnabled;
    }

    public boolean isInvalidateOnRelogin() {
        return this.invalidateOnRelogin;
    }

    public int getInvalidationIntervalSecs() {
        return this.invalidationIntervalSecs;
    }

    public String getPersistentStoreType() {
        return this.persistentStoreType;
    }

    public boolean isSamePersistentStore(SessionConfigManager sessionConfigManager) {
        if (sessionConfigManager == null) {
            return false;
        }
        if (!this.persistentStoreType.equals(sessionConfigManager.getPersistentStoreType())) {
            return false;
        }
        if (this.persistentStoreType.equals("file")) {
            return this.sessionPersistentStoreDir.equals(sessionConfigManager.sessionPersistentStoreDir);
        }
        if (this.persistentStoreType.equals("jdbc")) {
            return this.sessionPersistentStorePool.equals(sessionConfigManager.sessionPersistentStorePool) && this.sessionPersistentStoreTable.equals(sessionConfigManager.sessionPersistentStoreTable);
        }
        return true;
    }

    public BeanUpdateListener getBeanUpdateListener() {
        return this.sessionBeanListener;
    }

    private void initWithSessionConfigBean() {
        SessionConfigBean[] sessionConfigBeanArray = null;
        if (this.module != null && this.module.getWebAppBean() != null) {
            sessionConfigBeanArray = this.module.getWebAppBean().getSessionConfigs();
        }
        if (sessionConfigBeanArray != null && sessionConfigBeanArray.length > 0) {
            int n = sessionConfigBeanArray[0].getSessionTimeout();
            if (n == 0) {
                n = -1;
            }
            if (n != 60) {
                this.sessionTimeoutSecs = n * 60;
                this.isTimeoutSecsSet = true;
            }
        }
    }

    private void initWithSessionDescriptorBean(SessionDescriptorBean sessionDescriptorBean) {
        WeblogicWebAppBean weblogicWebAppBean;
        SessionDescriptorBean[] sessionDescriptorBeanArray;
        if (sessionDescriptorBean == null) {
            return;
        }
        this.sessionCookiesEnabled = sessionDescriptorBean.isCookiesEnabled();
        this.urlRewritingEnabled = sessionDescriptorBean.isUrlRewritingEnabled();
        this.encodeSessionIdInQueryParamsEnabled = sessionDescriptorBean.isEncodeSessionIdInQueryParams();
        this.sessionTrackingEnabled = sessionDescriptorBean.isTrackingEnabled();
        this.cacheSessionCookieEnabled = sessionDescriptorBean.isHttpProxyCachingOfCookies();
        this.idLength = sessionDescriptorBean.getIdLength();
        this.cookieComment = sessionDescriptorBean.getCookieComment();
        this.cookieDomain = sessionDescriptorBean.getCookieDomain();
        this.cookieName = sessionDescriptorBean.getCookieName();
        this.cookiePath = sessionDescriptorBean.getCookiePath();
        this.jdbcConnectionTimeoutSecs = sessionDescriptorBean.getJdbcConnectionTimeoutSecs();
        this.cookiePersistentStoreCookieName = sessionDescriptorBean.getPersistentStoreCookieName();
        this.sessionPersistentDataSourceJNDIName = sessionDescriptorBean.getPersistentDataSourceJNDIName();
        this.sessionPersistentFlushInterval = sessionDescriptorBean.getPersistentSessionFlushInterval();
        this.sessionPersistentFlushThreshold = sessionDescriptorBean.getPersistentSessionFlushThreshold();
        this.sessionPersistentQueueTimeout = sessionDescriptorBean.getPersistentAsyncQueueTimeout();
        this.sessionPersistentStoreDir = sessionDescriptorBean.getPersistentStoreDir();
        this.sessionPersistentStorePool = sessionDescriptorBean.getPersistentStorePool();
        this.sessionPersistentStoreTable = sessionDescriptorBean.getPersistentStoreTable();
        this.maxInactiveIntervalColumnName = sessionDescriptorBean.getJdbcColumnNameMaxInactiveInterval();
        this.cookieSecure = sessionDescriptorBean.isCookieSecure();
        this.cookieHttpOnly = sessionDescriptorBean.isCookieHttpOnly();
        this.persistentStoreType = sessionDescriptorBean.getPersistentStoreType();
        this.sessionSharingEnabled = sessionDescriptorBean.isSharingEnabled();
        this.invalidateOnRelogin = sessionDescriptorBean.isInvalidateOnRelogin();
        if (this.module != null && this.module.getWlWebAppBean() != null && (sessionDescriptorBeanArray = (weblogicWebAppBean = this.module.getWlWebAppBean()).getSessionDescriptors()) != null && sessionDescriptorBeanArray.length > 0) {
            sessionDescriptorBean = sessionDescriptorBeanArray[0];
        }
        this.debugEnabled = sessionDescriptorBean.isDebugEnabled();
        this.cookieMaxAgeSecs = sessionDescriptorBean.getCookieMaxAgeSecs();
        if (!this.isTimeoutSecsSet) {
            this.sessionTimeoutSecs = sessionDescriptorBean.getTimeoutSecs();
        }
        this.maxInMemorySessions = sessionDescriptorBean.getMaxInMemorySessions();
        this.cacheSize = sessionDescriptorBean.getCacheSize();
        this.monitoringAttributeName = sessionDescriptorBean.getMonitoringAttributeName();
        this.invalidationIntervalSecs = sessionDescriptorBean.getInvalidationIntervalSecs();
        if (sessionDescriptorBean.getCookiePath() != null && !"/".equals(sessionDescriptorBean.getCookiePath())) {
            this.cookiePath = sessionDescriptorBean.getCookiePath();
        }
        if (this.cookieName != null) {
            this.wlsAuthCookieName = "_WL_AUTHCOOKIE_" + this.cookieName;
        }
    }

    private BeanUpdateListener createBeanUpdateListener() {
        return new WebComponentBeanUpdateListener(){

            protected void handlePropertyRemove(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                String string = propertyUpdate.getPropertyName();
                if ("InvalidationIntervalSecs".equals(string)) {
                    SessionConfigManager.this.invalidationIntervalSecs = 60;
                    SessionConfigManager.this.servletContext.getSessionContext().setInvalidationIntervalSecs(60);
                } else if ("DebugEnabled".equals(string)) {
                    SessionConfigManager.this.debugEnabled = false;
                } else if ("CookieMaxAgeSecs".equals(string)) {
                    SessionConfigManager.this.cookieMaxAgeSecs = -1;
                } else if ("TimeoutSecs".equals(string) && !SessionConfigManager.this.isTimeoutSecsSet) {
                    SessionConfigManager.this.sessionTimeoutSecs = 3600;
                } else if ("MaxInMemorySessions".equals(string)) {
                    SessionConfigManager.this.maxInMemorySessions = -1;
                } else if ("CacheSize".equals(string)) {
                    SessionConfigManager.this.cacheSize = 1024;
                } else if ("MonitoringAttributeName".equals(string)) {
                    SessionConfigManager.this.monitoringAttributeName = null;
                }
            }

            protected void handlePropertyChange(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
                SessionDescriptorBean sessionDescriptorBean = (SessionDescriptorBean)descriptorBean;
                String string = propertyUpdate.getPropertyName();
                if ("InvalidationIntervalSecs".equals(string)) {
                    SessionConfigManager.this.invalidationIntervalSecs = sessionDescriptorBean.getInvalidationIntervalSecs();
                    SessionConfigManager.this.servletContext.getSessionContext().setInvalidationIntervalSecs(sessionDescriptorBean.getInvalidationIntervalSecs());
                } else if ("DebugEnabled".equals(string)) {
                    SessionConfigManager.this.debugEnabled = sessionDescriptorBean.isDebugEnabled();
                } else if ("CookieMaxAgeSecs".equals(string)) {
                    SessionConfigManager.this.cookieMaxAgeSecs = sessionDescriptorBean.getCookieMaxAgeSecs();
                } else if ("TimeoutSecs".equals(string) && !SessionConfigManager.this.isTimeoutSecsSet) {
                    SessionConfigManager.this.sessionTimeoutSecs = sessionDescriptorBean.getTimeoutSecs();
                } else if ("MaxInMemorySessions".equals(string)) {
                    SessionConfigManager.this.maxInMemorySessions = sessionDescriptorBean.getMaxInMemorySessions();
                } else if ("CacheSize".equals(string)) {
                    SessionConfigManager.this.cacheSize = sessionDescriptorBean.getCacheSize();
                } else if ("MonitoringAttributeName".equals(string)) {
                    SessionConfigManager.this.monitoringAttributeName = sessionDescriptorBean.getMonitoringAttributeName();
                }
            }

            protected void handleBeanAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) {
                if (!(descriptorBean instanceof SessionDescriptorBean) || propertyUpdate == null || !"SessionDescriptors".equals(propertyUpdate.getPropertyName())) {
                    return;
                }
                SessionDescriptorBean sessionDescriptorBean = (SessionDescriptorBean)descriptorBean;
                ((DescriptorBean)sessionDescriptorBean).addBeanUpdateListener((BeanUpdateListener)this);
                if (!SessionConfigManager.this.isTimeoutSecsSet) {
                    SessionConfigManager.this.sessionTimeoutSecs = sessionDescriptorBean.getTimeoutSecs();
                    SessionConfigManager.this.isTimeoutSecsSet = true;
                }
                SessionConfigManager.this.invalidationIntervalSecs = sessionDescriptorBean.getInvalidationIntervalSecs();
                SessionConfigManager.this.servletContext.getSessionContext().setInvalidationIntervalSecs(SessionConfigManager.this.invalidationIntervalSecs);
                SessionConfigManager.this.debugEnabled = sessionDescriptorBean.isDebugEnabled();
                SessionConfigManager.this.maxInMemorySessions = sessionDescriptorBean.getMaxInMemorySessions();
                SessionConfigManager.this.cookieMaxAgeSecs = sessionDescriptorBean.getCookieMaxAgeSecs();
                SessionConfigManager.this.monitoringAttributeName = sessionDescriptorBean.getMonitoringAttributeName();
            }

            protected void handleBeanRemove(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                if (propertyUpdate == null || !"SessionDescriptors".equals(propertyUpdate.getPropertyName()) || !(propertyUpdate.getRemovedObject() instanceof SessionDescriptorBean)) {
                    return;
                }
                SessionDescriptorBean sessionDescriptorBean = (SessionDescriptorBean)propertyUpdate.getRemovedObject();
                ((DescriptorBean)sessionDescriptorBean).removeBeanUpdateListener((BeanUpdateListener)this);
                if (!SessionConfigManager.this.isTimeoutSecsSet) {
                    SessionConfigManager.this.sessionTimeoutSecs = 3600;
                    SessionConfigManager.this.isTimeoutSecsSet = true;
                }
                SessionConfigManager.this.invalidationIntervalSecs = 60;
                SessionConfigManager.this.servletContext.getSessionContext().setInvalidationIntervalSecs(SessionConfigManager.this.invalidationIntervalSecs);
                SessionConfigManager.this.debugEnabled = false;
                SessionConfigManager.this.maxInMemorySessions = -1;
                SessionConfigManager.this.cookieMaxAgeSecs = -1;
                SessionConfigManager.this.monitoringAttributeName = null;
            }

            protected void prepareBeanAdd(BeanUpdateEvent.PropertyUpdate propertyUpdate, DescriptorBean descriptorBean) throws BeanUpdateRejectedException {
                if (!(descriptorBean instanceof SessionDescriptorBean)) {
                    return;
                }
                SessionDescriptorBean sessionDescriptorBean = (SessionDescriptorBean)descriptorBean;
                SessionDescriptorBean sessionDescriptorBean2 = (SessionDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(SessionConfigManager.this.module.getWlWebAppBean(), SessionConfigManager.this.module.getWlWebAppBean().getSessionDescriptors(), "SessionDescriptor");
                ArrayList<String> arrayList = new ArrayList<String>();
                1.computeChange("id-length", sessionDescriptorBean.getIdLength(), sessionDescriptorBean2.getIdLength(), arrayList);
                1.computeChange("tracking-enabled", sessionDescriptorBean.isTrackingEnabled(), sessionDescriptorBean2.isTrackingEnabled(), arrayList);
                1.computeChange("cache-size", sessionDescriptorBean.getCacheSize(), sessionDescriptorBean2.getCacheSize(), arrayList);
                1.computeChange("max-in-memory-sessions", sessionDescriptorBean.getMaxInMemorySessions(), sessionDescriptorBean2.getMaxInMemorySessions(), arrayList);
                1.computeChange("cookies-enabled", sessionDescriptorBean.isCookiesEnabled(), sessionDescriptorBean2.isCookiesEnabled(), arrayList);
                1.computeChange("cookie-name", sessionDescriptorBean.getCookieName(), sessionDescriptorBean2.getCookieName(), arrayList);
                1.computeChange("cookie-path", sessionDescriptorBean.getCookiePath(), sessionDescriptorBean2.getCookiePath(), arrayList);
                1.computeChange("cookie-domain", sessionDescriptorBean.getCookieDomain(), sessionDescriptorBean2.getCookieDomain(), arrayList);
                1.computeChange("cookie-comment", sessionDescriptorBean.getCookieComment(), sessionDescriptorBean2.getCookieComment(), arrayList);
                1.computeChange("cookie-secure", sessionDescriptorBean.isCookieSecure(), sessionDescriptorBean2.isCookieSecure(), arrayList);
                1.computeChange("persistent-store-type", sessionDescriptorBean.getPersistentStoreType(), sessionDescriptorBean2.getPersistentStoreType(), arrayList);
                1.computeChange("persistent-store-cookie-name", sessionDescriptorBean.getPersistentStoreCookieName(), sessionDescriptorBean2.getPersistentStoreCookieName(), arrayList);
                1.computeChange("persistent-store-dir", sessionDescriptorBean.getPersistentStoreDir(), sessionDescriptorBean2.getPersistentStoreDir(), arrayList);
                1.computeChange("persistent-store-pool", sessionDescriptorBean.getPersistentStorePool(), sessionDescriptorBean2.getPersistentStorePool(), arrayList);
                1.computeChange("persistent-data-source-jndi-name", sessionDescriptorBean.getPersistentDataSourceJNDIName(), sessionDescriptorBean2.getPersistentDataSourceJNDIName(), arrayList);
                1.computeChange("persistent-session-flush-interval", sessionDescriptorBean.getPersistentSessionFlushInterval(), sessionDescriptorBean2.getPersistentSessionFlushInterval(), arrayList);
                1.computeChange("persistent-session-flush-threshold", sessionDescriptorBean.getPersistentSessionFlushThreshold(), sessionDescriptorBean2.getPersistentSessionFlushThreshold(), arrayList);
                1.computeChange("persistent-async-queue-timeout", sessionDescriptorBean.getPersistentAsyncQueueTimeout(), sessionDescriptorBean2.getPersistentAsyncQueueTimeout(), arrayList);
                1.computeChange("persistent-store-table", sessionDescriptorBean.getPersistentStoreTable(), sessionDescriptorBean2.getPersistentStoreTable(), arrayList);
                1.computeChange("jdbc-column-name-max-inactive-interval", sessionDescriptorBean.getJdbcColumnNameMaxInactiveInterval(), sessionDescriptorBean2.getJdbcColumnNameMaxInactiveInterval(), arrayList);
                1.computeChange("jdbc-connection-timeout-secs", sessionDescriptorBean.getJdbcConnectionTimeoutSecs(), sessionDescriptorBean2.getJdbcConnectionTimeoutSecs(), arrayList);
                1.computeChange("url-rewriting-enabled", sessionDescriptorBean.isUrlRewritingEnabled(), sessionDescriptorBean2.isUrlRewritingEnabled(), arrayList);
                1.computeChange("http-proxy-caching-of-cookies", sessionDescriptorBean.isHttpProxyCachingOfCookies(), sessionDescriptorBean2.isHttpProxyCachingOfCookies(), arrayList);
                1.computeChange("encode-session-id-in-query-params", sessionDescriptorBean.isEncodeSessionIdInQueryParams(), sessionDescriptorBean2.isEncodeSessionIdInQueryParams(), arrayList);
                1.computeChange("sharing-enabled", sessionDescriptorBean.isSharingEnabled(), sessionDescriptorBean2.isSharingEnabled(), arrayList);
                1.computeChange("cookie-http-only", sessionDescriptorBean.isCookieHttpOnly(), sessionDescriptorBean2.isCookieHttpOnly(), arrayList);
                if (!arrayList.isEmpty()) {
                    throw new BeanUpdateRejectedException("Non-Dynamic property in \"session-descriptor\" is/are specified in deployment plan: '" + 1.getChangedPropertyNames(arrayList) + "'");
                }
            }
        };
    }

    static {
        SESSION_ELEMENTS_MAP.put("PersistentStoreType".toLowerCase(), "persistent-store-type");
        SESSION_ELEMENTS_MAP.put("CookiesEnabled".toLowerCase(), "cookies-enabled");
        SESSION_ELEMENTS_MAP.put("URLRewritingEnabled".toLowerCase(), "url-rewriting-enabled");
        SESSION_ELEMENTS_MAP.put("EncodeSessionIdInQueryParams".toLowerCase(), "encode-session-id-in-query-params");
        SESSION_ELEMENTS_MAP.put("TrackingEnabled".toLowerCase(), "tracking-enabled");
        SESSION_ELEMENTS_MAP.put("CacheSessionCookie".toLowerCase(), "http-proxy-caching-of-cookies");
        SESSION_ELEMENTS_MAP.put("IDLength".toLowerCase(), "id-length");
        SESSION_ELEMENTS_MAP.put("CookieComment".toLowerCase(), "cookie-comment");
        SESSION_ELEMENTS_MAP.put("CookieDomain".toLowerCase(), "cookie-domain");
        SESSION_ELEMENTS_MAP.put("CookieMaxAgeSecs".toLowerCase(), "cookie-max-age-secs");
        SESSION_ELEMENTS_MAP.put("CookieName".toLowerCase(), "cookie-name");
        SESSION_ELEMENTS_MAP.put("CookiePath".toLowerCase(), "cookie-path");
        SESSION_ELEMENTS_MAP.put("InvalidationIntervalSecs".toLowerCase(), "invalidation-interval-secs");
        SESSION_ELEMENTS_MAP.put("PersistentStoreCookieName".toLowerCase(), "persistent-store-cookie-name");
        SESSION_ELEMENTS_MAP.put("PersistentStoreDir".toLowerCase(), "persistent-store-dir");
        SESSION_ELEMENTS_MAP.put("PersistentStorePool".toLowerCase(), "persistent-store-pool");
        SESSION_ELEMENTS_MAP.put("PersistentStoreTable".toLowerCase(), "persistent-store-table");
        SESSION_ELEMENTS_MAP.put("SessionDebuggable".toLowerCase(), "debug-enabled");
        SESSION_ELEMENTS_MAP.put("ConsoleMainAttribute".toLowerCase(), "monitoring-attribute-name");
        SESSION_ELEMENTS_MAP.put("TimeoutSecs".toLowerCase(), "timeout-secs");
        SESSION_ELEMENTS_MAP.put("CookieSecure".toLowerCase(), "cookie-secure");
        SESSION_ELEMENTS_MAP.put("JDBCColumnName_MaxInactiveInterval".toLowerCase(), "jdbc-column-name-max-inactive-interval");
        SESSION_ELEMENTS_MAP.put("CacheSize".toLowerCase(), "cache-size");
        SESSION_ELEMENTS_MAP.put("JDBCConnectionTimeoutSecs".toLowerCase(), "jdbc-connection-timeout-secs");
        SESSION_ELEMENTS_MAP.put("SharingEnabled".toLowerCase(), "sharing-enabled");
        SESSION_ELEMENTS_MAP.put("PersistentDataSourceJNDIName".toLowerCase(), "persistent-data-source-jndi-name");
        SESSION_ELEMENTS_MAP.put("PersistentSessionFlushInterval".toLowerCase(), "persistent-session-flush-interval");
        SESSION_ELEMENTS_MAP.put("PersistentSessionFlushThreshold".toLowerCase(), "persistent-session-flush-threshold");
        SESSION_ELEMENTS_MAP.put("PersistentAsyncQueueTimeout".toLowerCase(), "persistent-async-queue-timeout");
    }
}

