/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.health.HealthState;
import weblogic.j2ee.descriptor.wl.SessionDescriptorBean;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.ServletSessionRuntimeMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.SessionCreationException;
import weblogic.servlet.internal.ContextVersionManager;
import weblogic.servlet.internal.NakedTimerListenerBase;
import weblogic.servlet.internal.ServletContextManager;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.AsyncJDBCSessionContext;
import weblogic.servlet.internal.session.AsyncReplicatedSessionContext;
import weblogic.servlet.internal.session.CookieSessionContext;
import weblogic.servlet.internal.session.FileSessionContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.JDBCSessionContext;
import weblogic.servlet.internal.session.MANAsyncReplicatedSessionContext;
import weblogic.servlet.internal.session.MANReplicatedSessionContext;
import weblogic.servlet.internal.session.MemorySessionContext;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionConstants;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.internal.session.SessionInfo;
import weblogic.servlet.internal.session.SharedSessionData;
import weblogic.servlet.internal.session.TargetValidator;
import weblogic.servlet.internal.session.WANAsyncSessionContext;
import weblogic.servlet.internal.session.WANSessionContext;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public abstract class SessionContext
implements HttpSessionContext,
SessionConstants {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean DEBUG = false;
    protected final WebAppServletContext servletContext;
    private final ServerRuntimeMBean serverRuntime;
    private final Hashtable openSessions = new Hashtable();
    protected final Hashtable transientData = new Hashtable();
    protected final SessionConfigManager configMgr;
    private static final ClusterMBean cluster = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getCluster();
    private int curOpenSessions = 0;
    private int totalOpenSessions = 0;
    private int maxOpenSessions = 0;
    private SessionInvalidator invalidator = null;
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");
    protected static final DebugLogger DEBUG_SESSIONS = DebugLogger.getDebugLogger((String)"DebugHttpSessions");
    protected static final String COHERENECE_WEB_SESSIONS = "coherence-web-sessions-enabled";
    private static final String COMPONENT = "In-memory Replication - Servlet";
    private static final ServerIdentity currentClusterMember = LocalServerIdentity.getIdentity();

    protected SessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        this.configMgr = sessionConfigManager;
        this.servletContext = webAppServletContext;
        this.serverRuntime = ManagementService.getRuntimeAccess(KERNEL_ID).getServerRuntime();
    }

    public void startTimers() {
        this.initializeInvalidator();
    }

    protected void checkSessionCount() {
        if (this.isServerOverloaded()) {
            throw new SessionCreationException("The server is running low on memory, cannot create new sessions");
        }
        if (this.configMgr.getMaxInMemorySessions() > -1 && this.getOpenSessions().size() >= this.configMgr.getMaxInMemorySessions()) {
            throw new SessionCreationException("Cannot create new sessions as the MaxInMemorySessions limit (" + this.configMgr.getMaxInMemorySessions() + ") has been exceeded");
        }
    }

    private boolean isServerOverloaded() {
        HealthState healthState = this.serverRuntime.getHealthState();
        if (healthState.getState() != 4 || healthState.getReasonCode().length < 1) {
            return false;
        }
        for (int i = 0; i < healthState.getReasonCode().length; ++i) {
            if (healthState.getReasonCode()[i] != "server is low on memory") continue;
            return true;
        }
        return false;
    }

    protected boolean isDebugEnabled() {
        return DEBUG_SESSIONS.isDebugEnabled() || this.getConfigMgr() != null && this.getConfigMgr().isDebugEnabled();
    }

    protected void initializeInvalidator() {
        this.invalidator = new SessionInvalidator();
    }

    public Hashtable getSessionsMap() {
        return this.openSessions;
    }

    public void setSessionsMap(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.openSessions.putAll(hashtable);
    }

    public void initialize(WebAppServletContext webAppServletContext) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final synchronized SessionContext getInstance(WebAppServletContext webAppServletContext, SessionDescriptorBean sessionDescriptorBean) throws DeploymentException {
        Object object;
        SessionConfigManager sessionConfigManager = new SessionConfigManager(sessionDescriptorBean, webAppServletContext);
        if (webAppServletContext != null && webAppServletContext.getVersionId() != null && webAppServletContext.getContextManager() != null && (object = webAppServletContext.getContextManager().getContext(webAppServletContext.isAdminMode())) != null && ((WebAppServletContext)object).getVersionId() != null && !sessionConfigManager.isSamePersistentStore(((WebAppServletContext)object).getSessionContext().getConfigMgr())) {
            Loggable loggable = HTTPSessionLogger.logIncompatiblePersistentStoreLoggable((String)webAppServletContext.getAppDisplayName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        object = null;
        if ("true".equalsIgnoreCase(webAppServletContext.getInitParameter(COHERENECE_WEB_SESSIONS)) || webAppServletContext.getApplicationContext() != null && "true".equalsIgnoreCase(webAppServletContext.getApplicationContext().getApplicationParameter(COHERENECE_WEB_SESSIONS))) {
            try {
                Class<?> clazz = webAppServletContext.getServletClassLoader().loadClass("weblogic.servlet.internal.session.CoherenceWebSessionContextImpl");
                Class[] classArray = new Class[]{webAppServletContext.getClass(), sessionConfigManager.getClass()};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{webAppServletContext, sessionConfigManager};
                return (SessionContext)constructor.newInstance(objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DeploymentException("This web-application was configured to use Coherence*Web sessions via the coherence-web-sessions-enabled context-param, but either the Coherence*Web session SPI library  or coherence.jar is not found in the web-application classloader.", classNotFoundException);
            }
            catch (Exception exception) {
                throw new DeploymentException("An error occurred instantiating Coherence*Web sessions for this web application", exception);
            }
        }
        String string = sessionConfigManager.getPersistentStoreType();
        if ("memory".equals(string)) {
            object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("file".equals(string)) {
            object = new FileSessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"file", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("replicated".equals(string) && cluster != null && "man".equals(cluster.getClusterType())) {
            TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
            object = new MANReplicatedSessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"sync-replication-across-cluster", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("replicated".equals(string) && cluster != null && "wan".equals(cluster.getClusterType())) {
            if (null != cluster.getDataSourceForSessionPersistence()) {
                TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
                object = new WANSessionContext(webAppServletContext, sessionConfigManager);
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"async-replication-across-cluster", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            }
            Loggable loggable = HTTPSessionLogger.logInsufficientConfigurationLoggable((String)webAppServletContext.getAppDisplayName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        if ("replicated".equals(string)) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            if (runtimeAccess.getServer().getCluster() == null) {
                Loggable loggable = HTTPSessionLogger.logClusteringRequiredForReplicationLoggable((String)webAppServletContext.getAppDisplayName());
                loggable.log();
                throw new DeploymentException(loggable.getMessage());
            }
            try {
                TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
                if (cluster.getPersistSessionsOnShutdown()) {
                    if (null == cluster.getDataSourceForSessionPersistence()) {
                        Loggable loggable = HTTPSessionLogger.logInsufficientConfigurationLoggable((String)webAppServletContext.getAppDisplayName());
                        loggable.log();
                        throw new DeploymentException(loggable.getMessage());
                    }
                    object = new WANSessionContext(webAppServletContext, sessionConfigManager);
                } else {
                    object = new ReplicatedSessionContext(webAppServletContext, sessionConfigManager);
                }
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"replicated", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            }
            catch (RuntimeException runtimeException) {
                HTTPSessionLogger.logSessionNotAllowed((String)runtimeException.getMessage());
                object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            return object;
        }
        if ("async-replicated".equals(string) && cluster != null && "man".equals(cluster.getClusterType())) {
            TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
            object = new MANAsyncReplicatedSessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"sync-replication-across-cluster", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("async-replicated".equals(string) && cluster != null && "wan".equals(cluster.getClusterType())) {
            if (null != cluster.getDataSourceForSessionPersistence()) {
                TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
                object = new WANAsyncSessionContext(webAppServletContext, sessionConfigManager);
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"async-replication-across-cluster", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            }
            Loggable loggable = HTTPSessionLogger.logInsufficientConfigurationLoggable((String)webAppServletContext.getAppDisplayName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        if ("async-replicated".equals(string)) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            if (runtimeAccess.getServer().getCluster() == null) {
                Loggable loggable = HTTPSessionLogger.logClusteringRequiredForReplicationLoggable((String)webAppServletContext.getAppDisplayName());
                loggable.log();
                throw new DeploymentException(loggable.getMessage());
            }
            try {
                TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
                if (cluster.getPersistSessionsOnShutdown()) {
                    if (null == cluster.getDataSourceForSessionPersistence()) {
                        Loggable loggable = HTTPSessionLogger.logInsufficientConfigurationLoggable((String)webAppServletContext.getAppDisplayName());
                        loggable.log();
                        throw new DeploymentException(loggable.getMessage());
                    }
                    object = new WANSessionContext(webAppServletContext, sessionConfigManager);
                } else {
                    object = new AsyncReplicatedSessionContext(webAppServletContext, sessionConfigManager);
                }
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"async-replicated", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            }
            catch (RuntimeException runtimeException) {
                HTTPSessionLogger.logSessionNotAllowed((String)runtimeException.getMessage());
                object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            return object;
        }
        if ("async-replicated-if-clustered".equals(string)) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            if (runtimeAccess.getServer().getCluster() == null) {
                object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            } else {
                try {
                    TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
                    if (cluster.getPersistSessionsOnShutdown()) {
                        if (null == cluster.getDataSourceForSessionPersistence()) {
                            Loggable loggable = HTTPSessionLogger.logInsufficientConfigurationLoggable((String)webAppServletContext.getAppDisplayName());
                            loggable.log();
                            throw new DeploymentException(loggable.getMessage());
                        }
                        object = new WANSessionContext(webAppServletContext, sessionConfigManager);
                    } else {
                        object = new AsyncReplicatedSessionContext(webAppServletContext, sessionConfigManager);
                    }
                    if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                    Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"async-replicated", (String)webAppServletContext.getContextPath());
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                    return object;
                }
                catch (RuntimeException runtimeException) {
                    HTTPSessionLogger.logSessionNotAllowed((String)runtimeException.getMessage());
                    object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
                    Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                }
            }
            return object;
        }
        if ("replicated_if_clustered".equals(string)) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            if (runtimeAccess.getServer().getCluster() == null) {
                object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            }
            try {
                TargetValidator.validateTargetting(webAppServletContext.getWebAppModule(), string);
                if ("man".equals(cluster.getClusterType())) {
                    object = new MANReplicatedSessionContext(webAppServletContext, sessionConfigManager);
                    if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                    Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"sync-replication-across-cluster", (String)webAppServletContext.getAppDisplayName());
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                    return object;
                }
                if ("wan".equals(cluster.getClusterType()) || cluster.getPersistSessionsOnShutdown()) {
                    if (null == cluster.getDataSourceForSessionPersistence()) {
                        Loggable loggable = HTTPSessionLogger.logInsufficientConfigurationLoggable((String)webAppServletContext.getAppDisplayName());
                        loggable.log();
                        throw new DeploymentException(loggable.getMessage());
                    }
                    object = new WANSessionContext(webAppServletContext, sessionConfigManager);
                    if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                    Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"async-replication-across-cluster", (String)webAppServletContext.getAppDisplayName());
                    DEBUG_SESSIONS.debug(loggable.getMessage());
                    return object;
                }
                object = new ReplicatedSessionContext(webAppServletContext, sessionConfigManager);
                if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"replicated", (String)webAppServletContext.getContextPath());
                DEBUG_SESSIONS.debug(loggable.getMessage());
                return object;
            }
            catch (RuntimeException runtimeException) {
                HTTPSessionLogger.logSessionNotAllowed((String)runtimeException.getMessage());
                object = new MemorySessionContext(webAppServletContext, sessionConfigManager);
                Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"memory", (String)webAppServletContext.getAppDisplayName());
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            return object;
        }
        if ("jdbc".equals(string)) {
            object = new JDBCSessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"jdbc", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("async-jdbc".equals(string)) {
            object = new AsyncJDBCSessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"async-jdbc", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("cookie".equals(string)) {
            object = new CookieSessionContext(webAppServletContext, sessionConfigManager);
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            Loggable loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"cookie", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        if ("coherence-web".equals(string)) {
            Loggable loggable;
            try {
                loggable = webAppServletContext.getServletClassLoader().loadClass("weblogic.servlet.internal.session.CoherenceWebSessionContextImpl");
                Class[] classArray = new Class[]{webAppServletContext.getClass(), sessionConfigManager.getClass()};
                Constructor<?> constructor = loggable.getConstructor(classArray);
                Object[] objectArray = new Object[]{webAppServletContext, sessionConfigManager};
                object = (SessionContext)constructor.newInstance(objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DeploymentException("This web-application was confirgured to use Coherence*Web sessions, but either the Coherence*Web session SPI library is not found in the web-application classloader or the coherence-wls.jar was not found in the weblogic system classloader.", classNotFoundException);
            }
            catch (Exception exception) {
                throw new DeploymentException("An error occured instantaiting Coherence*Web sessions for this web application", exception);
            }
            if (!DEBUG_SESSIONS.isDebugEnabled()) return object;
            loggable = HTTPSessionLogger.logCreatingSessionContextOfTypeLoggable((String)"coherence-web", (String)webAppServletContext.getAppDisplayName());
            DEBUG_SESSIONS.debug(loggable.getMessage());
            return object;
        }
        Loggable loggable = HTTPSessionLogger.logUnknownPeristentTypeLoggable((String)string, (String)webAppServletContext.getAppDisplayName());
        loggable.log();
        throw new DeploymentException(loggable.getMessage());
    }

    public abstract void sync(HttpSession var1);

    public abstract String getPersistentStoreType();

    public abstract HttpSession getNewSession(String var1, ServletRequestImpl var2, ServletResponseImpl var3);

    public abstract SessionData getSessionInternal(String var1, ServletRequestImpl var2, ServletResponseImpl var3);

    boolean invalidateSession(SessionData sessionData, boolean bl) {
        return this.invalidateSession(sessionData, bl, true);
    }

    abstract boolean invalidateSession(SessionData var1, boolean var2, boolean var3);

    abstract void unregisterExpiredSessions(ArrayList var1);

    public String[] getIdsInternal() {
        Hashtable hashtable = this.getOpenSessions();
        if (hashtable == null) {
            return new String[0];
        }
        return hashtable.keySet().toArray(new String[0]);
    }

    public SessionData getSessionInternalForAuthentication(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        return this.getSessionInternal(string, servletRequestImpl, servletResponseImpl);
    }

    public boolean hasSession(String string) {
        return this.getSessionInternal(string, null, null) != null;
    }

    public HttpSession getSharedSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        if (!this.getConfigMgr().isSessionSharingEnabled()) {
            return null;
        }
        WebAppServletContext webAppServletContext = this.getServletContext();
        if (webAppServletContext == null) {
            return null;
        }
        ServletContextManager servletContextManager = webAppServletContext.getServer().getServletContextManager();
        WebAppServletContext[] webAppServletContextArray = servletContextManager.getAllContexts();
        for (int i = 0; i < webAppServletContextArray.length; ++i) {
            SessionData sessionData;
            if (webAppServletContext.getApplicationContext() != webAppServletContextArray[i].getApplicationContext() || webAppServletContextArray[i] == webAppServletContext || (sessionData = webAppServletContextArray[i].getSessionContext().getSessionInternal(string, servletRequestImpl, servletResponseImpl)) == null) continue;
            return new SharedSessionData(sessionData, webAppServletContext);
        }
        return null;
    }

    public SessionData getSessionFromOtherContexts(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        WebAppServletContext webAppServletContext = this.getServletContext();
        if (webAppServletContext == null || webAppServletContext.getVersionId() == null) {
            return null;
        }
        ContextVersionManager contextVersionManager = webAppServletContext.getContextManager();
        if (contextVersionManager == null) {
            return null;
        }
        Iterator iterator = contextVersionManager.getServletContexts(servletRequestImpl.isAdminChannelRequest());
        while (iterator.hasNext()) {
            SessionData sessionData;
            WebAppServletContext webAppServletContext2 = (WebAppServletContext)iterator.next();
            if (webAppServletContext2 == webAppServletContext) continue;
            if (DEBUG_APP_VERSION.isEnabled()) {
                HTTPLogger.logDebug((String)("Trying to getSessionInternal from another  context=" + webAppServletContext2 + " for id=" + string));
            }
            if ((sessionData = webAppServletContext2.getSessionContext().getSessionInternal(string, servletRequestImpl, servletResponseImpl)) == null) continue;
            return sessionData;
        }
        return null;
    }

    public abstract int getNonPersistedSessionCount();

    public void storeAttributesInBytes() {
        String[] stringArray = this.getIdsInternal();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            SessionData sessionData = this.getSessionInternal(stringArray[i], null, null);
            if (sessionData == null) continue;
            sessionData.storeAttributesInBytes();
        }
    }

    public void destroy(boolean bl) {
        this.cancelTrigger();
    }

    public void cancelTrigger() {
        if (this.invalidator != null) {
            this.invalidator.stop();
        }
        this.invalidator = null;
    }

    public WebAppServletContext getServletContext() {
        return this.servletContext;
    }

    public abstract int getCurrOpenSessionsCount();

    public int getTotalOpenSessionsCount() {
        return this.totalOpenSessions;
    }

    public int getMaxOpenSessionsCount() {
        return this.maxOpenSessions;
    }

    public void setCurrOpenSessionsCount(int n) {
        this.curOpenSessions = n;
    }

    public void setTotalOpenSessionsCount(int n) {
        this.totalOpenSessions = n;
    }

    public void setMaxOpenSessionsCount(int n) {
        this.maxOpenSessions = n;
    }

    public void incrementOpenSessionsCount() {
        ++this.curOpenSessions;
        ++this.totalOpenSessions;
        if (this.curOpenSessions > this.maxOpenSessions) {
            this.maxOpenSessions = this.curOpenSessions;
        }
    }

    public void decrementOpenSessionsCount() {
        --this.curOpenSessions;
        if (this.curOpenSessions < 0) {
            this.curOpenSessions = 0;
        }
    }

    public void addSession(String string, Object object) {
        this.openSessions.put(string, object);
        this.servletContext.addSession(string);
    }

    public void removeSession(String string) {
        this.openSessions.remove(string);
        this.servletContext.removeSession(string);
    }

    public void exit(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, HttpSession httpSession) {
    }

    public void enter(ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl, HttpSession httpSession) {
    }

    public Object getOpenSession(String string) {
        return this.openSessions.get(string);
    }

    public Hashtable getOpenSessions() {
        return this.openSessions;
    }

    public synchronized ServletSessionRuntimeMBean getServletSessionRuntimeMBean(String string) {
        SessionData sessionData = this.getSessionInternal(string, null, null);
        if (sessionData == null || !sessionData.isValid()) {
            return null;
        }
        return sessionData.getServletSessionRuntimeMBean();
    }

    public synchronized ServletSessionRuntimeMBean[] getServletSessionRuntimeMBeans() {
        if (!this.configMgr.isMonitoringEnabled()) {
            return new ServletSessionRuntimeMBean[0];
        }
        HashSet<ServletSessionRuntimeMBean> hashSet = new HashSet<ServletSessionRuntimeMBean>();
        String[] stringArray = this.getIdsInternal();
        if (stringArray.length < 1) {
            return new ServletSessionRuntimeMBean[0];
        }
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            ServletSessionRuntimeMBean servletSessionRuntimeMBean = this.getServletSessionRuntimeMBean(stringArray[i]);
            if (servletSessionRuntimeMBean == null) continue;
            hashSet.add(servletSessionRuntimeMBean);
        }
        if (hashSet.isEmpty()) {
            return new ServletSessionRuntimeMBean[0];
        }
        ServletSessionRuntimeMBean[] servletSessionRuntimeMBeanArray = new ServletSessionRuntimeMBean[hashSet.size()];
        hashSet.toArray(servletSessionRuntimeMBeanArray);
        return servletSessionRuntimeMBeanArray;
    }

    public synchronized Set getAllServletSessions() {
        String[] stringArray = this.getIdsInternal();
        if (stringArray.length < 1) {
            return new HashSet();
        }
        HashSet<SessionInfo> hashSet = new HashSet<SessionInfo>(stringArray.length);
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            SessionInfo sessionInfo;
            SessionData sessionData = this.getSessionInternal(stringArray[i], null, null);
            if (sessionData == null || !sessionData.isValid() || (sessionInfo = new SessionInfo(sessionData)).getMonitoringId() == null) continue;
            hashSet.add(sessionInfo);
        }
        return hashSet;
    }

    public String[] getServletSessionsMonitoringIds() {
        String[] stringArray = this.getIdsInternal();
        if (stringArray.length < 1) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            String string;
            SessionData sessionData = this.getSessionInternal(stringArray[i], null, null);
            if (sessionData == null || !sessionData.isValid() || (string = sessionData.getMonitoringId()) == null) continue;
            hashSet.add(string);
        }
        if (hashSet.isEmpty()) {
            return new String[0];
        }
        String[] stringArray2 = new String[hashSet.size()];
        hashSet.toArray(stringArray2);
        return stringArray2;
    }

    public void invalidateServletSession(String string) throws IllegalStateException {
        SessionData sessionData = this.getSessionWithMonitoringId(string);
        if (sessionData == null || !sessionData.isValid()) {
            throw new IllegalStateException("Session has been invalidated already");
        }
        sessionData.invalidate();
    }

    private SessionData getSessionWithMonitoringId(String string) {
        String[] stringArray = this.getIdsInternal();
        if (stringArray.length < 1) {
            return null;
        }
        for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
            SessionData sessionData = this.getSessionInternal(stringArray[i], null, null);
            if (sessionData == null || !sessionData.isValid() || !string.equals(sessionData.getMonitoringId())) continue;
            return sessionData;
        }
        return null;
    }

    public long getSessionLastAccessedTime(String string) throws IllegalStateException {
        SessionData sessionData = this.getSessionWithMonitoringId(string);
        if (sessionData == null || !sessionData.isValid()) {
            throw new IllegalStateException("Session has been invalidated already");
        }
        return sessionData.getLastAccessedTime();
    }

    public long getSessionMaxInactiveInterval(String string) throws IllegalStateException {
        SessionData sessionData = this.getSessionWithMonitoringId(string);
        if (sessionData == null || !sessionData.isValid()) {
            throw new IllegalStateException("Session has been invalidated already");
        }
        return sessionData.getMaxInactiveInterval();
    }

    public String getMonitoringId(String string) {
        SessionData sessionData = this.getSessionInternal(string, null, null);
        if (sessionData == null || !sessionData.isValid()) {
            throw new IllegalStateException("Session has been invalidated already");
        }
        return sessionData.getMonitoringId();
    }

    protected final ServerIdentity getCurrentClusterMember() {
        return currentClusterMember;
    }

    public void notifySessionAttributeChange(HttpSession httpSession, String string, Object object, Object object2) {
        this.servletContext.getEventsManager().notifySessionAttributeChange(httpSession, string, object, object2);
    }

    public static void declareProperties() {
    }

    public void setInvalidationIntervalSecs(int n) {
        if (this.configMgr.getInvalidationIntervalSecs() == n) {
            return;
        }
        if (this.invalidator != null) {
            this.invalidator.bounce();
        }
    }

    public synchronized HttpSession getSession(String string) {
        HTTPSessionLogger.logDeprecatedCall((String)"getSession(String id)");
        return null;
    }

    public Enumeration getIds() {
        HTTPSessionLogger.logDeprecatedCall((String)"getIds()");
        return new Vector().elements();
    }

    public void deleteInvalidSessions() {
        if (this.invalidator != null) {
            this.invalidator.cleanupExpiredSessions();
        }
    }

    public SessionConfigManager getConfigMgr() {
        return this.configMgr;
    }

    protected void invalidateOrphanedSessions() {
    }

    public String lookupAppVersionIdForSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        return null;
    }

    private boolean invalidateSession(SessionData sessionData) {
        Throwable throwable;
        InvalidationAction invalidationAction = new InvalidationAction(this, sessionData);
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)sessionData.getInternalAttribute("weblogic.authuser");
        if (authenticatedSubject == null) {
            authenticatedSubject = SubjectUtils.getAnonymousSubject();
        }
        if ((throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)invalidationAction)) != null) {
            HTTPSessionLogger.logUnexpectedTimeoutError((Throwable)throwable);
        }
        return throwable == null && invalidationAction.isInvalidated();
    }

    private static class InvalidationAction
    implements PrivilegedAction {
        private SessionData sess;
        private SessionContext ctx;
        private boolean invalidated = false;

        InvalidationAction(SessionContext sessionContext, SessionData sessionData) {
            this.ctx = sessionContext;
            this.sess = sessionData;
        }

        public Object run() {
            try {
                this.invalidated = this.ctx.invalidateSession(this.sess, true);
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }

        public boolean isInvalidated() {
            return this.invalidated;
        }
    }

    private class SessionInvalidator
    extends NakedTimerListenerBase {
        private Timer timer;
        private int invalCount;

        private SessionInvalidator() {
            super("ServletSessionTimer", SessionContext.this.servletContext);
            this.invalCount = 0;
            this.start();
        }

        private void start() {
            int n = SessionContext.this.configMgr.getInvalidationIntervalSecs();
            if (SessionContext.this.isDebugEnabled()) {
                Loggable loggable = HTTPSessionLogger.logInvalidationIntervalLoggable((int)n);
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
            this.timer = this.timerManager.schedule((TimerListener)this, 0L, (long)(n * 1000));
        }

        private void stop() {
            this.timer.cancel();
            this.timerManager.stop();
        }

        private void bounce() {
            this.timer.cancel();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            if (!SessionContext.this.getServletContext().isStarted()) {
                return;
            }
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                javaURLContextFactory.pushContext(SessionContext.this.getServletContext().getEnvironmentContext());
                ClassLoader classLoader2 = SessionContext.this.getServletContext().getServletClassLoader();
                thread2.setContextClassLoader(classLoader2);
                Throwable throwable = (Throwable)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)SubjectUtils.getAnonymousSubject(), (PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        try {
                            SessionInvalidator.this.cleanupExpiredSessions();
                        }
                        catch (Throwable throwable) {
                            HTTPSessionLogger.logUnexpectedTimeoutError((Throwable)throwable);
                        }
                        return null;
                    }
                });
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                javaURLContextFactory.popContext();
                thread2.setContextClassLoader(classLoader);
                throw throwable;
            }
            javaURLContextFactory.popContext();
            thread2.setContextClassLoader(classLoader);
        }

        private boolean hasSessionExpired(SessionData sessionData, long l) {
            long l2 = Long.MAX_VALUE;
            int n = sessionData.getMaxInactiveInterval();
            l2 = l - (long)n * 1000L;
            return n >= 0 && sessionData.getLAT() < l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanupExpiredSessions() {
            try {
                long l = System.currentTimeMillis();
                String[] stringArray = SessionContext.this.getIdsInternal();
                int n = stringArray.length;
                boolean bl = false;
                boolean bl2 = false;
                ArrayList<SessionData> arrayList = new ArrayList<SessionData>();
                for (int i = 0; i < n; ++i) {
                    try {
                        SessionData sessionData;
                        if (stringArray[i] == null) break;
                        SessionData sessionData2 = SessionContext.this.getSessionInternal(stringArray[i], null, null);
                        if (sessionData2 != null) {
                            if (!sessionData2.isValid() || sessionData2.sessionInUse()) continue;
                            sessionData = sessionData2;
                            synchronized (sessionData) {
                                if (!sessionData2.isValid() || sessionData2.sessionInUse() || !this.hasSessionExpired(sessionData2, l)) {
                                    continue;
                                }
                                if (!sessionData2.acquireInvalidationLock()) {
                                    continue;
                                }
                                if (SessionContext.this.invalidateSession(sessionData2)) {
                                    arrayList.add(sessionData2);
                                    if (SessionContext.this.isDebugEnabled()) {
                                        Loggable loggable = HTTPSessionLogger.logTimerInvalidatedSessionLoggable((String)stringArray[i], (String)SessionContext.this.getServletContext().getContextPath());
                                        DEBUG_SESSIONS.debug(loggable.getMessage());
                                    }
                                }
                                continue;
                            }
                        }
                        sessionData2 = (SessionData)SessionContext.this.openSessions.get(stringArray[i]);
                        if (sessionData2 == null || sessionData2.sessionInUse()) continue;
                        sessionData = sessionData2;
                        synchronized (sessionData) {
                            if (!sessionData2.sessionInUse() && this.hasSessionExpired(sessionData2, l)) {
                                SessionContext.this.invalidateSession(sessionData2);
                            }
                            continue;
                        }
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        HTTPSessionLogger.logUnexpectedTimeoutError((Throwable)throwable);
                    }
                }
                SessionContext.this.unregisterExpiredSessions(arrayList);
                ++this.invalCount;
                this.invalCount %= 10;
                if (this.invalCount == 9) {
                    SessionContext.this.invalidateOrphanedSessions();
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                HTTPSessionLogger.logUnexpectedTimeoutErrorRaised((Throwable)throwable);
            }
        }
    }
}

