/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import weblogic.common.internal.PassivationUtils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.spi.BusinessHandle;
import weblogic.ejb.spi.BusinessObject;
import weblogic.logging.Loggable;
import weblogic.management.runtime.ServletSessionRuntimeMBean;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rjvm.LocalRJVM;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.internal.AttributeWrapper;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServerHelper;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.servlet.internal.session.EJBAttributeWrapper;
import weblogic.servlet.internal.session.EJBHomeAttributeWrapper;
import weblogic.servlet.internal.session.FileSessionContext;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.ServletSessionRuntimeManager;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionConstants;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.SessionInternal;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.NestedRuntimeException;
import weblogic.utils.concurrent.Latch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionData
implements HttpSession,
SessionInternal,
Externalizable,
SessionConstants {
    static final long serialVersionUID = -4398986144473197373L;
    private transient boolean needToSerializeAttributes = false;
    private static final transient int AVALABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    protected transient SessionContext sessionContext = null;
    private transient ServletSessionRuntimeMBean runtime = null;
    protected String id = null;
    protected String versionId = null;
    protected long creationTime = 0L;
    protected long accessTime = 0L;
    protected int maxInactiveInterval = -1;
    protected boolean isNew = true;
    protected boolean isValid = true;
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(16, 0.75f, AVALABLE_PROCESSORS);
    protected transient Hashtable transientAttributes = null;
    protected Map<String, Object> internalAttributes = new ConcurrentHashMap<String, Object>(16, 0.75f, AVALABLE_PROCESSORS);
    protected transient Hashtable internalTransientAttributes = null;
    private transient int activeRequestCount = 0;
    protected static final String DEFAULT_SERVER_INDICATOR = "USE_DEFAULT_WEB_SERVER";
    private static final boolean WIN_32 = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    private transient Object removeLock = new Object();
    private Latch invalidationLatch = new Latch();
    private static int currProcessedSessions = 0;
    protected static final String VERSION_ID = "weblogic.versionId";
    public static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");
    public static final DebugLogger DEBUG_SESSIONS = DebugLogger.getDebugLogger((String)"DebugHttpSessions");
    protected static final String DEBUG_SESSION_INDICATOR = "wl_debug_session";
    private transient CRC32 crc = null;
    private int invalidatingThreadID;
    private static final char[] SESSION_CHARS = new char[]{'Q', 'B', 'C', 'D', 'G', 'F', 'G', 'H', 'L', 'J', 'K', 'L', 'M', 'N', 'T', 'P', 'Q', 'R', 'S', 'T', 'J', 'V', 'W', 'X', 'Y', 'Z', 'h', 'b', 'c', 'd', 'p', 'f', 'g', 'h', 'v', 'j', 'k', 'l', 'm', 'n', 'y', 'p', 'q', 'r', 's', 't', 'n', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '2', '1'};
    public static final Hashtable ht = new Hashtable();
    private static boolean unlimited = false;
    private boolean processed = false;
    private boolean special = false;

    public SessionData() {
        this.setModified(false);
        this.initializeCRC32();
    }

    public SessionData(String string, SessionContext sessionContext, boolean bl) {
        this();
        WebAppServletContext webAppServletContext;
        this.id = string;
        this.sessionContext = sessionContext;
        this.isNew = bl;
        if (this.isNew) {
            if (this.id != null) {
                this.id = !this.reuseSessionId(this.id) ? null : RSID.getID(this.id);
            }
            if (this.id == null) {
                this.id = this.generateSessionId();
            }
            if (this.isDebugEnabled()) {
                webAppServletContext = HTTPSessionLogger.logCreateNewSessionForPathLoggable((String)this.id, (String)this.getContextPath());
                DEBUG_SESSIONS.debug(webAppServletContext.getMessage());
            }
            this.accessTime = this.creationTime = System.currentTimeMillis();
            this.maxInactiveInterval = this.sessionContext.getConfigMgr().getSessionTimeoutSecs();
            this.isValid = true;
            if (this.sessionContext.getConfigMgr().isMonitoringEnabled()) {
                this.runtime = ServletSessionRuntimeManager.getInstance().findOrCreate(this);
            }
        }
        webAppServletContext = this.getWebAppServletContext();
        this.versionId = webAppServletContext.getVersionId();
    }

    protected void setMonitoringId() {
        this.setInternalAttribute("weblogic.servlet.monitoringId", this.getNextId());
    }

    protected boolean isDebugEnabled() {
        return DEBUG_SESSIONS.isDebugEnabled() || this.sessionContext != null && this.sessionContext.getConfigMgr() != null && this.sessionContext.getConfigMgr().isDebugEnabled();
    }

    private String generateSessionId() {
        if (WIN_32) {
            while (true) {
                this.id = this.getNextId();
                if (FileSessionContext.containsReservedKeywords(this.id)) {
                    if (!this.isDebugEnabled()) continue;
                    HTTPSessionLogger.logSessionIDContainsReservedKeyword((String)this.id);
                    continue;
                }
                break;
            }
        } else {
            this.id = this.getNextId();
        }
        return this.id;
    }

    private boolean reuseSessionId(String string) {
        if (this.getWebAppServletContext().getServer().getMBean().isSingleSignonDisabled() || !this.sessionContext.getConfigMgr().getCookiePath().equals("/")) {
            return false;
        }
        WebAppServletContext[] webAppServletContextArray = this.getWebAppServletContext().getServer().getServletContextManager().getAllContexts();
        if (webAppServletContextArray == null || webAppServletContextArray.length < 2) {
            return false;
        }
        String string2 = this.sessionContext.getConfigMgr().getCookieName();
        for (int i = 0; i < webAppServletContextArray.length; ++i) {
            if (webAppServletContextArray[i] == this.getWebAppServletContext() || webAppServletContextArray[i].getSessionContext() == null || !webAppServletContextArray[i].getSessionContext().getConfigMgr().getCookieName().equals(string2) || !webAppServletContextArray[i].getSessionContext().getConfigMgr().getCookiePath().equals("/") || !webAppServletContextArray[i].getSessionContext().hasSession(string)) continue;
            return true;
        }
        return false;
    }

    final void reinitRuntimeMBean() {
        if (!this.sessionContext.getConfigMgr().isMonitoringEnabled()) {
            return;
        }
        if (this.runtime != null) {
            return;
        }
        this.runtime = ServletSessionRuntimeManager.getInstance().findOrCreate(this);
    }

    protected void unregisterRuntimeMBean() {
        if (!this.sessionContext.getConfigMgr().isMonitoringEnabled()) {
            return;
        }
        ServletSessionRuntimeManager.getInstance().destroy(this);
    }

    ServletSessionRuntimeMBean getServletSessionRuntimeMBean() {
        return this.runtime;
    }

    public final boolean isModified() {
        return this.needToSerializeAttributes;
    }

    public final void setModified(boolean bl) {
        this.needToSerializeAttributes = bl;
    }

    final String getContextPath() {
        WebAppServletContext webAppServletContext = this.getWebAppServletContext();
        if (webAppServletContext == null) {
            return null;
        }
        return webAppServletContext.getContextPath();
    }

    final String getContextName() {
        WebAppServletContext webAppServletContext = this.getWebAppServletContext();
        if (webAppServletContext == null) {
            return null;
        }
        return webAppServletContext.getName();
    }

    public ServletContext getServletContext() {
        return this.sessionContext.getServletContext();
    }

    public final WebAppServletContext getWebAppServletContext() {
        return this.sessionContext.getServletContext();
    }

    public long getCreationTime() throws IllegalStateException {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        return this.creationTime;
    }

    @Override
    public final String getInternalId() {
        return this.id;
    }

    public String getId() {
        return this.getIdWithServerInfo() + "!" + this.creationTime;
    }

    @Override
    public String getIdWithServerInfo() {
        if (this.getContext() == null || this.getWebAppServletContext().getServer().isWAPEnabled()) {
            return this.id;
        }
        StringBuffer stringBuffer = new StringBuffer(this.sessionContext.getConfigMgr().getIDLength() + 12);
        stringBuffer.append(this.id);
        stringBuffer.append("!");
        if (ServerHelper.useExtendedSessionFormat()) {
            stringBuffer.append(ServerHelper.createServerEntry(ServerHelper.getNetworkChannelName(), LocalServerIdentity.getIdentity(), "!"));
        } else {
            stringBuffer.append(this.getWebAppServletContext().getServer().getServerHash());
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getVersionId() {
        return this.versionId;
    }

    @Override
    public final void setVersionId(String string) {
        this.versionId = string;
    }

    public long getLastAccessedTime() {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        return this.accessTime;
    }

    @Override
    public final long getLAT() {
        return this.accessTime;
    }

    @Override
    public void setLastAccessedTime(long l) {
        this.accessTime = l;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = n;
    }

    public HttpSessionContext getSessionContext() {
        return this.sessionContext;
    }

    final void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public final SessionContext getContext(String string, String string2) {
        if (this.sessionContext != null) {
            return this.sessionContext;
        }
        WebAppServletContext webAppServletContext = SessionData.getServletContext(string, string2, this.versionId);
        if (webAppServletContext == null) {
            return null;
        }
        this.sessionContext = webAppServletContext.getSessionContext();
        return this.sessionContext;
    }

    protected static final WebAppServletContext getServletContext(String string, String string2, String string3) {
        HttpServer httpServer = null;
        httpServer = string.equals(DEFAULT_SERVER_INDICATOR) ? WebService.defaultHttpServer() : WebService.getHttpServer(string);
        if (httpServer == null) {
            throw new AssertionError((Object)("WebService.getHttpServer(" + string + ") returns null"));
        }
        return httpServer.getServletContextManager().getContextForContextPath(string2, string3);
    }

    @Override
    public final SessionContext getContext() {
        return this.sessionContext;
    }

    public final Object getValue(String string) throws IllegalStateException {
        return this.getAttribute(string);
    }

    public final void putValue(String string, Object object) throws IllegalStateException {
        this.setAttribute(string, object);
    }

    public final String[] getValueNames() throws IllegalStateException {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = this.getAttributeNames();
        while (stringArray.hasMoreElements()) {
            arrayList.add(stringArray.nextElement());
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public final void removeValue(String string) {
        this.removeAttribute(string);
    }

    public Object getAttribute(String string) throws IllegalStateException {
        this.check(string);
        Object object = this.getSecurityModuleAttribute(string);
        if (object != null) {
            return object;
        }
        return this.getAttributeInternal(string);
    }

    protected Object getSecurityModuleAttribute(String string) {
        if (string.equals("weblogic.formauth.targeturl")) {
            if (this.getContext().getServletContext().getConfigManager().isServletAuthFromURL()) {
                return this.getInternalAttribute("weblogic.formauth.targeturl");
            }
            return this.getInternalAttribute("weblogic.formauth.targeturi");
        }
        return null;
    }

    protected Object getAttributeInternal(String string) {
        Object object;
        if (this.attributes != null && (object = this.attributes.get(string)) != null) {
            AttributeWrapper attributeWrapper = (AttributeWrapper)object;
            try {
                Object object2 = attributeWrapper.getObject();
                if (object2 != null && attributeWrapper instanceof EJBAttributeWrapper && object2 instanceof BusinessHandle) {
                    BusinessHandle businessHandle = (BusinessHandle)object2;
                    try {
                        return businessHandle.getBusinessObject();
                    }
                    catch (RemoteException remoteException) {
                        throw new NestedRuntimeException((Throwable)remoteException);
                    }
                }
                if (object2 != null && attributeWrapper instanceof EJBAttributeWrapper && object2 instanceof Handle) {
                    Loggable loggable;
                    if (this.isDebugEnabled()) {
                        loggable = HTTPSessionLogger.logGetAttributeEJBObjectLoggable((String)string);
                        DEBUG_SESSIONS.debug(loggable.getMessage());
                    }
                    loggable = (Handle)object2;
                    try {
                        return loggable.getEJBObject();
                    }
                    catch (RemoteException remoteException) {
                        HTTPSessionLogger.logErrorReconstructingEJBObject((String)string, (Exception)remoteException);
                        throw new NestedRuntimeException((Throwable)remoteException);
                    }
                }
                if (object2 != null && attributeWrapper instanceof EJBHomeAttributeWrapper && object2 instanceof HomeHandle) {
                    Loggable loggable;
                    if (this.isDebugEnabled()) {
                        loggable = HTTPSessionLogger.logGetAttributeEJBHomeLoggable((String)string);
                        DEBUG_SESSIONS.debug(loggable.getMessage());
                    }
                    loggable = (HomeHandle)object2;
                    try {
                        return loggable.getEJBHome();
                    }
                    catch (RemoteException remoteException) {
                        HTTPSessionLogger.logErrorReconstructingEJBHome((String)string, (Exception)remoteException);
                        throw new NestedRuntimeException((Throwable)remoteException);
                    }
                }
                return object2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)classNotFoundException);
                this.attributes.remove(string);
            }
            catch (IOException iOException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)iOException);
                this.attributes.remove(string);
            }
            catch (RuntimeException runtimeException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)runtimeException);
                this.attributes.remove(string);
            }
            return null;
        }
        if (this.transientAttributes != null) {
            return this.transientAttributes.get(string);
        }
        return null;
    }

    protected void check(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        if (string == null) {
            throw new IllegalArgumentException("Key for session.getAttribute() is null");
        }
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        Vector<String> vector = new Vector<String>();
        if (this.attributes != null) {
            for (String string : this.attributes.keySet()) {
                vector.addElement(string);
            }
        }
        if (this.transientAttributes != null) {
            Enumeration enumeration = this.transientAttributes.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setAttribute(String string, Object object) throws IllegalStateException, IllegalArgumentException {
        this.setAttribute(string, object, true);
    }

    @Override
    public void setAttribute(String string, Object object, boolean bl) throws IllegalStateException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Key for session.setAttribute() is null");
        }
        if (object == null) {
            this.removeAttribute(string, bl);
            return;
        }
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        Object object2 = this.getAttribute(string);
        AttributeInfo attributeInfo = this.validateAttributeValue(string, object);
        boolean bl2 = false;
        if (object2 != null) {
            boolean bl3 = bl2 = object2 == object || object2.hashCode() == object.hashCode() && object2.equals(object);
            if (!bl2) {
                this.removeAttribute(string, true, true);
            }
        }
        if (bl && !bl2 && object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string, object));
        }
        if (object instanceof EJBObject) {
            EJBObject eJBObject = (EJBObject)object;
            this.setEJBObject(string, eJBObject);
        } else if (object instanceof EJBHome) {
            EJBHome eJBHome = (EJBHome)object;
            this.setEJBHome(string, eJBHome);
        } else if (object instanceof Serializable || object instanceof Remote) {
            if (object instanceof BusinessObject) {
                this.setBusinessObject(string, (BusinessObject)object);
            } else if (object instanceof Remote) {
                BusinessObject businessObject = null;
                try {
                    businessObject = (BusinessObject)PortableRemoteObject.narrow((Object)object, BusinessObject.class);
                    this.setBusinessObject(string, businessObject);
                }
                catch (ClassCastException classCastException) {
                    this.setModified(true);
                    AttributeWrapper attributeWrapper = new AttributeWrapper(object);
                    if (attributeInfo != null) {
                        attributeWrapper.setCheckSum(attributeInfo.checksum);
                        attributeWrapper.setPreviousChecksum(attributeInfo.oldChecksum);
                    }
                    this.attributes.put(string, attributeWrapper);
                }
            } else {
                this.setModified(true);
                AttributeWrapper attributeWrapper = new AttributeWrapper(object);
                if (attributeInfo != null) {
                    attributeWrapper.setCheckSum(attributeInfo.checksum);
                    attributeWrapper.setPreviousChecksum(attributeInfo.oldChecksum);
                }
                this.attributes.put(string, attributeWrapper);
            }
        } else {
            if (this.transientAttributes == null) {
                this.transientAttributes = new Hashtable();
                if (!HttpServer.isProductionModeEnabled()) {
                    this.logTransientAttributeError(string);
                }
            }
            this.transientAttributes.put(string, object);
        }
        if (bl) {
            this.sessionContext.notifySessionAttributeChange(this, string, object2, object);
        }
    }

    protected void setOldChecksum(String string, AttributeWrapper attributeWrapper) {
        AttributeWrapper attributeWrapper2;
        if (this.isDebugEnabled() && (attributeWrapper2 = (AttributeWrapper)this.attributes.get(string)) != null) {
            attributeWrapper.setPreviousChecksum(attributeWrapper2.getCheckSum());
        }
    }

    protected AttributeInfo validateAttributeValue(String string, Object object) {
        AttributeInfo attributeInfo = null;
        if (this.isDebugEnabled() && object != null) {
            try {
                attributeInfo = this.testSerializability(string, object);
                Loggable loggable = HTTPSessionLogger.logSessionObjectSizeLoggable((String)string, (int)attributeInfo.size);
                DEBUG_SESSIONS.debug(loggable.getMessage());
                if (attributeInfo.oldChecksum >= 0L) {
                    String string2 = "Attribute value for " + string + " has";
                    string2 = string2 + (attributeInfo.oldChecksum == attributeInfo.checksum ? " NOT " : " ");
                    string2 = string2 + "changed. old value checksum: " + attributeInfo.oldChecksum + ", new value checksum: " + attributeInfo.checksum;
                    DEBUG_SESSIONS.debug(string2);
                } else {
                    DEBUG_SESSIONS.debug("Checksum for attribute '" + string + "', value: " + attributeInfo.checksum);
                }
            }
            catch (Exception exception) {
                Loggable loggable = HTTPSessionLogger.logObjectNotSerializableLoggable((String)string, (Exception)exception);
                DEBUG_SESSIONS.debug(loggable.getMessage());
            }
        }
        return attributeInfo;
    }

    private void setEJBHome(String string, EJBHome eJBHome) {
        Loggable loggable;
        if (this.isDebugEnabled()) {
            loggable = HTTPSessionLogger.logSetAttributeEJBHomeLoggable((String)string);
            DEBUG_SESSIONS.debug(loggable.getMessage());
        }
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap<String, Object>();
        }
        loggable = null;
        try {
            loggable = eJBHome.getHomeHandle();
        }
        catch (RemoteException remoteException) {
            HTTPSessionLogger.logErrorFindingHomeHandle((String)string, (Exception)remoteException);
            throw new NestedRuntimeException((Throwable)remoteException);
        }
        this.attributes.put(string, new EJBHomeAttributeWrapper((HomeHandle)loggable));
        this.setModified(true);
    }

    private void setEJBObject(String string, EJBObject eJBObject) {
        Loggable loggable;
        if (this.isDebugEnabled()) {
            loggable = HTTPSessionLogger.logSetAttributeEJBObjectLoggable((String)string);
            DEBUG_SESSIONS.debug(loggable.getMessage());
        }
        try {
            loggable = eJBObject.getHandle();
        }
        catch (RemoteException remoteException) {
            HTTPSessionLogger.logErrorFindingHandle((String)string, (Exception)remoteException);
            throw new NestedRuntimeException((Throwable)remoteException);
        }
        this.attributes.put(string, new EJBAttributeWrapper((Handle)loggable));
        this.setModified(true);
    }

    private void setBusinessObject(String string, BusinessObject businessObject) {
        BusinessHandle businessHandle;
        try {
            businessHandle = businessObject._WL_getBusinessObjectHandle();
        }
        catch (RemoteException remoteException) {
            HTTPSessionLogger.logErrorFindingHandle((String)string, (Exception)remoteException);
            throw new NestedRuntimeException((Throwable)remoteException);
        }
        this.attributes.put(string, new EJBAttributeWrapper(businessHandle));
        this.setModified(true);
    }

    protected abstract void logTransientAttributeError(String var1);

    public void removeAttribute(String string) throws IllegalStateException {
        this.removeAttribute(string, true);
    }

    protected void removeAttribute(String string, boolean bl) throws IllegalStateException {
        this.removeAttribute(string, false, bl);
    }

    protected void removeAttribute(String string, boolean bl, boolean bl2) throws IllegalStateException {
        Object object;
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        if (string == null) {
            throw new IllegalArgumentException("Key for session.removeAttribute() is null");
        }
        Object object2 = null;
        if (this.attributes != null && this.attributes.get(string) != null && (object = this.attributes.remove(string)) != null) {
            this.setModified(true);
            AttributeWrapper attributeWrapper = (AttributeWrapper)object;
            try {
                object2 = object = attributeWrapper.getObject();
                if (bl2 && object instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, object));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)runtimeException);
            }
        }
        if (this.transientAttributes != null && this.transientAttributes.get(string) != null && (object = this.transientAttributes.remove(string)) != null) {
            object2 = object;
            if (bl2 && object instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, object));
            }
        }
        if (bl2 && !bl && object2 != null) {
            this.sessionContext.notifySessionAttributeChange(this, string, object2, null);
        }
    }

    @Override
    public Object getInternalAttribute(String string) {
        return this.getInternalAttribute(string, true);
    }

    private Object getInternalAttribute(String string, boolean bl) throws IllegalStateException {
        Object object;
        if (!this.isValid && bl) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        if (string == null) {
            return null;
        }
        if (this.internalAttributes != null && (object = this.internalAttributes.get(string)) != null) {
            AttributeWrapper attributeWrapper = (AttributeWrapper)object;
            try {
                return attributeWrapper.getObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                HTTPSessionLogger.logUnableToDeserializeSessionData((Throwable)runtimeException);
            }
            this.internalAttributes.remove(string);
            return null;
        }
        if (this.internalTransientAttributes != null) {
            return this.internalTransientAttributes.get(string);
        }
        return null;
    }

    @Override
    public void setInternalAttribute(String string, Object object) throws IllegalStateException, IllegalArgumentException {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        if (string == null) {
            throw new IllegalArgumentException("Key for session.setInternalAttribute() is null");
        }
        if (object == null) {
            this.removeInternalAttribute(string);
            return;
        }
        if (object instanceof Serializable || object instanceof Remote) {
            this.setModified(true);
            this.internalAttributes.put(string, new AttributeWrapper(object));
            if (this.internalTransientAttributes != null) {
                this.internalTransientAttributes.remove(string);
            }
        } else {
            if (this.internalTransientAttributes == null) {
                this.internalTransientAttributes = new Hashtable();
            }
            this.internalTransientAttributes.put(string, object);
            if (this.internalAttributes != null) {
                this.internalAttributes.remove(string);
            }
        }
    }

    @Override
    public void removeInternalAttribute(String string) throws IllegalStateException {
        Object object;
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        if (string == null) {
            throw new IllegalArgumentException("Key for session.removeInternalAttribute() is null");
        }
        if (this.internalAttributes != null && (object = this.internalAttributes.remove(string)) != null) {
            this.setModified(true);
            return;
        }
        if (this.internalTransientAttributes != null) {
            this.internalTransientAttributes.remove(string);
        }
    }

    @Override
    public Enumeration getInternalAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        Vector<String> vector = new Vector<String>();
        if (this.internalAttributes != null) {
            for (String string : this.internalAttributes.keySet()) {
                vector.addElement(string);
            }
        }
        if (this.internalTransientAttributes != null) {
            Enumeration enumeration = this.internalTransientAttributes.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    protected boolean acquireInvalidationLock() {
        if (this.invalidationLatch.tryLock()) {
            this.invalidatingThreadID = System.identityHashCode(Thread.currentThread());
            return true;
        }
        return false;
    }

    @Override
    public void invalidate(boolean bl) throws IllegalStateException {
        if (!this.isValid) {
            throw new IllegalStateException("Session already invalidated");
        }
        if (this.acquireInvalidationLock()) {
            if (this.sessionContext != null) {
                this.sessionContext.invalidateSession(this, false, bl);
            }
        } else {
            if (System.identityHashCode(Thread.currentThread()) == this.invalidatingThreadID) {
                return;
            }
            throw new IllegalStateException("Session invalidation is in progress with different thread");
        }
        this.setValid(false);
    }

    @Override
    public void invalidate() throws IllegalStateException {
        this.invalidate(true);
    }

    public boolean isNew() throws IllegalStateException {
        if (!this.isValid) {
            throw new IllegalStateException("HttpSession is invalid");
        }
        return this.isNew;
    }

    @Override
    public final void setNew(boolean bl) {
        if (bl != this.isNew) {
            this.isNew = bl;
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public int getConcurrentRequestCount() {
        return this.getActiveRequestCount();
    }

    final int getActiveRequestCount() {
        return this.activeRequestCount;
    }

    final synchronized void incrementActiveRequestCount() {
        ++this.activeRequestCount;
    }

    final synchronized void decrementActiveRequestCount() {
        --this.activeRequestCount;
    }

    final synchronized boolean sessionInUse() {
        return this.activeRequestCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isValidForceCheck() {
        if (!this.isValid) {
            return false;
        }
        if (this.sessionInUse()) {
            return true;
        }
        if (this.maxInactiveInterval >= 0 && (System.currentTimeMillis() - this.accessTime) / 1000L > (long)this.maxInactiveInterval) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            boolean bl = false;
            try {
                ClassLoader classLoader2 = this.getWebAppServletContext().getServletClassLoader();
                if (classLoader != classLoader2) {
                    Thread.currentThread().setContextClassLoader(classLoader2);
                    bl = true;
                }
                this.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                if (bl) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
            this.isValid = false;
            return false;
        }
        return true;
    }

    public final void setValid(boolean bl) {
        if (bl != this.isValid) {
            this.isValid = bl;
        }
    }

    void remove() {
        this.remove(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(boolean bl) {
        Object object = this.removeLock;
        synchronized (object) {
            this.removeSessionLogin();
            this.getWebAppServletContext().getEventsManager().notifySessionLifetimeEvent(this, false);
            if (this.attributes != null) {
                for (String string : this.attributes.keySet()) {
                    try {
                        this.removeAttribute(string, bl);
                    }
                    catch (Exception exception) {
                        HTTPSessionLogger.logAttributeRemovalFailure((String)this.getWebAppServletContext().getLogContext(), (String)this.getId(), (Throwable)exception);
                    }
                }
            }
            if (this.transientAttributes != null) {
                Enumeration enumeration = this.transientAttributes.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    string = (String)enumeration.nextElement();
                    try {
                        this.removeAttribute(string, bl);
                    }
                    catch (Exception exception) {
                        HTTPSessionLogger.logAttributeRemovalFailure((String)this.getWebAppServletContext().getLogContext(), (String)this.getId(), (Throwable)exception);
                    }
                }
            }
            this.internalAttributes = null;
            this.unregisterRuntimeMBean();
            this.isValid = false;
        }
    }

    private void removeSessionLogin() {
        if (this.sessionContext == null) {
            return;
        }
        WebAppServletContext webAppServletContext = this.sessionContext.getServletContext();
        SessionConfigManager sessionConfigManager = this.sessionContext.getConfigMgr();
        HttpServer.SessionLogin sessionLogin = webAppServletContext.getServer().getSessionLogin();
        if (sessionConfigManager.isSessionSharingEnabled()) {
            sessionLogin.unregister(this.id);
        } else {
            sessionLogin.unregister(this.id, webAppServletContext.getContextPath());
        }
    }

    void syncSession() {
        int n;
        if (this.isDebugEnabled() && (n = SessionData.calculateSessionSize(new ConcurrentHashMap<String, Object>(this.attributes))) > -1) {
            Loggable loggable = HTTPSessionLogger.logSessionSizeLoggable((String)this.id, (int)n);
            DEBUG_SESSIONS.debug(loggable.getMessage());
        }
    }

    static final int calculateSessionSize(Object object) {
        try {
            return PassivationUtils.sizeOf(object);
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    void storeAttributesInBytes() {
        AttributeWrapper attributeWrapper;
        if (this.attributes != null) {
            for (Object object : this.attributes.values()) {
                attributeWrapper = (AttributeWrapper)object;
                try {
                    attributeWrapper.convertToBytes();
                }
                catch (IOException iOException) {
                    HTTPSessionLogger.logExceptionSerializingAttributeWrapper((Exception)iOException);
                }
            }
        }
        if (this.internalAttributes != null) {
            for (Object object : this.internalAttributes.values()) {
                attributeWrapper = (AttributeWrapper)object;
                try {
                    attributeWrapper.convertToBytes();
                }
                catch (IOException iOException) {
                    HTTPSessionLogger.logExceptionSerializingAttributeWrapper((Exception)iOException);
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        block2: {
            this.creationTime = objectInput.readLong();
            this.accessTime = objectInput.readLong();
            this.maxInactiveInterval = objectInput.readInt();
            this.isNew = objectInput.readBoolean();
            this.isValid = objectInput.readBoolean();
            this.attributes = SessionData.convertToConcurrentHashMap(objectInput.readObject());
            this.id = (String)objectInput.readObject();
            try {
                this.internalAttributes = SessionData.convertToConcurrentHashMap(objectInput.readObject());
                this.setupVersionIdFromAttrs();
            }
            catch (OptionalDataException optionalDataException) {
                this.internalAttributes = null;
                if (!this.isDebugEnabled()) break block2;
                DEBUG_SESSIONS.debug("Ignoring the OptionalDataException " + optionalDataException.getMessage(), (Throwable)optionalDataException);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.initVersionAttrsIfNeeded();
        objectOutput.writeLong(this.creationTime);
        objectOutput.writeLong(this.accessTime);
        objectOutput.writeInt(this.maxInactiveInterval);
        objectOutput.writeBoolean(this.isNew);
        objectOutput.writeBoolean(this.isValid);
        objectOutput.writeObject(SessionData.convertToHashtable(this.attributes));
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(SessionData.convertToHashtable(this.internalAttributes));
    }

    final String getMainAttributeValue() {
        String string = this.sessionContext.getConfigMgr().getMonitoringAttributeName();
        if (string == null) {
            return null;
        }
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    private String getNextId() {
        char[] cArray = new char[this.sessionContext.getConfigMgr().getIDLength()];
        int n = (int)(System.currentTimeMillis() / 1000L);
        SecureRandom secureRandom = LocalRJVM.getLocalRJVM().getSecureRandom();
        for (int i = 0; i < this.sessionContext.getConfigMgr().getIDLength(); ++i) {
            if (i > 3 && i < 8) continue;
            cArray[i] = SESSION_CHARS[secureRandom.nextInt(SESSION_CHARS.length)];
        }
        cArray[4] = SESSION_CHARS[n >> 24 & 0x3F];
        cArray[5] = SESSION_CHARS[n >> 16 & 0x3F];
        cArray[6] = SESSION_CHARS[n >> 8 & 0x3F];
        cArray[7] = SESSION_CHARS[n & 0x1F];
        return new String(cArray);
    }

    public final void notifyAboutToPassivate(HttpSessionEvent httpSessionEvent) {
        SessionData.notifyAboutToPassivate(this.attributes, httpSessionEvent);
        SessionData.notifyAboutToPassivate(this.transientAttributes, httpSessionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeInfo testSerializability(String string, Object object) throws Exception {
        byte[] byArray = this.serialize(object);
        this.deserialize(byArray);
        AttributeInfo attributeInfo = new AttributeInfo();
        if (this.crc != null) {
            try {
                this.crc.update(byArray);
                attributeInfo.checksum = this.crc.getValue();
                Object object2 = this.attributes.get(string);
                if (object2 != null && object2 instanceof AttributeWrapper) {
                    AttributeWrapper attributeWrapper = (AttributeWrapper)object2;
                    attributeInfo.oldChecksum = attributeWrapper.getCheckSum();
                }
            }
            finally {
                this.crc.reset();
            }
        }
        attributeInfo.size = byArray.length;
        return attributeInfo;
    }

    protected Object deserialize(byte[] byArray) throws ClassNotFoundException, IOException {
        return PassivationUtils.toObject(byArray);
    }

    protected byte[] serialize(Object object) throws IOException {
        byte[] byArray = PassivationUtils.toByteArray(object);
        return byArray;
    }

    private static void notifyAboutToPassivate(Map<String, Object> map, HttpSessionEvent httpSessionEvent) {
        if (map != null) {
            for (Object object : map.values()) {
                if (object instanceof AttributeWrapper) {
                    try {
                        AttributeWrapper attributeWrapper = (AttributeWrapper)object;
                        object = attributeWrapper.getObject(false);
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                    if (object == null) continue;
                }
                if (!(object instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)object).sessionWillPassivate(httpSessionEvent);
            }
        }
    }

    public final void notifyActivated(HttpSessionEvent httpSessionEvent) {
        SessionData.notifyActivated(this.attributes, httpSessionEvent);
        SessionData.notifyActivated(this.transientAttributes, httpSessionEvent);
    }

    private static void notifyActivated(Map<String, Object> map, HttpSessionEvent httpSessionEvent) {
        if (map != null) {
            for (Object object : map.values()) {
                if (object instanceof AttributeWrapper) {
                    try {
                        AttributeWrapper attributeWrapper = (AttributeWrapper)object;
                        object = attributeWrapper.getObject();
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                    if (object == null) continue;
                }
                if (!(object instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)object).sessionDidActivate(httpSessionEvent);
            }
        }
    }

    protected final boolean isProcessed() {
        if (this.processed || unlimited || this.special) {
            return true;
        }
        int[] nArray = (int[])ht.get(this.id);
        int n = 0;
        if (nArray != null) {
            n = nArray[0];
            nArray[0] = ++n;
            this.processed = true;
            return true;
        }
        return this.processed;
    }

    protected final void setProcessed(boolean bl) {
        this.processed = bl;
        if (bl) {
            int[] nArray = (int[])ht.get(this.id);
            int n = 0;
            if (nArray != null) {
                n = nArray[0];
            } else {
                nArray = new int[1];
                SessionData.incrementProcessedSessionsCount();
            }
            nArray[0] = ++n;
            ht.put(this.id, nArray);
        }
    }

    protected static final void checkSpecial(ServletRequestImpl servletRequestImpl, SessionData sessionData) {
        sessionData.special = servletRequestImpl.getContext().isInternalApp();
    }

    public static final synchronized void invalidateProcessedSession(SessionData sessionData) {
        if (unlimited || sessionData.special) {
            return;
        }
        if (sessionData.isProcessed()) {
            int[] nArray = (int[])ht.get(sessionData.id);
            int n = nArray[0];
            if (--n == 0) {
                SessionData.decrementProcessedSessionsCount();
                ht.remove(sessionData.id);
            } else {
                nArray[0] = n;
            }
        }
    }

    static final ConcurrentHashMap<String, Object> convertToConcurrentHashMap(Object object) {
        ConcurrentHashMap<String, Object> concurrentHashMap = null;
        if (object instanceof Hashtable) {
            Map map = (Map)object;
            concurrentHashMap = new ConcurrentHashMap<String, Object>(map);
        } else if (object instanceof Dictionary) {
            Dictionary dictionary = (Dictionary)object;
            concurrentHashMap = new ConcurrentHashMap<String, Object>();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                concurrentHashMap.put(string, dictionary.get(string));
            }
        } else if (object instanceof ConcurrentHashMap) {
            concurrentHashMap = (ConcurrentHashMap<String, Object>)object;
        } else {
            throw new IllegalArgumentException("unkonwn attribute map, and its type is " + object.getClass());
        }
        return concurrentHashMap;
    }

    static final Hashtable<String, Object> convertToHashtable(Map<String, Object> map) {
        if (!(map instanceof Hashtable)) {
            return new Hashtable<String, Object>(map);
        }
        return (Hashtable)map;
    }

    public static final synchronized void incrementProcessedSessionsCount() {
        ++currProcessedSessions;
    }

    public static final synchronized void decrementProcessedSessionsCount() {
        --currProcessedSessions;
    }

    public static final int getCurrProcessedSessionsCount() {
        return currProcessedSessions;
    }

    protected void initVersionAttrsIfNeeded() {
        if (this.versionId != null && this.getInternalAttribute(VERSION_ID) == null) {
            this.setInternalAttribute(VERSION_ID, this.versionId);
        }
    }

    protected void setupVersionIdFromAttrs() {
        if (this.internalAttributes == null) {
            return;
        }
        Object object = this.getInternalAttribute(VERSION_ID, false);
        if (this.versionId == null && object instanceof String) {
            this.versionId = (String)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateVersionIfNeeded(SessionContext sessionContext) {
        String string = (String)this.getInternalAttribute(VERSION_ID);
        if (string == null) {
            return;
        }
        if (sessionContext == null) {
            if (DEBUG_APP_VERSION.isEnabled()) {
                HTTPLogger.logDebug((String)("Cannot find SessionContext of version=" + string + ", using existing version=" + this.versionId + " for id=" + this.id + ", sessionContext is null"));
            }
            return;
        }
        WebAppServletContext webAppServletContext = sessionContext.getServletContext();
        if (webAppServletContext == null) {
            if (DEBUG_APP_VERSION.isEnabled()) {
                HTTPLogger.logDebug((String)("Cannot find SessionContext of version=" + string + ", using existing version=" + this.versionId + " for id=" + this.id + ", servletContext is null"));
            }
            return;
        }
        if (webAppServletContext.getVersionId() == null || webAppServletContext.getVersionId().equals(string)) {
            return;
        }
        String string2 = webAppServletContext.getServer().getName();
        String string3 = webAppServletContext.getContextPath();
        if (string2 == null || string3 == null) {
            if (DEBUG_APP_VERSION.isEnabled()) {
                HTTPLogger.logDebug((String)("Cannot find SessionContext of version=" + string + ", using existing version=" + this.versionId + " for id=" + this.id + ", webServerName or contextPath is null"));
            }
            return;
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            HTTPLogger.logDebug((String)("SessionData with id=" + this.id + " of version=" + this.versionId + " is being rewired to version=" + string));
        }
        String string4 = this.versionId;
        this.sessionContext = null;
        this.versionId = string;
        try {
            this.getContext(string2, string3);
        }
        finally {
            if (this.sessionContext == null) {
                this.sessionContext = sessionContext;
                this.versionId = string4;
                if (DEBUG_APP_VERSION.isEnabled()) {
                    HTTPLogger.logDebug((String)("Cannot find SessionContext of version=" + string + ", using existing version=" + this.versionId));
                }
            }
        }
    }

    public String getMonitoringId() {
        String string = this.sessionContext.getConfigMgr().getMonitoringAttributeName();
        if (string == null) {
            return (String)this.getInternalAttribute("weblogic.servlet.monitoringId");
        }
        Object object = this.getAttribute(string);
        if (object == null) {
            return (String)this.getInternalAttribute("weblogic.servlet.monitoringId");
        }
        return object.toString();
    }

    @Override
    public boolean hasStateAttributes() {
        return this.attributes.size() > 0 || this.internalAttributes != null && (this.internalAttributes.size() > 1 || this.internalAttributes.get("weblogic.workContexts") == null);
    }

    public final void setDebugFlag(boolean bl) {
        if (bl) {
            this.setAttribute(DEBUG_SESSION_INDICATOR, Boolean.TRUE);
        } else {
            this.removeAttribute(DEBUG_SESSION_INDICATOR);
        }
    }

    public final boolean isDebuggingSession() {
        if (HttpServer.isProductionModeEnabled()) {
            return false;
        }
        return this.getAttribute(DEBUG_SESSION_INDICATOR) != null;
    }

    public String toString() {
        if (!this.isValid()) {
            return "HttpSession is invalid: " + this.getId();
        }
        if (!this.isDebuggingSession()) {
            return super.toString();
        }
        return this.dump(true);
    }

    private String dump(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(super.toString()).append(" - \n").append(" session-id: ").append(this.getId()).append('\n').append(" create-time: ").append(new Date(this.creationTime)).append('\n').append(" access-time: ").append(new Date(this.accessTime)).append('\n').append(" max-inactive-interval: ").append(this.maxInactiveInterval).append("\n -");
        this.addUpAttributesTo(this.attributes, stringBuilder);
        this.addUpAttributesTo(this.transientAttributes, stringBuilder);
        if (bl) {
            return stringBuilder.toString();
        }
        this.addUpAttributesTo(this.internalAttributes, stringBuilder);
        this.addUpAttributesTo(this.internalTransientAttributes, stringBuilder);
        return stringBuilder.toString();
    }

    protected final void logSessionAttributeChanged(String string, String string2, Object object, Object object2) {
        object = object == null ? "null" : object;
        object2 = object2 == null ? "null" : object2;
        HTTPSessionLogger.logAttributeChanged((String)string, (String)this.getServletContext().getContextPath(), (String)this.getId(), (String)string2, (String)object.toString(), (String)object2.toString());
    }

    public static final void dumpSessionToLog(HttpSession httpSession) {
        if (httpSession == null) {
            return;
        }
        HTTPSessionLogger.logDumpSession((String)(httpSession instanceof SessionData ? ((SessionData)httpSession).dump(true) : httpSession.toString()));
    }

    private final void addUpAttributesTo(Map<String, Object> map, StringBuilder stringBuilder) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (String string : map.keySet()) {
            stringBuilder.append("\n").append(string).append(": ").append(this.getAttribute(string));
        }
    }

    private void initializeCRC32() {
        if (this.isDebugEnabled() && this.crc == null) {
            this.crc = new CRC32();
        }
    }

    protected static class AttributeInfo {
        int size;
        long checksum = -1L;
        long oldChecksum = -1L;

        protected AttributeInfo() {
        }
    }
}

