/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.IOException;
import java.rmi.UnmarshalException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import weblogic.servlet.internal.session.EJBAttributeWrapper;
import weblogic.servlet.internal.session.EJBHomeAttributeWrapper;
import weblogic.utils.io.Replacer;

public class SessionObjectReplacer
implements Replacer {
    private Replacer nextReplacer;

    public static SessionObjectReplacer getInstance() {
        return SingletonMaker.singleton;
    }

    private SessionObjectReplacer() {
    }

    public void insertReplacer(Replacer replacer) {
        this.nextReplacer = replacer;
    }

    public Object replaceObject(Object object) throws IOException {
        Object object2 = object;
        if (object instanceof EJBHome) {
            EJBHome eJBHome = (EJBHome)object;
            object2 = new EJBHomeAttributeWrapper(eJBHome.getHomeHandle());
        } else if (object instanceof EJBObject) {
            EJBObject eJBObject = (EJBObject)object;
            object2 = new EJBAttributeWrapper(eJBObject.getHandle());
        } else {
            object2 = this.nextReplacer == null ? object : this.nextReplacer.replaceObject(object);
        }
        return object2;
    }

    public Object resolveObject(Object object) throws IOException {
        Object object2 = object;
        if (object instanceof EJBHomeAttributeWrapper) {
            EJBAttributeWrapper eJBAttributeWrapper = (EJBAttributeWrapper)object;
            HomeHandle homeHandle = null;
            try {
                homeHandle = (HomeHandle)eJBAttributeWrapper.getObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnmarshalException("Failed to unmarshal home handle");
            }
            object2 = homeHandle.getEJBHome();
        } else if (object instanceof EJBAttributeWrapper) {
            EJBAttributeWrapper eJBAttributeWrapper = (EJBAttributeWrapper)object;
            Handle handle = null;
            try {
                handle = (Handle)eJBAttributeWrapper.getObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnmarshalException("Failed to unmarshal eo handle");
            }
            object2 = handle.getEJBObject();
        } else {
            object2 = this.nextReplacer == null ? object : this.nextReplacer.resolveObject(object);
        }
        return object2;
    }

    private static class SingletonMaker {
        static final SessionObjectReplacer singleton = new SessionObjectReplacer();

        private SingletonMaker() {
        }
    }
}

