/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.session.HTTPSessionLogger;

final class TargetValidator {
    TargetValidator() {
    }

    static void validateTargetting(WebAppModule webAppModule, String string) throws DeploymentException {
        TargetMBean[] targetMBeanArray = webAppModule.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean instanceof ServerMBean) {
                ClusterMBean clusterMBean = ((ServerMBean)targetMBean).getCluster();
                if (clusterMBean == null) continue;
                if (!TargetValidator.listContainsAllClusterMembers(targetMBeanArray, clusterMBean)) {
                    Loggable loggable = HTTPSessionLogger.logInhomogeneousDeploymentForAppLoggable((String)webAppModule.getId(), (String)webAppModule.getAppDisplayName(), (String)string, (String)clusterMBean.getName());
                    loggable.log();
                    throw new DeploymentException(loggable.getMessage());
                }
            }
            if (!(targetMBean instanceof VirtualHostMBean)) continue;
            TargetValidator.validateTargetting((VirtualHostMBean)targetMBean, webAppModule, string);
        }
    }

    private static void validateTargetting(VirtualHostMBean virtualHostMBean, WebAppModule webAppModule, String string) throws DeploymentException {
        TargetMBean[] targetMBeanArray = virtualHostMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            ClusterMBean clusterMBean;
            TargetMBean targetMBean = targetMBeanArray[i];
            if (!(targetMBean instanceof ServerMBean) || (clusterMBean = ((ServerMBean)targetMBean).getCluster()) == null || TargetValidator.listContainsAllClusterMembers(targetMBeanArray, clusterMBean)) continue;
            Loggable loggable = HTTPSessionLogger.logInhomogeneousDeploymentForVHostLoggable((String)webAppModule.getId(), (String)webAppModule.getAppDisplayName(), (String)string, (String)virtualHostMBean.getName(), (String)clusterMBean.getName());
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private static boolean listContainsAllClusterMembers(TargetMBean[] targetMBeanArray, ClusterMBean clusterMBean) {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (TargetValidator.contains(targetMBeanArray, serverMBeanArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(TargetMBean[] targetMBeanArray, ServerMBean serverMBean) {
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] != serverMBean) continue;
            return true;
        }
        return false;
    }
}

