/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.io.Serializable;
import weblogic.cluster.replication.AsyncReplicatable;
import weblogic.cluster.replication.AsyncReplicationManager;
import weblogic.servlet.internal.session.AsyncReplicatedSessionChange;
import weblogic.servlet.internal.session.ReplicatedSessionChange;
import weblogic.servlet.internal.session.SessionContext;
import weblogic.servlet.internal.session.WANSessionData;

public class WANAsyncSessionData
extends WANSessionData
implements AsyncReplicatable {
    private static final long serialVersionUID = 1539991387938295130L;
    private transient ReplicatedSessionChange asyncChange;
    private boolean blockingFlushCall = false;

    public WANAsyncSessionData() {
    }

    public WANAsyncSessionData(String string, SessionContext sessionContext) {
        this(string, sessionContext, true);
    }

    protected WANAsyncSessionData(String string, SessionContext sessionContext, boolean bl) {
        super(string, sessionContext, bl);
    }

    protected void initializeChange() {
        this.asyncChange = new AsyncReplicatedSessionChange();
    }

    protected ReplicatedSessionChange getSessionChange() {
        return this.asyncChange;
    }

    void syncSession() {
        super.syncSession();
        if (this.blockingFlushCall) {
            ((AsyncReplicationManager)this.getReplicationServices()).blockingFlush();
            this.blockingFlushCall = false;
        }
    }

    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        if (string.equals("weblogic.authuser")) {
            this.blockingFlushCall = true;
        }
    }

    protected Serializable getUpdateObject() {
        return this;
    }

    public void setQueued() {
        ((AsyncReplicatedSessionChange)this.asyncChange).setQueued();
    }

    public boolean isQueued() {
        return ((AsyncReplicatedSessionChange)this.asyncChange).isQueued();
    }

    public Serializable getBatchedChanges() {
        return this.asyncChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        ReplicatedSessionChange replicatedSessionChange = this.asyncChange;
        synchronized (replicatedSessionChange) {
            ((AsyncReplicatedSessionChange)this.asyncChange).commit();
        }
    }
}

