/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import javax.servlet.http.HttpSession;
import weblogic.servlet.cluster.WANPersistenceManager;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.ReplicatedSessionContext;
import weblogic.servlet.internal.session.SessionConfigManager;
import weblogic.servlet.internal.session.SessionData;
import weblogic.servlet.internal.session.WANSessionData;

public final class WANSessionContext
extends ReplicatedSessionContext {
    private final String contextPath = this.getServletContext().getContextPath();

    public WANSessionContext(WebAppServletContext webAppServletContext, SessionConfigManager sessionConfigManager) {
        super(webAppServletContext, sessionConfigManager);
    }

    public String getPersistentStoreType() {
        return "async-replication-across-cluster";
    }

    public HttpSession getNewSession(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        this.checkSessionCount();
        WANSessionData wANSessionData = new WANSessionData(string, this);
        wANSessionData.setMonitoringId();
        return wANSessionData;
    }

    public SessionData getSessionInternal(String string, ServletRequestImpl servletRequestImpl, ServletResponseImpl servletResponseImpl) {
        SessionData sessionData = super.getSessionInternal(string, servletRequestImpl, servletResponseImpl);
        String string2 = RSID.getID(string);
        if (sessionData == null && servletRequestImpl != null && servletResponseImpl != null) {
            WANSessionData wANSessionData = new WANSessionData(string2, this, false);
            if (WANPersistenceManager.getInstance().fetchState(string2, this.contextPath, wANSessionData)) {
                return wANSessionData;
            }
            return null;
        }
        return sessionData;
    }

    public void destroy(boolean bl) {
        for (WANSessionData wANSessionData : this.getOpenSessions().values()) {
            WANPersistenceManager.getInstance().flushUponShutdown(RSID.getID(wANSessionData.getIdWithServerInfo()), wANSessionData.getCreationTime(), wANSessionData.getContextPath(), wANSessionData.getMaxInactiveInterval(), wANSessionData.getLAT(), wANSessionData.getSessionDiff());
        }
        super.destroy(bl);
    }

    public int getNonPersistedSessionCount() {
        return 0;
    }
}

