/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import java.util.HashMap;
import weblogic.servlet.cluster.WANPersistenceManager;
import weblogic.servlet.cluster.wan.SessionDiff;
import weblogic.servlet.internal.session.RSID;
import weblogic.servlet.internal.session.ReplicatedSessionChange;
import weblogic.servlet.internal.session.ReplicatedSessionData;
import weblogic.servlet.internal.session.SessionContext;

public class WANSessionData
extends ReplicatedSessionData {
    private static final long serialVersionUID = -8758624332473471640L;
    private final SessionDiff diff = new SessionDiff();
    private static final String WAN_SESSION_VERSION = "wls_wan_session_version";

    public WANSessionData() {
    }

    public WANSessionData(String string, SessionContext sessionContext) {
        this(string, sessionContext, true);
    }

    protected WANSessionData(String string, SessionContext sessionContext, boolean bl) {
        super(string, sessionContext, bl);
    }

    public void removeInternalAttribute(String string) throws IllegalStateException {
        super.removeInternalAttribute(string);
        this.diff.setAttribute(string, null, false, true);
        super.setInternalAttribute(WAN_SESSION_VERSION, new Integer(this.diff.getVersionCount()));
    }

    public final void setInternalAttribute(String string, Object object) throws IllegalStateException {
        Object object2 = super.getInternalAttribute(string);
        super.setInternalAttribute(string, object);
        this.diff.setAttribute(string, object, object2 == null, true);
        super.setInternalAttribute(WAN_SESSION_VERSION, new Integer(this.diff.getVersionCount()));
    }

    public final void removeAttribute(String string) throws IllegalStateException {
        super.removeAttribute(string);
        this.diff.setAttribute(string, null, false, false);
        super.setInternalAttribute(WAN_SESSION_VERSION, new Integer(this.diff.getVersionCount()));
    }

    public final void setAttribute(String string, Object object) throws IllegalStateException {
        Object object2 = super.getAttribute(string);
        super.setAttribute(string, object);
        this.diff.setAttribute(string, object, object2 == null, false);
        super.setInternalAttribute(WAN_SESSION_VERSION, new Integer(this.diff.getVersionCount()));
    }

    private String getIdWithoutServerInfo() {
        return RSID.getID(this.getIdWithServerInfo());
    }

    public void invalidate() {
        super.invalidate();
        WANPersistenceManager.getInstance().invalidate(this.getIdWithoutServerInfo(), this.getContextPath());
    }

    void remove(boolean bl) {
        super.remove(bl);
        WANPersistenceManager.getInstance().invalidate(this.getIdWithoutServerInfo(), this.getContextPath());
    }

    public SessionDiff getChange() {
        return this.diff;
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    void syncSession() {
        super.syncSession();
        WANPersistenceManager.getInstance().update(this.getIdWithoutServerInfo(), this.getCreationTime(), this.getContextPath(), this.getMaxInactiveInterval(), this.getLAT(), this.diff);
    }

    SessionDiff getSessionDiff() {
        return this.diff;
    }

    public void setSessionCreationTime(long l) {
        this.creationTime = l;
    }

    public void applySessionDiff(SessionDiff sessionDiff) {
        Object object2;
        HashMap hashMap = sessionDiff.getAttributes();
        for (Object object2 : hashMap.keySet()) {
            this.setAttribute((String)object2, hashMap.get(object2));
        }
        object2 = sessionDiff.getInternalAttributes();
        for (String string : ((HashMap)object2).keySet()) {
            this.setInternalAttribute(string, ((HashMap)object2).get(string));
        }
        this.diff.setVersionCounter(sessionDiff.getVersionCount());
    }

    protected void applySessionChange(ReplicatedSessionChange replicatedSessionChange) {
        HashMap hashMap = replicatedSessionChange.getInternalAttributeChanges();
        Integer n = (Integer)hashMap.remove(WAN_SESSION_VERSION);
        if (n != null) {
            this.diff.setVersionCounter(n + 1);
        }
        super.applySessionChange(replicatedSessionChange);
    }
}

