/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.internal.session;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import weblogic.servlet.internal.session.HTTPSessionLogger;
import weblogic.servlet.internal.session.SessionData;

public class WLSessionAttributeChangedListener
implements HttpSessionAttributeListener {
    public final void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (!this.debuggable(httpSessionBindingEvent)) {
            return;
        }
        this.logAttributeEvent("Add new Attribute", httpSessionBindingEvent);
        if ("wl_debug_session".equals(httpSessionBindingEvent.getName())) {
            this.logStartStopDebugging(true, httpSessionBindingEvent.getSession());
        }
    }

    public final void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (!this.debuggable(httpSessionBindingEvent)) {
            return;
        }
        this.logAttributeEvent("Remove Attribute", httpSessionBindingEvent);
        if ("wl_debug_session".equals(httpSessionBindingEvent.getName())) {
            this.logStartStopDebugging(false, httpSessionBindingEvent.getSession());
        }
    }

    public final void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (!this.debuggable(httpSessionBindingEvent)) {
            return;
        }
        this.logAttributeEvent("Replace Attribute", httpSessionBindingEvent);
    }

    private final boolean debuggable(HttpSessionBindingEvent httpSessionBindingEvent) {
        return httpSessionBindingEvent.getSession() != null && httpSessionBindingEvent.getSession() instanceof SessionData;
    }

    private final void logAttributeEvent(String string, HttpSessionBindingEvent httpSessionBindingEvent) {
        SessionData sessionData = (SessionData)httpSessionBindingEvent.getSession();
        if (!sessionData.isDebuggingSession()) {
            return;
        }
        sessionData.logSessionAttributeChanged(string, httpSessionBindingEvent.getName(), httpSessionBindingEvent.getValue(), sessionData.getAttribute(httpSessionBindingEvent.getName()));
    }

    private final void logStartStopDebugging(boolean bl, HttpSession httpSession) {
        String string = httpSession.getServletContext() == null ? "" : httpSession.getServletContext().getContextPath();
        String string2 = bl ? "Start to debug session" : "Stop debugging session";
        HTTPSessionLogger.logDebugSessionEvent((String)string2, (String)string, (String)httpSession.getId());
        SessionData.dumpSessionToLog(httpSession);
    }
}

