/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import weblogic.servlet.internal.CharChunkOutput;
import weblogic.servlet.internal.ChunkOutputWrapper;
import weblogic.servlet.internal.DelegateChunkWriter;
import weblogic.servlet.jsp.ByteWriter;
import weblogic.servlet.jsp.PageContextImpl;

public final class BodyContentImpl
extends BodyContent
implements ByteWriter {
    ChunkOutputWrapper co;
    private CharChunkOutput coimpl;
    PageContextImpl pc;
    private boolean usingWriter;
    private static final String EOL = System.getProperty("line.separator");

    public BodyContentImpl(JspWriter jspWriter, PageContextImpl pageContextImpl, Writer writer) {
        super(jspWriter);
        this.pc = pageContextImpl;
        if (writer == null) {
            ServletResponse servletResponse = pageContextImpl.getResponse();
            this.coimpl = new CharChunkOutput(servletResponse);
            this.coimpl.setStickyBufferSize(true);
            this.co = new ChunkOutputWrapper(this.coimpl);
        } else {
            this.usingWriter = true;
            DelegateChunkWriter.DelegateJspChunkWriter delegateJspChunkWriter = new DelegateChunkWriter.DelegateJspChunkWriter(writer);
            this.co = new ChunkOutputWrapper(delegateJspChunkWriter);
        }
    }

    public void clearBuffer() throws IOException {
        this.co.clearBuffer();
    }

    public void clear() throws IOException {
        if (this.usingWriter) {
            throw new IOException("Cannot call clear() on an unbuffered Writer. ");
        }
        this.co.clearBuffer();
    }

    public void flush() throws IOException {
        if (!this.usingWriter) {
            throw new IOException();
        }
        this.co.flush();
    }

    public void close() throws IOException {
    }

    public int getBufferSize() {
        return this.co.getBufferSize();
    }

    public int getRemaining() {
        if (this.usingWriter) {
            return 0;
        }
        int n = this.co.getBufferSize() - this.co.getCount();
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public boolean isAutoFlush() {
        return true;
    }

    public void newLine() throws IOException {
        this.co.print(EOL);
    }

    public void print(boolean bl) throws IOException {
        this.co.print(String.valueOf(bl));
    }

    public void print(char c) throws IOException {
        this.co.write(c);
    }

    public void print(char[] cArray) throws IOException {
        this.co.write(cArray, 0, cArray.length);
    }

    public void print(double d) throws IOException {
        this.co.print(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this.co.print(String.valueOf(f));
    }

    public void print(int n) throws IOException {
        this.co.print(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.co.print(String.valueOf(l));
    }

    public void print(Object object) throws IOException {
        if (object != null) {
            this.co.print(String.valueOf(object));
        }
    }

    public void print(String string) throws IOException {
        if (string != null) {
            this.co.print(string);
        }
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        if (object != null) {
            this.print(object);
            this.newLine();
        }
    }

    public void println(String string) throws IOException {
        if (string != null) {
            this.print(string);
            this.newLine();
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void write(char[] cArray) throws IOException {
        this.co.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.co.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.co.write(n);
    }

    public void write(String string) throws IOException {
        if (string != null) {
            this.co.print(string);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        this.co.print(string.substring(n, n2));
    }

    public void clearBody() {
        this.co.clearBuffer();
    }

    public Reader getReader() {
        if (this.usingWriter) {
            return null;
        }
        char[] cArray = this.coimpl.getCharBuffer();
        int n = this.coimpl.getCount();
        if (cArray == null || n == 0) {
            return new StringReader("");
        }
        return new CharArrayReader(cArray, 0, n);
    }

    public String getString() {
        if (this.usingWriter) {
            return null;
        }
        String string = "";
        char[] cArray = this.coimpl.getCharBuffer();
        int n = this.coimpl.getCount();
        if (cArray == null || n == 0) {
            return string;
        }
        return new String(cArray, 0, n);
    }

    public void writeOut(Writer writer) throws IOException {
        if (!this.usingWriter) {
            char[] cArray = this.coimpl.getCharBuffer();
            int n = this.coimpl.getCount();
            if (cArray == null || n == 0) {
                return;
            }
            writer.write(cArray, 0, n);
        }
    }

    public void write(byte[] byArray, String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(ByteBuffer byteBuffer, String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void setInitCharacterEncoding(String string, boolean bl) {
    }

    ChunkOutputWrapper getChunkOutputWrapper() {
        return this.co;
    }

    private static void p(String string) {
        System.err.println("[BC]: " + string);
    }
}

