/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import weblogic.servlet.jsp.ELContextImpl;

public class ELHelper {
    public static Object evaluate(String string, Class clazz, PageContext pageContext, FunctionMapper functionMapper) {
        ValueExpression valueExpression = ELHelper.createValueExpression(string, clazz, pageContext, functionMapper);
        return valueExpression.getValue(pageContext.getELContext());
    }

    public static ValueExpression createValueExpression(String string, Class clazz, PageContext pageContext, FunctionMapper functionMapper) {
        ExpressionFactory expressionFactory = ELHelper.getExpressionFactory(pageContext);
        if (string.length() == 0) {
            return expressionFactory.createValueExpression((Object)string, clazz);
        }
        ELContextImpl eLContextImpl = (ELContextImpl)pageContext.getELContext();
        eLContextImpl.setFunctionMapper(functionMapper);
        return expressionFactory.createValueExpression((ELContext)eLContextImpl, string, clazz);
    }

    public static MethodExpression createMethodExpression(String string, Class clazz, Class[] classArray, PageContext pageContext, FunctionMapper functionMapper) {
        ExpressionFactory expressionFactory = ELHelper.getExpressionFactory(pageContext);
        ELContextImpl eLContextImpl = (ELContextImpl)pageContext.getELContext();
        eLContextImpl.setFunctionMapper(functionMapper);
        return expressionFactory.createMethodExpression((ELContext)eLContextImpl, string, clazz, classArray);
    }

    public static void mapValueExpression(PageContext pageContext, String string, ValueExpression valueExpression) {
        ELContext eLContext = pageContext.getELContext();
        eLContext.getVariableMapper().setVariable(string, valueExpression);
    }

    public static void mapMethodExpression(PageContext pageContext, String string, MethodExpression methodExpression) {
        ExpressionFactory expressionFactory = ELHelper.getExpressionFactory(pageContext);
        ValueExpression valueExpression = expressionFactory.createValueExpression((Object)methodExpression, Object.class);
        ELHelper.mapValueExpression(pageContext, string, valueExpression);
    }

    private static ExpressionFactory getExpressionFactory(PageContext pageContext) {
        JspApplicationContext jspApplicationContext = Holder.jspFactory.getJspApplicationContext(pageContext.getServletContext());
        return jspApplicationContext.getExpressionFactory();
    }

    private static class Holder {
        static JspFactory jspFactory = JspFactory.getDefaultFactory();

        private Holder() {
        }
    }
}

