/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.descriptor.DescriptorBean;
import weblogic.html.EntityEscape;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.jsp.compiler.Diagnostic;
import weblogic.jsp.compiler.DiagnosticList;
import weblogic.jsp.compiler.IApplication;
import weblogic.jsp.compiler.ICPL;
import weblogic.jsp.compiler.IClientContext;
import weblogic.jsp.compiler.IJavelin;
import weblogic.jsp.compiler.IJavelinFile;
import weblogic.jsp.compiler.ILanguage;
import weblogic.jsp.compiler.client.ClientUtils;
import weblogic.jsp.compiler.jsp.IJspCompilerOptions;
import weblogic.jsp.internal.html.HtmlLanguageX;
import weblogic.jsp.internal.jsp.JspLanguageX;
import weblogic.jsp.internal.jsp.options.JspCompilerOptionsX;
import weblogic.jsp.internal.jsp.utils.JavaTransformUtils;
import weblogic.jsp.languages.java.IJavaLanguage;
import weblogic.jsp.wlw.filesystem.IFile;
import weblogic.jsp.wlw.util.filesystem.FS;
import weblogic.servlet.internal.RequestCallback;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.CompilationException;
import weblogic.servlet.jsp.JspCLLManager;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspFileNotFoundException;
import weblogic.servlet.jsp.JspStub;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.Source;

public class JavelinxJSPStub
extends JspStub {
    private static final boolean verboseload = Boolean.getBoolean("weblogic.jsp.javelin.verboseload");

    public JavelinxJSPStub(String string, String string2, Map map, WebAppServletContext webAppServletContext, JspConfig jspConfig) {
        super(string, string2, map, webAppServletContext, jspConfig);
    }

    protected URI getFileToCompileURI(String string) throws Exception {
        WarSource warSource = this.getContext().getResourceAsSource(string);
        if (warSource == null) {
            throw new JspFileNotFoundException("no resource '" + string + "' in servlet context root '" + this.getContext().getDocroot() + "'");
        }
        return JavelinxJSPStub.getAbsoluteJspURI(warSource, string);
    }

    protected URI[] prepareDocRoots(String string) throws IOException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        String[] stringArray = this.getSourcePaths(string);
        if (stringArray != null && stringArray.length > 0) {
            IFile[] iFileArray = new IFile[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]).getCanonicalFile();
                iFileArray[i] = FS.getIFile((File)file);
                if (iFileArray[i] == null) continue;
                arrayList.add(iFileArray[i].getURI());
            }
        } else {
            String string2 = this.getContext().getDocroot();
            IFile iFile = FS.getIFile((File)new File(string2));
            if (iFile != null) {
                arrayList.add(iFile.getURI());
            }
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    protected String[] getSourcePaths(String string) {
        WarSource warSource = this.getContext().getResourceAsSource(string);
        if (warSource != null && "file".equals(warSource.getURL().getProtocol())) {
            String string2 = this.getContext().getResourceFinder(string).getClassPath();
            return StringUtils.splitCompletely((String)string2, (String)File.pathSeparator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compilePage(RequestCallback requestCallback) throws Exception {
        String string = this.getRequestURI(requestCallback);
        URI uRI = this.getFileToCompileURI(string);
        URI[] uRIArray = this.prepareDocRoots(string);
        WebAppBean webAppBean = this.getContext().getWebAppModule().getWebAppBean();
        String string2 = ((DescriptorBean)webAppBean).getDescriptor().getOriginalVersionInfo();
        IJavelin iJavelin = this.prepareJavelin(string2);
        JspCLLManager.JspClientContext jspClientContext = new JspCLLManager.JspClientContext();
        IApplication iApplication = iJavelin.createApplication("JSPStubx", (IClientContext)jspClientContext);
        ICPL iCPL = iApplication.createCPL("CPL");
        try {
            IJspCompilerOptions iJspCompilerOptions = JspCompilerOptionsX.createFeature((ICPL)iCPL);
            if (this.getContext().getConfigManager().useDefaultEncoding() && this.jsps.getEncoding() == null) {
                this.jsps.setEncoding(this.getContext().getConfigManager().getDefaultEncoding());
            }
            JspCLLManager.setUpCompilerOptions(iJspCompilerOptions, this.jsps);
            JspCLLManager.makeConfigFeature(webAppBean, iCPL, this.getContext().getJSPManager().getJspExtensions());
            this.prepareCPLClasspath(iCPL);
            iCPL.setClassLoader((ClassLoader)((Object)this.getContext().getTagFileHelper().getTagFileClassLoader()));
            JspCLLManager.setWebAppProjectFeature(iCPL, this.getContext().getContextPath(), uRIArray, string2, JspCLLManager.getVirtualRootsInfo(this.getContext().getWebAppModule().getWlWebAppBean()), this.resourceProvider);
            Set set = new HashSet<IFile>();
            IFile iFile = FS.getIFile((URI)uRI);
            set.add(iFile);
            iCPL.addSourceFiles(set);
            set = iCPL.getSourceFiles();
            HashSet hashSet = new HashSet();
            Map map = this.prepareBuildOptions();
            IFile iFile2 = FS.getIFile((File)new File(this.jsps.getWorkingDir()));
            while (set.size() > 0) {
                hashSet.addAll(set);
                ClientUtils.get((IApplication)iApplication).build(iCPL, set, iFile2, map);
                set.addAll(iCPL.getSourceFiles());
                set.removeAll(hashSet);
            }
            ClientUtils.get((IApplication)iApplication).buildPrototypes(iCPL, iFile2, map);
            this.reportCompilationErrorIfNeccessary(iCPL, jspClientContext, requestCallback, string, hashSet);
        }
        finally {
            ClientUtils.get((IApplication)iApplication).closeAndWait();
        }
    }

    private void reportCompilationErrorIfNeccessary(ICPL iCPL, JspCLLManager.JspClientContext jspClientContext, RequestCallback requestCallback, String string, Set set) throws IOException {
        StringBuilder stringBuilder = this.getInternalErrors(jspClientContext);
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        Map map = iCPL.getFilesWithDiagnostics();
        if (stringBuilder != null || map != null && map.size() > 0) {
            Object object;
            stringBuffer = new StringBuffer();
            stringBuffer2 = new StringBuffer();
            boolean bl = false;
            if (stringBuilder != null) {
                this.appendErrorMessageHeader(stringBuffer2, string);
                stringBuffer.append((CharSequence)stringBuilder);
                bl = true;
            }
            if (map != null && map.size() > 0) {
                for (Map.Entry object2 : map.entrySet()) {
                    DiagnosticList diagnosticList;
                    List list;
                    int n;
                    object = (IJavelinFile)object2.getKey();
                    if (object.isBinary() || object2.getValue() == null || !set.contains(object) || (n = (list = (diagnosticList = (DiagnosticList)object2.getValue()).get(true, Diagnostic.Severity.ERROR)).size()) <= 0) continue;
                    if (!bl) {
                        bl = true;
                        this.appendErrorMessageHeader(stringBuffer2, string);
                    }
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    diagnosticList.print(true, JavaTransformUtils.isDiagnosticWithAbsolutePath ? object.getIFile().getDisplayPath() : object.getName(), printWriter, true, Diagnostic.Severity.ERROR);
                    stringBuffer.append(stringWriter.toString());
                }
            }
            if (bl) {
                String string2 = stringBuffer.toString();
                EntityEscape.escapeString(string2, stringBuffer2);
                stringBuffer2.append("</pre>\n</body></html>\n");
                String string3 = stringBuffer2.toString();
                this.getContext().log(string2);
                object = new CompilationException("Failed to compile JSP " + string, string, string2, string3, null);
                if (this.jsps.isVerbose() && !this.isErrorPageDefined(500) && !this.isErrorPageDefined((Throwable)object)) {
                    requestCallback.reportJSPCompilationFailure(string2, string3);
                }
                this.destroy();
                throw object;
            }
        }
    }

    private Map prepareBuildOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.jsps.isKeepGenerated()) {
            hashMap.put("-keepGenerated", "true");
            hashMap.put("-s", new File(this.jsps.getWorkingDir()).getAbsolutePath());
        }
        return hashMap;
    }

    private StringBuilder getInternalErrors(JspCLLManager.JspClientContext jspClientContext) {
        StringBuilder stringBuilder = null;
        if (jspClientContext.hasException()) {
            stringBuilder = new StringBuilder("Exception occurred while processing '");
            stringBuilder.append(jspClientContext.getPath());
            stringBuilder.append("'");
            Throwable throwable = jspClientContext.getException();
            if (throwable != null) {
                stringBuilder.append(StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
        return stringBuilder;
    }

    private void prepareCPLClasspath(ICPL iCPL) {
        ArrayList arrayList = new ArrayList();
        this.addPaths(arrayList, this.getContext().getFullClasspath());
        iCPL.initializeBinaryPaths(arrayList);
    }

    private IJavelin prepareJavelin(String string) {
        IJavelin iJavelin = this.createJaveLin(verboseload, false);
        iJavelin.addLanguage((ILanguage)new JspLanguageX(iJavelin));
        iJavelin.addLanguage((ILanguage)new HtmlLanguageX(iJavelin));
        float f = 0.0f;
        if (string != null) {
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        IJavaLanguage iJavaLanguage = (IJavaLanguage)iJavelin.getLanguage("java");
        if (this.jsps.isDebugEnabled()) {
            iJavaLanguage.setEmitDebug(7);
        }
        if ((double)f < 2.4 && iJavaLanguage != null) {
            iJavaLanguage.setJSPBackCompat(true);
        }
        return iJavelin;
    }

    protected IJavelin createJaveLin(boolean bl, boolean bl2) {
        return ClientUtils.createCommandLineJavelin((boolean)bl, (boolean)false, (boolean)false);
    }

    private void appendErrorMessageHeader(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<html>\n<head>\n<title>Weblogic JSP compilation error</title>\n</head>\n<body>\n");
        stringBuffer.append("<b>Compilation of JSP File '");
        stringBuffer.append(string);
        stringBuffer.append("' <font color=#FF0000>failed</font>:</b><HR><pre>\n");
    }

    private boolean isErrorPageDefined(int n) {
        return this.getContext().getErrorManager().getErrorLocation(String.valueOf(n)) != null;
    }

    private boolean isErrorPageDefined(Throwable throwable) {
        return this.getContext().getErrorManager().getExceptionLocation(throwable) != null;
    }

    private void addPaths(List list, String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (!file.exists()) continue;
            list.add(FS.getIFile((File)file));
        }
    }

    static URI getAbsoluteJspURI(Source source, String string) throws CompilationException {
        URL uRL = source.getURL();
        String string2 = uRL.getProtocol();
        if ("file".equals(string2)) {
            return new File(uRL.getPath()).toURI();
        }
        if ("zip".equals(string2)) {
            String string3 = uRL.toString();
            int n = string3.indexOf("!/");
            if (n == -1) {
                String string4 = "JSP source=" + string3 + " can't be loaded";
                throw new CompilationException(string4, string, "", "", null);
            }
            String string5 = string3.substring("zip:".length());
            if (string5.charAt(0) != '/') {
                string5 = "/" + string5;
            }
            try {
                return new URI("war:file:" + string5);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string6 = "JSP source URI syntax error: URI: " + string5 + ", error: " + uRISyntaxException.getMessage();
                throw new CompilationException(string6, string, "", "", null);
            }
        }
        String string7 = "JSP source in an unsupported form: URL=" + source.getCodeSourceURL() + " Source class=" + source.getClass().getName();
        throw new CompilationException(string7, string, "", "", null);
    }

    static {
        FS.initializeForJSP();
    }
}

