/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import weblogic.j2ee.descriptor.JspConfigBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.JSPServlet;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.JSPPrecompiler;
import weblogic.servlet.jsp.JspCLLManager;
import weblogic.servlet.jsp.JspClassLoader;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspStub;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.ResourceEnumerator;

public class JavelinxJspPrecompiler
implements JSPPrecompiler {
    private WebAppServletContext servletContext;
    private ResourceEnumerator resourceEnumerator;
    private File workingDir = null;
    private JspConfig config;
    private StubCompilerContext compilerContext;

    public void compile(WebAppServletContext webAppServletContext, File file) throws Exception {
        this.init(webAppServletContext, file, webAppServletContext.getJSPManager().createJspConfig());
        this.compileAll();
    }

    private void init(WebAppServletContext webAppServletContext, File file, JspConfig jspConfig) {
        Object[] objectArray;
        this.servletContext = webAppServletContext;
        this.compilerContext = new StubCompilerContext(webAppServletContext);
        String string = jspConfig.getWorkingDir();
        WebAppBean webAppBean = webAppServletContext.getWebAppModule().getWebAppBean();
        JspConfigBean[] jspConfigBeanArray = webAppBean.getJspConfigs();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("*.jsp", "*.jsp");
        hashMap.put("*.jspx", "*.jspx");
        for (int i = 0; i < jspConfigBeanArray.length; ++i) {
            objectArray = jspConfigBeanArray[i].getJspPropertyGroups();
            for (int j = 0; j < objectArray.length; ++j) {
                String[] stringArray = objectArray[j].getUrlPatterns();
                for (int k = 0; k < stringArray.length; ++k) {
                    if (hashMap.get(stringArray[k]) != null) continue;
                    hashMap.put(stringArray[k], stringArray[k]);
                }
            }
        }
        this.workingDir = string != null ? new File(string.replace('/', File.separatorChar)) : webAppServletContext.getRootTempDir();
        String[] stringArray = new String[]{"*.html", "/classes/*"};
        objectArray = hashMap.keySet().toArray(new String[hashMap.size()]);
        this.resourceEnumerator = ResourceEnumerator.makeInstance((File)file, (String[])stringArray, (String[])objectArray);
        webAppServletContext.addClassPath(this.workingDir.getAbsolutePath());
        this.config = jspConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAll() throws Exception {
        String string = this.config.getPackagePrefix();
        if (string == null) {
            string = "jsp_servlet";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = null;
            while ((string2 = this.resourceEnumerator.getNextURI()) != null) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                if (this.needsCompilation(string2, string)) {
                    arrayList.add(string2);
                    continue;
                }
                HTTPLogger.logJSPClassUptodate((String)this.servletContext.getAppDisplayName(), (String)string2);
            }
        }
        finally {
            this.resourceEnumerator.close();
        }
        int n = 50;
        int n2 = arrayList.size();
        int n3 = n;
        for (int i = 0; i < n2; i += n3) {
            int n4 = Math.min(n3, n2 - i);
            int n5 = i;
            int n6 = i + n4;
            List list = arrayList.subList(n5, n6);
            JspCLLManager.compileJsps(list, this.compilerContext);
        }
    }

    private boolean needsCompilation(String string, String string2) {
        Class<?> clazz = null;
        try {
            String string3 = JSPServlet.uri2classname(string2, string);
            ClassLoader classLoader = this.makeLoader(string3);
            clazz = classLoader.loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            HTTPLogger.logPrecompilingJspNoClass((String)this.servletContext.getAppDisplayName(), (String)string);
            return true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (clazz != null && JspStub.isJSPClassStale(clazz, this.servletContext)) {
            HTTPLogger.logPrecompilingStaleJsp((String)this.servletContext.getAppDisplayName(), (String)string);
            return true;
        }
        return false;
    }

    private ClassLoader makeLoader(String string) {
        GenericClassLoader genericClassLoader = (GenericClassLoader)this.servletContext.getServletClassLoader();
        ClassFinder classFinder = genericClassLoader.getClassFinder();
        JspClassLoader jspClassLoader = new JspClassLoader(classFinder, (ClassLoader)genericClassLoader, string);
        jspClassLoader.addClassFinderFirst((ClassFinder)new ClasspathClassFinder2(this.config.getWorkingDir()));
        return jspClassLoader;
    }

    static class StubCompilerContext
    implements JspCLLManager.IJSPCompilerContext {
        private WebAppServletContext context;

        StubCompilerContext(WebAppServletContext webAppServletContext) {
            this.context = webAppServletContext;
        }

        public ClassLoader getClassLoader() {
            return this.context.getTagFileHelper().getTagFileClassLoader();
        }

        public Source getSource(String string) {
            return this.context.getResourceAsSource(string);
        }

        public String getClasspath() {
            return this.context.getFullClasspath();
        }

        public JspConfig getJspConfig() {
            return this.context.getJSPManager().createJspConfig();
        }

        public String[] getSourcePaths() {
            String string = this.context.getResourceFinder("/").getClassPath();
            return StringUtils.splitCompletely((String)string, (String)File.pathSeparator);
        }

        public WebAppBean getWebAppBean() {
            return this.context.getWebAppModule().getWebAppBean();
        }

        public WeblogicWebAppBean getWlWebAppBean() {
            return this.context.getWebAppModule().getWlWebAppBean();
        }

        public String getName() {
            return this.context.getName();
        }

        public WebAppServletContext getServletContext() {
            return this.context;
        }

        public String getContextPath() {
            return this.context.getContextPath();
        }

        public void say(String string) {
        }

        public void sayError(String string, String string2) {
            HTTPLogger.logJSPPrecompileErrors((String)this.context.getAppDisplayName(), (String)string, (String)string2);
        }

        public Set getAdditionalExtensions() {
            return null;
        }
    }
}

