/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.net.URI;
import weblogic.jsp.compiler.jsp.IWebAppProjectFeature;
import weblogic.jsp.wlw.filesystem.IFile;
import weblogic.jsp.wlw.util.filesystem.FS;
import weblogic.servlet.jsp.JspClassLoader;
import weblogic.servlet.jsp.JspStub;
import weblogic.servlet.jsp.StaleChecker;
import weblogic.servlet.jsp.TagFileClassLoader;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.version;

public class JavelinxTagFileStaleChecker
implements StaleChecker {
    private static final boolean debug = false;
    private final IWebAppProjectFeature webapp;

    public JavelinxTagFileStaleChecker(IWebAppProjectFeature iWebAppProjectFeature) {
        this.webapp = iWebAppProjectFeature;
    }

    public boolean isResourceStale(String string, long l, String string2, String string3) {
        if (!version.getReleaseBuildVersion().equals(string2)) {
            return true;
        }
        URI uRI = this.webapp.findResource(string);
        IFile iFile = FS.getIFile((URI)uRI);
        return l < iFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClassStale(String string, ClassLoader classLoader, IWebAppProjectFeature iWebAppProjectFeature) {
        Object object;
        if (!(classLoader instanceof GenericClassLoader)) {
            return true;
        }
        boolean bl = false;
        JspClassLoader jspClassLoader = null;
        try {
            jspClassLoader = new JspClassLoader(((GenericClassLoader)classLoader).getClassFinder(), classLoader, string);
            object = jspClassLoader.loadClass(string);
            bl = JspStub.isJSPClassStale(object, new JavelinxTagFileStaleChecker(iWebAppProjectFeature));
        }
        catch (Throwable throwable) {
            bl = true;
        }
        finally {
            jspClassLoader = null;
        }
        if (bl && classLoader instanceof TagFileClassLoader) {
            object = (TagFileClassLoader)((Object)classLoader);
            object.forceToBounce();
        }
        return bl;
    }
}

