/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.util.ArrayList;
import java.util.List;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;
import weblogic.servlet.jsp.ELContextImpl;
import weblogic.servlet.jsp.JspConfig;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static ExpressionFactory exprFactory = JspConfig.COMMON_UTILS.getExpressionFactory();
    private ServletContext context;
    private List listeners;
    private CompositeELResolver resolver;
    private CompositeELResolver appResolver;
    private boolean contextStarted;

    public JspApplicationContextImpl(ServletContext servletContext) {
        this.context = servletContext;
        this.listeners = new ArrayList();
        this.appResolver = new CompositeELResolver();
        this.resolver = new CompositeELResolver();
        this.initELResolver();
    }

    public void addELContextListener(ELContextListener eLContextListener) {
        if (eLContextListener != null) {
            this.listeners.add(eLContextListener);
        }
    }

    public void addELResolver(ELResolver eLResolver) {
        if (this.contextStarted) {
            throw new IllegalStateException("It is illegal to register an ELResolver after all ServletContextListeners have had their contextInitialized methods invoked.");
        }
        if (eLResolver != null) {
            this.appResolver.add(eLResolver);
        }
    }

    public ExpressionFactory getExpressionFactory() {
        return exprFactory;
    }

    public void setContextStarted(boolean bl) {
        this.contextStarted = bl;
    }

    public ELContextImpl createELContext(JspContext jspContext) {
        ELContextImpl eLContextImpl = new ELContextImpl((ELResolver)this.resolver, JspConfig.COMMON_UTILS.getVariableMapper(), null);
        eLContextImpl.putContext(JspContext.class, jspContext);
        for (ELContextListener eLContextListener : this.listeners) {
            eLContextListener.contextCreated(new ELContextEvent((ELContext)eLContextImpl));
        }
        return eLContextImpl;
    }

    private void initELResolver() {
        this.resolver.add((ELResolver)new ImplicitObjectELResolver());
        if (this.appResolver != null) {
            this.resolver.add((ELResolver)this.appResolver);
        }
        this.resolver.add((ELResolver)new MapELResolver());
        this.resolver.add((ELResolver)new ResourceBundleELResolver());
        this.resolver.add((ELResolver)new ListELResolver());
        this.resolver.add((ELResolver)new ArrayELResolver());
        this.resolver.add((ELResolver)new BeanELResolver());
        this.resolver.add((ELResolver)new ScopedAttributeELResolver());
    }
}

