/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.jsp.provider.JspResourceProvider;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.JspConfigBean;
import weblogic.j2ee.descriptor.JspPropertyGroupBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.VirtualDirectoryMappingBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.jsp.compiler.Diagnostic;
import weblogic.jsp.compiler.DiagnosticList;
import weblogic.jsp.compiler.IApplication;
import weblogic.jsp.compiler.ICPL;
import weblogic.jsp.compiler.IClientContext;
import weblogic.jsp.compiler.IJavelin;
import weblogic.jsp.compiler.IJavelinFile;
import weblogic.jsp.compiler.ILanguage;
import weblogic.jsp.compiler.ISourceFile;
import weblogic.jsp.compiler.client.ClientUtils;
import weblogic.jsp.compiler.jsp.IJspCompilerOptions;
import weblogic.jsp.compiler.jsp.IJspConfigFeature;
import weblogic.jsp.compiler.jsp.IWebAppProjectFeature;
import weblogic.jsp.internal.css.CSSLanguage;
import weblogic.jsp.internal.html.HtmlLanguageX;
import weblogic.jsp.internal.jsp.JspLanguageX;
import weblogic.jsp.internal.jsp.config.JspConfigFeatureX;
import weblogic.jsp.internal.jsp.config.JspPropertyGroup;
import weblogic.jsp.internal.jsp.config.JspPropertySet;
import weblogic.jsp.internal.jsp.config.URLPattern;
import weblogic.jsp.internal.jsp.options.JspCompilerOptionsX;
import weblogic.jsp.internal.jsp.utils.JavaTransformUtils;
import weblogic.jsp.languages.java.IJavaLanguage;
import weblogic.jsp.wlw.filesystem.IFile;
import weblogic.jsp.wlw.filesystem.IFileFilter;
import weblogic.jsp.wlw.util.filesystem.FS;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.CompilationException;
import weblogic.servlet.jsp.JavelinxJSPStub;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.utils.StringUtils;
import weblogic.utils.classloaders.Source;

public class JspCLLManager {
    static final IJavelin JAVELIN = ClientUtils.createCommandLineJavelin((boolean)false);
    private static boolean EXTRA_SAVE_USE_BEAN;
    private static boolean DISABLE_SMAP;
    private static final int MAX_DIAGNOSTIC_ERRORS = 100;
    private IJSPCompilerContext compilerContext;
    private IApplication application;
    private ICPL cll;
    private IFile workingDir;
    private boolean addTemporaryCPL;
    private boolean isClosed;
    private boolean keepGenerated;
    private Set _tagFiles;
    private Map _tagFilesModified = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileJsps(List list, IJSPCompilerContext iJSPCompilerContext) throws CompilationException {
        JspCLLManager jspCLLManager = null;
        boolean bl = true;
        try {
            Object object;
            jspCLLManager = new JspCLLManager(iJSPCompilerContext);
            JspConfig jspConfig = iJSPCompilerContext.getJspConfig();
            Set<IFile> set = new HashSet();
            HashSet hashSet = new HashSet();
            StringWriter stringWriter = null;
            for (String string : list) {
                IFile iFile;
                object = iJSPCompilerContext.getSource(string);
                if (object == null) {
                    iJSPCompilerContext.sayError(string, " Cannot find " + string + " in the given docroot");
                    continue;
                }
                URI uRI = JavelinxJSPStub.getAbsoluteJspURI(object, string);
                if (uRI == null || (iFile = FS.getIFile((URI)uRI)) == null) continue;
                iJSPCompilerContext.say(string);
                set.add(iFile);
                jspCLLManager.getCLL().addSourceFile(iFile);
            }
            set = jspCLLManager.getCLL().getSourceFiles();
            boolean bl2 = false;
            try {
                bl2 = !jspCLLManager.build(set, null, hashSet);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bl2 || jspCLLManager.getCLL().getFilesWithDiagnostics().size() > 0) {
                boolean bl3;
                if (stringWriter == null) {
                    stringWriter = new StringWriter();
                }
                if (bl3 = jspCLLManager.addDiagnostics(true, stringWriter, hashSet)) {
                    bl = false;
                    object = stringWriter.getBuffer().toString();
                    if (!jspConfig.isPrecompileContinue()) {
                        throw new CompilationException((String)object, null, "", null, null);
                    }
                    iJSPCompilerContext.sayError("jspURI", (String)object);
                    if (stringWriter != null) {
                        stringWriter.getBuffer().setLength(0);
                    }
                    hashSet.clear();
                    set.clear();
                }
            }
        }
        finally {
            if (jspCLLManager != null) {
                jspCLLManager.close();
            }
        }
        return bl;
    }

    public JspCLLManager(IJSPCompilerContext iJSPCompilerContext) {
        this(iJSPCompilerContext, false);
    }

    public JspCLLManager(IJSPCompilerContext iJSPCompilerContext, boolean bl) {
        this.addTemporaryCPL = bl;
        this.compilerContext = iJSPCompilerContext;
        this.initialize();
    }

    private void initialize() {
        this.initCPL();
        this.initCompilerOptions();
        this.initConfigOptions();
        this.initPaths();
    }

    public ICPL getCLL() {
        return this.cll;
    }

    public boolean build(Set set, IFile iFile, Set set2) throws InterruptedException {
        Map map = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.keepGenerated) {
            hashMap.put("-keepGenerated", "true");
            hashMap.put("-s", this.workingDir.getFile().getAbsolutePath());
        }
        while (set.size() > 0) {
            set2.addAll(set);
            map = null;
            map = ClientUtils.get((IApplication)this.application).build(this.cll, set, this.workingDir, hashMap);
            set.addAll(this.cll.getSourceFiles());
            set.removeAll(set2);
        }
        map.putAll(ClientUtils.get((IApplication)this.application).buildPrototypes(this.cll, this.workingDir, hashMap));
        return !ClientUtils.hasErrors(map);
    }

    public boolean addDiagnostics(boolean bl, Writer writer, Set set) {
        Object object;
        Object object22;
        boolean bl2 = false;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object22 : set) {
            if (object22 instanceof ISourceFile) {
                object = (ISourceFile)object22;
                if (object.getCreator() != null) {
                    hashSet.add(object.getCreator().getIFile());
                    continue;
                }
                hashSet.add(object.getIFile());
                continue;
            }
            hashSet.add(object22);
        }
        object22 = this.cll.getFilesWithDiagnostics();
        object = null;
        PrintWriter printWriter = null;
        for (Map.Entry entry : object22.entrySet()) {
            List list;
            int n;
            DiagnosticList diagnosticList;
            IJavelinFile iJavelinFile = (IJavelinFile)entry.getKey();
            if (iJavelinFile.isBinary() || !hashSet.contains(iJavelinFile.getIFile()) || (diagnosticList = (DiagnosticList)entry.getValue()) == null || (n = (list = diagnosticList.get(true, Diagnostic.Severity.ERROR)).size()) <= 0) continue;
            bl2 = true;
            if (printWriter == null) {
                printWriter = new PrintWriter(writer);
            }
            if (object == null) {
                object = new DiagnosticMessageLimitFilter(100);
            }
            diagnosticList.print(true, JavaTransformUtils.isDiagnosticWithAbsolutePath ? iJavelinFile.getIFile().getDisplayPath() : iJavelinFile.getName(), printWriter, bl, Diagnostic.Severity.ERROR, (DiagnosticList.Filter)object);
            if (!((DiagnosticMessageLimitFilter)object).isMax()) continue;
            break;
        }
        return bl2;
    }

    public synchronized void close() {
        try {
            if (!this.isClosed) {
                ClientUtils.get((IApplication)this.application).close();
            }
            this.cll = null;
            this.application = null;
            this.isClosed = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void initCPL() {
        String string = this.compilerContext.getName();
        if (this.addTemporaryCPL) {
            string = string + System.currentTimeMillis();
        }
        try {
            this.application = JAVELIN.createApplication(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            this.application = JAVELIN.createApplication(string + System.currentTimeMillis());
        }
        this.cll = this.application.createCPL("CPL");
    }

    private void initCompilerOptions() {
        IJspCompilerOptions iJspCompilerOptions = JspCompilerOptionsX.createFeature((ICPL)this.cll);
        JspConfig jspConfig = this.compilerContext.getJspConfig();
        String string = jspConfig.getWorkingDir();
        IJavaLanguage iJavaLanguage = JAVELIN.getJavaLanguage();
        if (DISABLE_SMAP) {
            iJavaLanguage.setEmitDebug(0);
        } else if (jspConfig.isDebugEnabled()) {
            iJavaLanguage.setEmitDebug(7);
        }
        this.workingDir = FS.getIFile((File)new File(string));
        this.keepGenerated = jspConfig.isKeepGenerated();
        JspCLLManager.setUpCompilerOptions(iJspCompilerOptions, jspConfig);
        this.cll.setClassLoader(this.compilerContext.getClassLoader());
    }

    static void setUpCompilerOptions(IJspCompilerOptions iJspCompilerOptions, JspConfig jspConfig) {
        String string;
        String string2 = jspConfig.getSuperClassName();
        if (string2 == null || "".equals(string2)) {
            string2 = "weblogic.servlet.jsp.JspBase";
        }
        if ((string = jspConfig.getPackagePrefix()) == null) {
            string = "jsp_servlet";
        }
        iJspCompilerOptions.setCompilerOption("disableEnsureAppDeployment", "true");
        iJspCompilerOptions.setCompilerOption("packagePrefix", string);
        iJspCompilerOptions.setCompilerOption("superclass", string2);
        iJspCompilerOptions.setCompilerOption("keepgenerated", Boolean.toString(jspConfig.isKeepGenerated()));
        iJspCompilerOptions.setCompilerOption("printNulls", Boolean.toString(jspConfig.isPrintNulls()));
        iJspCompilerOptions.setCompilerOption("compilerSupportsEncoding", Boolean.toString(jspConfig.isCompilerSupportsEncoding()));
        iJspCompilerOptions.setCompilerOption("backwardCompatible", Boolean.toString(jspConfig.isBackwardCompatible()));
        iJspCompilerOptions.setCompilerOption("rtexprvalueJspParamName", Boolean.toString(jspConfig.isRtexprvalueJspParamName()));
        iJspCompilerOptions.setCompilerOption("compressHtmlTemplate", Boolean.toString(jspConfig.isCompressHtmlTemplate()));
        iJspCompilerOptions.setCompilerOption("optimizeJavaExpression", Boolean.toString(jspConfig.isOptimizeJavaExpression()));
        iJspCompilerOptions.setCompilerOption("useByteBuffer", Boolean.toString(jspConfig.useByteBuffer()));
        if (jspConfig.getCompiler() != null) {
            iJspCompilerOptions.setCompilerOption("compiler", jspConfig.getCompiler());
        }
        if (jspConfig.getEncoding() != null) {
            iJspCompilerOptions.setCompilerOption("jspEncoding", jspConfig.getEncoding());
        }
        if (EXTRA_SAVE_USE_BEAN) {
            iJspCompilerOptions.setCompilerOption("extraSaveBeanToContext", "true");
        }
    }

    private void initConfigOptions() {
        WebAppBean webAppBean = this.compilerContext.getWebAppBean();
        IJspConfigFeature iJspConfigFeature = JspCLLManager.makeConfigFeature(webAppBean, this.cll, this.compilerContext.getAdditionalExtensions());
    }

    private void initPaths() {
        ArrayList arrayList = new ArrayList();
        this.addPaths(arrayList, this.compilerContext.getClasspath());
        this.cll.initializeBinaryPaths(arrayList);
        this._tagFiles = new HashSet();
        String[] stringArray = this.compilerContext.getSourcePaths();
        ArrayList<URI> arrayList2 = new ArrayList<URI>();
        if (stringArray != null && stringArray.length > 0) {
            IFile[] iFileArray = new IFile[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                iFileArray[i] = FS.getIFile((File)new File(stringArray[i]));
                if (iFileArray[i] == null) continue;
                arrayList2.add(iFileArray[i].getCanonicalIFile().getURI());
            }
        }
        this.cll.setFeature(IWebAppProjectFeature.class, (Object)new WebAppProjectFeatureImpl(this.cll, this.compilerContext.getContextPath(), arrayList2.toArray(new URI[arrayList2.size()]), JspCLLManager.getWebAppVersion(this.compilerContext.getWebAppBean()), JspCLLManager.getVirtualRootsInfo(this.compilerContext.getWlWebAppBean())));
    }

    private static boolean isWebAppVersionGE2dot4(WebAppBean webAppBean) {
        boolean bl = false;
        String string = JspCLLManager.getWebAppVersion(webAppBean);
        try {
            bl = Double.parseDouble(string) >= 2.4;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static String getWebAppVersion(WebAppBean webAppBean) {
        if (webAppBean == null) {
            return "2.5";
        }
        return ((DescriptorBean)webAppBean).getDescriptor().getOriginalVersionInfo();
    }

    private boolean isTagFileStale(IFile iFile) {
        Object v = this._tagFilesModified.get(iFile);
        if (v == null || (Long)v < iFile.lastModified()) {
            this._tagFilesModified.put(iFile, new Long(iFile.lastModified()));
            return true;
        }
        return false;
    }

    static IJspConfigFeature makeConfigFeature(WebAppBean webAppBean, ICPL iCPL, Set set) {
        JspPropertyGroupBean[] jspPropertyGroupBeanArray;
        JspConfigBean jspConfigBean;
        Object object;
        ArrayList arrayList = new ArrayList();
        if (webAppBean != null && (object = webAppBean.getJspConfigs()) != null && ((JspConfigBean[])object).length > 0 && (jspConfigBean = object[0]) != null && (jspPropertyGroupBeanArray = jspConfigBean.getJspPropertyGroups()) != null) {
            for (int i = 0; i < jspPropertyGroupBeanArray.length; ++i) {
                JspCLLManager.fillPropertyGroups(jspPropertyGroupBeanArray[i], arrayList);
            }
        }
        if ((object = JspCLLManager.fillDefaultGroups(set)) != null) {
            arrayList.addAll(object);
        }
        return JspConfigFeatureX.createFeature((ICPL)iCPL, arrayList, (boolean)JspCLLManager.isWebAppVersionGE2dot4(webAppBean));
    }

    private static void fillPropertyGroups(JspPropertyGroupBean jspPropertyGroupBean, List list) {
        if (jspPropertyGroupBean == null || jspPropertyGroupBean.getUrlPatterns() == null) {
            return;
        }
        String[] stringArray = jspPropertyGroupBean.getUrlPatterns();
        Boolean bl = jspPropertyGroupBean.isElIgnored() ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl2 = jspPropertyGroupBean.isScriptingInvalid() ? Boolean.TRUE : Boolean.FALSE;
        String string = jspPropertyGroupBean.getPageEncoding();
        List<String> list2 = null;
        if (jspPropertyGroupBean.getIncludePreludes() != null) {
            list2 = Arrays.asList(jspPropertyGroupBean.getIncludePreludes());
        }
        List<String> list3 = null;
        if (jspPropertyGroupBean.getIncludeCodas() != null) {
            list3 = Arrays.asList(jspPropertyGroupBean.getIncludeCodas());
        }
        Boolean bl3 = jspPropertyGroupBean.isIsXmlSet() ? (jspPropertyGroupBean.isIsXml() ? Boolean.TRUE : Boolean.FALSE) : null;
        Boolean bl4 = jspPropertyGroupBean.isDeferredSyntaxAllowedAsLiteral() ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl5 = jspPropertyGroupBean.isTrimDirectiveWhitespaces() ? Boolean.TRUE : Boolean.FALSE;
        JspPropertySet jspPropertySet = new JspPropertySet(bl, bl2, string, list2, list3, bl3, bl4, bl5);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                URLPattern uRLPattern = new URLPattern(stringArray[i], true);
                list.add(new JspPropertyGroup(uRLPattern, jspPropertySet));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static List fillDefaultGroups(Set set) {
        if (set == null) {
            return null;
        }
        ArrayList<JspPropertyGroup> arrayList = null;
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        Boolean bl3 = Boolean.FALSE;
        Boolean bl4 = Boolean.FALSE;
        JspPropertySet jspPropertySet = new JspPropertySet(bl, bl2, null, null, null, null, bl3, bl4);
        for (String string : set) {
            if (arrayList == null) {
                arrayList = new ArrayList<JspPropertyGroup>(set.size());
            }
            URLPattern uRLPattern = new URLPattern(string, true);
            arrayList.add(new JspPropertyGroup(uRLPattern, jspPropertySet));
        }
        return arrayList;
    }

    private void addPaths(List list, String string) {
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (!file.exists()) continue;
            list.add(FS.getIFile((File)file));
        }
    }

    private void addLooseClassFiles(Set set, IFile iFile) {
        IFile[] iFileArray;
        if (iFile != null && iFile.exists() && (iFileArray = iFile.listIFiles(new IFileFilter(){

            public boolean accept(IFile iFile) {
                if ("class".equals(iFile.getNameExtension(false))) {
                    return true;
                }
                return iFile.isDirectory();
            }
        })) != null) {
            for (int i = 0; i < iFileArray.length; ++i) {
                if (iFileArray[i].isDirectory()) {
                    this.addLooseClassFiles(set, iFileArray[i]);
                    continue;
                }
                set.add(iFileArray[i]);
            }
        }
    }

    private static void getTagFiles(IFile iFile, Set set) {
        if (iFile != null && iFile.exists()) {
            IFile[] iFileArray = iFile.listIFiles();
            for (int i = 0; i < iFileArray.length; ++i) {
                if (iFileArray[i].getNameExtension(false).equals("tag") || iFileArray[i].getNameExtension(false).equals("tagx")) {
                    set.add(iFileArray[i]);
                    continue;
                }
                if (!iFileArray[i].isDirectory()) continue;
                JspCLLManager.getTagFiles(iFileArray[i], set);
            }
        }
    }

    public static void setWebAppProjectFeature(ICPL iCPL, String string, URI[] uRIArray, String string2, VirtualRootInfo[] virtualRootInfoArray, JspResourceProvider jspResourceProvider) {
        iCPL.setFeature(IWebAppProjectFeature.class, (Object)new WebAppProjectFeatureImpl(iCPL, string, uRIArray, string2, virtualRootInfoArray, jspResourceProvider));
    }

    static VirtualRootInfo[] getVirtualRootsInfo(WeblogicWebAppBean weblogicWebAppBean) {
        if (weblogicWebAppBean == null) {
            return null;
        }
        VirtualDirectoryMappingBean[] virtualDirectoryMappingBeanArray = weblogicWebAppBean.getVirtualDirectoryMappings();
        if (virtualDirectoryMappingBeanArray == null || virtualDirectoryMappingBeanArray.length == 0) {
            return null;
        }
        VirtualRootInfo[] virtualRootInfoArray = new VirtualRootInfo[virtualDirectoryMappingBeanArray.length];
        for (int i = 0; i < virtualDirectoryMappingBeanArray.length; ++i) {
            String[] stringArray = virtualDirectoryMappingBeanArray[i].getUrlPatterns();
            if (stringArray == null || stringArray.length == 0) {
                stringArray = new String[]{WebAppSecurity.fixupURLPattern("*")};
            }
            try {
                File file = new File(virtualDirectoryMappingBeanArray[i].getLocalPath()).getCanonicalFile();
                IFile iFile = FS.getIFile((File)file);
                if (iFile != null) {
                    virtualRootInfoArray[i] = new VirtualRootInfo(iFile.getURI(), stringArray);
                    continue;
                }
                virtualRootInfoArray[i] = null;
                continue;
            }
            catch (IOException iOException) {
                virtualRootInfoArray[i] = null;
            }
        }
        return virtualRootInfoArray;
    }

    static {
        FS.initialize();
        JAVELIN.addLanguage((ILanguage)new JspLanguageX(JAVELIN));
        JAVELIN.addLanguage((ILanguage)new HtmlLanguageX(JAVELIN));
        JAVELIN.addLanguage((ILanguage)new CSSLanguage(JAVELIN));
        EXTRA_SAVE_USE_BEAN = Boolean.getBoolean("weblogic.jsp.extraSaveUseBean");
        DISABLE_SMAP = Boolean.getBoolean("weblogic.jsp.disableSMAP");
    }

    private static class DiagnosticMessageLimitFilter
    implements DiagnosticList.Filter {
        private final int max;
        private int count;

        DiagnosticMessageLimitFilter(int n) {
            this.max = n;
            this.count = 0;
        }

        public boolean accept(Diagnostic diagnostic) {
            if (this.isMax() || diagnostic == null) {
                return false;
            }
            ++this.count;
            return true;
        }

        boolean isMax() {
            return this.count >= this.max;
        }
    }

    public static class JspClientContext
    implements IClientContext {
        private boolean hasException = false;
        private Throwable exception;
        private String path;

        JspClientContext() {
        }

        public void addFileListener(IFile iFile) {
        }

        public void exceptionEncountered(Throwable throwable, IFile iFile) {
            this.path = iFile.getDisplayPath();
            this.exception = throwable;
            this.hasException = true;
        }

        public void removeFileListener(IFile iFile) {
        }

        public void synchronizeFileListeners() {
        }

        public boolean hasException() {
            return this.hasException;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getPath() {
            return this.path;
        }
    }

    static class VirtualRootInfo {
        private URI virtualRoot;
        private String[] urlPatterns;

        public VirtualRootInfo(URI uRI, String[] stringArray) {
            this.virtualRoot = uRI;
            this.urlPatterns = stringArray;
        }
    }

    private static class WebAppProjectFeatureImpl
    implements IWebAppProjectFeature {
        private ICPL _cpl;
        private String _contextPath;
        private URI[] _roots;
        private VirtualRootInfo[] _vroots;
        private String _version;
        private JspResourceProvider _resourceProvider = null;

        public WebAppProjectFeatureImpl(ICPL iCPL, String string, URI[] uRIArray, String string2, VirtualRootInfo[] virtualRootInfoArray) {
            this._cpl = iCPL;
            this._contextPath = string;
            this._roots = uRIArray;
            this._vroots = virtualRootInfoArray;
            this._version = string2;
        }

        public WebAppProjectFeatureImpl(ICPL iCPL, String string, URI[] uRIArray, String string2, VirtualRootInfo[] virtualRootInfoArray, JspResourceProvider jspResourceProvider) {
            this(iCPL, string, uRIArray, string2, virtualRootInfoArray);
            this._resourceProvider = jspResourceProvider;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public ICPL getCPL() {
            return this._cpl;
        }

        public URI[] getRoots() {
            return this._roots;
        }

        public URI findRoot(String string) {
            try {
                URI uRI = new URI(string);
                for (int i = 0; i < this._roots.length; ++i) {
                    URI uRI2 = this._roots[i].relativize(uRI);
                    if (uRI2.equals(uRI)) continue;
                    return this._roots[i];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            for (int i = 0; i < this._roots.length; ++i) {
                IFile iFile = FS.getIFile((IFile)FS.getIFile((URI)this._roots[i]), (String)string);
                if (iFile == null || !iFile.exists()) continue;
                return this._roots[i];
            }
            return null;
        }

        public URI findResource(String string) {
            String string2;
            if (string == null) {
                return null;
            }
            for (int i = 0; i < this._roots.length; ++i) {
                String string3;
                IFile iFile = FS.getIFile((IFile)FS.getIFile((URI)this._roots[i]), (String)string);
                if (iFile == null || !iFile.exists() || !(string3 = iFile.getURI().normalize().toString()).startsWith(string2 = this._roots[i].normalize().toString())) continue;
                return iFile.getURI();
            }
            if (this._vroots == null || this._vroots.length == 0) {
                return null;
            }
            URLPattern uRLPattern = new URLPattern(string, false);
            for (int i = 0; i < this._vroots.length; ++i) {
                if (this._vroots[i] == null) continue;
                for (int j = 0; j < this._vroots[i].urlPatterns.length; ++j) {
                    String string4;
                    String string5;
                    if (!this.matchPattern(this._vroots[i].urlPatterns[j], uRLPattern) || (string2 = FS.getIFile((IFile)FS.getIFile((URI)this._vroots[i].virtualRoot), (String)string)) == null || !(string5 = string2.getURI().normalize().getSchemeSpecificPart()).startsWith(string4 = this._vroots[i].virtualRoot.normalize().toString())) continue;
                    return string2.getURI();
                }
            }
            return null;
        }

        private boolean matchPattern(String string, URLPattern uRLPattern) {
            URLPattern uRLPattern2 = new URLPattern(string, true);
            if (uRLPattern2.getExtension() == null) {
                if (uRLPattern2.getPath() == null || uRLPattern.getPath() == null) {
                    return false;
                }
                if (uRLPattern.getPath().startsWith(uRLPattern2.getPath())) {
                    return true;
                }
            } else {
                if (uRLPattern2.getExtension().equals("*") || uRLPattern2.getPath() != null && uRLPattern2.getPath().equals("/")) {
                    return true;
                }
                if (uRLPattern.getExtension() != null) {
                    if (uRLPattern2.getExtension().equals(uRLPattern.getExtension())) {
                        return true;
                    }
                } else {
                    if (uRLPattern2.getPath() == null || uRLPattern.getPath() == null) {
                        return false;
                    }
                    if (uRLPattern.getPath().startsWith(uRLPattern2.getPath())) {
                        return true;
                    }
                }
            }
            return false;
        }

        public URI[] getVirtualRoots() {
            if (this._vroots == null || this._vroots.length == 0) {
                return null;
            }
            URI[] uRIArray = new URI[this._vroots.length];
            for (int i = 0; i < this._vroots.length; ++i) {
                uRIArray[i] = this._vroots[i].virtualRoot;
            }
            return uRIArray;
        }

        public String getVersion() {
            return this._version;
        }

        public IWebAppProjectFeature[] getWebAppProjects() {
            return new IWebAppProjectFeature[]{this};
        }

        public JspResourceProvider getResourceProvider() {
            return this._resourceProvider;
        }
    }

    public static interface IJSPCompilerContext {
        public ClassLoader getClassLoader();

        public Source getSource(String var1);

        public String getClasspath();

        public JspConfig getJspConfig();

        public String[] getSourcePaths();

        public WebAppBean getWebAppBean();

        public WeblogicWebAppBean getWlWebAppBean();

        public String getName();

        public WebAppServletContext getServletContext();

        public String getContextPath();

        public void say(String var1);

        public void sayError(String var1, String var2);

        public Set getAdditionalExtensions();
    }
}

