/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.security.AccessController;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ExpressionFactory;
import javax.el.VariableMapper;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import weblogic.kernel.Kernel;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.HTTPLogger;
import weblogic.servlet.jsp.CommonUtils14;
import weblogic.servlet.jsp.PageContextImpl;

public final class JspConfig {
    public static final ICommonUtils COMMON_UTILS = JspConfig.makeCommonUtils();
    public static final String DEFAULT_JSP_SERVLET = JspConfig.getDefaultJSPServlet();
    public static final String DEFAULT_COMPILER_CLASS = "com.sun.tools.javac.Main";
    public static final String DEFAULT_PACKAGE_PREFIX = "jsp_servlet";
    public static final String DEFAULT_SUPER_CLASS = "weblogic.servlet.jsp.JspBase";
    public static final String DEFAULT_DEFAULT_FILE_NAME = "index.jsp";
    public static final int DEFAULT_PAGE_CHECK_SECONDS = 1;
    public static final boolean DEFAULT_VERBOSE = true;
    public static final boolean DEFAULT_KEEP_GENERATED = false;
    public static final boolean DEFAULT_COMPILER_SUPPORTS_ENCODING = true;
    public static final boolean DEFAULT_NO_TRY_BLOCKS = false;
    public static final boolean DEFAULT_PRECOMPILE = false;
    public static final boolean DEFAULT_PRECOMPILE_CONTINUE = false;
    public static final boolean DEFAULT_EXACT_MAPPING = true;
    public static final boolean DEFAULT_DEBUG_ENABLED = false;
    public static final boolean DEFAULT_BACKWARD_COMPATIBLE = false;
    public static final boolean DEFAULT_PRINT_NULLS = true;
    public static final boolean DEFAULT_COMPRESS_HTML_TEMPLATE = false;
    public static final boolean DEFAULT_OPTIMIZE_JAVA_EXPRESSION = false;
    public static final boolean DEFAULT_STRICT_STALE_CHECK = true;
    public static final String BACKWARD_COMPATIBLE = "backwardCompatible";
    public static final String RTEXPRVALUE_JSP_PARAM_NAME = "rtexprvalueJspParamName";
    public static final String COMPILER = "compiler";
    public static final String COMPILE_COMMAND = "compileCommand";
    public static final String COMPILER_CLASS = "compilerClass";
    public static final String COMPILE_FLAGS = "compileFlags";
    public static final String COMPILER_SUPPORTS_ENCODING = "compilerSupportsEncoding";
    public static final String DEBUG = "debug";
    public static final String DEFAULT_FILE_NAME = "defaultFileName";
    public static final String ENCODING = "encoding";
    public static final String EXACT_MAPPING = "exactMapping";
    public static final String JSP_PRECOMPILER = "jspPrecompiler";
    public static final String JSP_SERVLET = "jspServlet";
    public static final String KEEP_GENERATED = "keepgenerated";
    public static final String PACKAGE_PREFIX = "packagePrefix";
    public static final String PAGE_CHECK_SECONDS = "pageCheckSeconds";
    public static final String PRECOMPILE = "precompile";
    public static final String PRECOMPILE_CONTINUE = "precompileContinue";
    public static final String PRINT_NULLS = "printNulls";
    public static final String NO_TRY_BLOCKS = "noTryBlocks";
    public static final String SUPER_CLASS = "superclass";
    public static final String VERBOSE = "verbose";
    public static final String WORKING_DIR = "workingDir";
    public static final String COMPRESS_HTML_TEMPLATE = "compressHtmlTemplate";
    public static final String OPTIMIZE_JAVA_EXPRESSION = "optimizeJavaExpression";
    public static final String RESOURCE_PROVIDER_CLASS = "resourceProviderClass";
    public static final String STRICT_STALE_CHECK = "strictStaleCheck";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean PRODUCTION_MODE = !Kernel.isServer() || ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled();
    private static Boolean compilerClassExists;
    private boolean verbose;
    private boolean keepgenerated;
    private boolean compilerSupportsEncoding;
    private boolean noTryBlocks;
    private boolean precompileContinue;
    private boolean compressHtmlTemplate;
    private boolean optimizeJavaExpression;
    private long pageCheckSeconds;
    private String[] compileFlags;
    private String compileFlagsString;
    private boolean debugEnabled;
    private boolean backwardCompatible;
    private boolean isRtexprvalueJspParamName;
    private boolean printNulls;
    private boolean exactMapping;
    private boolean useByteBuffer;
    private boolean isStrictStaleCheck;
    public String packagePrefix;
    public String compileropt;
    public String compilerval;
    public String compilerClass;
    public String compiler;
    public String compileCommand;
    public String workingDir;
    public String superclassName;
    public String encoding;
    public String defaultFilename;
    public String jspServlet;

    public JspConfig(Map map) {
        String string;
        String string2 = null;
        string2 = this.get(map, VERBOSE);
        this.verbose = string2 == null ? true : "true".equalsIgnoreCase(string2);
        this.compileFlagsString = this.get(map, COMPILE_FLAGS);
        this.compileFlags = JspConfig.parseFlags(this.compileFlagsString);
        string2 = this.get(map, KEEP_GENERATED);
        this.keepgenerated = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, "useByteBuffer");
        this.useByteBuffer = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, STRICT_STALE_CHECK);
        this.isStrictStaleCheck = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, PRECOMPILE_CONTINUE);
        this.precompileContinue = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, COMPILER_SUPPORTS_ENCODING);
        this.compilerSupportsEncoding = string2 == null ? true : "true".equalsIgnoreCase(string2);
        string2 = this.get(map, NO_TRY_BLOCKS);
        this.noTryBlocks = "true".equalsIgnoreCase(string2);
        this.pageCheckSeconds = PRODUCTION_MODE ? -1L : 1L;
        string2 = this.get(map, PAGE_CHECK_SECONDS);
        if (string2 != null) {
            try {
                this.pageCheckSeconds = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((this.workingDir = this.get(map, WORKING_DIR)) == null) {
            throw new IllegalArgumentException("JSP 'workingDir' must be specified");
        }
        string2 = this.get(map, DEBUG);
        this.debugEnabled = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, COMPRESS_HTML_TEMPLATE);
        this.compressHtmlTemplate = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, OPTIMIZE_JAVA_EXPRESSION);
        this.optimizeJavaExpression = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, COMPILER);
        if (string2 != null) {
            this.compiler = string2;
        }
        if ((string = this.get(map, "compilerclass")) == null) {
            this.compileropt = "-compiler";
            this.compilerval = this.compileCommand = this.get(map, COMPILE_COMMAND);
        } else {
            this.compileropt = "-compilerclass";
            this.compilerval = this.compilerClass = string;
        }
        this.superclassName = this.get(map, SUPER_CLASS);
        this.encoding = this.get(map, ENCODING);
        this.defaultFilename = this.get(map, "defaultFilename");
        if (this.defaultFilename == null) {
            this.defaultFilename = DEFAULT_DEFAULT_FILE_NAME;
        }
        if ((this.packagePrefix = this.get(map, PACKAGE_PREFIX)) == null) {
            this.packagePrefix = DEFAULT_PACKAGE_PREFIX;
        }
        string2 = this.get(map, BACKWARD_COMPATIBLE);
        this.backwardCompatible = "true".equalsIgnoreCase(string2);
        string2 = this.get(map, RTEXPRVALUE_JSP_PARAM_NAME);
        this.isRtexprvalueJspParamName = "true".equalsIgnoreCase(string2);
        this.printNulls = !"false".equalsIgnoreCase(this.get(map, PRINT_NULLS));
        this.exactMapping = !"false".equalsIgnoreCase(this.get(map, EXACT_MAPPING));
        this.jspServlet = this.get(map, JSP_SERVLET);
    }

    public static boolean checkCompilerClass() {
        if (compilerClassExists != null) {
            return compilerClassExists == Boolean.TRUE;
        }
        try {
            Class<?> clazz = Class.forName(DEFAULT_COMPILER_CLASS);
            compilerClassExists = clazz != null ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Throwable throwable) {
            HTTPLogger.logUnableToLoadDefaultCompilerClass((String)DEFAULT_COMPILER_CLASS, (Throwable)throwable);
            compilerClassExists = Boolean.FALSE;
        }
        return compilerClassExists == Boolean.TRUE;
    }

    private static String getDefaultJSPServlet() {
        return "weblogic.servlet.JSPServlet";
    }

    private String get(Map map, String string) {
        return this.trim((String)map.get(string));
    }

    private String get(ServletConfig servletConfig, String string) {
        return this.trim(servletConfig.getInitParameter(string));
    }

    private String trim(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    public static String[] parseFlags(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void setValuesFromInitArgs(ServletConfig servletConfig) {
        String string = this.get(servletConfig, "defaultFilename");
        if (string != null) {
            this.defaultFilename = string;
        }
        if ((string = this.get(servletConfig, VERBOSE)) != null) {
            this.verbose = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, NO_TRY_BLOCKS)) != null) {
            this.noTryBlocks = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, DEBUG)) != null) {
            this.debugEnabled = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, KEEP_GENERATED)) != null) {
            this.keepgenerated = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, BACKWARD_COMPATIBLE)) != null) {
            this.backwardCompatible = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, RTEXPRVALUE_JSP_PARAM_NAME)) != null) {
            this.isRtexprvalueJspParamName = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, PRINT_NULLS)) != null) {
            this.printNulls = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, EXACT_MAPPING)) != null) {
            this.exactMapping = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, COMPILER_SUPPORTS_ENCODING)) != null) {
            this.compilerSupportsEncoding = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, PRECOMPILE_CONTINUE)) != null) {
            this.precompileContinue = "true".equalsIgnoreCase(string);
        }
        if ((string = this.get(servletConfig, COMPILE_FLAGS)) != null) {
            this.compileFlagsString = string;
            this.compileFlags = JspConfig.parseFlags(string);
        }
        if ((string = this.get(servletConfig, PAGE_CHECK_SECONDS)) != null) {
            try {
                this.pageCheckSeconds = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.get(servletConfig, PACKAGE_PREFIX)) != null) {
            this.packagePrefix = string;
        }
        if ((string = this.get(servletConfig, "compilerclass")) != null) {
            this.compileropt = "-compilerclass";
            this.compilerClass = this.compilerval = string;
        } else {
            string = this.get(servletConfig, COMPILE_COMMAND);
            if (string != null) {
                this.compileropt = "-compiler";
                this.compilerval = this.compileCommand = string;
            }
        }
        string = this.get(servletConfig, WORKING_DIR);
        if (string != null) {
            this.workingDir = string;
        }
        if ((string = this.get(servletConfig, SUPER_CLASS)) != null) {
            this.superclassName = string;
        }
        if ((string = this.get(servletConfig, ENCODING)) != null) {
            this.encoding = string;
        }
        if ((string = this.get(servletConfig, JSP_SERVLET)) != null) {
            this.jspServlet = string;
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public String getCompileropt() {
        return this.compileropt;
    }

    public String getCompilerClass() {
        return this.compilerClass;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public long getPageCheckSecs() {
        return this.pageCheckSeconds;
    }

    public String getSuperClassName() {
        return this.superclassName;
    }

    public boolean isKeepGenerated() {
        return this.keepgenerated;
    }

    public boolean useByteBuffer() {
        return this.useByteBuffer;
    }

    public boolean isPrecompileContinue() {
        return this.precompileContinue;
    }

    public boolean isCompilerSupportsEncoding() {
        return this.compilerSupportsEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDefaultFilename() {
        return this.defaultFilename;
    }

    public String[] getCompileFlags() {
        return this.compileFlags;
    }

    public String getCompileFlagsString() {
        return this.compileFlagsString;
    }

    public boolean isNoTryBlocks() {
        return this.noTryBlocks;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isBackwardCompatible() {
        return this.backwardCompatible;
    }

    public boolean isRtexprvalueJspParamName() {
        return this.isRtexprvalueJspParamName;
    }

    public boolean isPrintNulls() {
        return this.printNulls;
    }

    public boolean isExactMapping() {
        return this.exactMapping;
    }

    public String getJspServlet() {
        return this.jspServlet;
    }

    public boolean isCompressHtmlTemplate() {
        return this.compressHtmlTemplate;
    }

    public boolean isOptimizeJavaExpression() {
        return this.optimizeJavaExpression;
    }

    public boolean isStrictStaleCheck() {
        return this.isStrictStaleCheck;
    }

    public String getCompilerval() {
        if (this.compilerval == null) {
            return this.getCompileCommand();
        }
        return this.compilerval;
    }

    public String getCompileCommand() {
        ServerMBean serverMBean;
        if (this.compileCommand != null && this.compileCommand.length() > 0) {
            return this.compileCommand;
        }
        String string = null;
        if (Kernel.isServer() && (serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer()) != null) {
            string = serverMBean.getJavaCompiler();
        }
        if (string == null || string.length() == 0) {
            string = "javac";
        }
        return string;
    }

    public void setCompileCommand(String string) {
        this.compileropt = "-compiler";
        this.compilerval = this.compileCommand = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setKeepGenerated(boolean bl) {
        this.keepgenerated = bl;
    }

    public void setUseByteBuffer(boolean bl) {
        this.useByteBuffer = bl;
    }

    public void setDebugEnabled(boolean bl) {
        this.debugEnabled = bl;
    }

    public void setCompressHtmlTemplate(boolean bl) {
        this.compressHtmlTemplate = bl;
    }

    public void setOptimizeJavaExpression(boolean bl) {
        this.optimizeJavaExpression = bl;
    }

    public void setPageCheckSecs(long l) {
        this.pageCheckSeconds = l;
    }

    public void setWorkingDir(String string) {
        if (string == null) {
            throw new IllegalArgumentException("JSP 'workingDir' cannot be null");
        }
        this.workingDir = string;
    }

    public void setCompilerClass(String string) {
        this.compileropt = "-compilerclass";
        this.compilerval = this.compilerClass = string;
    }

    public void setPrecompileContinue(boolean bl) {
        this.precompileContinue = bl;
    }

    public void setNoTryBlocks(boolean bl) {
        this.noTryBlocks = bl;
    }

    public void setCompilerSupportsEncoding(boolean bl) {
        this.compilerSupportsEncoding = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setCompileFlagsString(String string) {
        this.compileFlagsString = string;
        this.compileFlags = JspConfig.parseFlags(string);
    }

    public void setExactMapping(boolean bl) {
        this.exactMapping = bl;
    }

    public static boolean isJspServletValid(String string, String string2, ClassLoader classLoader) throws DeploymentException {
        if (string2 == null) {
            return false;
        }
        if (string2.equals(DEFAULT_JSP_SERVLET)) {
            return true;
        }
        if (classLoader == null) {
            return true;
        }
        try {
            Class<?> clazz = classLoader.loadClass(string2);
            Class<?> clazz2 = classLoader.loadClass("javax.servlet.http.HttpServlet");
            boolean bl = clazz2.isAssignableFrom(clazz);
            if (!bl) {
                Loggable loggable = HTTPLogger.logInvalidJspServletLoggable((String)string, (String)string2);
                throw new DeploymentException(loggable.getMessage());
            }
            return bl;
        }
        catch (Exception exception) {
            Loggable loggable = HTTPLogger.logUnableToLoadJspServletClassLoggable((String)string, (String)string2, (Throwable)exception);
            loggable.log();
            throw new DeploymentException(loggable.getMessage(), exception);
        }
    }

    public String toString() {
        String string = this.getCompileFlagsString();
        if (string == null) {
            string = "";
        }
        return "[JspConfig: verbose=" + this.isVerbose() + ",packagePrefix=" + this.getPackagePrefix() + "," + this.compileropt + "=" + this.compilerval + ",compileFlags=" + string + ",workingDir=" + this.getWorkingDir() + ",pageCheckSeconds=" + this.getPageCheckSecs() + ",superclass=" + this.getSuperClassName() + ",keepgenerated=" + this.isKeepGenerated() + ",precompileContinue=" + this.isPrecompileContinue() + ",compilerSupportsEncoding=" + this.isCompilerSupportsEncoding() + ",encoding=" + this.getEncoding() + ",defaultfilename=" + this.getDefaultFilename() + ",compilerclass=" + this.getCompilerClass() + ",noTryBlocks=" + this.isNoTryBlocks() + ",debugEnabled=" + this.isDebugEnabled() + ",printNulls=" + this.isPrintNulls() + ",jspServlet=" + this.getJspServlet() + "]";
    }

    private static ICommonUtils makeCommonUtils() {
        try {
            Class<?> clazz = Class.forName("weblogic.servlet.jsp.CommonUtils15");
            if (clazz != null) {
                return (ICommonUtils)clazz.newInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            return new CommonUtils14();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static interface ICommonUtils {
        public ExpressionEvaluator getExpressionEvaluator();

        public VariableResolver getVariableResolver(PageContextImpl var1);

        public String getDefaultJSPServlet();

        public String getJspPrecompilerClass();

        public ExpressionFactory getExpressionFactory();

        public VariableMapper getVariableMapper();
    }
}

