/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import weblogic.servlet.internal.WebAppServletContext;

public final class JspExceptionWriter
extends PrintWriter {
    private String packagePrefix;
    private ServletContext sc;
    private boolean transformed = false;

    public JspExceptionWriter(String string, Writer writer, ServletContext servletContext) {
        super(writer, true);
        this.packagePrefix = string;
        this.sc = servletContext;
    }

    public void println(String string) {
        if (string.startsWith("\tat " + this.packagePrefix + ".")) {
            try {
                string = string.substring(4);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.substring(0, string2.lastIndexOf("."));
                String string4 = string2.substring(string2.lastIndexOf(".") + 1);
                String string5 = stringTokenizer.nextToken();
                if (string5.equals("Native Method")) {
                    super.println("\tat " + string + " [native method]");
                    return;
                }
                stringTokenizer = new StringTokenizer(string5, ":");
                String string6 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                String string7 = string3.replace('.', '/') + ".java";
                ClassLoader classLoader = ((WebAppServletContext)this.sc).getServletClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(string7);
                if (inputStream == null) {
                    super.println("\tat " + string + " [no source]");
                    return;
                }
                Vector<String> vector = new Vector<String>();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n2 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    int n3;
                    if (++n2 != n || (n3 = string.lastIndexOf("//[ ")) == -1) continue;
                    string = string.substring(n3 + 4);
                    stringTokenizer = new StringTokenizer(string);
                    try {
                        vector.addElement(stringTokenizer.nextToken(";"));
                        stringTokenizer.nextToken(":");
                        try {
                            vector.addElement(stringTokenizer.nextToken(": ]"));
                            bufferedReader.close();
                            inputStream = this.sc.getResourceAsStream((String)vector.elementAt(0));
                            if (inputStream == null) break;
                            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            n2 = 1;
                            int n4 = Integer.parseInt((String)vector.elementAt(1));
                            while ((string = bufferedReader.readLine()) != null) {
                                if (n2++ != n4) continue;
                                vector.addElement(string);
                                break;
                            }
                            bufferedReader.close();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            vector = null;
                        }
                        break;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        vector = null;
                        break;
                    }
                }
                if (vector == null) {
                    super.println("\tat " + string + " [could not parse]");
                    return;
                }
                String string8 = (String)vector.elementAt(0);
                super.println("\tat " + string3 + (string4.equals("_jspService") ? "" : "." + string4) + "(" + string8 + ":" + vector.elementAt(1) + ")");
                this.transformed = true;
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                super.println("\tat " + string + " [could not parse]");
                return;
            }
            catch (NumberFormatException numberFormatException) {
                super.println("\tat " + string + " [no line number]");
                return;
            }
            catch (IOException iOException) {
                super.println("\tat " + string);
                return;
            }
        }
        if (!this.transformed) {
            super.println(string);
        }
    }

    public void println(Object object) {
        this.println(object.toString());
    }

    public void println(char[] cArray) {
        this.println(new String(cArray));
    }
}

