/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import oracle.jsp.provider.JspResourceProvider;
import weblogic.servlet.internal.RequestCallback;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.StubLifecycleHelper;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.CompilationException;
import weblogic.servlet.jsp.JspClassLoader;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspFileNotFoundException;
import weblogic.servlet.jsp.StaleChecker;
import weblogic.servlet.jsp.StaleIndicator;
import weblogic.servlet.jsp.TagFileClassLoader;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;

public abstract class JspStub
extends ServletStubImpl {
    public static final String DEFAULT_PACKAGE_PREFIX = "jsp_servlet";
    protected JspConfig jsps;
    protected JspResourceProvider resourceProvider;
    private String hardcodedFilePath = null;
    private static final boolean alwaysCheckDisk = JspStub.initAlwaysCheckDiskProp();
    private long lastStaleCheck;
    private URL sourceUrl = null;
    private GenericClassLoader jspClassLoader;

    public JspStub(String string, String string2, Map map, WebAppServletContext webAppServletContext, JspConfig jspConfig) {
        super(string, string2, webAppServletContext, map);
        this.jsps = jspConfig;
        this.hardcodedFilePath = string;
        this.resourceProvider = webAppServletContext.getJspResourceProvider();
    }

    protected String getDefaultContentType() {
        return "text/html";
    }

    protected boolean isServletStale(Servlet servlet) {
        StaleIndicator staleIndicator = (StaleIndicator)servlet;
        try {
            return staleIndicator._isStale();
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public String getFilePath() {
        return this.hardcodedFilePath;
    }

    public void setFilePath(String string) {
        this.hardcodedFilePath = string;
    }

    protected synchronized ClassLoader getNewClassLoader() {
        this.jspClassLoader = null;
        return this.getClassLoader();
    }

    protected ClassLoader getClassLoader() {
        if (this.jspClassLoader == null) {
            TagFileClassLoader tagFileClassLoader = this.getContext().getTagFileHelper().getTagFileClassLoader();
            ClassFinder classFinder = tagFileClassLoader.getClassFinder();
            this.jspClassLoader = new JspClassLoader(classFinder, (ClassLoader)((Object)tagFileClassLoader), this.className);
            this.jspClassLoader.addClassFinderFirst((ClassFinder)new ClasspathClassFinder2(this.jsps.getWorkingDir()));
        }
        return this.jspClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadJSPOnUpdate(RequestCallback requestCallback) throws IOException, ServletException {
        JspStub jspStub = this;
        synchronized (jspStub) {
            if (this.isStale()) {
                this.getLifecycleHelper().destroy();
                this.prepareServlet(requestCallback, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForReload(RequestCallback requestCallback) throws ServletException, IOException {
        long l;
        if (this.lastStaleCheck > 0L && this.getContext().getTagFileHelper().getCLCreationTime() > this.lastStaleCheck) {
            this.lastStaleCheck = 0L;
        }
        if ((l = this.jsps.getPageCheckSecs() * 1000L) >= 0L && this.lastStaleCheck + l <= System.currentTimeMillis()) {
            JspStub jspStub = this;
            synchronized (jspStub) {
                if (this.lastStaleCheck + l <= System.currentTimeMillis()) {
                    if (this.needToPrepare(requestCallback)) {
                        JspStub jspStub2 = this;
                        synchronized (jspStub2) {
                            this.getLifecycleHelper().destroy();
                            this.prepareServlet(requestCallback, alwaysCheckDisk);
                        }
                    }
                    this.lastStaleCheck = System.currentTimeMillis();
                }
            }
        }
        super.checkForReload(requestCallback);
    }

    protected final boolean isStale() {
        boolean bl;
        StubLifecycleHelper stubLifecycleHelper = this.getLifecycleHelper();
        if (stubLifecycleHelper == null) {
            return false;
        }
        try {
            Servlet servlet = stubLifecycleHelper.getServlet();
            boolean bl2 = this.isServletStale(servlet);
            stubLifecycleHelper.returnServlet(servlet);
            bl = bl2;
        }
        catch (ServletException servletException) {
            bl = true;
        }
        return bl;
    }

    private boolean isClassLoaderStale() {
        if (this.jspClassLoader == null) {
            return false;
        }
        boolean bl = this.jspClassLoader.getParent() != this.getContext().getTagFileHelper().getTagFileClassLoader();
        return bl;
    }

    private boolean needToPrepare(RequestCallback requestCallback) throws JspFileNotFoundException {
        Source source = this.getSourceForRequestURI(requestCallback);
        if (!(this.resourceProvider != null || source != null && source.getURL().equals(this.sourceUrl))) {
            return true;
        }
        boolean bl = this.isStale();
        if (bl) {
            return true;
        }
        boolean bl2 = this.isClassLoaderStale();
        return bl2 && !this.isJspFromArchivedSharedLib(source);
    }

    private void setSourceUrl(Source source) {
        if (source != null) {
            this.sourceUrl = source.getURL();
        }
    }

    private Source getSourceForRequestURI(RequestCallback requestCallback) throws JspFileNotFoundException {
        String string;
        if (this.getContext() != null && (string = this.getRequestURI(requestCallback)) != null) {
            return this.getContext().getResourceAsSource(string);
        }
        return null;
    }

    protected String getRequestURI(RequestCallback requestCallback) {
        return this.hardcodedFilePath != null ? this.hardcodedFilePath : requestCallback.getIncludeURI();
    }

    protected void prepareServlet(RequestCallback requestCallback) throws ServletException, IOException {
        this.prepareServlet(requestCallback, true);
        if (this.lastStaleCheck == 0L) {
            this.lastStaleCheck = System.currentTimeMillis();
        }
    }

    private void prepareServlet(RequestCallback requestCallback, boolean bl) throws ServletException, IOException {
        Object object;
        Source source = this.getSourceForRequestURI(requestCallback);
        String string = this.getRequestURI(requestCallback);
        if (source == null && this.resourceProvider == null && this.getContext() != null && string != null) {
            throw new JspFileNotFoundException("Requested JSP source file '" + string + "' no longer exists");
        }
        this.setSourceUrl(source);
        ClassLoader classLoader = this.getNewClassLoader();
        boolean bl2 = true;
        if (bl) {
            try {
                object = classLoader.loadClass(this.getClassName());
                if (!JspStub.isJSPClassStale((Class)object, this.getContext())) {
                    bl2 = false;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bl2) {
            object = Thread.currentThread();
            ClassLoader classLoader2 = ((Thread)object).getContextClassLoader();
            try {
                try {
                    ((Thread)object).setContextClassLoader(classLoader);
                    this.compilePage(requestCallback);
                }
                catch (ServletException servletException) {
                    throw servletException;
                }
                catch (CompilationException compilationException) {
                    throw compilationException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new ServletException("JSP compilation of " + string + " failed: " + exception.toString(), (Throwable)exception);
                }
                Object var11_11 = null;
                ((Thread)object).setContextClassLoader(classLoader2);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                ((Thread)object).setContextClassLoader(classLoader2);
                throw throwable;
            }
        }
        if (this.jsps.getPageCheckSecs() >= 0L) {
            this.getContext().getTagFileHelper().reloadIfNecessary(this.jsps.getPageCheckSecs());
        }
        if (bl2) {
            this.getNewClassLoader();
        }
        super.prepareServlet(requestCallback);
    }

    static void p(String string) {
        System.err.println("[JspStub]: " + string);
    }

    private static boolean initAlwaysCheckDiskProp() {
        return Boolean.getBoolean("weblogic.jsp.alwaysCheckDisk");
    }

    public static boolean isJSPClassStale(Class clazz, StaleChecker staleChecker) {
        try {
            Class[] classArray = new Class[]{StaleChecker.class};
            Method method = clazz.getMethod("_staticIsStale", classArray);
            if (method == null) {
                return true;
            }
            int n = method.getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) {
                return true;
            }
            Class<?>[] classArray2 = method.getParameterTypes();
            if (classArray2 == null || classArray2.length != 1 || classArray2[0] != StaleChecker.class) {
                return true;
            }
            if (method.getReturnType() != Boolean.TYPE) {
                return true;
            }
            Object[] objectArray = new Object[]{staleChecker};
            Object object = method.invoke(null, objectArray);
            if (!(object instanceof Boolean)) {
                return true;
            }
            return (Boolean)object;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private boolean isJspFromArchivedSharedLib(Source source) {
        WarSource warSource;
        return source instanceof WarSource && (warSource = (WarSource)source).isFromArchive() && warSource.isFromLibrary();
    }

    protected abstract void compilePage(RequestCallback var1) throws Exception;
}

