/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import weblogic.servlet.ServletResponseAttributeEvent;
import weblogic.servlet.ServletResponseAttributeListener;
import weblogic.servlet.internal.ChunkOutputWrapper;
import weblogic.servlet.internal.DelegateChunkWriter;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;
import weblogic.servlet.jsp.ByteWriter;
import weblogic.servlet.jsp.NestedBodyResponse;
import weblogic.utils.http.BytesToString;

public final class JspWriterImpl
extends JspWriter
implements ByteWriter,
ServletResponseAttributeListener {
    private static final String EOL = System.getProperty("line.separator");
    private ChunkOutputWrapper co = null;
    private ServletResponse response;
    private boolean isClosed;
    private String initEncoding = null;
    private boolean isEncodingSupported = false;
    private boolean is8BitEncoding = false;
    private boolean isEncodingChanged = false;
    private boolean isServletResponseWrapper = false;

    public JspWriterImpl(ServletResponse servletResponse, int n, boolean bl) throws IOException {
        super(n, bl);
        this.response = servletResponse;
        if (this.response instanceof ServletResponseImpl) {
            ServletResponseImpl servletResponseImpl = (ServletResponseImpl)this.response;
            ServletOutputStreamImpl servletOutputStreamImpl = (ServletOutputStreamImpl)servletResponseImpl.getOutputStreamNoCheck();
            this.co = servletOutputStreamImpl.getOutput();
            this.co.setAutoFlush(this.autoFlush);
            ((ServletResponseImpl)this.response).registerAttributeListener(this);
        } else if (this.response instanceof NestedBodyResponse) {
            this.co = ((NestedBodyResponse)this.response).getBodyContentImpl().getChunkOutputWrapper();
            this.co.setAutoFlush(this.autoFlush);
            ServletResponse servletResponse2 = ((NestedBodyResponse)this.response).getResponse();
            while (servletResponse2 instanceof NestedBodyResponse) {
                servletResponse2 = ((NestedBodyResponse)servletResponse2).getResponse();
            }
            if (servletResponse2 instanceof ServletResponseImpl) {
                ((ServletResponseImpl)servletResponse2).registerAttributeListener(this);
            } else {
                this.isServletResponseWrapper = true;
            }
        } else {
            this.isServletResponseWrapper = true;
            DelegateChunkWriter delegateChunkWriter = new DelegateChunkWriter(this.response, this.autoFlush, this.bufferSize);
            this.co = new ChunkOutputWrapper(delegateChunkWriter);
            this.co.setAutoFlush(this.autoFlush);
        }
    }

    public void clear() throws IOException {
        if (this.response.isCommitted()) {
            throw new IOException("response already committed");
        }
        this.co.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        this.co.clearBuffer();
    }

    public void flush() throws IOException {
        this.checkIsClosed();
        this.co.flush();
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.co.flush();
        this.isClosed = true;
    }

    public int getBufferSize() {
        return this.co.getBufferSize();
    }

    public int getRemaining() {
        int n = this.co.getBufferSize() - this.co.getCount();
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public boolean isAutoFlush() {
        return this.co.isAutoFlush();
    }

    public void newLine() throws IOException {
        this.checkIsClosed();
        this.co.print(EOL);
    }

    public void print(boolean bl) throws IOException {
        this.checkIsClosed();
        this.co.print(String.valueOf(bl));
    }

    public void print(char c) throws IOException {
        this.checkIsClosed();
        this.co.write(c);
    }

    public void print(char[] cArray) throws IOException {
        this.checkIsClosed();
        this.co.write(cArray, 0, cArray.length);
    }

    public void print(double d) throws IOException {
        this.checkIsClosed();
        this.co.print(String.valueOf(d));
    }

    public void print(float f) throws IOException {
        this.checkIsClosed();
        this.co.print(String.valueOf(f));
    }

    public void print(int n) throws IOException {
        this.checkIsClosed();
        this.co.print(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.checkIsClosed();
        this.co.print(String.valueOf(l));
    }

    public void print(Object object) throws IOException {
        this.checkIsClosed();
        this.co.print(String.valueOf(object));
    }

    public void print(String string) throws IOException {
        this.checkIsClosed();
        if (string == null) {
            this.co.print("null");
        } else {
            this.co.print(string);
        }
    }

    public void println(boolean bl) throws IOException {
        this.checkIsClosed();
        this.print(bl);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.checkIsClosed();
        this.print(c);
        this.newLine();
    }

    public void println(char[] cArray) throws IOException {
        this.checkIsClosed();
        this.print(cArray);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.checkIsClosed();
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.checkIsClosed();
        this.print(f);
        this.newLine();
    }

    public void println(int n) throws IOException {
        this.checkIsClosed();
        this.print(n);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.checkIsClosed();
        this.print(l);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.checkIsClosed();
        this.print(object);
        this.newLine();
    }

    public void println(String string) throws IOException {
        this.checkIsClosed();
        this.print(string);
        this.newLine();
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void write(char[] cArray) throws IOException {
        this.checkIsClosed();
        this.co.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.checkIsClosed();
        this.co.write(cArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.checkIsClosed();
        this.co.write(n);
    }

    public void write(String string) throws IOException {
        this.checkIsClosed();
        if (string == null) {
            this.co.print("null");
        } else {
            this.co.print(string);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        this.checkIsClosed();
        this.co.print(string.substring(n, n + n2));
    }

    public void write(byte[] byArray, String string) throws IOException {
        this.checkIsClosed();
        if (!this.isEncodingSupported || this.hasEncodingChanged()) {
            this.print(string);
        } else {
            this.co.write(byArray, 0, byArray.length);
        }
    }

    public void write(ByteBuffer byteBuffer, String string) throws IOException {
        this.checkIsClosed();
        if (!this.isEncodingSupported || this.hasEncodingChanged()) {
            this.print(string);
        } else {
            this.co.write(byteBuffer);
        }
    }

    private boolean hasEncodingChanged() {
        if (this.isServletResponseWrapper) {
            String string = this.response.getCharacterEncoding();
            if (this.is8BitEncoding) {
                return !BytesToString.is8BitUnicodeSubset((String)string);
            }
            if (string != null) {
                string = string.intern();
            }
            return this.initEncoding != string;
        }
        return this.isEncodingChanged;
    }

    public void setInitCharacterEncoding(String string, boolean bl) {
        if (this.initEncoding == string) {
            return;
        }
        this.initEncoding = string;
        this.is8BitEncoding = BytesToString.is8BitUnicodeSubset((String)this.initEncoding);
        this.isEncodingSupported = bl;
        this.checkAndSetEncodingChange(this.response.getCharacterEncoding());
    }

    private void checkIsClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
    }

    public void attributeChanged(ServletResponseAttributeEvent servletResponseAttributeEvent) {
        if (servletResponseAttributeEvent.getName() == "ENCODING") {
            ServletResponse servletResponse = servletResponseAttributeEvent.getResponse();
            String string = servletResponse.getCharacterEncoding();
            this.checkAndSetEncodingChange(string);
        }
    }

    private void checkAndSetEncodingChange(String string) {
        this.isEncodingChanged = this.is8BitEncoding ? !BytesToString.is8BitUnicodeSubset((String)string) : (string == null ? true : this.initEncoding != string.intern());
    }
}

