/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.application.library.LibraryManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.CharsetMappingBean;
import weblogic.j2ee.descriptor.wl.CharsetParamsBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.JspDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.servlet.internal.CharsetMap;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.internal.dd.compliance.ComplianceUtils;
import weblogic.servlet.internal.dd.compliance.DeploymentInfo;
import weblogic.servlet.jsp.JspClassLoader;
import weblogic.servlet.utils.WarUtils;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.tools.ui.progress.ProgressListener;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.JarFileUtils;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.webservice.tools.cchecker.ComplianceChecker;

public class JspcInvoker {
    private static final boolean debug = false;
    private static final String WEB_XML = "WEB-INF/web.xml";
    private static final String JSPC_TEMP_DIR = ".jspcgen_" + System.currentTimeMillis();
    private static final String tmpDirRoot = System.getProperty("java.io.tmpdir");
    final Getopt2 opts;
    private boolean isExtracted;
    private String warName;
    private ProgressListener listener;
    private WebAppBean bean;
    private WeblogicWebAppBean wlBean;

    public JspcInvoker(Getopt2 getopt2) {
        this.opts = getopt2;
    }

    public JspcInvoker(Getopt2 getopt2, ProgressListener progressListener) {
        this.opts = getopt2;
        this.listener = progressListener;
    }

    public void checkCompliance(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, ModuleValidationInfo moduleValidationInfo, boolean bl) throws ErrorCollectionException {
        this.checkCompliance(genericClassLoader, virtualJarFile, file, null, null, moduleValidationInfo, bl);
    }

    public void checkCompliance(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, ModuleValidationInfo moduleValidationInfo, boolean bl) throws ErrorCollectionException {
        try {
            String string = moduleValidationInfo == null ? this.getUriFromPlan(deploymentPlanBean) : moduleValidationInfo.getURI();
            this.parseDescriptors(file, virtualJarFile, file2, deploymentPlanBean, string);
        }
        catch (IOException iOException) {
            throw new ErrorCollectionException((Throwable)iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ErrorCollectionException((Throwable)xMLStreamException);
        }
        this.checkCompliance(genericClassLoader, moduleValidationInfo, bl, virtualJarFile);
    }

    private String getUriFromPlan(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean == null) {
            return null;
        }
        ModuleOverrideBean[] moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides();
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
            if (!deploymentPlanBean.rootModule(moduleOverrideBean.getModuleName())) continue;
            return moduleOverrideBean.getModuleName();
        }
        return null;
    }

    private void checkCompliance(GenericClassLoader genericClassLoader, ModuleValidationInfo moduleValidationInfo, boolean bl, VirtualJarFile virtualJarFile) throws ErrorCollectionException {
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        deploymentInfo.setWebAppBean(this.bean);
        deploymentInfo.setWeblogicWebAppBean(this.wlBean);
        deploymentInfo.setClassLoader((ClassLoader)genericClassLoader);
        deploymentInfo.setModuleValidationInfo(moduleValidationInfo);
        deploymentInfo.setVerbose(bl);
        deploymentInfo.setIsWebServiceModule(virtualJarFile.getEntry("WEB-INF/webservices.xml") != null);
        if (bl) {
            JspcInvoker.p("Checking web app for compliance.");
        }
        ComplianceUtils.checkCompliance(deploymentInfo, this.listener);
    }

    public void compile(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, ModuleValidationInfo moduleValidationInfo, LibraryManager libraryManager) throws ErrorCollectionException {
        this.compile(genericClassLoader, virtualJarFile, file, null, null, moduleValidationInfo, libraryManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compile(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean, ModuleValidationInfo moduleValidationInfo, LibraryManager libraryManager) throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException;
        block23: {
            this.ensureClean();
            File file3 = JspcInvoker.getJspcTempDir();
            ClassFinder classFinder = null;
            errorCollectionException = null;
            try {
                block22: {
                    try {
                        ClassFinder classFinder2;
                        Object object;
                        ComplianceChecker complianceChecker;
                        War war = new War("jspc", file3, virtualJarFile);
                        File file4 = this.determineDocroot(virtualJarFile);
                        String string = moduleValidationInfo == null ? this.getUriFromPlan(deploymentPlanBean) : moduleValidationInfo.getURI();
                        this.parseDescriptors(file, virtualJarFile, file2, deploymentPlanBean, string);
                        boolean bl = this.opts.getBooleanOption("verbose");
                        if (this.wlBean != null) {
                            JspcInvoker.processLibraries(this.wlBean, war, file3, libraryManager, moduleValidationInfo == null ? null : moduleValidationInfo.getURI());
                        }
                        classFinder = war.getClassFinder();
                        genericClassLoader.addClassFinder(classFinder);
                        try {
                            this.checkCompliance(genericClassLoader, moduleValidationInfo, bl, virtualJarFile);
                        }
                        catch (ErrorCollectionException errorCollectionException2) {
                            errorCollectionException = errorCollectionException2;
                        }
                        if (virtualJarFile.getEntry("WEB-INF/web-services.xml") != null) {
                            try {
                                if (bl) {
                                    JspcInvoker.p("Checking web services for compliance.");
                                }
                                complianceChecker = new ComplianceChecker(null);
                                complianceChecker.runChecker(virtualJarFile, genericClassLoader, bl);
                            }
                            catch (Exception exception) {
                                if (errorCollectionException == null) {
                                    errorCollectionException = new ErrorCollectionException((Throwable)exception);
                                }
                                errorCollectionException.add((Throwable)exception);
                            }
                        }
                        if (errorCollectionException != null && !errorCollectionException.isEmpty()) break block22;
                        complianceChecker = this.validateToolInputs(file4);
                        Object var16_19 = null;
                        try {
                            object = Class.forName("weblogic.servlet.jsp.jspc20");
                            classFinder2 = ((Class)object).getConstructor(String[].class);
                            var16_19 = classFinder2.newInstance(complianceChecker);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw exception;
                        }
                        if (var16_19 != null) {
                            object = var16_19;
                            object.setWebBean(this.bean);
                            object.setWlWebBean(this.wlBean);
                            classFinder2 = war.getResourceFinder("/");
                            object.runJspc(genericClassLoader, classFinder2, virtualJarFile);
                        }
                        if (this.isExtracted) {
                            if (this.warName != null) {
                                JarFileUtils.createJarFileFromDirectory((String)this.warName, (File)file4);
                            }
                            FileUtils.remove((File)file4);
                        }
                        if (classFinder != null) {
                            classFinder.close();
                            classFinder = null;
                        }
                        if (war != null) {
                            war.remove();
                            FileUtils.remove((File)file3);
                        }
                    }
                    catch (Exception exception) {
                        if (errorCollectionException == null) {
                            errorCollectionException = new ErrorCollectionException();
                        }
                        errorCollectionException.add((Throwable)exception);
                        throw errorCollectionException;
                    }
                }
                Object var20_23 = null;
                if (classFinder == null) break block23;
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                if (classFinder != null) {
                    classFinder.close();
                }
                throw throwable;
            }
            classFinder.close();
        }
        if (errorCollectionException != null && !errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void parseDescriptors(File file, VirtualJarFile virtualJarFile, File file2, DeploymentPlanBean deploymentPlanBean, String string) throws IOException, XMLStreamException {
        try {
            WebAppDescriptor webAppDescriptor = WarUtils.getWebAppDescriptor(file, virtualJarFile, file2, deploymentPlanBean, string);
            this.bean = webAppDescriptor.getWebAppBean();
            this.wlBean = webAppDescriptor.getWeblogicWebAppBean();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private String[] validateToolInputs(File file) {
        String string = this.determineTargetDir(file);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.opts.getBooleanOption("verbose")) {
            arrayList.add("-verboseJspc");
        }
        if (this.opts.getBooleanOption("keepgenerated")) {
            arrayList.add("-keepgenerated");
        }
        if (this.opts.getBooleanOption("forceGeneration")) {
            arrayList.add("-forceGeneration");
        }
        if (this.opts.getBooleanOption("k")) {
            arrayList.add("-k");
        }
        if (this.opts.getBooleanOption("useByteBuffer")) {
            arrayList.add("-useByteBuffer");
        }
        arrayList.add("-d");
        arrayList.add(this.opts.getOption("d", string));
        arrayList.add("-noexit");
        if (this.opts.hasOption("jsps")) {
            arrayList.add("-jsps");
            arrayList.add(this.opts.getOption("jsps"));
        }
        if (this.opts.getBooleanOption("compileAllTagFiles")) {
            arrayList.add("-compileAllTagFiles");
        }
        if (this.opts.hasOption("compiler")) {
            arrayList.add("-compiler");
            arrayList.add(this.opts.getOption("compiler"));
        }
        return arrayList.toArray(new String[0]);
    }

    private String determineTargetDir(File file) {
        File file2 = new File(file, "WEB-INF" + File.separatorChar + "classes");
        return file2.getAbsolutePath();
    }

    private File determineDocroot(VirtualJarFile virtualJarFile) throws IOException {
        if (virtualJarFile.isDirectory()) {
            return virtualJarFile.getDirectory();
        }
        this.isExtracted = true;
        this.warName = virtualJarFile.getName();
        if (this.warName.lastIndexOf(File.separator) != -1) {
            this.warName = this.warName.substring(this.warName.lastIndexOf(File.separator) + 1);
        }
        File file = JspcInvoker.getJspcTempDir();
        JarFileUtils.extract((VirtualJarFile)virtualJarFile, (File)file);
        return file;
    }

    public static File getJspcTempDir() {
        File file = new File(tmpDirRoot, JSPC_TEMP_DIR);
        file.mkdirs();
        return file;
    }

    private void ensureClean() {
        File file = new File(tmpDirRoot, JSPC_TEMP_DIR);
        FileUtils.remove((File)file);
    }

    public static String determineWebAppClasspath(VirtualJarFile virtualJarFile, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        File[] fileArray = virtualJarFile.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            JspcInvoker.buildWebAppClasspath(fileArray[i], stringBuffer, map);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static void addFileToClasspath(StringBuffer stringBuffer, File file) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(File.pathSeparator);
        }
        stringBuffer.append(file.getAbsolutePath());
    }

    private static void buildWebAppClasspath(File file, StringBuffer stringBuffer, Map map) {
        File[] fileArray;
        File file2;
        File file3 = new File(file, "WEB-INF");
        if (!file3.exists() || !file3.isDirectory()) {
            return;
        }
        File file4 = new File(file3, "classes");
        if (file4.exists() && file4.isDirectory()) {
            JspcInvoker.addFileToClasspath(stringBuffer, file4);
        }
        if ((file2 = new File(file3, "lib")).exists() && file2.isDirectory() && (fileArray = file2.listFiles(new JarFileFilter())) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                JspcInvoker.addFileToClasspath(stringBuffer, fileArray[i]);
                map.put(fileArray[i].getName(), fileArray[i].getAbsolutePath());
            }
        }
    }

    public static GenericClassLoader getJspClassLoader(ClassLoader classLoader, ClassFinder classFinder, String string) {
        return new JspClassLoader(classFinder, classLoader, string);
    }

    public static Map makeDescriptorMap(WeblogicWebAppBean weblogicWebAppBean, CharsetMap charsetMap) {
        CharsetParamsBean charsetParamsBean;
        if (weblogicWebAppBean == null) {
            return null;
        }
        Map map = JspcInvoker.makeDefaultDescriptorMap();
        JspDescriptorBean jspDescriptorBean = (JspDescriptorBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getJspDescriptors(), "JspDescriptor");
        if (jspDescriptorBean != null) {
            JspcInvoker.setArg(map, "keepgenerated", "" + jspDescriptorBean.isKeepgenerated());
            JspcInvoker.setArg(map, "backwardCompatible", "" + jspDescriptorBean.isBackwardCompatible());
            JspcInvoker.setArg(map, "rtexprvalueJspParamName", "" + jspDescriptorBean.isRtexprvalueJspParamName());
            JspcInvoker.setArg(map, "superclass", jspDescriptorBean.getSuperClass());
            JspcInvoker.setArg(map, "packagePrefix", jspDescriptorBean.getPackagePrefix());
            JspcInvoker.setArg(map, "pageCheckSeconds", "" + jspDescriptorBean.getPageCheckSeconds());
            JspcInvoker.setArg(map, "encoding", jspDescriptorBean.getEncoding());
            JspcInvoker.setArg(map, "printNulls", "" + jspDescriptorBean.isPrintNulls());
            JspcInvoker.setArg(map, "debug", "" + jspDescriptorBean.isDebug());
            JspcInvoker.setArg(map, "compressHtmlTemplate", "" + jspDescriptorBean.isCompressHtmlTemplate());
            JspcInvoker.setArg(map, "optimizeJavaExpression", "" + jspDescriptorBean.isOptimizeJavaExpression());
            JspcInvoker.setArg(map, "strictStaleCheck", "" + jspDescriptorBean.isStrictStaleCheck());
        }
        if (charsetMap != null && (charsetParamsBean = (CharsetParamsBean)DescriptorUtils.getFirstChildOrDefaultBean(weblogicWebAppBean, weblogicWebAppBean.getCharsetParams(), "CharsetParams")) != null) {
            CharsetMappingBean[] charsetMappingBeanArray = charsetParamsBean.getCharsetMappings();
            for (int i = 0; i < charsetMappingBeanArray.length; ++i) {
                charsetMap.addMapping(charsetMappingBeanArray[i]);
            }
        }
        return map;
    }

    public static Map makeDefaultDescriptorMap() {
        HashMap hashMap = new HashMap();
        JspcInvoker.setArg(hashMap, "defaultFileName", "index.jsp");
        JspcInvoker.setArg(hashMap, "verbose", "true");
        JspcInvoker.setArg(hashMap, "keepgenerated", "false");
        JspcInvoker.setArg(hashMap, "precompileContinue", "false");
        JspcInvoker.setArg(hashMap, "pageCheckSeconds", "1");
        JspcInvoker.setArg(hashMap, "packagePrefix", "jsp_servlet");
        JspcInvoker.setArg(hashMap, "superclass", "weblogic.servlet.jsp.JspBase");
        JspcInvoker.setArg(hashMap, "exactMapping", "true");
        JspcInvoker.setArg(hashMap, "backwardCompatible", "false");
        JspcInvoker.setArg(hashMap, "printNulls", "true");
        JspcInvoker.setArg(hashMap, "compressHtmlTemplate", "false");
        JspcInvoker.setArg(hashMap, "optimizeJavaExpression", "false");
        JspcInvoker.setArg(hashMap, "strictStaleCheck", "true");
        return hashMap;
    }

    static void setArg(Map map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    static void say(String string) {
        System.out.println("[jspc] " + string);
    }

    static void p(String string) {
        System.out.println("[JspcInvoker]" + string);
    }

    static void printAll(Getopt2 getopt2) {
        JspcInvoker.p("-d :" + getopt2.getOption("d"));
        JspcInvoker.p("-lineNumbers :" + getopt2.getOption("lineNumbers"));
        JspcInvoker.p("-k :" + getopt2.getOption("k"));
        JspcInvoker.p("-verbose :" + getopt2.getOption("verbose"));
        JspcInvoker.p("-keepgenerated :" + getopt2.getOption("keepgenerated"));
        JspcInvoker.p("-compiler :" + getopt2.getOption("compiler"));
        JspcInvoker.p("-forceGeneration :" + getopt2.getOption("forceGeneration"));
    }

    public static boolean canFindJavelinClasses() {
        try {
            URL uRL = new Object().getClass().getResource("/weblogic/servlet/jsp/.build.txt");
            if (uRL == null) {
                return true;
            }
            Class.forName("weblogic.jsp.wlw.filesystem.IFileFilter");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void processLibraries(WeblogicWebAppBean weblogicWebAppBean, War war, File file, LibraryManager libraryManager, String string) throws ToolFailureException, IOException {
        WebAppLibraryUtils.initWebAppLibraryManager(libraryManager, weblogicWebAppBean, string);
        WebAppLibraryUtils.extractWebAppLibraries(libraryManager, war, file);
    }

    public static interface IJspc {
        public void setWebBean(WebAppBean var1);

        public void setWlWebBean(WeblogicWebAppBean var1);

        public void runJspc(GenericClassLoader var1, ClassFinder var2, VirtualJarFile var3) throws Exception;
    }

    private static class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        public boolean accept(File file) {
            return !file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".JAR"));
        }
    }
}

