/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import javax.el.ELContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import weblogic.servlet.internal.ChunkOutputWrapper;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.BodyContentImpl;
import weblogic.servlet.jsp.JspApplicationContextImpl;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspFactoryImpl;
import weblogic.servlet.jsp.JspWriterImpl;
import weblogic.servlet.jsp.NestedBodyResponse;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.utils.io.FilenameEncoder;

public final class PageContextImpl
extends PageContext {
    private HttpServletRequest rq;
    private HttpServletResponse rp;
    protected Servlet servlet;
    protected ServletConfig config;
    protected ServletContext context;
    protected JspFactory factory;
    protected ELContext elContext;
    protected JspApplicationContextImpl jaCtxImpl;
    protected boolean needsSession;
    protected String errorPageURL;
    protected boolean autoFlush;
    protected int bufferSize;
    protected transient HashMap attributes;
    protected transient JspWriter out;
    private Stack writers = new Stack();

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = servlet.getServletConfig().getServletContext();
        this.rq = (HttpServletRequest)servletRequest;
        this.rp = (HttpServletResponse)servletResponse;
        this.errorPageURL = string;
        this.needsSession = bl;
        this.bufferSize = n;
        this.autoFlush = bl2;
        this.attributes = new HashMap();
        servletResponse.setBufferSize(n);
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", this.rq);
        this.setAttribute("javax.servlet.jsp.jspResponse", this.rp);
        this.setAttribute("javax.servlet.jsp.jspPage", this.servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.setAttribute("weblogic.servlet.jsp", "true", 2);
    }

    protected PageContextImpl(JspFactory jspFactory, Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException, IllegalStateException, IllegalArgumentException {
        this.out = new JspWriterImpl(servletResponse, n, bl2);
        this.initialize(servlet, servletRequest, servletResponse, string, bl, n, bl2);
    }

    private RequestDispatcher getRD(String string) throws ServletException {
        String string2;
        if (string == null) {
            throw new ServletException("requested URL string is null");
        }
        if (!string.startsWith("/")) {
            int n;
            string2 = (String)this.rq.getAttribute("javax.servlet.include.request_uri");
            if (string2 == null) {
                string2 = ServletRequestImpl.getResolvedURI(this.rq);
            }
            string = (n = string2.lastIndexOf(47)) == -1 ? '/' + string : (n == string2.length() - 1 ? string2 + string : string2.substring(0, n + 1) + string);
            if (!"/".equals(this.context.getContextPath())) {
                string = string.substring(this.context.getContextPath().length());
            }
            n = string.indexOf(63);
            String string3 = null;
            if (n != -1) {
                string3 = string.substring(n);
                string = string.substring(0, n);
            }
            string = FilenameEncoder.resolveRelativeURIPath((String)string);
            if (string3 != null) {
                string = string + string3;
            }
        }
        if ((string2 = this.servlet.getServletConfig().getServletContext().getRequestDispatcher(string)) == null) {
            throw new ServletException("no request dispatcher available for '" + string + "'");
        }
        return string2;
    }

    public void forward(String string) throws IOException, ServletException {
        try {
            this.out.clear();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.getRD(string).forward((ServletRequest)this.rq, (ServletResponse)this.rp);
    }

    public void include(String string) throws IOException, ServletException {
        this.getRD(string).include((ServletRequest)this.rq, (ServletResponse)this.rp);
    }

    public void include(String string, boolean bl) throws IOException, ServletException {
        if (bl && !(this.out instanceof BodyContent)) {
            this.out.flush();
        }
        this.include(string);
    }

    public JspWriter _createOut(int n, boolean bl) {
        return this.out;
    }

    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        return this.attributes.get(string);
    }

    public void removeAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("removeAttribute called with null name");
        }
        this.attributes.remove(string);
        this.removeAttribute(string, 2);
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            this.removeAttribute(string, 3);
        }
        this.removeAttribute(string, 4);
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        if (this.needsSession) {
            this.needsSession = false;
            return this.rq.getSession(true);
        }
        return this.rq.getSession(false);
    }

    private HttpSession getSessionForSessionScope() {
        HttpSession httpSession = this.getSession();
        if (httpSession == null) {
            throw new IllegalStateException("Either the page doesn't participate in a session, or the session is not valid any longer");
        }
        return httpSession;
    }

    public Object getPage() {
        return this.servlet;
    }

    public ServletRequest getRequest() {
        return this.rq;
    }

    public ServletResponse getResponse() {
        return this.rp;
    }

    public Exception getException() {
        return (Exception)this.rq.getAttribute("javax.servlet.jsp.jspException");
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    public void release() {
        this.rq = null;
        this.rp = null;
        this.context = null;
        this.errorPageURL = null;
        this.attributes.clear();
        this.out = null;
        this.writers = null;
    }

    public void setAttribute(String string, Object object, int n) {
        switch (n) {
            case 1: {
                this.setAttribute(string, object);
                break;
            }
            case 2: {
                this.rq.setAttribute(string, object);
                break;
            }
            case 4: {
                this.context.setAttribute(string, object);
                break;
            }
            case 3: {
                HttpSession httpSession = this.getSessionForSessionScope();
                httpSession.setAttribute(string, object);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scope: " + n);
            }
        }
    }

    public Object getAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        switch (n) {
            case 1: {
                return this.getAttribute(string);
            }
            case 2: {
                return this.rq.getAttribute(string);
            }
            case 4: {
                return this.context.getAttribute(string);
            }
            case 3: {
                HttpSession httpSession = this.getSessionForSessionScope();
                return httpSession.getAttribute(string);
            }
        }
        throw new IllegalArgumentException("illegal scope: " + n);
    }

    public Object findAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("findAttribute called with a null value");
        }
        Object object = null;
        object = this.getAttribute(string, 1);
        if (object == null && (object = this.getAttribute(string, 2)) == null) {
            HttpSession httpSession = this.getSession();
            if (httpSession != null) {
                object = this.getAttribute(string, 3);
            }
            if (object == null) {
                object = this.getAttribute(string, 4);
            }
        }
        return object;
    }

    public void removeAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        switch (n) {
            case 1: {
                this.attributes.remove(string);
                break;
            }
            case 2: {
                this.rq.removeAttribute(string);
                break;
            }
            case 4: {
                this.context.removeAttribute(string);
                break;
            }
            case 3: {
                HttpSession httpSession = this.getSessionForSessionScope();
                httpSession.removeAttribute(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scope: " + n);
            }
        }
    }

    public int getAttributesScope(String string) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (this.getAttribute(string, 1) != null) {
            return 1;
        }
        if (this.getAttribute(string, 2) != null) {
            return 2;
        }
        if (this.getAttribute(string, 3) != null) {
            return 3;
        }
        if (this.getAttribute(string, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration getAttributeNamesInScope(int n) {
        switch (n) {
            case 1: {
                return new IteratorEnumerator(this.attributes.keySet().iterator());
            }
            case 2: {
                return this.rq.getAttributeNames();
            }
            case 3: {
                HttpSession httpSession = this.getSessionForSessionScope();
                return httpSession.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("illegal scope: " + n);
    }

    public void handlePageException(Throwable throwable) throws ServletException, IOException {
        Throwable throwable2;
        if (throwable == null) {
            throw new NullPointerException("null Throwable");
        }
        Throwable throwable3 = throwable;
        if (throwable3 instanceof ServletException) {
            throwable3 = WebAppServletContext.getRootCause((ServletException)throwable3);
        }
        String string = this.rq.getRequestURI();
        this.rq.setAttribute("javax.servlet.jsp.jspException", (Object)throwable3);
        this.rq.setAttribute("javax.servlet.error.request_uri", (Object)string);
        if (this.errorPageURL != null) {
            ((WebAppServletContext)this.context).getErrorManager().setErrorAttributes(this.rq, string, throwable3);
            if (this.rp.isCommitted()) {
                this.include(this.errorPageURL);
            } else {
                this.forward(this.errorPageURL);
            }
            return;
        }
        if (throwable instanceof JspException && (throwable2 = ((JspException)throwable).getRootCause()) != null) {
            throwable = throwable2;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof ServletException) {
            throw (ServletException)throwable;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new ServletException(throwable);
    }

    public void handlePageException(Exception exception) throws ServletException, IOException {
        Exception exception2 = exception;
        this.handlePageException((Throwable)exception2);
    }

    public JspWriter pushBody(Writer writer) {
        this.writers.push(this.out);
        this.out = new BodyContentImpl(this.out, this, writer);
        this.rp = new NestedBodyResponse(this.rp, (BodyContentImpl)this.out);
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        ChunkOutputWrapper chunkOutputWrapper = ((BodyContentImpl)this.out).co;
        this.rq.setAttribute("weblogic.servlet.BodyTagOutput", (Object)chunkOutputWrapper);
        return (BodyContent)this.out;
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter popBody() {
        this.out = (JspWriter)this.writers.pop();
        if (this.rp instanceof NestedBodyResponse) {
            this.rp = (HttpServletResponse)((NestedBodyResponse)this.rp).getResponse();
        }
        if (this.out instanceof BodyContentImpl) {
            ChunkOutputWrapper chunkOutputWrapper = ((BodyContentImpl)this.out).co;
            this.rq.setAttribute("weblogic.servlet.BodyTagOutput", (Object)chunkOutputWrapper);
        } else {
            this.rq.removeAttribute("weblogic.servlet.BodyTagOutput");
        }
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        if (JspConfig.COMMON_UTILS != null) {
            return JspConfig.COMMON_UTILS.getExpressionEvaluator();
        }
        return null;
    }

    public VariableResolver getVariableResolver() {
        if (JspConfig.COMMON_UTILS != null) {
            return JspConfig.COMMON_UTILS.getVariableResolver(this);
        }
        return null;
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.getJspApplicationContextImpl().createELContext((JspContext)this);
        }
        return this.elContext;
    }

    public JspApplicationContextImpl getJspApplicationContextImpl() {
        if (this.jaCtxImpl == null) {
            JspFactoryImpl.init();
            this.jaCtxImpl = (JspApplicationContextImpl)JspFactoryImpl.getDefaultFactory().getJspApplicationContext(this.context);
        }
        return this.jaCtxImpl;
    }
}

