/*
 * Decompiled with CFR 0.152.
 */
package weblogic.servlet.jsp;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import oracle.jsp.provider.JspResourceProvider;
import weblogic.servlet.JSPServlet;
import weblogic.servlet.internal.FilterChainImpl;
import weblogic.servlet.internal.ServletStubImpl;
import weblogic.servlet.internal.WebAppConfigManager;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.jsp.JspConfig;
import weblogic.servlet.jsp.JspStub;
import weblogic.servlet.security.internal.WebAppSecurity;
import weblogic.servlet.utils.ServletMapping;
import weblogic.servlet.utils.URLMapping;

public class ResourceProviderJspStub
extends ServletStubImpl {
    private static final Constructor PROVIDER_JAVELINX_STUB = ResourceProviderJspStub.getProviderStubConstructor();
    private String uri;
    private JspConfig jspConfig;
    private JspResourceProvider jspResourceProvider;
    private URLMapping servletMapping = new ServletMapping(WebAppConfigManager.isCaseInsensitive(), WebAppSecurity.getEnforceStrictURLPattern());

    public ResourceProviderJspStub(String string, WebAppServletContext webAppServletContext, JspConfig jspConfig) {
        super(string, null, webAppServletContext, null);
        this.uri = string;
        this.jspConfig = jspConfig;
        this.jspResourceProvider = webAppServletContext.getJspResourceProvider();
    }

    public void execute(ServletRequest servletRequest, ServletResponse servletResponse, FilterChainImpl filterChainImpl) throws ServletException, IOException {
        String string = this.jspResourceProvider.getProviderURI(this.uri);
        if (string == null) {
            ((HttpServletResponse)servletResponse).sendError(404);
            return;
        }
        ServletStubImpl servletStubImpl = (ServletStubImpl)this.servletMapping.get(string);
        if (servletStubImpl != null) {
            servletStubImpl.execute(servletRequest, servletResponse, filterChainImpl);
            return;
        }
        servletStubImpl = ResourceProviderJspStub.getNewProviderStub(string, JSPServlet.uri2classname(this.jspConfig.getPackagePrefix(), string), null, this.getContext(), this.jspConfig, this.uri);
        this.servletMapping.put(string, servletStubImpl);
        servletStubImpl.execute(servletRequest, servletResponse, filterChainImpl);
    }

    private static JspStub getNewProviderStub(String string, String string2, Map map, WebAppServletContext webAppServletContext, JspConfig jspConfig, String string3) throws ServletException {
        try {
            return (JspStub)PROVIDER_JAVELINX_STUB.newInstance(string, string2, map, webAppServletContext, jspConfig, string3);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    private static Constructor getProviderStubConstructor() {
        try {
            Class<?> clazz = Class.forName("weblogic.servlet.jsp.ResourceProviderJavelinxJspStub");
            return clazz.getConstructor(String.class, String.class, Map.class, WebAppServletContext.class, JspConfig.class, String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)"Unable to find class weblogic.servlet.jsp.ResourceProviderJavelinxJspStub");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)"Unable to find constructor weblogic.servlet.jsp.ResourceProviderJavelinxJspStub(String, String, Map, WebAppServletContext, JspConfig, String)");
        }
    }
}

